/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.configuration.GuidanceGroupingItemProvider;
import org.eclipse.epf.library.edit.configuration.GuidanceItemProvider;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.services.GlossaryList;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.TermDefinition;

public class GlossaryBuilder {
    public static final String GLOSSARY_BACKPATH = "./../";
    private AdapterFactory adapterFactory;
    private static final Class ITreeItemContentProviderClass = ITreeItemContentProvider.class;
    private static final String GLOSSARY_HTML_FILE = "process/glossary.htm";
    private static final String GLOSSARY_INDEX_HTML_FILE = "process/glossary/index.htm";
    private static final String GLOSSARY_NAVIG_HTML_FILE = "process/glossary/navig.htm";
    private static final String GLOSSARY_XSL_FILE = "xsl/glossary.xsl";
    private static final String GLOSSARY_INDEX_XSL_FILE = "xsl/glossary_index.xsl";
    private static final String GLOSSARY_NAVIG_XSL_FILE = "xsl/glossary_navig.xsl";
    private GlossaryList glossaryItems = new GlossaryList();

    public void execute(MethodConfiguration methodConfiguration, String string, String string2, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        this.glossaryItems.clear();
        ConfigurationFilter configurationFilter = new ConfigurationFilter(methodConfiguration, null);
        this.adapterFactory = TngAdapterFactory.INSTANCE.getConfigurationView_AdapterFactory((IFilter)configurationFilter);
        this.iterate(methodConfiguration, iProgressMonitor);
        this.createGlossary(string, string2);
    }

    private void iterate(Object object, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(object, (Object)ITreeItemContentProviderClass);
        if (iTreeItemContentProvider != null) {
            Collection collection = iTreeItemContentProvider.getChildren(object);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                Object object2 = LibraryUtil.unwrap(iterator.next());
                if (object2 instanceof GuidanceGroupingItemProvider) {
                    this.iterate(object2, iProgressMonitor);
                    continue;
                }
                if (object2 instanceof GuidanceItemProvider) {
                    this.iterate(object2, iProgressMonitor);
                    continue;
                }
                if (!(object2 instanceof TermDefinition)) continue;
                this.glossaryItems.add((TermDefinition)object2);
            }
        }
    }

    private void createGlossary(String string, String string2) {
        try {
            URL uRL = new URL(PublishingPlugin.getDefault().getInstallURL(), GLOSSARY_XSL_FILE);
            if (uRL == null) {
                System.out.println("Unable to get glossary xsl template xsl/glossary.xsl");
                return;
            }
            String string3 = Platform.resolve((URL)uRL).getPath();
            StringBuffer stringBuffer = this.glossaryItems.getXml();
            File file = new File(string, GLOSSARY_HTML_FILE);
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            Properties properties = PublishingPlugin.getDefault().getProperties("/xsl/resources.properties");
            properties.setProperty("title", string2);
            StringWriter stringWriter = new StringWriter();
            XSLTProcessor.transform((String)string3, (String)stringBuffer.toString(), (Properties)properties, (Writer)stringWriter);
            stringWriter.flush();
            String string4 = ResourceHelper.decodeUrlsInContent((String)stringWriter.getBuffer().toString());
            FileUtil.writeUTF8File((String)file.getAbsolutePath(), (String)this.fixContent(string4));
            stringWriter.close();
            uRL = new URL(PublishingPlugin.getDefault().getInstallURL(), GLOSSARY_INDEX_XSL_FILE);
            if (uRL == null) {
                System.out.println("Unable to get glossary xsl template xsl/glossary_index.xsl");
                return;
            }
            string3 = Platform.resolve((URL)uRL).getPath();
            file = new File(string, GLOSSARY_INDEX_HTML_FILE);
            stringWriter = new StringWriter();
            XSLTProcessor.transform((String)string3, (String)stringBuffer.toString(), (Properties)properties, (Writer)stringWriter);
            stringWriter.flush();
            if (!file.exists()) {
                File file3 = file.getParentFile();
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                file.createNewFile();
            }
            FileUtil.writeUTF8File((String)file.getAbsolutePath(), (String)stringWriter.toString());
            stringWriter.close();
            uRL = new URL(PublishingPlugin.getDefault().getInstallURL(), GLOSSARY_NAVIG_XSL_FILE);
            if (uRL == null) {
                System.out.println("Unable to get glossary xsl template xsl/glossary_navig.xsl");
                return;
            }
            string3 = Platform.resolve((URL)uRL).getPath();
            file = new File(string, GLOSSARY_NAVIG_HTML_FILE);
            stringWriter = new StringWriter();
            XSLTProcessor.transform((String)string3, (String)stringBuffer.toString(), (Properties)properties, (Writer)stringWriter);
            stringWriter.flush();
            FileUtil.writeUTF8File((String)file.getAbsolutePath(), (String)stringWriter.toString());
            stringWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String fixContent(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = ResourceHelper.p_link_ref.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            string2 = this.fixUrlText(string2);
            String string4 = "<a " + string2 + ">" + string3 + "</a>";
            matcher.appendReplacement(stringBuffer, string4);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String fixUrlText(String string) {
        MethodElement methodElement;
        String string2 = ResourceHelper.getGuidFromUrl((String)string);
        if (string2 == null) {
            return string;
        }
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        MethodElement methodElement2 = methodElement = iLibraryManager != null ? iLibraryManager.getMethodElement(string2) : null;
        if (methodElement == null) {
            return string;
        }
        String string3 = "";
        string3 = methodElement instanceof TermDefinition ? "#" + methodElement.getName() : "../" + ResourceHelper.getElementPath((MethodElement)methodElement).replace(File.separatorChar, '/') + ResourceHelper.getFileName((MethodElement)methodElement, (String)".html");
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = ResourceHelper.p_link_href_picker.matcher(" " + string + " ");
        if (matcher.find()) {
            matcher.appendReplacement(stringBuffer, " href=\"" + string3 + "\" ");
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return string;
    }
}

