/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.configuration.GuidanceGroupingItemProvider;
import org.eclipse.epf.library.edit.configuration.GuidanceItemProvider;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.services.IndexList;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.TermDefinition;

public class IndexBuilder {
    private AdapterFactory adapterFactory;
    private static final Class ITreeItemContentProviderClass = ITreeItemContentProvider.class;
    private static final String INDEX_HTML_FILE = "index/contents.htm";
    private static final String INDEX_NAVIG_HTML_FILE = "index/navig.htm";
    private static final String INDEX_XSL_FILE = "xsl/index_contents.xsl";
    private static final String INDEX_NAVIG_XSL_FILE = "xsl/index_navig.xsl";
    private IndexList indexItems = new IndexList();

    public void execute(MethodConfiguration methodConfiguration, String string, String string2, IProgressMonitor iProgressMonitor) {
        this.indexItems.clear();
        ConfigurationFilter configurationFilter = new ConfigurationFilter(methodConfiguration, null);
        this.adapterFactory = TngAdapterFactory.INSTANCE.getConfigurationView_AdapterFactory((IFilter)configurationFilter);
        this.iterate(methodConfiguration);
        this.createIndex(string, string2);
    }

    private void iterate(Object object) {
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(object, (Object)ITreeItemContentProviderClass);
        if (iTreeItemContentProvider != null) {
            Collection collection = iTreeItemContentProvider.getChildren(object);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object2 = LibraryUtil.unwrap(iterator.next());
                if (object2 instanceof GuidanceGroupingItemProvider) {
                    this.iterate(object2);
                    continue;
                }
                if (object2 instanceof GuidanceItemProvider) {
                    this.iterate(object2);
                    continue;
                }
                if (!(object2 instanceof TermDefinition)) continue;
                TermDefinition termDefinition = (TermDefinition)object2;
                String string = termDefinition.getName();
                String string2 = "definition in glossary";
                String string3 = "../glossary/glossary.htm#" + termDefinition.getName();
                this.indexItems.add(string, string2, string3);
            }
        }
    }

    private void createIndex(String string, String string2) {
        try {
            URL uRL = new URL(PublishingPlugin.getDefault().getInstallURL(), INDEX_XSL_FILE);
            if (uRL == null) {
                System.out.println("Unable to get index xsl template xsl/index_contents.xsl");
                return;
            }
            String string3 = Platform.resolve((URL)uRL).getPath();
            StringBuffer stringBuffer = this.indexItems.getXml();
            File file = new File(string, INDEX_HTML_FILE);
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            Properties properties = new Properties();
            properties.setProperty("title", string2);
            StringWriter stringWriter = new StringWriter();
            XSLTProcessor.transform((String)string3, (String)stringBuffer.toString(), (Properties)properties, (Writer)stringWriter);
            stringWriter.flush();
            String string4 = stringWriter.getBuffer().toString();
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string4);
            fileWriter.flush();
            fileWriter.close();
            uRL = new URL(PublishingPlugin.getDefault().getInstallURL(), INDEX_NAVIG_XSL_FILE);
            if (uRL == null) {
                System.out.println("Unable to get glossary xsl template xsl/index_navig.xsl");
                return;
            }
            string3 = Platform.resolve((URL)uRL).getPath();
            file = new File(string, INDEX_NAVIG_HTML_FILE);
            fileWriter = new FileWriter(file);
            XSLTProcessor.transform((String)string3, (String)stringBuffer.toString(), (Properties)properties, (Writer)fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

