/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramService;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ControlNode;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.ObjectNode;
import org.eclipse.uml2.uml.StructuredActivityNode;

public class RefreshFromBaseAction
implements IObjectActionDelegate {
    private EditPart editPart;
    private IWorkbenchPart targetPart;
    private org.eclipse.gef.commands.Command refreshFromBaseCommand = new org.eclipse.gef.commands.Command(DiagramCoreResources.AbstractDiagramEditorrefreshfrombase){
        private ArrayList oldContent;
        {
            this.oldContent = new ArrayList();
        }

        public void execute() {
            Diagram diagram = (Diagram)RefreshFromBaseAction.this.editPart.getModel();
            EditPart editPart = RefreshFromBaseAction.this.editPart.getParent();
            this.oldContent.clear();
            this.oldContent.addAll(diagram.getPersistedChildren());
            boolean bl = RefreshFromBaseAction.this.refreshFromBase(diagram);
            if (!bl) {
                return;
            }
            if (RefreshFromBaseAction.this.editPart.isActive()) {
                RefreshFromBaseAction.this.editPart.deactivate();
            }
            RefreshFromBaseAction.this.editPart = (EditPart)EditPartService.getInstance().createGraphicEditPart((View)diagram);
            RefreshFromBaseAction.this.editPart.setParent(editPart);
            editPart.getViewer().setContents(RefreshFromBaseAction.this.editPart);
        }

        public void undo() {
            Diagram diagram = (Diagram)RefreshFromBaseAction.this.editPart.getModel();
            diagram.getChildren().clear();
            diagram.getChildren().addAll((Collection)this.oldContent);
            if (RefreshFromBaseAction.this.editPart.isActive()) {
                RefreshFromBaseAction.this.editPart.deactivate();
            }
            RefreshFromBaseAction.this.editPart = (EditPart)EditPartService.getInstance().createGraphicEditPart((View)diagram);
            RefreshFromBaseAction.this.getGraphicalViewer().setContents(RefreshFromBaseAction.this.editPart);
            RefreshFromBaseAction.this.editPart.activate();
        }
    };

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.targetPart = iWorkbenchPart;
    }

    public void run(IAction iAction) {
        this.refreshFromBaseCommand.execute();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        this.editPart = null;
        if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && iStructuredSelection.getFirstElement() instanceof EditPart) {
            this.editPart = (EditPart)iStructuredSelection.getFirstElement();
        }
        if (this.editPart != null) {
            iAction.setChecked(false);
            if (this.editPart instanceof DiagramEditPart && !((DiagramEditPart)this.editPart).isEditModeEnabled()) {
                iAction.setEnabled(false);
                return;
            }
            iStructuredSelection = (Diagram)this.editPart.getModel();
            EObject eObject = iStructuredSelection.getElement();
            org.eclipse.epf.uma.Activity activity = null;
            if (eObject instanceof Activity) {
                activity = (org.eclipse.epf.uma.Activity)BridgeHelper.getMethodElement((EModelElement)eObject);
            } else if (eObject instanceof org.eclipse.epf.diagram.model.Diagram) {
                activity = (org.eclipse.epf.uma.Activity)((org.eclipse.epf.diagram.model.Diagram)eObject).getLinkedElement();
            }
            if (activity != null && activity instanceof org.eclipse.epf.uma.Activity && (activity.getVariabilityBasedOnElement() == null || activity.getVariabilityBasedOnElement() != null && activity.getVariabilityType() != VariabilityType.EXTENDS_LITERAL)) {
                iAction.setEnabled(false);
                return;
            }
        } else {
            iAction.setEnabled(false);
        }
    }

    private GraphicalViewer getGraphicalViewer() {
        return (GraphicalViewer)this.editPart.getRoot().getViewer();
    }

    public boolean refreshFromBase(final Diagram diagram) {
        final boolean[] blArray = new boolean[1];
        try {
            TxUtil.runInTransaction((EObject)diagram, (Runnable)new Runnable(){

                public void run() {
                    blArray[0] = RefreshFromBaseAction.this.doRefreshFromBase(diagram);
                }
            });
        }
        catch (Exception exception) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
        }
        return blArray[0];
    }

    /*
     * WARNING - void declaration
     */
    private boolean doRefreshFromBase(Diagram diagram) {
        org.eclipse.epf.uma.Activity activity = null;
        EObject eObject = diagram.getElement();
        if (eObject instanceof Activity) {
            activity = (org.eclipse.epf.uma.Activity)BridgeHelper.getMethodElement((EModelElement)eObject);
        } else if (eObject instanceof org.eclipse.epf.diagram.model.Diagram) {
            activity = (org.eclipse.epf.uma.Activity)((org.eclipse.epf.diagram.model.Diagram)eObject).getLinkedElement();
        }
        if (activity == null) {
            return false;
        }
        org.eclipse.epf.uma.Activity activity2 = (org.eclipse.epf.uma.Activity)activity.getVariabilityBasedOnElement();
        if (activity2 == null || activity.getVariabilityType() == VariabilityType.LOCAL_REPLACEMENT_LITERAL) {
            return false;
        }
        int n = DiagramHelper.getDiagramType(diagram);
        DiagramService diagramService = new DiagramService();
        try {
            Diagram diagram2 = diagramService.getBaseDiagram(activity, n);
            if (diagram2 == null) {
                return false;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            HashMap<EObject, Object> hashMap = new HashMap<EObject, Object>();
            Diagram diagram3 = DiagramHelper.copyDiagram((EditingDomain)DiagramHelper.getEditingDomain(), diagram2);
            switch (n) {
                case 0: {
                    Object object;
                    EObject eObject2;
                    Object object22;
                    Activity activity3 = (Activity)eObject;
                    boolean bl = activity3.eDeliver();
                    activity3.eSetDeliver(false);
                    for (Object object22 : diagram2.getChildren()) {
                        void var16_23;
                        EObject eObject3 = object22.getElement();
                        if (!(eObject3 instanceof StructuredActivityNode) && !(eObject3 instanceof ObjectNode)) continue;
                        MethodElement methodElement = BridgeHelper.getMethodElement((EModelElement)((ActivityNode)eObject3));
                        if (methodElement == null) {
                            MethodElement methodElement2 = BridgeHelper.getMethodElementFromAnnotation((EModelElement)eObject3, activity2.eResource().getResourceSet());
                        }
                        if (var16_23 == null || (eObject2 = DiagramHelper.findNode(diagram, var16_23)) == null) continue;
                        arrayList.add(eObject2);
                        hashMap.put(eObject2, object22);
                    }
                    Iterator iterator = diagram.getChildren();
                    object22 = iterator.iterator();
                    while (object22.hasNext()) {
                        org.eclipse.gmf.runtime.notation.Node node = (org.eclipse.gmf.runtime.notation.Node)object22.next();
                        eObject2 = node.getElement();
                        if (eObject2 instanceof ControlNode) {
                            if (!BridgeHelper.isInherited((EModelElement)node)) continue;
                            arrayList.add(node);
                            continue;
                        }
                        if (!(eObject2 instanceof ActivityNode) || !((object = BridgeHelper.getMethodElement((EModelElement)((NamedElement)eObject2))) instanceof org.eclipse.epf.uma.Activity) || ((org.eclipse.epf.uma.Activity)object).getVariabilityBasedOnElement() == null) continue;
                        arrayList.add(node);
                    }
                    for (Edge edge : diagram.getEdges()) {
                        if (!arrayList.contains(edge.getSource()) || !arrayList.contains(edge.getTarget())) continue;
                        arrayList.add(edge);
                    }
                    for (View view : arrayList) {
                        if (view instanceof org.eclipse.gmf.runtime.notation.Node) {
                            diagram.removeChild(view);
                            activity3.getNodes().remove((Object)view.getElement());
                            continue;
                        }
                        if (!(view instanceof Edge)) continue;
                        diagram.removeEdge((Edge)view);
                        activity3.getEdges().remove((Object)view.getElement());
                    }
                    DiagramHelper.reassociate(activity, diagram3);
                    object22 = diagram3.getChildren();
                    int n2 = object22.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        object = object22.get(n3);
                        if (object instanceof View) {
                            View view = (View)object;
                            BridgeHelper.markInherited((EModelElement)view);
                        }
                        ++n3;
                    }
                    Activity activity4 = (Activity)diagram3.getElement();
                    diagram.getPersistedChildren().addAll((Collection)diagram3.getPersistedChildren());
                    diagram.getPersistedEdges().addAll((Collection)diagram3.getPersistedEdges());
                    activity3.getNodes().addAll((Collection)activity4.getNodes());
                    activity3.getEdges().addAll((Collection)activity4.getEdges());
                    activity3.eSetDeliver(bl);
                    break;
                }
                default: {
                    for (org.eclipse.gmf.runtime.notation.Node node : diagram2.getChildren()) {
                        MethodElement methodElement;
                        org.eclipse.gmf.runtime.notation.Node node2;
                        EObject eObject4 = node.getElement();
                        if (!(eObject4 instanceof Node) || (node2 = DiagramHelper.findNodeInADD(diagram, methodElement = ((Node)eObject4).getLinkedElement())) == null) continue;
                        arrayList.add(node2);
                    }
                    for (View view : arrayList) {
                        if (view instanceof org.eclipse.gmf.runtime.notation.Node) {
                            diagram.removeChild(view);
                            continue;
                        }
                        if (!(view instanceof Edge)) continue;
                        diagram.removeEdge((Edge)view);
                    }
                    diagram.getPersistedChildren().addAll((Collection)diagram3.getPersistedChildren());
                    diagram.getPersistedEdges().addAll((Collection)diagram3.getPersistedEdges());
                }
            }
            try {
                if (this.targetPart instanceof AbstractDiagramEditor) {
                    DiagramEditorUtil.resetEditor((AbstractDiagramEditor)this.targetPart);
                }
            }
            catch (Exception exception) {}
        }
        finally {
            diagramService.dispose();
        }
        return true;
    }

    public static Command copyDiagram(EditingDomain editingDomain, Diagram diagram) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(diagram.getElement());
        arrayList.add(diagram);
        Command command = CopyCommand.create((EditingDomain)editingDomain, arrayList);
        command.execute();
        return command;
    }

    public void initialize() {
        if (this.targetPart instanceof AbstractDiagramEditor) {
            AbstractDiagramEditor abstractDiagramEditor = (AbstractDiagramEditor)this.targetPart;
            abstractDiagramEditor.getDiagramEditPart();
        }
    }
}

