/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.commands.CopyDiagramCommand;
import org.eclipse.epf.diagram.core.commands.DeleteDiagramCommand;
import org.eclipse.epf.diagram.core.commands.DeleteDiagramNodeCommand;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.command.INestedCommandProvider;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.command.ResourceAwareCompoundCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityDropCommand;
import org.eclipse.epf.library.edit.process.command.ProcessDeepCopyCommand;
import org.eclipse.epf.library.edit.util.ActivityHandler;
import org.eclipse.epf.library.edit.util.ExposedAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedCommandProvider
implements INestedCommandProvider {
    private static final boolean DEBUG = DiagramCorePlugin.getDefault().isDebugging();

    public Command createNestedCommand(Command command) {
        if (command instanceof ActivityDropCommand) {
            ActivityDropCommand activityDropCommand = (ActivityDropCommand)command;
            if (1 == activityDropCommand.getType()) {
                return this.createNestedCommandForCopy(activityDropCommand);
            }
            if (3 == activityDropCommand.getType()) {
                return this.createNestedCommandForDeepCopy(activityDropCommand);
            }
        } else if (command instanceof ProcessDeepCopyCommand) {
            ProcessDeepCopyCommand processDeepCopyCommand = (ProcessDeepCopyCommand)command;
            Process process = null;
            Collection collection = processDeepCopyCommand.getResult();
            if (!collection.isEmpty()) {
                process = (Process)collection.iterator().next();
            }
            if (process != null) {
                HashMap<Activity, Activity> hashMap = new HashMap<Activity, Activity>();
                hashMap.put((Activity)process, (Activity)processDeepCopyCommand.getSourceProcess());
                return this.createNestedCommandForDeepCopy(processDeepCopyCommand.getTargetProcess(), processDeepCopyCommand.getMethodConfiguration(), new ArrayList<Activity>(processDeepCopyCommand.getResult()), hashMap, true);
            }
        }
        return null;
    }

    private Command createNestedCommandForCopy(ActivityDropCommand activityDropCommand) {
        activityDropCommand.getActivityHandler();
        Collection collection = activityDropCommand.getModifiedResources();
        if (collection != null && !collection.isEmpty()) {
            ResourceAwareCompoundCommand resourceAwareCompoundCommand;
            block7: {
                resourceAwareCompoundCommand = new ResourceAwareCompoundCommand(Integer.MAX_VALUE);
                CopyCommand.Helper helper = activityDropCommand.getActivityHandler().getCopyHelper();
                Activity activity = activityDropCommand.getActivity();
                Process process = TngUtil.getOwningProcess((BreakdownElement)activity);
                Set set = helper.keySet();
                if (process != null) {
                    try {
                        HashMap<EObject, EObject> hashMap = new HashMap<EObject, EObject>();
                        for (EObject eObject : set) {
                            EObject eObject2 = (EObject)helper.get((Object)eObject);
                            if (!(eObject instanceof Activity) || !(eObject2 instanceof Activity)) continue;
                            if (DEBUG) {
                                System.out.println("OrigAct:" + eObject);
                                System.out.println("CopyAct:" + eObject2);
                            }
                            hashMap.put(eObject2, eObject);
                        }
                        resourceAwareCompoundCommand.append((Command)new CopyDiagramCommand(hashMap.keySet(), hashMap, process));
                    }
                    catch (Exception exception) {
                        CommonPlugin.getDefault().getLogger().logError((Throwable)exception);
                        if (!DEBUG) break block7;
                        exception.printStackTrace();
                    }
                }
            }
            if (!resourceAwareCompoundCommand.isEmpty()) {
                return resourceAwareCompoundCommand;
            }
        }
        return null;
    }

    private Command createNestedCommandForDeepCopy(final Process process, MethodConfiguration methodConfiguration, List<Activity> list, Map<Activity, Activity> map, boolean bl) {
        ResourceAwareCompoundCommand resourceAwareCompoundCommand = bl ? new ResourceAwareCompoundCommand(Integer.MAX_VALUE){

            public void execute() {
                super.execute();
                if (DiagramManager.hasDiagramManager(process)) {
                    DiagramManager diagramManager = DiagramManager.getInstance(process, (Object)this);
                    ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = LibraryServiceUtil.getPersisterFor((Resource)process.eResource()).getFailSafePersister();
                    try {
                        try {
                            Resource resource = diagramManager.getResource();
                            failSafeMethodLibraryPersister.save(resource);
                            failSafeMethodLibraryPersister.commit();
                        }
                        catch (Exception exception) {
                            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
                            try {
                                failSafeMethodLibraryPersister.rollback();
                            }
                            catch (Exception exception2) {
                                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception2);
                            }
                            diagramManager.removeConsumer((Object)this);
                        }
                    }
                    finally {
                        diagramManager.removeConsumer((Object)this);
                    }
                }
            }
        } : new ResourceAwareCompoundCommand(Integer.MAX_VALUE);
        ExposedAdapterFactory exposedAdapterFactory = (ExposedAdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        IConfigurator iConfigurator = (IConfigurator)exposedAdapterFactory.getFilter();
        MethodConfiguration methodConfiguration2 = iConfigurator != null ? iConfigurator.getMethodConfiguration() : null;
        try {
            if (iConfigurator != null) {
                iConfigurator.setMethodConfiguration(methodConfiguration);
            }
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Activity activity = list.get(n2);
                Activity activity2 = map.get(activity);
                Process process2 = TngUtil.getOwningProcess((BreakdownElement)activity2);
                HashMap hashMap = new HashMap();
                final HashSet<Activity> hashSet = new HashSet<Activity>(list);
                boolean bl2 = process2 == process;
                AdapterFactoryTreeIterator adapterFactoryTreeIterator = new AdapterFactoryTreeIterator((AdapterFactory)exposedAdapterFactory, (Object)activity);
                AdapterFactoryTreeIterator adapterFactoryTreeIterator2 = bl2 ? new AdapterFactoryTreeIterator((AdapterFactory)exposedAdapterFactory, activity2){
                    private static final long serialVersionUID = 1L;

                    protected Iterator getChildren(Object object) {
                        if (hashSet.contains(object)) {
                            return Collections.EMPTY_LIST.iterator();
                        }
                        return super.getChildren(object);
                    }
                } : new AdapterFactoryTreeIterator((AdapterFactory)exposedAdapterFactory, (Object)activity2);
                while (adapterFactoryTreeIterator.hasNext()) {
                    Object object;
                    Object object2 = adapterFactoryTreeIterator.next();
                    if (bl2) {
                        while (hashSet.contains(object = adapterFactoryTreeIterator2.next())) {
                        }
                    } else {
                        if (!adapterFactoryTreeIterator2.hasNext()) {
                            System.out.println();
                        }
                        object = adapterFactoryTreeIterator2.next();
                    }
                    if (object2 instanceof WrapperItemProvider) {
                        object2 = TngUtil.unwrap(object2);
                    }
                    if (object instanceof WrapperItemProvider) {
                        object = TngUtil.unwrap(object);
                    }
                    hashMap.put(object2, object);
                }
                resourceAwareCompoundCommand.append((Command)new CopyDiagramCommand(hashMap.keySet(), hashMap, process, true));
                ++n2;
            }
        }
        finally {
            if (iConfigurator != null) {
                iConfigurator.setMethodConfiguration(methodConfiguration2);
            }
        }
        return !resourceAwareCompoundCommand.isEmpty() ? resourceAwareCompoundCommand : null;
    }

    private Command createNestedCommandForDeepCopy(ActivityDropCommand activityDropCommand) {
        ActivityHandler activityHandler = activityDropCommand.getActivityHandler();
        if (activityHandler != null && !activityHandler.getDeepCopies().isEmpty()) {
            return this.createNestedCommandForDeepCopy(activityHandler.getTargetProcess(), activityHandler.getDeepCopyConfig(), activityHandler.getDeepCopies(), activityHandler.getDeepCopyToOriginalMap(), false);
        }
        return null;
    }

    public Command createRelatedObjects(Collection collection, Command command) {
        MethodElementAddCommand methodElementAddCommand;
        Command command2;
        ResourceAwareCompoundCommand resourceAwareCompoundCommand = new ResourceAwareCompoundCommand(Integer.MAX_VALUE);
        if (command instanceof MethodElementAddCommand && (command2 = (methodElementAddCommand = (MethodElementAddCommand)command).getCommand()) instanceof AddCommand) {
            EditingDomain editingDomain = ((AddCommand)command2).getDomain();
            if (((AddCommand)command2).getOwner() instanceof ProcessPackage) {
                Map map;
                if (editingDomain instanceof TraceableAdapterFactoryEditingDomain && !(map = ((TraceableAdapterFactoryEditingDomain)editingDomain).getCopyToOriginalMap()).isEmpty()) {
                    Collection collection2 = methodElementAddCommand.getAffectedObjects();
                    for (MethodElement methodElement : collection2) {
                        if (!(methodElement instanceof ProcessComponent)) continue;
                        resourceAwareCompoundCommand.append((Command)new CopyDiagramCommand(map.keySet(), map, ((ProcessComponent)methodElement).getProcess()));
                    }
                }
            } else if (editingDomain instanceof TraceableAdapterFactoryEditingDomain) {
                Map map = ((TraceableAdapterFactoryEditingDomain)editingDomain).getOriginalToClipboardMap();
                HashMap hashMap = new HashMap();
                EObject eObject = ((AddCommand)command2).getOwner();
                Process process = TngUtil.getOwningProcess((Object)eObject);
                if (process != null) {
                    for (Object k : map.keySet()) {
                        Object v = map.get(k);
                        hashMap.put(v, k);
                    }
                    resourceAwareCompoundCommand.append((Command)new CopyDiagramCommand(hashMap.keySet(), hashMap, process));
                }
            }
        }
        if (!resourceAwareCompoundCommand.isEmpty()) {
            return resourceAwareCompoundCommand;
        }
        return null;
    }

    public Command removeRelatedObjects(Collection collection, Command command) {
        Process process;
        ProcessComponent processComponent2;
        ResourceAwareCompoundCommand resourceAwareCompoundCommand = new ResourceAwareCompoundCommand(Integer.MAX_VALUE);
        if (command instanceof DeleteMethodElementCommand) {
            Command command2 = ((DeleteMethodElementCommand)command).getCommand();
            List<Object> list = null;
            if (command2 instanceof RemoveCommand) {
                list = Collections.singletonList((RemoveCommand)command2);
            } else if (command2 instanceof CompoundCommand) {
                list = new ArrayList<RemoveCommand>();
                for (ProcessComponent processComponent2 : ((CompoundCommand)command2).getCommandList()) {
                    if (!(processComponent2 instanceof RemoveCommand)) continue;
                    list.add((RemoveCommand)((Object)((RemoveCommand)processComponent2)));
                }
            }
            if (list != null && !list.isEmpty() && (processComponent2 = ((RemoveCommand)list.get(0)).getOwner()) instanceof Activity) {
                Object object;
                process = TngUtil.getOwningProcess((BreakdownElement)((Activity)processComponent2));
                HashSet<Activity> hashSet = new HashSet<Activity>();
                for (Object object2 : collection) {
                    if (!(object2 instanceof Activity)) continue;
                    object = new AbstractTreeIterator<Object>(object2){
                        private static final long serialVersionUID = 1L;

                        protected Iterator<? extends Object> getChildren(Object object) {
                            if (object instanceof Activity) {
                                return ((Activity)object).getBreakdownElements().iterator();
                            }
                            return Collections.emptyList().iterator();
                        }
                    };
                    while (object.hasNext()) {
                        Object e = object.next();
                        if (!(e instanceof Activity)) continue;
                        hashSet.add((Activity)e);
                    }
                }
                if (!hashSet.isEmpty()) {
                    resourceAwareCompoundCommand.append((Command)new DeleteDiagramCommand(hashSet, process));
                }
                for (RemoveCommand removeCommand : list) {
                    if (!(removeCommand.getOwner() instanceof Activity) || !(object = new DeleteDiagramNodeCommand((Activity)removeCommand.getOwner(), removeCommand.getCollection())).canExecute()) continue;
                    resourceAwareCompoundCommand.append((Command)object);
                }
            }
        }
        if (!collection.isEmpty()) {
            for (List<Object> list : collection) {
                if (!(list instanceof ProcessComponent)) continue;
                processComponent2 = (ProcessComponent)list;
                process = processComponent2.getProcess();
                this.closeDiagramEditors(process);
            }
        }
        if (!resourceAwareCompoundCommand.isEmpty()) {
            return resourceAwareCompoundCommand;
        }
        return null;
    }

    private void closeDiagramEditors(Process process) {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        ArrayList<IEditorReference> arrayList = new ArrayList<IEditorReference>();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IEditorReference iEditorReference = iEditorReferenceArray[n];
            try {
                IEditorInput iEditorInput = iEditorReference.getEditorInput();
                if (iEditorInput instanceof DiagramEditorInputProxy) {
                    DiagramEditorInput diagramEditorInput = ((DiagramEditorInputProxy)iEditorInput).getDiagramEditorInput();
                    BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = diagramEditorInput.getWrapper();
                    Process process2 = null;
                    if (breakdownElementWrapperItemProvider != null) {
                        if (breakdownElementWrapperItemProvider instanceof BreakdownElementWrapperItemProvider) {
                            process2 = TngUtil.getOwningProcess((BreakdownElementWrapperItemProvider)breakdownElementWrapperItemProvider);
                        }
                    } else {
                        breakdownElementWrapperItemProvider = diagramEditorInput.getMethodElement();
                        if (breakdownElementWrapperItemProvider instanceof BreakdownElement) {
                            process2 = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)breakdownElementWrapperItemProvider));
                        }
                    }
                    if (process2 == process2) {
                        arrayList.add(iEditorReference);
                    }
                }
            }
            catch (PartInitException partInitException) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)partInitException);
            }
            ++n;
        }
        if (!arrayList.isEmpty()) {
            IEditorReference[] iEditorReferenceArray2 = new IEditorReference[arrayList.size()];
            arrayList.toArray(iEditorReferenceArray2);
            iWorkbenchPage.closeEditors(iEditorReferenceArray2, false);
        }
    }
}

