/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.services;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.events.ResourceChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.providers.AccessibleDiagramModificationListener;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.FileSynchronizer;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.WorkProductDependencyDiagram;
import org.eclipse.epf.diagram.model.impl.DiagramImpl;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResource;
import org.eclipse.epf.library.persistence.internal.IFailSafeSavable;
import org.eclipse.epf.library.persistence.util.ExtendedResourceSet;
import org.eclipse.epf.persistence.FailSafePersistenceHelper;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil;
import org.eclipse.gmf.runtime.emf.core.resources.GMFHelper;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramManager {
    private static final boolean DEBUG = DiagramCorePlugin.getDefault().isDebugging();
    private static final String DIAGRAM_FILENAME_WITHOUT_EXTENSION = "diagram";
    private static final String DIAGRAM_FILENAME = "diagram.xmi";
    private static final Map<Process, DiagramManager> processToDiagramManagerMap = new HashMap<Process, DiagramManager>();
    private static ILibraryServiceListener libSvcListener;
    private static final FileSynchronizer fileSynchronizer;
    public static final String ADD_kind = "ADD";
    public static final String AD_kind = "AD";
    public static final String WPD_kind = "WPDD";
    private Process process;
    private Resource resource;
    private InternalTransactionalEditingDomain editingDomain;
    private IProgressMonitor monitor;
    private boolean resourceIsNew;
    private List<IResourceChangeListener> resourceChangeListeners = new UniqueEList();
    private ExtendedResourceSet resourceSet;
    private HashMap<org.eclipse.epf.uma.Activity, Map<String, Diagram>> activityToSavedDiagramMap;
    protected UniqueEList<Object> consumers = new UniqueEList();

    static {
        fileSynchronizer = new FileSynchronizer(){

            @Override
            protected Collection<IFile> handleChangedFiles(Collection<IFile> collection) {
                try {
                    Collection<DiagramManager> collection2 = DiagramManager.getDiagramManagers();
                    if (!collection2.isEmpty()) {
                        ArrayList<IFile> arrayList = new ArrayList<IFile>();
                        for (DiagramManager diagramManager : collection2) {
                            IFile iFile;
                            Resource resource = diagramManager.getResource(false);
                            if (resource == null || !resource.isLoaded() || !collection.contains(iFile = WorkspaceSynchronizer.getFile((Resource)diagramManager.getResource()))) continue;
                            try {
                                diagramManager.reload();
                                arrayList.add(iFile);
                            }
                            catch (IOException iOException) {
                                CommonPlugin.getDefault().getLogger().logError((Throwable)iOException);
                                if (!DEBUG) continue;
                                iOException.printStackTrace();
                            }
                        }
                        return arrayList;
                    }
                }
                catch (CoreException coreException) {
                    this.handleCoreException(coreException, coreException.getMessage());
                }
                return Collections.emptyList();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Map<IFile, IPath> handleMovedFiles(Map<IFile, IPath> map) {
                for (Map.Entry<IFile, IPath> entry : map.entrySet()) {
                    IFile iFile = entry.getKey();
                    if (!DiagramManager.DIAGRAM_FILENAME.equals(iFile.getName())) continue;
                    Map map2 = processToDiagramManagerMap;
                    synchronized (map2) {
                        DiagramManager diagramManager = DiagramManager.getDiagramManager(iFile);
                        if (diagramManager != null) {
                            diagramManager.updateResourceURI();
                        }
                    }
                }
                return super.handleMovedFiles(map);
            }

            @Override
            protected Collection handleDeletedFiles(Collection<IFile> collection) {
                return super.handleDeletedFiles(collection);
            }
        };
    }

    private static DiagramManager getDiagramManager(IFile iFile) {
        for (DiagramManager diagramManager : processToDiagramManagerMap.values()) {
            if (diagramManager.resource == null || !iFile.equals((Object)WorkspaceSynchronizer.getFile((Resource)diagramManager.resource))) continue;
            return diagramManager;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeDiagramManagers(MethodLibrary methodLibrary) {
        Map<Process, DiagramManager> map = processToDiagramManagerMap;
        synchronized (map) {
            Iterator<Map.Entry<Process, DiagramManager>> iterator = processToDiagramManagerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Process, DiagramManager> entry = iterator.next();
                if (UmaUtil.getMethodLibrary((EObject)((EObject)entry.getKey())) != methodLibrary) continue;
                entry.getValue().doDispose();
                iterator.remove();
            }
        }
    }

    private static synchronized void setupLibraryServiceListener() {
        if (libSvcListener == null) {
            libSvcListener = new LibraryServiceListener(){

                public void libraryClosed(MethodLibrary methodLibrary) {
                    DiagramManager.disposeDiagramManagers(methodLibrary);
                }

                public void libraryReopened(MethodLibrary methodLibrary) {
                    DiagramManager.disposeDiagramManagers(methodLibrary);
                }
            };
            LibraryService.getInstance().addListener(libSvcListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DiagramManager getInstance(Process process, Object object) {
        if (DEBUG && process.eIsProxy()) {
            System.err.println("Process is a proxy: " + process);
        }
        assert (process != null && object != null && !process.eIsProxy());
        DiagramManager.setupLibraryServiceListener();
        DiagramManager diagramManager = processToDiagramManagerMap.get(process);
        if (diagramManager != null && diagramManager.isDisposed()) {
            processToDiagramManagerMap.remove(process);
            diagramManager = null;
        }
        if (diagramManager == null) {
            Map<Process, DiagramManager> map = processToDiagramManagerMap;
            synchronized (map) {
                diagramManager = processToDiagramManagerMap.get(process);
                if (diagramManager == null) {
                    diagramManager = new DiagramManager(process);
                    processToDiagramManagerMap.put(process, diagramManager);
                    if (!DiagramManager.fileSynchronizer.fIsInstalled) {
                        fileSynchronizer.install();
                    }
                }
            }
        }
        diagramManager.addConsumer(object);
        return diagramManager;
    }

    public static final boolean hasDiagramManager(Process process) {
        return processToDiagramManagerMap.containsKey(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean disposeDiagramManager(Process process) {
        Map<Process, DiagramManager> map = processToDiagramManagerMap;
        synchronized (map) {
            block4: {
                DiagramManager diagramManager = processToDiagramManagerMap.get(process);
                if (diagramManager == null) break block4;
                diagramManager.doDispose();
                processToDiagramManagerMap.remove(process);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<DiagramManager> getDiagramManagers() {
        ArrayList<DiagramManager> arrayList;
        Map<Process, DiagramManager> map = processToDiagramManagerMap;
        synchronized (map) {
            arrayList = new ArrayList<DiagramManager>(processToDiagramManagerMap.values());
        }
        return arrayList.isEmpty() ? Collections.EMPTY_LIST : arrayList;
    }

    private DiagramManager(Process process) {
        this.process = process;
    }

    public Process getProcess() {
        return this.process;
    }

    public void addResourceChangeListener(IResourceChangeListener iResourceChangeListener) {
        if (!this.resourceChangeListeners.contains(iResourceChangeListener)) {
            this.resourceChangeListeners.add(iResourceChangeListener);
        }
    }

    public void removeResourceChangeListener(IResourceChangeListener iResourceChangeListener) {
        this.resourceChangeListeners.remove(iResourceChangeListener);
    }

    public synchronized boolean addConsumer(Object object) {
        return this.consumers.add(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeConsumer(Object object) {
        boolean bl = this.consumers.remove(object);
        if (bl && this.consumers.isEmpty()) {
            Map<Process, DiagramManager> map = processToDiagramManagerMap;
            synchronized (map) {
                processToDiagramManagerMap.remove(this.process);
                if (processToDiagramManagerMap.isEmpty()) {
                    fileSynchronizer.uninstall();
                }
            }
            this.doDispose();
        }
        return bl;
    }

    public boolean isNewResource() {
        return this.resourceIsNew;
    }

    public void setResourceIsNew(boolean bl) {
        this.resourceIsNew = bl;
    }

    public InternalTransactionalEditingDomain getEditingDomain() {
        if (this.editingDomain == null && !this.isDisposed()) {
            this.editingDomain = this.createEditingDomain();
            this.resourceSet = (ExtendedResourceSet)this.editingDomain.getResourceSet();
        }
        return this.editingDomain;
    }

    private InternalTransactionalEditingDomain createEditingDomain() {
        GMFExtendedResourceSet gMFExtendedResourceSet = new GMFExtendedResourceSet();
        gMFExtendedResourceSet.add(this.process.eResource().getResourceSet());
        return (InternalTransactionalEditingDomain)DiagramEditingDomainFactory.getInstance().createEditingDomain((ResourceSet)gMFExtendedResourceSet);
    }

    private void doDispose() {
        if (this.resource != null) {
            IFile iFile = WorkspaceSynchronizer.getFile((Resource)this.resource);
            if (iFile != null) {
                fileSynchronizer.unmonitor(iFile);
            }
            this.resource = null;
        }
        this.resourceChangeListeners.clear();
        if (this.editingDomain != null) {
            this.resourceSet.dispose();
            this.resourceSet = null;
            this.editingDomain.dispose();
            this.editingDomain = null;
        }
        this.consumers.clear();
        if (this.activityToSavedDiagramMap != null) {
            this.activityToSavedDiagramMap.clear();
        }
        this.process = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<Process, DiagramManager> map = processToDiagramManagerMap;
        synchronized (map) {
            processToDiagramManagerMap.remove(this.process);
        }
        this.doDispose();
    }

    public boolean isDisposed() {
        return this.process == null;
    }

    public List<Diagram> getDiagrams(org.eclipse.epf.uma.Activity activity, int n) throws CoreException {
        this.checkActivity(activity);
        Resource resource = this.getResource(false);
        if (resource != null) {
            ArrayList<Diagram> arrayList = new ArrayList<Diagram>();
            for (EObject eObject : resource.getContents()) {
                if (!(eObject instanceof Diagram)) continue;
                Diagram diagram = (Diagram)eObject;
                String string = DiagramManager.getDiagramTypeString(n);
                if (!string.equals(diagram.getType()) || !DiagramManager.isDiagramOf(diagram, activity)) continue;
                EObject eObject2 = diagram.getElement();
                if (eObject2 instanceof DiagramImpl) {
                    ((DiagramImpl)eObject2).setGraphicalDataRequired(false);
                }
                arrayList.add(diagram);
            }
            if (!arrayList.isEmpty()) {
                return arrayList;
            }
        }
        return Collections.emptyList();
    }

    private static void markInherited(Diagram diagram) {
        EList eList = diagram.getChildren();
        int n = eList.size();
        int n2 = 0;
        while (n2 < n) {
            View view = (View)eList.get(n2);
            BridgeHelper.markInherited((EModelElement)view);
            ++n2;
        }
    }

    private static String getDiagramTypeString(int n) {
        switch (n) {
            case 2: {
                return ADD_kind;
            }
            case 0: {
                return AD_kind;
            }
            case 1: {
                return WPD_kind;
            }
        }
        return null;
    }

    public static int getDiagramType(String string) {
        if (AD_kind.equals(string)) {
            return 0;
        }
        if (ADD_kind.equals(string)) {
            return 2;
        }
        if (WPD_kind.equals(string)) {
            return 1;
        }
        return -1;
    }

    public void associate(Diagram diagram, int n, org.eclipse.epf.uma.Activity activity) throws CoreException {
        switch (n) {
            case 0: {
                this.associateAD(diagram, activity);
                return;
            }
            case 2: {
                this.associateADD(diagram, activity);
                return;
            }
            case 1: {
                this.associateWPD(diagram, activity);
            }
        }
    }

    private void associateWPD(Diagram diagram, org.eclipse.epf.uma.Activity activity) throws CoreException {
        if (diagram.getElement() instanceof WorkProductDependencyDiagram) {
            ((WorkProductDependencyDiagram)diagram.getElement()).setLinkedElement((MethodElement)activity);
            ((DiagramImpl)diagram.getElement()).setGraphicalDataRequired(false);
        }
        this.getResource().getContents().add((Object)diagram.getElement());
        this.getResource().getContents().add((Object)diagram);
    }

    private void associateAD(Diagram diagram, org.eclipse.epf.uma.Activity activity) throws CoreException {
        if (diagram.getElement() instanceof EModelElement) {
            BridgeHelper.associate((EModelElement)diagram.getElement(), (MethodElement)activity);
        }
        this.getResource().getContents().add((Object)diagram.getElement());
        this.getResource().getContents().add((Object)diagram);
    }

    private void associateADD(Diagram diagram, org.eclipse.epf.uma.Activity activity) throws CoreException {
        if (diagram.getElement() instanceof ActivityDetailDiagram) {
            ((ActivityDetailDiagram)diagram.getElement()).setLinkedElement((MethodElement)activity);
            ((DiagramImpl)diagram.getElement()).setGraphicalDataRequired(false);
        }
        this.getResource().getContents().add((Object)diagram.getElement());
        this.getResource().getContents().add((Object)diagram);
    }

    private Diagram copyDiagram(Diagram diagram, org.eclipse.epf.uma.Activity activity) {
        Diagram diagram2 = DiagramHelper.copyDiagram((EditingDomain)this.getEditingDomain(), diagram);
        DiagramHelper.reassociate(activity, diagram2);
        return diagram2;
    }

    public Diagram createDiagram(final org.eclipse.epf.uma.Activity activity, final int n, PreferencesHint preferencesHint) throws CoreException {
        org.eclipse.epf.uma.Activity activity2;
        block11: {
            this.checkActivity(activity);
            if (ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)activity)) {
                activity2 = (org.eclipse.epf.uma.Activity)activity.getVariabilityBasedOnElement();
                DiagramManager diagramManager = DiagramManager.getInstance(TngUtil.getOwningProcess((BreakdownElement)activity2), this);
                try {
                    Diagram diagram;
                    List<Diagram> list = diagramManager.getDiagrams(activity2, n);
                    if (!list.isEmpty() && (diagram = list.get(0)) != null) {
                        final Diagram diagram2 = this.copyDiagram(diagram, activity);
                        TxUtil.runInTransaction((TransactionalEditingDomain)this.getEditingDomain(), (Runnable)new Runnable(){

                            public void run() {
                                DiagramManager.markInherited(diagram2);
                                try {
                                    DiagramManager.this.associate(diagram2, n, activity);
                                }
                                catch (CoreException coreException) {
                                    throw new WrappedException((Exception)((Object)coreException));
                                }
                            }
                        });
                        Diagram diagram3 = diagram2;
                        return diagram3;
                    }
                }
                catch (Exception exception) {
                    CommonPlugin.getDefault().getLogger().logError("Error in retrieving base diagram: ", (Throwable)exception);
                }
                finally {
                    if (diagramManager != null) {
                        diagramManager.removeConsumer(this);
                    }
                }
            }
            activity2 = new Diagram[1];
            try {
                TxUtil.runInTransaction((TransactionalEditingDomain)this.getEditingDomain(), (Runnable)new Runnable((Diagram[])activity2, activity, n, preferencesHint){
                    private final /* synthetic */ Diagram[] val$resultHolder;
                    private final /* synthetic */ org.eclipse.epf.uma.Activity val$act;
                    private final /* synthetic */ int val$type;
                    private final /* synthetic */ PreferencesHint val$hint;
                    {
                        this.val$resultHolder = diagramArray;
                        this.val$act = activity;
                        this.val$type = n;
                        this.val$hint = preferencesHint;
                    }

                    public void run() {
                        try {
                            this.val$resultHolder[0] = DiagramManager.this.doCreateDiagram(this.val$act, this.val$type, this.val$hint);
                        }
                        catch (CoreException coreException) {
                            throw new WrappedException((Exception)((Object)coreException));
                        }
                    }
                });
            }
            catch (Exception exception) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
                if (!DEBUG) break block11;
                exception.printStackTrace();
            }
        }
        return activity2[0];
    }

    private Diagram doCreateDiagram(org.eclipse.epf.uma.Activity activity, int n, PreferencesHint preferencesHint) throws CoreException {
        switch (n) {
            case 0: {
                return this.createAD(activity, preferencesHint);
            }
            case 2: {
                return this.createADD(activity, preferencesHint);
            }
            case 1: {
                return this.createWPDD(activity, preferencesHint);
            }
        }
        return null;
    }

    private Diagram createWPDD(org.eclipse.epf.uma.Activity activity, PreferencesHint preferencesHint) throws CoreException {
        WorkProductDependencyDiagram workProductDependencyDiagram = ModelFactory.eINSTANCE.createWorkProductDependencyDiagram();
        if (workProductDependencyDiagram instanceof DiagramImpl) {
            ((DiagramImpl)workProductDependencyDiagram).setGraphicalDataRequired(false);
        }
        workProductDependencyDiagram.setNew(true);
        Diagram diagram = ViewService.createDiagram((EObject)workProductDependencyDiagram, (String)DiagramManager.getDiagramTypeString(1), (PreferencesHint)preferencesHint);
        if (diagram != null) {
            diagram.setName(activity.getName());
            workProductDependencyDiagram.setLinkedElement((MethodElement)activity);
            this.getResource().getContents().add((Object)workProductDependencyDiagram);
            this.getResource().getContents().add((Object)diagram);
        }
        return diagram;
    }

    private Diagram createADD(org.eclipse.epf.uma.Activity activity, PreferencesHint preferencesHint) throws CoreException {
        ActivityDetailDiagram activityDetailDiagram = ModelFactory.eINSTANCE.createActivityDetailDiagram();
        if (activityDetailDiagram instanceof DiagramImpl) {
            ((DiagramImpl)activityDetailDiagram).setGraphicalDataRequired(false);
        }
        activityDetailDiagram.setNew(true);
        Diagram diagram = ViewService.createDiagram((EObject)activityDetailDiagram, (String)DiagramManager.getDiagramTypeString(2), (PreferencesHint)preferencesHint);
        if (diagram != null) {
            activityDetailDiagram.setLinkedElement((MethodElement)activity);
            diagram.setName(activity.getName());
            this.getResource().getContents().add((Object)activityDetailDiagram);
            this.getResource().getContents().add((Object)diagram);
        }
        return diagram;
    }

    private Diagram createAD(org.eclipse.epf.uma.Activity activity, PreferencesHint preferencesHint) throws CoreException {
        Activity activity2 = UMLFactory.eINSTANCE.createActivity();
        Diagram diagram = ViewService.createDiagram((EObject)activity2, (String)DiagramManager.getDiagramTypeString(0), (PreferencesHint)preferencesHint);
        if (diagram != null) {
            BridgeHelper.associate((EModelElement)activity2, (MethodElement)activity);
            diagram.setName(activity.getName());
            activity2.setName(activity.getName());
            this.getResource().getContents().add((Object)activity2);
            this.getResource().getContents().add((Object)diagram);
        }
        return diagram;
    }

    private IProgressMonitor getMonitor() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        return this.monitor;
    }

    public static String getDiagramFilePath(Process process) {
        ProcessComponent processComponent;
        block4: {
            try {
                processComponent = (ProcessComponent)process.eContainer();
                if (processComponent != null) break block4;
                return null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        if (UmaUtil.hasDirectResource((EObject)processComponent)) {
            return new File(new File(FileManager.toFileString((URI)process.eResource().getURI())).getParentFile(), DIAGRAM_FILENAME).getCanonicalPath();
        }
        URI uRI = MultiFileSaveUtil.createURI((MethodElement)processComponent, (ResourceSet)processComponent.eResource().getResourceSet());
        return new File(new File(uRI.toFileString()).getParentFile(), DIAGRAM_FILENAME).getCanonicalPath();
    }

    public void reload() throws IOException {
        if (this.resource == null) {
            return;
        }
        this.resource.unload();
        this.resource.load(Collections.EMPTY_MAP);
        IFile iFile = WorkspaceSynchronizer.getFile((Resource)this.resource);
        fileSynchronizer.updateModificationStamp(iFile);
        this.notifyReloaded();
    }

    public Resource getResource() throws CoreException {
        if (this.resource == null) {
            this.resource = this.getResource(true);
        }
        return this.resource;
    }

    private static URI createDiagramResourceURI(String string) {
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(string));
        return URI.createPlatformResourceURI((String)iFile.getFullPath().toString());
    }

    private static Resource loadDiagramResource(IFile iFile, EditingDomain editingDomain, Map map, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        iFile.refreshLocal(0, iProgressMonitor);
        URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
        Resource resource = editingDomain.getResourceSet().getResource(uRI, false);
        if (resource == null) {
            resource = editingDomain.getResourceSet().createResource(uRI);
        }
        if (!resource.isLoaded()) {
            HashMap hashMap = new HashMap(GMFResourceFactory.getDefaultLoadOptions());
            for (Object k : map.keySet()) {
                hashMap.put(k, map.get(k));
            }
            try {
                resource.load(hashMap);
            }
            catch (IOException iOException) {
                resource.unload();
                throw iOException;
            }
        }
        return resource;
    }

    private Resource getResource(boolean bl) throws CoreException {
        block17: {
            if (this.resource == null) {
                String string = DiagramManager.getDiagramFilePath(this.process);
                if (string != null) {
                    IResource iResource = FileManager.getResourceForLocation((String)string);
                    if (iResource instanceof IFile) {
                        IFile iFile = (IFile)iResource;
                        try {
                            Diagram diagram = DiagramIOUtil.load((TransactionalEditingDomain)this.getEditingDomain(), (IFile)iFile, (boolean)true, (IProgressMonitor)this.getMonitor());
                            this.resource = diagram.eResource();
                        }
                        catch (CoreException coreException) {
                            if (org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.l10n.EditorMessages.Diagram_NO_DIAGRAM_IN_RESOURCE.equals(coreException.getMessage())) {
                                try {
                                    this.resource = DiagramManager.loadDiagramResource(iFile, (EditingDomain)this.getEditingDomain(), Collections.EMPTY_MAP, this.getMonitor());
                                }
                                catch (IOException iOException) {
                                    if (DEBUG) {
                                        DiagramCorePlugin.getDefault().getLogger().logError((Throwable)coreException);
                                    }
                                    throw new CoreException((IStatus)new Status(4, "org.eclipse.epf.diagram.core", iOException.getMessage(), (Throwable)iOException));
                                }
                            }
                            throw coreException;
                        }
                        fileSynchronizer.monitor(iFile);
                    } else if (bl) {
                        this.resource = this.getEditingDomain().getResourceSet().createResource(DiagramManager.createDiagramResourceURI(string));
                        this.resourceIsNew = true;
                        try {
                            TxUtil.runInTransaction((TransactionalEditingDomain)this.getEditingDomain(), (Runnable)new Runnable(){

                                public void run() {
                                    DiagramManager.this.resource.getContents().clear();
                                }
                            });
                        }
                        catch (Exception exception) {
                            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
                        }
                    }
                }
            } else if (!this.resource.isLoaded()) {
                try {
                    this.resource.load(Collections.EMPTY_MAP);
                    this.notifyReloaded();
                }
                catch (IOException iOException) {
                    CommonPlugin.getDefault().getLogger().logError((Throwable)iOException);
                    if (!DEBUG) break block17;
                    iOException.printStackTrace();
                }
            }
        }
        return this.resource;
    }

    private void notifyReloaded() {
        for (IResourceChangeListener iResourceChangeListener : this.resourceChangeListeners) {
            try {
                iResourceChangeListener.resourceChanged((IResourceChangeEvent)new ResourceChangeEvent((Object)this, 1, 0, null));
            }
            catch (Exception exception) {
                CommonPlugin.getDefault().getLogger().logError((Throwable)exception);
                if (!DEBUG) continue;
                exception.printStackTrace();
            }
        }
    }

    private void checkActivity(org.eclipse.epf.uma.Activity activity) {
        Process process = TngUtil.getOwningProcess((BreakdownElement)activity);
        if (process != this.process) {
            throw new IllegalArgumentException("The specified activity does not belong to the process of this diagram manager.");
        }
    }

    private static boolean isDiagramOf(Diagram diagram, org.eclipse.epf.uma.Activity activity) {
        if (AD_kind.equals(diagram.getType())) {
            return BridgeHelper.getMethodElementFromAnnotation((EModelElement)diagram.getElement(), activity.eResource().getResourceSet()) == activity;
        }
        if (ADD_kind.equals(diagram.getType())) {
            EObject eObject = diagram.getElement();
            return eObject instanceof ActivityDetailDiagram && ((ActivityDetailDiagram)eObject).getLinkedElement() == activity;
        }
        if (WPD_kind.equals(diagram.getType())) {
            EObject eObject = diagram.getElement();
            return eObject instanceof WorkProductDependencyDiagram && ((WorkProductDependencyDiagram)eObject).getLinkedElement() == activity;
        }
        return false;
    }

    public static void checkSynchronizationState(Resource resource) throws CoreException {
        if (!DiagramManager.isSynchronized(resource)) {
            Status status = new Status(4, "org.eclipse.ui", 274, EditorMessages.FileDocumentProvider_error_out_of_sync, null);
            throw new CoreException((IStatus)status);
        }
    }

    public static boolean isSynchronized(Resource resource) {
        FileSynchronizer.FileInfo fileInfo;
        IFile iFile = WorkspaceSynchronizer.getFile((Resource)resource);
        if (iFile != null && (fileInfo = fileSynchronizer.getFileInfo(iFile)) != null) {
            return fileInfo.fModificationStamp == FileSynchronizer.computeModificationStamp((IResource)iFile);
        }
        return true;
    }

    private Map<org.eclipse.epf.uma.Activity, Map<String, Diagram>> getActivityToSavedDiagramsMap() {
        if (this.activityToSavedDiagramMap == null) {
            this.activityToSavedDiagramMap = new HashMap();
        }
        return this.activityToSavedDiagramMap;
    }

    private Diagram getDiagramBackup(org.eclipse.epf.uma.Activity activity, String string) {
        Map<String, Diagram> map;
        if (this.activityToSavedDiagramMap != null && (map = this.activityToSavedDiagramMap.get(activity)) != null) {
            return map.get(string);
        }
        return null;
    }

    public void replaceTemporarily(final org.eclipse.epf.uma.Activity activity, final Diagram diagram) {
        try {
            new AbstractEMFOperation((TransactionalEditingDomain)this.getEditingDomain(), ""){

                protected IStatus doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                    try {
                        List<Diagram> list = DiagramManager.this.getDiagrams(activity, DiagramManager.getDiagramType(diagram.getType()));
                        if (!list.isEmpty()) {
                            Diagram diagram2 = list.get(0);
                            HashMap<String, Diagram> hashMap = (HashMap<String, Diagram>)DiagramManager.this.getActivityToSavedDiagramsMap().get(activity);
                            if (hashMap == null) {
                                hashMap = new HashMap<String, Diagram>();
                                DiagramManager.this.getActivityToSavedDiagramsMap().put(activity, hashMap);
                            }
                            if (hashMap.get(diagram.getType()) == null) {
                                hashMap.put(diagram.getType(), diagram2);
                            }
                            ((InternalEObject)diagram).eSetProxyURI(null);
                            TreeIterator treeIterator = diagram.eAllContents();
                            while (treeIterator.hasNext()) {
                                ((InternalEObject)treeIterator.next()).eSetProxyURI(null);
                            }
                            ((InternalEObject)diagram.getElement()).eSetProxyURI(null);
                            treeIterator = diagram.getElement().eAllContents();
                            while (treeIterator.hasNext()) {
                                ((InternalEObject)treeIterator.next()).eSetProxyURI(null);
                            }
                            DiagramManager.this.resource.getContents().set(DiagramManager.this.resource.getContents().indexOf((Object)diagram2), (Object)diagram);
                            DiagramManager.this.resource.getContents().set(DiagramManager.this.resource.getContents().indexOf((Object)diagram2.getElement()), (Object)diagram.getElement());
                        } else {
                            DiagramManager.this.resource.getContents().add((Object)diagram.getElement());
                            DiagramManager.this.resource.getContents().add((Object)diagram);
                        }
                    }
                    catch (CoreException coreException) {
                        CommonPlugin.getDefault().getLogger().logError((Throwable)coreException);
                    }
                    return Status.OK_STATUS;
                }
            }.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            CommonPlugin.getDefault().getLogger().logError((Throwable)executionException);
        }
    }

    private Diagram getSavedDiagram(org.eclipse.epf.uma.Activity activity, Diagram diagram) {
        Diagram diagram2 = this.getDiagramBackup(activity, diagram.getType());
        return diagram2;
    }

    public synchronized boolean reverseToSaved(final org.eclipse.epf.uma.Activity activity, final Diagram diagram, PreferencesHint preferencesHint) {
        final Diagram diagram2 = this.getSavedDiagram(activity, diagram);
        try {
            new AbstractEMFOperation((TransactionalEditingDomain)this.getEditingDomain(), ""){

                protected IStatus doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                    if (diagram2 != null) {
                        DiagramManager.this.resource.getContents().set(DiagramManager.this.resource.getContents().indexOf((Object)diagram), (Object)diagram2);
                        DiagramManager.this.resource.getContents().set(DiagramManager.this.resource.getContents().indexOf((Object)diagram.getElement()), (Object)diagram2.getElement());
                        DiagramManager.this.removeDiagramBackup(activity, diagram.getType());
                    } else {
                        DiagramManager.this.resource.getContents().remove((Object)diagram.getElement());
                        DiagramManager.this.resource.getContents().remove((Object)diagram);
                    }
                    ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = LibraryServiceUtil.getPersisterFor((Resource)activity.eResource()).getFailSafePersister();
                    try {
                        failSafeMethodLibraryPersister.save(DiagramManager.this.resource);
                        failSafeMethodLibraryPersister.commit();
                    }
                    catch (Exception exception) {
                        DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
                        try {
                            failSafeMethodLibraryPersister.rollback();
                        }
                        catch (Exception exception2) {}
                        throw new ExecutionException(exception.getMessage(), (Throwable)exception);
                    }
                    return Status.OK_STATUS;
                }
            }.execute((IProgressMonitor)new NullProgressMonitor(), null);
            return true;
        }
        catch (ExecutionException executionException) {
            CommonPlugin.getDefault().getLogger().logError((Throwable)executionException);
            return false;
        }
    }

    public void updateResourceURI() {
        String string;
        File file;
        if (this.resource == null) {
            return;
        }
        File file2 = new File(FileManager.toFileString((URI)this.resource.getURI())).getParentFile();
        if (!file2.equals(file = new File(this.process.eResource().getURI().toFileString()).getParentFile()) && (string = DiagramManager.getDiagramFilePath(this.process)) != null && new File(string).exists()) {
            this.resource.setURI(DiagramManager.createDiagramResourceURI(string));
        }
    }

    public void backupDiagram(org.eclipse.epf.uma.Activity activity, Diagram diagram) {
        Map<String, Diagram> map = this.getActivityToSavedDiagramsMap().get(activity);
        if (map == null) {
            map = new HashMap<String, Diagram>();
            this.getActivityToSavedDiagramsMap().put(activity, map);
        }
        map.put(diagram.getType(), DiagramHelper.copyDiagram((EditingDomain)this.getEditingDomain(), diagram));
    }

    public Diagram removeDiagramBackup(org.eclipse.epf.uma.Activity activity, String string) {
        Map<String, Diagram> map;
        if (this.activityToSavedDiagramMap != null && (map = this.activityToSavedDiagramMap.get(activity)) != null) {
            return map.remove(string);
        }
        return null;
    }

    private class GMFExtendedResourceSet
    extends ExtendedResourceSet {
        private GMFExtendedResourceSet() {
        }

        protected int getURIType(URI uRI) {
            if ("uma".equals(uRI.scheme())) {
                return 2;
            }
            if (DiagramManager.DIAGRAM_FILENAME.equals(uRI.lastSegment())) {
                return 1;
            }
            return 2;
        }

        public Resource createResource(URI uRI) {
            GMFResourceEx gMFResourceEx = new GMFResourceEx(uRI);
            gMFResourceEx.getDefaultLoadOptions().putAll(GMFResourceFactory.getDefaultLoadOptions());
            gMFResourceEx.getDefaultSaveOptions().putAll(GMFResourceFactory.getDefaultSaveOptions());
            if (!gMFResourceEx.getEncoding().equals("UTF-8")) {
                gMFResourceEx.setEncoding("UTF-8");
            }
            this.getResources().add((Object)gMFResourceEx);
            return gMFResourceEx;
        }
    }

    private class GMFResourceEx
    extends GMFResource
    implements IFailSafeSavable {
        private FailSafePersistenceHelper failSafePersistenceHelper;

        public GMFResourceEx(URI uRI) {
            super(uRI);
        }

        protected XMLHelper createXMLHelper() {
            return new GMFHelper((XMLResource)this){

                protected URI getHREF(Resource resource, EObject eObject) {
                    if (resource instanceof ILibraryResource) {
                        return ((ILibraryResource)resource).getProxyURI(eObject);
                    }
                    return super.getHREF(resource, eObject);
                }
            };
        }

        public void updateInfo() {
            IFile iFile = WorkspaceSynchronizer.getFile((Resource)this);
            if (DiagramManager.this.resourceIsNew) {
                DiagramManager.this.resourceIsNew = false;
                fileSynchronizer.monitor(iFile);
            }
            fileSynchronizer.updateModificationStamp(iFile);
            try {
                iFile.refreshLocal(0, null);
            }
            catch (CoreException coreException) {
                CommonPlugin.getDefault().getLogger().logError((Throwable)coreException);
            }
        }

        public void save(Map map) throws IOException {
            super.save(map);
            if (!this.hasTempURI()) {
                this.updateInfo();
            }
        }

        private Adapter superCreateModificationAdapter() {
            return super.createModificationTrackingAdapter();
        }

        protected Adapter createModificationTrackingAdapter() {
            return new AdapterImpl(){
                private Adapter delegate;
                {
                    this.delegate = GMFResourceEx.this.superCreateModificationAdapter();
                }

                public void notifyChanged(Notification notification) {
                    this.delegate.notifyChanged(notification);
                    GMFResourceEx.this.notifyDiagramChangeListeners(notification);
                }
            };
        }

        public void eNotify(Notification notification) {
            if (this.isLoaded() && notification.getNotifier() instanceof Resource && notification.getFeatureID(Resource.class) == 3 && notification.getEventType() == 1) {
                int n;
                if (this.eAdapters != null && this.eDeliver() && (n = this.eAdapters.size()) > 0) {
                    Adapter[] adapterArray = (Adapter[])this.eAdapters.data();
                    int n2 = 0;
                    while (n2 < n) {
                        Adapter adapter = adapterArray[n2];
                        if (!(adapter instanceof AccessibleDiagramModificationListener)) {
                            adapter.notifyChanged(notification);
                        }
                        ++n2;
                    }
                }
            } else {
                super.eNotify(notification);
            }
        }

        protected void notifyDiagramChangeListeners(Notification notification) {
            int n;
            BasicEList basicEList = this.eBasicAdapters();
            if (basicEList != null && this.eDeliver() && (n = basicEList.size()) > 0) {
                Adapter[] adapterArray = (Adapter[])basicEList.data();
                int n2 = 0;
                while (n2 < n) {
                    Adapter adapter = adapterArray[n2];
                    if (adapter instanceof AccessibleDiagramModificationListener) {
                        adapter.notifyChanged(notification);
                    }
                    ++n2;
                }
            }
        }

        private FailSafePersistenceHelper getFailSafePersistenceHelper() {
            if (this.failSafePersistenceHelper == null) {
                String string = String.valueOf(DiagramManager.this.process.getGuid()) + DiagramManager.DIAGRAM_FILENAME_WITHOUT_EXTENSION;
                this.failSafePersistenceHelper = new FailSafePersistenceHelper((Resource)this, string);
                this.failSafePersistenceHelper.setCommitEmptyResource(true);
            }
            return this.failSafePersistenceHelper;
        }

        public void commit() {
            this.getFailSafePersistenceHelper().commit();
        }

        public void deleteBackup() {
            this.getFailSafePersistenceHelper().deleteBackup();
        }

        public boolean hasTempURI() {
            return this.getFailSafePersistenceHelper().hasTempURI();
        }

        public boolean restore() {
            return this.getFailSafePersistenceHelper().restore();
        }

        public void setTxID(String string) {
            this.getFailSafePersistenceHelper().setTempURI(string);
        }

        public void txFinished(boolean bl) {
            this.getFailSafePersistenceHelper().txFinished(bl);
            if (bl) {
                this.updateInfo();
            }
        }

        protected void doUnload() {
            super.doUnload();
            TreeIterator treeIterator = this.getAllProperContents(this.unloadingContents);
            ArrayList<EObject> arrayList = new ArrayList<EObject>();
            while (treeIterator.hasNext()) {
                arrayList.add((EObject)treeIterator.next());
            }
            for (EObject eObject : arrayList) {
                EcoreUtil.remove((EObject)eObject);
            }
        }
    }
}

