/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.util;

import com.ibm.icu.text.BreakIterator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.core.bridge.ActivityDiagramAdapter;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.figures.WidenedWrapLabel;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.IDiagramEditorInputProvider;
import org.eclipse.epf.diagram.core.util.DiagramConstants;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeTypes;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.uml2.uml.ActivityNode;

public final class DiagramCoreUtil {
    public static void setLabelProperties(WrapLabel wrapLabel) {
        wrapLabel.setFont(DiagramConstants.DEFAULT_FONT);
        wrapLabel.setIconAlignment(8);
        wrapLabel.setLabelAlignment(8);
        wrapLabel.setTextAlignment(8);
        wrapLabel.setTextPlacement(4);
        wrapLabel.setTextWrap(true);
        wrapLabel.setTextWrapAlignment(2);
    }

    public static void setDefaultFontPreference(IPreferenceStore iPreferenceStore) {
        FontData[] fontDataArray = JFaceResources.getDefaultFont().getFontData();
        FontData fontData = fontDataArray[0];
        fontData.setHeight(8);
        fontData.setName(DiagramConstants.DEFAULT_FONT_NAME);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"Appearance.defaultFont", (FontData)fontData);
    }

    public static String validStringForBreakdownElements(EditPart editPart, String string) {
        Object object = editPart.getModel();
        if (object instanceof Node) {
            Node node = (Node)object;
            EObject eObject = node.getElement();
            MethodElement methodElement = BridgeHelper.getMethodElement((EModelElement)eObject);
            EObject eObject2 = node.getDiagram().getElement();
            ActivityDiagramAdapter activityDiagramAdapter = (ActivityDiagramAdapter)BridgeHelper.getNodeAdapter(eObject2);
            if (activityDiagramAdapter != null) {
                if (methodElement instanceof Activity) {
                    return TngUtil.checkWBSActivityPresentationName((Object)methodElement, (String)string, (Suppression)activityDiagramAdapter.getSuppression());
                }
                return TngUtil.checkWorkBreakdownElementPresentationName((Object)methodElement, (String)string, (Suppression)activityDiagramAdapter.getSuppression());
            }
        }
        return null;
    }

    public static Color getFontColor(AbstractEditPart abstractEditPart) {
        Object object;
        if (LibraryUtil.PUBLISH_MODE) {
            return null;
        }
        EditPartViewer editPartViewer = abstractEditPart.getViewer();
        if (editPartViewer instanceof IDiagramEditorInputProvider && (object = ((IDiagramEditorInputProvider)editPartViewer).getDiagramEditorInput()) != null && ((DiagramEditorInput)object).getWrapper() != null) {
            return DiagramConstants.READ_ONLY_FONT_COLOR;
        }
        object = abstractEditPart.getModel();
        if (object instanceof View) {
            return DiagramCoreUtil.getFontColor((View)object);
        }
        return null;
    }

    private static Color getFontColor(View view) {
        if (BridgeHelper.isReadOnly(view)) {
            return DiagramConstants.READ_ONLY_FONT_COLOR;
        }
        return null;
    }

    public static DiagramEditPart getDiagramEditPart(EditPart editPart) {
        while (editPart != null && !(editPart instanceof DiagramEditPart)) {
            editPart = editPart.getParent();
        }
        return (DiagramEditPart)editPart;
    }

    public static boolean isReadOnly(AbstractEditPart abstractEditPart) {
        Object object = abstractEditPart.getModel();
        if (object instanceof View) {
            return BridgeHelper.isReadOnly((View)object);
        }
        return false;
    }

    public static boolean isSyncBar(EditPart editPart) {
        View view;
        EObject eObject;
        if (editPart instanceof IGraphicalEditPart && (eObject = (view = (View)editPart.getModel()).getElement()) instanceof ActivityNode) {
            return BridgeHelper.isSynchBar((ActivityNode)eObject);
        }
        return false;
    }

    public static String wrap(String string, int n) {
        String string2 = "";
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        String string3 = string;
        while (true) {
            if (string3.length() <= n) {
                string2 = String.valueOf(string2) + string3;
                break;
            }
            breakIterator.setText(string3);
            int n2 = breakIterator.following(n);
            if (n2 == -1) {
                string2 = String.valueOf(string2) + string3;
                break;
            }
            if (n2 >= string3.length()) {
                string2 = String.valueOf(string2) + string3;
                break;
            }
            string2 = String.valueOf(string2) + string3.substring(0, n2) + "\n";
            string3 = string3.substring(n2);
        }
        return string2;
    }

    public static void setDefaultLineStyle(IPreferenceStore iPreferenceStore) {
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"Appearance.lineColor", (RGB)PreferenceConverter.COLOR_DEFAULT_DEFAULT);
    }

    public static int getTextHeight(String string, FontStyle fontStyle, int n) {
        Dimension dimension;
        Font font = null;
        String string2 = null;
        int n2 = 0;
        if (fontStyle != null) {
            string2 = fontStyle.getFontName();
            n2 = fontStyle.getFontHeight();
            if (string2 == null) {
                string2 = DiagramConstants.getFontName();
            }
            if (n2 == 0) {
                n2 = 8;
            }
            font = new Font(null, string2, n2, 0);
        } else {
            font = DiagramConstants.DEFAULT_FONT;
        }
        try {
            dimension = FigureUtilities.getTextExtents((String)string, (Font)font);
        }
        finally {
            if (font != null && font != DiagramConstants.DEFAULT_FONT) {
                font.dispose();
            }
        }
        int n3 = 0;
        if (dimension != null && dimension.width > 0) {
            int n4 = dimension.width / n;
            int n5 = dimension.width % n;
            if (n5 != 0) {
                ++n4;
            }
            n3 = n4;
            return n3 * n2;
        }
        return 0;
    }

    public static Dimension getTextSizeInWrapLabel(String string, Font font, int n, int n2, IMapMode iMapMode) {
        class MyWrapLabel
        extends WidenedWrapLabel
        implements IMapMode {
            private IMapMode mapMode;

            public MyWrapLabel(IMapMode iMapMode) {
                this.mapMode = iMapMode != null ? iMapMode : MapModeTypes.IDENTITY_MM;
            }

            public int DPtoLP(int n) {
                return this.mapMode.DPtoLP(n);
            }

            public Translatable DPtoLP(Translatable translatable) {
                return this.mapMode.DPtoLP(translatable);
            }

            public int LPtoDP(int n) {
                return this.mapMode.LPtoDP(n);
            }

            public Translatable LPtoDP(Translatable translatable) {
                return this.mapMode.LPtoDP(translatable);
            }
        }
        MyWrapLabel myWrapLabel = new MyWrapLabel(iMapMode);
        DiagramCoreUtil.setLabelProperties(myWrapLabel);
        myWrapLabel.setText(string);
        if (font != null) {
            myWrapLabel.setFont(font);
        }
        return myWrapLabel.getTextSize(n, n2);
    }
}

