/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma.ecore.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValueManager {
    public static final DefaultValueManager INSTANCE = new DefaultValueManager();
    private final Map<EStructuralFeature, Map<EClass, Object>> featureToTypedDefaultValuesMap = new HashMap<EStructuralFeature, Map<EClass, Object>>();
    private final Map<EClass, Map<EStructuralFeature, Object>> typeToFeatureDefaultValueMap = new HashMap<EClass, Map<EStructuralFeature, Object>>();
    private final Map<EStructuralFeature, Map<EClass, Object>> featureToTypedStaticDefaultValuesMap = new HashMap<EStructuralFeature, Map<EClass, Object>>();
    private final Map<EClass, Map<EStructuralFeature, Object>> typeToFeatureStaticDefaultValueMap = new HashMap<EClass, Map<EStructuralFeature, Object>>();
    private volatile boolean useStatic;

    protected DefaultValueManager() {
    }

    public void setUseStatic(boolean bl) {
        this.useStatic = bl;
    }

    public boolean isUseStatic() {
        return this.useStatic;
    }

    private static Map<EStructuralFeature, Object> getFeatureToDefaultValueMap(EClass eClass, Map<EStructuralFeature, Map<EClass, Object>> map, Map<EStructuralFeature, Object> map2) {
        Map<Object, Object> map3;
        if (map.isEmpty()) {
            map3 = Collections.EMPTY_MAP;
        } else {
            map3 = new HashMap<EStructuralFeature, Object>();
            for (Map.Entry<EStructuralFeature, Map<EClass, Object>> entry : map.entrySet()) {
                EStructuralFeature eStructuralFeature = entry.getKey();
                if (eClass.getFeatureID(eStructuralFeature) == -1) continue;
                Object object = null;
                EClass eClass2 = eClass;
                boolean bl = false;
                for (Map.Entry<EClass, Object> entry2 : entry.getValue().entrySet()) {
                    EClass eClass3 = entry2.getKey();
                    if (!eClass3.isSuperTypeOf(eClass) || eClass2 != null && !eClass2.isSuperTypeOf(eClass3)) continue;
                    eClass2 = eClass3;
                    object = entry2.getValue();
                    bl = true;
                }
                if (!bl) continue;
                Object object2 = map2.get(eStructuralFeature);
                if (object2 == null) {
                    object2 = eStructuralFeature.getDefaultValue();
                }
                if ((object != null || object2 == null) && (object == null || object.equals(object2))) continue;
                map3.put(eStructuralFeature, object);
            }
            if (map3.isEmpty()) {
                map3 = Collections.EMPTY_MAP;
            }
        }
        return map3;
    }

    public synchronized Map<EStructuralFeature, Object> getFeatureToDefaultValueMap(EClass eClass) {
        if (this.useStatic) {
            return this.getFeatureToStaticDefaultValueMap(eClass);
        }
        return this.getFeatureToDynamicDefaultValueMap(eClass);
    }

    private synchronized Map<EStructuralFeature, Object> getFeatureToDynamicDefaultValueMap(EClass eClass) {
        Map<EStructuralFeature, Object> map = this.typeToFeatureDefaultValueMap.get(eClass);
        if (map == null) {
            map = DefaultValueManager.getFeatureToDefaultValueMap(eClass, this.featureToTypedDefaultValuesMap, this.getFeatureToStaticDefaultValueMap(eClass));
            this.typeToFeatureDefaultValueMap.put(eClass, map);
        }
        return map;
    }

    private synchronized Map<EStructuralFeature, Object> getFeatureToStaticDefaultValueMap(EClass eClass) {
        Map<EStructuralFeature, Object> map = this.typeToFeatureStaticDefaultValueMap.get(eClass);
        if (map == null) {
            map = DefaultValueManager.getFeatureToDefaultValueMap(eClass, this.featureToTypedStaticDefaultValuesMap, Collections.EMPTY_MAP);
            this.typeToFeatureStaticDefaultValueMap.put(eClass, map);
        }
        return map;
    }

    private static final synchronized void setDefaultValue(EClass eClass, EStructuralFeature eStructuralFeature, Object object, Map<EStructuralFeature, Map<EClass, Object>> map) {
        if (!eStructuralFeature.getEContainingClass().isSuperTypeOf(eClass)) {
            return;
        }
        Map<EClass, Object> map2 = map.get(eStructuralFeature);
        if (map2 == null) {
            map2 = new HashMap<EClass, Object>();
            map.put(eStructuralFeature, map2);
        }
        map2.put(eClass, object);
    }

    public final synchronized void setDefaultValue(EClass eClass, EStructuralFeature eStructuralFeature, Object object) {
        DefaultValueManager.setDefaultValue(eClass, eStructuralFeature, object, this.featureToTypedDefaultValuesMap);
        this.typeToFeatureDefaultValueMap.clear();
    }

    public final synchronized void setStaticDefaultValue(EClass eClass, EStructuralFeature eStructuralFeature, Object object) {
        this.setDefaultValue(eClass, eStructuralFeature, object);
        DefaultValueManager.setDefaultValue(eClass, eStructuralFeature, object, this.featureToTypedStaticDefaultValuesMap);
    }

    public final void removeDefaultValue(EStructuralFeature eStructuralFeature) {
        this.featureToTypedDefaultValuesMap.remove(eStructuralFeature);
    }

    public final void removeDefaultValue(EStructuralFeature eStructuralFeature, EClass eClass) {
        assert (eStructuralFeature.getEContainingClass().isSuperTypeOf(eClass));
        Map<EClass, Object> map = this.featureToTypedDefaultValuesMap.get(eStructuralFeature);
        if (map != null) {
            map.remove(eClass);
        }
        this.typeToFeatureDefaultValueMap.clear();
    }

    private static void assignDefaultValues(EObject eObject, Map<EStructuralFeature, Object> map) {
        if (map.isEmpty()) {
            return;
        }
        for (Map.Entry<EStructuralFeature, Object> entry : map.entrySet()) {
            eObject.eSet(entry.getKey(), entry.getValue());
        }
    }

    public void assignDefaultValues(EObject eObject) {
        EClass eClass = eObject.eClass();
        Map<EStructuralFeature, Object> map = this.getFeatureToStaticDefaultValueMap(eClass);
        DefaultValueManager.assignDefaultValues(eObject, map);
        Map<EStructuralFeature, Object> map2 = this.getFeatureToDefaultValueMap(eObject.eClass());
        if (map2 != map) {
            DefaultValueManager.assignDefaultValues(eObject, map2);
        }
    }
}

