/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.services;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.epf.dataexchange.util.ContentProcessor;
import org.eclipse.epf.dataexchange.util.ILogger;
import org.eclipse.epf.dataexchange.util.IResourceHandler;
import org.eclipse.epf.export.services.DiagramHandler;
import org.eclipse.epf.export.xml.ExportXMLResources;
import org.eclipse.epf.export.xml.services.ExportResourceHandler;
import org.eclipse.epf.export.xml.services.ExportXMLData;
import org.eclipse.epf.export.xml.services.ExportXMLLogger;
import org.eclipse.epf.export.xml.services.XMLLibrary;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkOrderType;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.xml.uma.ContentCategoryPackage;
import org.eclipse.epf.xml.uma.Process;
import org.eclipse.osgi.util.NLS;

public class ExportXMLService {
    private ExportXMLData data;
    private XMLLibrary xmlLib;
    private List discardedElements = new ArrayList();
    ExportXMLLogger logger = null;
    private Map umaIdToXmlIdMap = new HashMap();
    private DiagramHandler diagramHandler;
    private Map<String, TaskDescriptor> tdMap;
    private List processedElements = new ArrayList();

    public ExportXMLService(ExportXMLData exportXMLData) {
        this.data = exportXMLData;
        this.logger = new ExportXMLLogger(new File(this.data.xmlFile).getParentFile());
    }

    public File getLogPath() {
        return this.logger.getLogPath();
    }

    public void dispose() {
        this.logger.dispose();
    }

    public void doExport(IProgressMonitor iProgressMonitor) {
        try {
            ExportResourceHandler exportResourceHandler = new ExportResourceHandler(new File(LibraryService.getInstance().getCurrentMethodLibraryLocation()), new File(this.data.getXMLFile()).getParentFile());
            ContentProcessor contentProcessor = new ContentProcessor((IResourceHandler)exportResourceHandler, (ILogger)this.logger);
            this.diagramHandler = new DiagramHandler(new File(LibraryService.getInstance().getCurrentMethodLibraryLocation()), new File(this.data.getXMLFile()).getParentFile()){

                public void visitElementMap(int n) {
                    if (n != 0) {
                        return;
                    }
                    Map map = this.getElementMap();
                    for (DiagramHandler.MapEntryValue mapEntryValue : map.values()) {
                        EDataObject eDataObject;
                        if (mapEntryValue.targetFile == null || mapEntryValue.sourceFile == null || !((eDataObject = ExportXMLService.this.getXmlObject(mapEntryValue.element)) instanceof Process)) continue;
                        Process process = (Process)eDataObject;
                        String string = mapEntryValue.sourceFile.getAbsolutePath();
                        String string2 = this.getRoot(mapEntryValue.element).getAbsolutePath();
                        int n2 = string2.length();
                        string = string.substring(n2 + 1);
                        string = URI.createFileURI((String)string).toString();
                        process.setDiagramURI(string);
                    }
                }
            };
            MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
            this.xmlLib = new XMLLibrary(contentProcessor, (ILogger)this.logger, this.data.getXMLFile());
            this.xmlLib.createLibrary(methodLibrary.getGuid(), methodLibrary.getName());
            EDataObject eDataObject = this.xmlLib.getRoot();
            this.creatEDataObjectTree((MethodElement)methodLibrary, eDataObject);
            this.iteratEDataObject((MethodElement)methodLibrary);
            this.xmlLib.fixLibraryForExport();
            this.xmlLib.fixTaskDescriptorsForExport(this.tdMap);
            this.diagramHandler.visitElementMap(0);
            if (this.data.exportType == 2) {
                this.xmlLib.storeExtraInfo(methodLibrary.getMethodPlugins());
            }
            this.xmlLib.save();
            this.diagramHandler.execute();
        }
        catch (Exception exception) {
            this.logger.logError(NLS.bind((String)ExportXMLResources.exportXMLService_error, (Object)exception.getMessage()), exception);
        }
    }

    private boolean isPluginSelected(MethodPlugin methodPlugin) {
        if (this.data.exportType == 1) {
            return true;
        }
        if (this.data.exportType == 2) {
            return this.data.selectedPlugins != null && this.data.selectedPlugins.contains(methodPlugin);
        }
        return this.data.exportType != 3;
    }

    private boolean isConfigExcluded(MethodConfiguration methodConfiguration) {
        if (this.data.exportType == 2) {
            return this.data.associatedConfigs == null || !this.data.associatedConfigs.contains(methodConfiguration.getGuid());
        }
        return false;
    }

    private void creatEDataObjectTree(MethodElement methodElement, EDataObject eDataObject) {
        if (methodElement instanceof MethodPlugin) {
            MethodPlugin methodPlugin = (MethodPlugin)methodElement;
            if (!this.isPluginSelected(methodPlugin)) {
                return;
            }
            this.discardedElements.addAll(TngUtil.getAllSystemPackages((MethodPlugin)methodPlugin));
            List list = this.getTopmostUserPackage(methodPlugin);
            List list2 = TngUtil.getContentCategoryPackages((MethodPlugin)methodPlugin);
            ContentCategoryPackage contentCategoryPackage = (ContentCategoryPackage)this.xmlLib.getContentCategoryPackage(methodPlugin.getGuid());
            String string = contentCategoryPackage.getId();
            for (MethodPackage methodPackage : list) {
                if (list2.contains(methodPackage)) {
                    this.setIdMapping(methodPackage.getGuid(), string);
                    this.creatEDataObjectTree((MethodElement)methodPackage, (EDataObject)contentCategoryPackage);
                    continue;
                }
                this.creatEDataObjectTree((MethodElement)methodPackage, eDataObject);
            }
        } else {
            for (Object e : methodElement.eContents()) {
                MethodElement methodElement2;
                MethodElement methodElement3 = methodElement2 = e instanceof MethodElement ? (MethodElement)e : null;
                if (methodElement2 == null || methodElement2 instanceof WorkOrder && methodElement instanceof MethodPackage || methodElement2 instanceof MethodPlugin && !this.isPluginSelected((MethodPlugin)methodElement2) || methodElement2 instanceof MethodConfiguration && this.isConfigExcluded((MethodConfiguration)methodElement2) || this.isDiscarded(methodElement2)) continue;
                this.createXmlObject(methodElement2, eDataObject);
            }
        }
    }

    private void setIdMapping(String string, String string2) {
        if (!this.umaIdToXmlIdMap.containsKey(string)) {
            this.umaIdToXmlIdMap.put(string, string2);
        }
    }

    private String getXmlId(String string) {
        if (this.umaIdToXmlIdMap.containsKey(string)) {
            return (String)this.umaIdToXmlIdMap.get(string);
        }
        return string;
    }

    private boolean isDiscarded(Object object) {
        if (object instanceof Diagram) {
            return true;
        }
        return this.discardedElements.contains(object);
    }

    private EDataObject getXmlObject(MethodElement methodElement) {
        String string = methodElement.getGuid();
        if (this.umaIdToXmlIdMap.containsKey(string)) {
            string = (String)this.umaIdToXmlIdMap.get(string);
        }
        return this.xmlLib.getElement(string);
    }

    private void createXmlObject(MethodElement methodElement, EDataObject eDataObject) {
        EReference eReference = methodElement.eContainmentFeature();
        this.createXmlObject(methodElement, eDataObject, eReference.getName());
    }

    private void createXmlObject(MethodElement methodElement, EDataObject eDataObject, String string) {
        try {
            List list;
            TaskDescriptor taskDescriptor;
            if (methodElement == null) {
                return;
            }
            String string2 = methodElement.getType().getName();
            EDataObject eDataObject2 = this.xmlLib.createElement(eDataObject, string, methodElement.eClass().getName(), string2, methodElement.getGuid());
            if (methodElement instanceof TaskDescriptor && (taskDescriptor = (TaskDescriptor)methodElement).getTask() != null && (list = taskDescriptor.getSelectedSteps()) != null && !list.isEmpty()) {
                if (this.tdMap == null) {
                    this.tdMap = new HashMap<String, TaskDescriptor>();
                }
                this.tdMap.put(taskDescriptor.getGuid(), taskDescriptor);
            }
            if (eDataObject2 != null) {
                this.creatEDataObjectTree(methodElement, eDataObject2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void iteratEDataObject(MethodElement methodElement) {
        MethodPlugin methodPlugin;
        this.diagramHandler.registerElement(methodElement, true);
        if (methodElement instanceof MethodPlugin && !this.isPluginSelected(methodPlugin = (MethodPlugin)methodElement)) {
            return;
        }
        if (this.isProcessed(methodElement.getGuid())) {
            return;
        }
        this.setProcessed(methodElement.getGuid());
        methodPlugin = this.getXmlObject(methodElement);
        if (methodPlugin == null) {
            if (methodElement instanceof MethodPackage) {
                Iterator iterator = ((MethodPackage)methodElement).getChildPackages().iterator();
                while (iterator.hasNext()) {
                    this.iteratEDataObject((MethodElement)iterator.next());
                }
            }
            return;
        }
        EClass eClass = methodElement.eClass();
        EList eList = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : eList) {
            String string2;
            Object object = methodElement.eGet(eStructuralFeature);
            try {
                if (object instanceof List && !eStructuralFeature.getName().equals("methodElementProperty")) {
                    for (String string2 : (List)object) {
                        Object object2;
                        if (string2 instanceof WorkOrder && (object2 = this.getXmlObject((MethodElement)string2)) == null) {
                            this.createXmlObject((MethodElement)string2, (EDataObject)methodPlugin, eStructuralFeature.getName());
                        }
                        object2 = this.getXmlId(string2.getGuid());
                        this.xmlLib.setReferenceValue((EDataObject)methodPlugin, eStructuralFeature.getName(), (String)object2, string2.getType());
                        this.iteratEDataObject((MethodElement)string2);
                    }
                    continue;
                }
                if (object instanceof MethodElement) {
                    MethodElement methodElement2 = (MethodElement)object;
                    if (methodElement2.eContainer() == null) continue;
                    string2 = this.getXmlId(methodElement2.getGuid());
                    this.xmlLib.setReferenceValue((EDataObject)methodPlugin, eStructuralFeature.getName(), string2, methodElement2.getType());
                    this.iteratEDataObject(methodElement2);
                    continue;
                }
                if (this.isDiscarded(methodElement)) continue;
                if (object instanceof WorkOrderType) {
                    object = ((WorkOrderType)object).getName();
                }
                this.xmlLib.setAtributeFeatureValue((EDataObject)methodPlugin, eStructuralFeature.getName(), object);
            }
            catch (Exception exception) {
                string2 = NLS.bind((String)ExportXMLResources.exportXMLService_feature_error, (Object)LibraryUtil.getTypeName((MethodElement)methodElement), (Object)eStructuralFeature.getName());
                this.logger.logError(string2, exception);
            }
        }
    }

    private boolean isProcessed(String string) {
        return this.processedElements.contains(string);
    }

    private void setProcessed(String string) {
        if (!this.processedElements.contains(string)) {
            this.processedElements.add(string);
        }
    }

    private List getTopmostUserPackage(MethodPlugin methodPlugin) {
        MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.coreContentPath);
        MethodPackage methodPackage2 = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        MethodPackage methodPackage3 = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.disciplineDefinitionPath);
        MethodPackage methodPackage4 = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.domainPath);
        MethodPackage methodPackage5 = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.roleSetPath);
        MethodPackage methodPackage6 = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.toolPath);
        MethodPackage methodPackage7 = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.workProductTypePath);
        MethodPackage methodPackage8 = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.capabilityPatternPath);
        MethodPackage methodPackage9 = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.deliveryProcessPath);
        MethodPackage methodPackage10 = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.processContributionPath);
        ArrayList<MethodPackage> arrayList = new ArrayList<MethodPackage>();
        arrayList.add(methodPackage);
        arrayList.add(methodPackage2);
        arrayList.add(methodPackage3);
        arrayList.add(methodPackage4);
        arrayList.add(methodPackage5);
        arrayList.add(methodPackage6);
        arrayList.add(methodPackage7);
        arrayList.add(methodPackage8);
        arrayList.add(methodPackage9);
        if (methodPackage10 != null) {
            arrayList.add(methodPackage10);
        }
        return arrayList;
    }
}

