/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.ArrayList;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.INavigatable;

public class CompareEditorInputNavigator
extends CompareNavigator {
    private boolean fNextFirstTime = true;
    private Object[] fPanes;

    public CompareEditorInputNavigator(Object[] panes) {
        this.fPanes = panes;
    }

    public Object[] getPanes() {
        return this.fPanes;
    }

    protected INavigatable[] getNavigatables() {
        ArrayList<INavigatable> result = new ArrayList<INavigatable>();
        Object[] panes = this.getPanes();
        int i = 0;
        while (i < panes.length) {
            Object pane = panes[i];
            INavigatable navigator = this.getNavigator(pane);
            if (navigator != null) {
                result.add(navigator);
            }
            ++i;
        }
        return result.toArray(new INavigatable[result.size()]);
    }

    public boolean selectChange(boolean next) {
        if (next && this.fNextFirstTime && this.mustOpen()) {
            this.fNextFirstTime = false;
            if (this.openElement()) {
                return false;
            }
        }
        return super.selectChange(next);
    }

    private boolean mustOpen() {
        Object[] panes = this.getPanes();
        if (panes == null || panes.length == 0) {
            return false;
        }
        int i = 1;
        while (i < panes.length) {
            Object pane = panes[i];
            INavigatable nav = this.getNavigator(pane);
            if (nav != null && nav.getInput() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean openElement() {
        Object[] panes = this.getPanes();
        if (panes == null || panes.length == 0) {
            return false;
        }
        INavigatable nav = this.getNavigator(panes[0]);
        if (nav != null) {
            return nav.openSelectedChange();
        }
        return false;
    }
}

