/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.export.services.DiagramHandler;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.importing.services.FileModifyChecker;
import org.eclipse.epf.importing.services.LibraryDiffManager;
import org.eclipse.epf.importing.services.ResourceScanner;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.DiagramElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;

public class LibraryImportManager {
    private Map renameElementMap = new HashMap();
    private Map setElementMap = null;
    private LibraryDiffManager diffMgr;
    private ElementDiffTree rootTree;
    private boolean configFolderError = false;
    private MethodLibrary baseLibrary = null;
    private MethodLibrary importingLibrary = null;
    private Map replacedElementMap = new HashMap();
    private List newElements = new ArrayList();
    private List deletedElements = new ArrayList();
    private boolean debug = ImportPlugin.getDefault().isDebugging();
    List checkedList = new ArrayList();
    IStatus fileCheckedOutStatus = null;
    List newResources = new ArrayList();
    ResourceScanner resScanner;
    private DiagramHandler diagramHandler;
    static MethodElement newCont = null;
    static MethodElement newElem = null;
    private List processedNewElements = new ArrayList();

    public LibraryImportManager(LibraryDiffManager libraryDiffManager, List list) {
        this.diffMgr = libraryDiffManager;
        this.rootTree = libraryDiffManager.getDiffTree();
        if (list != null) {
            this.checkedList.addAll(list);
            for (ElementDiffTree elementDiffTree : list) {
                MethodPackage methodPackage;
                List list2;
                MethodElement methodElement = elementDiffTree.getBaseElement();
                if (methodElement != null) {
                    this.checkedList.add(methodElement);
                }
                if (methodElement instanceof ProcessComponent) {
                    LibraryUtil.getAllChildPackages((MethodPackage)((MethodPackage)methodElement), (List)this.checkedList);
                }
                if (methodElement instanceof MethodPackage && (list2 = ((MethodPackage)methodElement).getChildPackages()).size() == 1 && TngUtil.isRootCutomCategoryPackage((MethodPackage)(methodPackage = (MethodPackage)list2.get(0)))) {
                    this.checkedList.add(methodPackage);
                }
                if ((methodElement = elementDiffTree.getImportElement()) != null) {
                    this.checkedList.add(methodElement);
                }
                if (methodElement instanceof ProcessComponent) {
                    LibraryUtil.getAllChildPackages((MethodPackage)((MethodPackage)methodElement), (List)this.checkedList);
                }
                if (!elementDiffTree.isNew()) continue;
                if (methodElement instanceof MethodPlugin) {
                    this.checkedList.addAll(LibraryUtil.getAllPackages((MethodPlugin)((MethodPlugin)methodElement)));
                    continue;
                }
                if (!(methodElement instanceof MethodPackage)) continue;
                LibraryUtil.getAllChildPackages((MethodPackage)((MethodPackage)methodElement), (List)this.checkedList);
            }
        } else {
            this.checkedList = null;
        }
        this.init();
        this.baseLibrary = (MethodLibrary)this.rootTree.getBaseElement();
        this.importingLibrary = (MethodLibrary)this.rootTree.getImportElement();
        this.resScanner = new ResourceScanner(LibraryUtil.getLibraryRootPath((MethodLibrary)this.importingLibrary), LibraryUtil.getLibraryRootPath((MethodLibrary)this.baseLibrary));
        this.diagramHandler = new DiagramHandler(LibraryUtil.getLibraryRootPath((MethodLibrary)this.importingLibrary), LibraryUtil.getLibraryRootPath((MethodLibrary)this.baseLibrary)){

            protected File[] getFiles(MethodElement methodElement) {
                return super.getFiles(methodElement, false);
            }
        };
    }

    private void init() {
    }

    private boolean isSelected(ElementDiffTree elementDiffTree) {
        if (this.checkedList == null || this.checkedList.contains(elementDiffTree)) {
            return true;
        }
        MethodElement methodElement = elementDiffTree.getBaseElement();
        if (methodElement == null) {
            methodElement = elementDiffTree.getImportElement();
        }
        return this.isSelected(methodElement);
    }

    private boolean isSelected(MethodElement methodElement) {
        if (this.checkedList == null || methodElement instanceof ContentDescription || methodElement.eContainer() instanceof ContentDescription || methodElement instanceof MethodLibrary) {
            return true;
        }
        if (this.checkedList.size() == 0) {
            return false;
        }
        if (methodElement instanceof MethodConfiguration) {
            return this.checkedList.contains(methodElement);
        }
        MethodElement methodElement2 = (MethodElement)LibraryUtil.getSelectable((EObject)methodElement);
        if (methodElement2 == null) {
            return false;
        }
        if (methodElement2 instanceof MethodLibrary) {
            return true;
        }
        return this.checkedList.contains(methodElement2);
    }

    public void doMerge(boolean bl, IProgressMonitor iProgressMonitor) throws Exception {
        this.configFolderError = false;
        if (this.debug) {
            System.out.println("Merging configuration ...");
        }
        if (this.debug) {
            System.out.println("loading library ...");
        }
        LibraryUtil.loadAll((MethodLibrary)this.baseLibrary);
        LibraryUtil.loadAll((MethodLibrary)this.importingLibrary);
        LibraryUtil.detachFromResource((MethodLibrary)this.importingLibrary);
        this.importingLibrary.setName("ImportingLib: " + this.importingLibrary.getName());
        if (this.debug) {
            System.out.println("Process configuration diff tree ...");
        }
        ArrayList arrayList = new ArrayList(this.baseLibrary.eResource().getResourceSet().getResources());
        this.processDiffTree(this.rootTree, bl);
        this.handleSetElements();
        if (this.debug) {
            System.out.println("perform integrity checking ...");
        }
        this.doIntegrityCheck();
        this.handleNewResources(arrayList);
        LibraryImportManager.handleNameReplace(this.renameElementMap);
        this.diagramHandler.postRegisterElements();
        if (this.debug) {
            System.out.println("check out files ...");
        }
        this.deleteResoruces();
        this.checkModifiedFiles();
        if (this.fileCheckedOutStatus.isOK()) {
            if (this.debug) {
                System.out.println("copying resource files ...");
            }
            this.resScanner.execute();
            this.diagramHandler.execute();
            if (this.debug) {
                System.out.println("saving library ...");
            }
            if (!this.configFolderError) {
                LibraryUtil.saveLibrary((MethodLibrary)this.baseLibrary, (boolean)false, (boolean)false);
            }
        } else {
            this.fileCheckOutError();
        }
        if (this.debug) {
            System.out.println("Merging configuration done...");
        }
    }

    private void fileCheckOutError() {
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                String string = ImportResources.importConfigWizard_title;
                String string2 = ImportResources.ImportConfigurationWizard_ERR_Import_configuration;
                new MsgDialog((AbstractPlugin)ImportPlugin.getDefault()).displayError(string, string2, LibraryImportManager.this.fileCheckedOutStatus);
            }
        });
        if (this.debug) {
            System.out.println("Checkout files failed ...");
        }
    }

    private void handleNewResources(List list) {
        for (Resource resource : this.baseLibrary.eResource().getResourceSet().getResources()) {
            if (list.contains(resource)) continue;
            this.logNewResource(resource);
        }
    }

    private void processDiffTree(ElementDiffTree elementDiffTree, boolean bl) throws Exception {
        List list;
        if (elementDiffTree == null || !this.isSelected(elementDiffTree)) {
            return;
        }
        int n = elementDiffTree.getDiffState();
        MethodElement methodElement = elementDiffTree.getBaseElement();
        MethodElement methodElement2 = elementDiffTree.getImportElement();
        if (bl && n == 4) {
            if (methodElement instanceof MethodConfiguration) {
                this.doReplaceConfiguration((MethodConfiguration)methodElement, (MethodConfiguration)methodElement2);
            } else if (methodElement instanceof MethodPlugin) {
                this.doReplacePlugin((MethodPlugin)methodElement, (MethodPlugin)methodElement2);
            } else if (methodElement instanceof MethodPackage) {
                this.doReplacePackage((MethodPackage)methodElement, (MethodPackage)methodElement2);
            } else if (this.debug) {
                System.out.println("What is this: " + LibraryUtil.getTypeName((MethodElement)methodElement));
            }
        } else if (n == 1) {
            this.doAdd((EObject)elementDiffTree.getBaseParentElement(), elementDiffTree.getImportElement());
        }
        if (n != 1 && (list = elementDiffTree.getChildren()) != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.processDiffTree((ElementDiffTree)iterator.next(), bl);
            }
        }
    }

    private void doReplaceConfiguration(MethodConfiguration methodConfiguration, MethodConfiguration methodConfiguration2) {
        if (this.isReplaced((MethodElement)methodConfiguration)) {
            return;
        }
        this.setReplaced((MethodElement)methodConfiguration);
        List list = LibraryUtil.getStructuralFeatures((MethodElement)methodConfiguration);
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                Object object = methodConfiguration2.eGet(eStructuralFeature);
                this.setFeatureValue((MethodElement)methodConfiguration, eStructuralFeature, object, false);
                ++n;
            }
        }
    }

    private void doReplacePlugin(MethodPlugin methodPlugin, MethodPlugin methodPlugin2) {
        if (this.isReplaced((MethodElement)methodPlugin)) {
            return;
        }
        this.setReplaced((MethodElement)methodPlugin);
        List list = LibraryUtil.getStructuralFeatures((MethodElement)methodPlugin);
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                if (eStructuralFeature != UmaPackage.eINSTANCE.getMethodPlugin_MethodPackages()) {
                    Object object = methodPlugin2.eGet(eStructuralFeature);
                    this.setFeatureValue((MethodElement)methodPlugin, eStructuralFeature, object, true);
                }
                ++n;
            }
        }
    }

    private void doReplacePackage(MethodPackage methodPackage, MethodPackage methodPackage2) {
        if (this.isReplaced((MethodElement)methodPackage)) {
            return;
        }
        this.setReplaced((MethodElement)methodPackage);
        if (this.debug) {
            System.out.println("Replacing package " + LibraryUtil.getTypeName((MethodElement)methodPackage));
        }
        List list = LibraryUtil.getStructuralFeatures((MethodElement)methodPackage);
        boolean bl = methodPackage instanceof ProcessPackage;
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                if (eStructuralFeature != UmaPackage.eINSTANCE.getMethodPackage_ChildPackages() || bl) {
                    Object object = methodPackage2.eGet(eStructuralFeature);
                    this.setFeatureValue((MethodElement)methodPackage, eStructuralFeature, object, true);
                }
                ++n;
            }
        }
    }

    private void doReplaceElement(MethodElement methodElement, MethodElement methodElement2) {
        List list;
        if (this.isReplaced(methodElement)) {
            return;
        }
        if (this.diffMgr.selectable(methodElement)) {
            return;
        }
        if (!this.isSelected(methodElement)) {
            return;
        }
        if (methodElement instanceof ContentDescription && methodElement2 instanceof ContentDescription && LibraryUtil.isIdentical((MethodElement)((ContentDescription)methodElement), (MethodElement)((ContentDescription)methodElement2))) {
            Resource resource;
            if (this.debug && (resource = methodElement.eResource()) != null) {
                System.out.println("Identical element not replaced: " + resource.getURI().toFileString());
            }
            this.scanResources(methodElement, true);
            return;
        }
        this.setReplaced(methodElement);
        if (this.debug) {
            System.out.println("Replacing element " + LibraryUtil.getTypeName((MethodElement)methodElement));
        }
        if ((list = LibraryUtil.getStructuralFeatures((MethodElement)methodElement)) != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                if (eStructuralFeature != UmaPackage.eINSTANCE.getMethodPlugin_MethodPackages() && eStructuralFeature != UmaPackage.eINSTANCE.getMethodPackage_ChildPackages() && !eStructuralFeature.isDerived()) {
                    Object object = methodElement2.eGet(eStructuralFeature);
                    this.setFeatureValue(methodElement, eStructuralFeature, object, true);
                }
                ++n;
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void setFeatureValue(MethodElement var1_1, EStructuralFeature var2_2, Object var3_3, boolean var4_4) {
        block35: {
            if (this.canIgnore(var2_2)) {
                return;
            }
            var5_5 = var1_1.eDeliver();
            try {
                var1_1.eSetDeliver(false);
                if (this.canReset(var2_2)) {
                    var1_1.eSet(var2_2, var3_3);
                    break block35;
                }
                if (!var2_2.isMany() || !(var3_3 instanceof List)) ** GOTO lbl50
                var6_6 = (List)var1_1.eGet(var2_2);
                if (var2_2.getName().equals("methodElementProperty")) {
                    this.setMepFeatureValue(var1_1, var2_2, var6_6, (List)var3_3);
                    return;
                }
                try {
                    var7_10 = new ElementListDiff(var6_6, (List)var3_3);
                    if (var4_4 && var7_10.deletedItems.size() > 0) {
                        var6_6.removeAll(var7_10.deletedItems);
                        this.logRemovedElements(var7_10.deletedItems);
                        if (this.debug) {
                            System.out.println("  Deleting feature value, feature: " + var2_2.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)var1_1) + ", values: " + var7_10.deletedItems);
                        }
                    }
                    if (var7_10.newItems.size() > 0) {
                        for (Object var9_13 : var7_10.newItems) {
                            if (!this.isSelected((MethodElement)var9_13)) continue;
                            var10_14 = this.diffMgr.getExistingElement(var9_13.getGuid());
                            if (var10_14 == null) {
                                var6_6.add(var9_13);
                                continue;
                            }
                            var6_6.add(var10_14);
                            this.doReplaceElement(var10_14, (MethodElement)var9_13);
                        }
                        if (this.debug) {
                            System.out.println("  Adding feature value, feature: " + var2_2.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)var1_1) + ", values: " + var7_10.newItems);
                        }
                    }
                    if (var7_10.oldNewMap.size() > 0) {
                        for (Object var9_13 : var7_10.oldNewMap.entrySet()) {
                            var10_14 = (MethodElement)var9_13.getKey();
                            if (!this.isSelected(var10_14)) continue;
                            var11_15 = (MethodElement)var9_13.getValue();
                            if (this.canReset(var10_14)) {
                                if (this.debug) {
                                    System.out.println("  Resetting feature value, feature: " + var2_2.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)var1_1) + ", value: " + LibraryUtil.getTypeName((MethodElement)var10_14));
                                }
                                EcoreUtil.replace((EObject)var1_1, (EStructuralFeature)var2_2, (Object)var10_14, (Object)var11_15);
                                this.logResetElement(var11_15);
                                continue;
                            }
                            this.doReplaceElement(var10_14, var11_15);
                        }
                    }
                    break block35;
lbl50:
                    // 1 sources

                    if (var3_3 instanceof MethodElement) {
                        var6_7 = (MethodElement)var1_1.eGet(var2_2);
                        var7_11 = (MethodElement)var3_3;
                        if ((var6_7 == null || this.isSelected(var6_7)) && this.isSelected(var7_11)) {
                            if (this.debug) {
                                System.out.println("  Replacinging feature value, feature: " + var2_2.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)var1_1) + ", value: " + LibraryUtil.getTypeName((MethodElement)var6_7));
                            }
                            if (var3_3 instanceof ContentDescription) {
                                if (var6_7.eContainer() != null || var7_11.eContainer() != null) {
                                    if (var6_7.eContainer() == null) {
                                        var1_1.eSet(var2_2, (Object)var6_7);
                                    }
                                    this.doReplaceElement(var6_7, var7_11);
                                }
                            } else if (this.canReset(var7_11)) {
                                var1_1.eSet(var2_2, var3_3);
                            } else if (var6_7 != null && var7_11 != null && var6_7.getGuid().equals(var7_11.getGuid())) {
                                this.doReplaceElement(var6_7, var7_11);
                            } else {
                                this.registerSetElement(var1_1, var2_2, var3_3);
                                var1_1.eSet(var2_2, var3_3);
                            }
                        }
                    } else if (var2_2 == UmaPackage.eINSTANCE.getNamedElement_Name()) {
                        if (!(var3_3 instanceof String)) {
                            throw new UnsupportedOperationException();
                        }
                        var6_8 = (String)var1_1.eGet(var2_2);
                        if (!var3_3.equals(var6_8)) {
                            LibraryImportManager.ensureUniqueNameForExistingElement(var1_1, var6_8, (String)var3_3, this.renameElementMap);
                        }
                    } else {
                        var1_1.eSet(var2_2, var3_3);
                        this.scanResources(var1_1, var2_2, var3_3);
                    }
                }
                catch (Exception var6_9) {
                    var6_9.printStackTrace();
                }
            }
            finally {
                var1_1.eSetDeliver(var5_5);
            }
        }
    }

    private void setMepFeatureValue(MethodElement methodElement, EStructuralFeature eStructuralFeature, List list, List list2) {
        int n = list2.size();
        if (list.size() == n) {
            if (n == 0) {
                return;
            }
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                MethodElementProperty methodElementProperty = (MethodElementProperty)list.get(n2);
                MethodElementProperty methodElementProperty2 = (MethodElementProperty)list2.get(n2);
                if (!methodElementProperty.getName().equals(methodElementProperty2.getName()) || !methodElementProperty.getValue().equals(methodElementProperty2.getValue())) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                return;
            }
        }
        list.removeAll(list);
        list.addAll(list2);
    }

    private void scanResources(MethodElement methodElement, boolean bl) {
        EStructuralFeature eStructuralFeature;
        if (methodElement == null) {
            return;
        }
        List list = LibraryUtil.getStructuralFeatures((MethodElement)methodElement);
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                eStructuralFeature = (EStructuralFeature)list.get(n);
                if (eStructuralFeature instanceof EAttribute) {
                    Object object = methodElement.eGet(eStructuralFeature);
                    this.scanResources(methodElement, eStructuralFeature, object);
                }
                ++n;
            }
        }
        if (!bl) {
            return;
        }
        TreeIterator treeIterator = methodElement.eAllContents();
        while (treeIterator.hasNext()) {
            eStructuralFeature = (EObject)treeIterator.next();
            if (eStructuralFeature instanceof MethodLibrary || eStructuralFeature instanceof MethodPlugin || eStructuralFeature instanceof MethodPackage || eStructuralFeature instanceof MethodConfiguration || !(eStructuralFeature instanceof MethodElement)) continue;
            this.scanResources((MethodElement)eStructuralFeature, false);
        }
    }

    private void scanResources(MethodElement methodElement, EStructuralFeature eStructuralFeature, Object object) {
        this.diagramHandler.registerElement(methodElement);
        if (eStructuralFeature == UmaPackage.eINSTANCE.getGuidanceDescription_Attachments()) {
            String string = (String)object;
            if (string != null && string.length() != 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    this.resScanner.copyResource(methodElement, string2);
                }
            }
        } else if (object instanceof String) {
            this.resScanner.scan(methodElement, object.toString());
        } else if (object instanceof URI) {
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
            this.resScanner.copyResource(((URI)object).getPath(), methodPlugin);
        }
    }

    private void doAdd(EObject eObject, MethodElement methodElement) throws Exception {
        String string;
        Object object;
        if (this.debug) {
            System.out.println("Adding element " + LibraryUtil.getTypeName((MethodElement)methodElement));
        }
        if (eObject == null) {
            return;
        }
        LibraryImportManager.ensureUniqueName(eObject, methodElement, this.renameElementMap);
        boolean bl = false;
        if (eObject instanceof MethodLibrary) {
            if (methodElement instanceof MethodPlugin) {
                object = (MethodPlugin)methodElement;
                this.checkModifiedFiles();
                boolean bl2 = bl = !this.fileCheckedOutStatus.isOK();
                if (!bl) {
                    ((MethodLibrary)eObject).getMethodPlugins().add(object);
                    LibraryUtil.saveLibrary((MethodLibrary)((MethodLibrary)eObject), (boolean)false, (boolean)false);
                }
            } else if (methodElement instanceof MethodConfiguration) {
                this.checkModifiedFiles();
                boolean bl3 = bl = this.configFolderError || !this.fileCheckedOutStatus.isOK();
                if (!bl) {
                    object = (MethodLibrary)eObject;
                    object.getPredefinedConfigurations().add(methodElement);
                    string = ((MultiFileResourceSetImpl)object.eResource().getResourceSet()).getPersister();
                    if (string instanceof IFileBasedLibraryPersister) {
                        IFileBasedLibraryPersister iFileBasedLibraryPersister = (IFileBasedLibraryPersister)string;
                        File file = iFileBasedLibraryPersister.getDefaultMethodConfigurationFolder((MethodLibrary)object);
                        if (file != null) {
                            iFileBasedLibraryPersister.setDefaultMethodConfigurationFolder((MethodLibrary)object, file);
                        } else {
                            bl = true;
                            this.configFolderError = true;
                        }
                    }
                    if (!bl) {
                        LibraryUtil.saveLibrary((MethodLibrary)((MethodLibrary)eObject), (boolean)false, (boolean)false);
                    }
                }
            } else {
                bl = true;
            }
        } else if (eObject instanceof MethodPackage && eObject.eContainer() != null && methodElement instanceof MethodPackage) {
            ((MethodPackage)eObject).getChildPackages().add(methodElement);
        } else {
            bl = true;
        }
        if (bl) {
            object = eObject instanceof MethodElement ? LibraryUtil.getTypeName((MethodElement)((MethodElement)eObject)) : eObject.toString();
            string = "can't add " + LibraryUtil.getTypeName((MethodElement)methodElement) + " to " + (String)object;
            ImportPlugin.getDefault().getLogger().logError(string);
            if (this.debug) {
                System.out.println(string);
            }
        } else {
            this.logNewElement(methodElement);
        }
    }

    private boolean checkModifiedConfigs(MethodPlugin methodPlugin) {
        List list = LibraryUtil.getAssociatedConfigurations((MethodPlugin)methodPlugin);
        List list2 = this.baseLibrary.getPredefinedConfigurations();
        HashMap<String, MethodConfiguration> hashMap = new HashMap<String, MethodConfiguration>();
        int n = 0;
        while (n < list2.size()) {
            MethodConfiguration methodConfiguration = (MethodConfiguration)list2.get(n);
            hashMap.put(methodConfiguration.getGuid(), methodConfiguration);
            ++n;
        }
        final ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < list.size()) {
            Resource resource;
            MethodConfiguration methodConfiguration = (MethodConfiguration)list.get(n2);
            if ((methodConfiguration = (MethodConfiguration)hashMap.get(methodConfiguration.getGuid())) != null && (resource = methodConfiguration.eResource()) != null) {
                arrayList.add(resource.getURI().toFileString());
            }
            ++n2;
        }
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                LibraryImportManager.this.fileCheckedOutStatus = FileModifyChecker.checkModify(arrayList);
            }
        });
        this.fileCheckOutError();
        return this.fileCheckedOutStatus.isOK();
    }

    private void doIntegrityCheck() {
        List list;
        while (this.newElements.size() > 0) {
            list = (MethodElement)this.newElements.remove(0);
            try {
                if (list instanceof DiagramElement) {
                    this.fixDiagram((DiagramElement)list);
                    continue;
                }
                this.fixNewElementReferences((MethodElement)list);
            }
            catch (Exception exception) {
                if (this.debug) {
                    System.out.println("Exception while fixing new element " + LibraryUtil.getTypeName((MethodElement)list));
                }
                exception.printStackTrace();
            }
        }
        list = this.baseLibrary.getPredefinedConfigurations();
        for (MethodConfiguration methodConfiguration : list) {
            LibraryUtil.validateMethodConfiguration(null, (MethodConfiguration)methodConfiguration);
        }
    }

    private void fixNewElementReferences(MethodElement methodElement) {
        List list;
        if (this.processedNewElements.contains(methodElement)) {
            return;
        }
        this.processedNewElements.add(methodElement);
        if (this.debug) {
            System.out.println("Fixing element " + LibraryUtil.getTypeName((MethodElement)methodElement));
        }
        if ((list = LibraryUtil.getStructuralFeatures((MethodElement)methodElement)) != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                Object object = methodElement.eGet(eStructuralFeature);
                if (object instanceof List) {
                    for (Object e : new ArrayList((List)object)) {
                        this.fixNewElementFeatureValue(methodElement, eStructuralFeature, e);
                    }
                } else {
                    this.fixNewElementFeatureValue(methodElement, eStructuralFeature, object);
                }
                ++n;
            }
        }
    }

    private void fixDiagram(DiagramElement diagramElement) {
        List list;
        if (this.processedNewElements.contains(diagramElement)) {
            return;
        }
        this.processedNewElements.add(diagramElement);
        if (this.debug) {
            System.out.println("Fixing diagram element " + LibraryUtil.getTypeName((MethodElement)diagramElement));
        }
        if ((list = LibraryUtil.getStructuralFeatures((MethodElement)diagramElement)) != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                Object object = diagramElement.eGet(eStructuralFeature);
                if (object instanceof List) {
                    for (Object e : new ArrayList((List)object)) {
                        if (!(e instanceof MethodElement)) continue;
                        if (eStructuralFeature == UmaPackage.eINSTANCE.getUMASemanticModelBridge_Element()) {
                            this.fixNewElementFeatureValue((MethodElement)diagramElement, eStructuralFeature, e);
                            continue;
                        }
                        if (!(e instanceof DiagramElement)) continue;
                        this.fixDiagram((DiagramElement)e);
                    }
                } else if (object instanceof MethodElement) {
                    if (eStructuralFeature == UmaPackage.eINSTANCE.getUMASemanticModelBridge_Element()) {
                        this.fixNewElementFeatureValue((MethodElement)diagramElement, eStructuralFeature, object);
                    } else if (object instanceof DiagramElement) {
                        this.fixDiagram((DiagramElement)object);
                    }
                }
                ++n;
            }
        }
    }

    private void fixNewElementFeatureValue(MethodElement methodElement, EStructuralFeature eStructuralFeature, Object object) {
        block12: {
            if (!(object instanceof MethodElement)) {
                return;
            }
            if (this.debug) {
                System.out.println("fixing element feature value " + LibraryUtil.getTypeName((MethodElement)methodElement) + ", feature=" + eStructuralFeature.getName());
            }
            boolean bl = methodElement.eDeliver();
            try {
                try {
                    methodElement.eSetDeliver(false);
                    MethodElement methodElement2 = (MethodElement)object;
                    MethodElement methodElement3 = this.getReplaced(methodElement2.getGuid());
                    if (methodElement3 == null) {
                        methodElement3 = this.diffMgr.getExistingElement(methodElement2.getGuid());
                    }
                    if (methodElement3 == null) {
                        this.fixNewElementReferences(methodElement2);
                        break block12;
                    }
                    try {
                        EcoreUtil.replace((EObject)methodElement, (EStructuralFeature)eStructuralFeature, (Object)methodElement2, (Object)methodElement3);
                    }
                    catch (Exception exception) {
                        EcoreUtil.remove((EObject)methodElement, (EStructuralFeature)eStructuralFeature, (Object)methodElement2);
                        if (this.debug) {
                            System.out.println("Replaceing feature value failed for element [" + LibraryUtil.getTypeName((MethodElement)methodElement) + "], feature [" + eStructuralFeature.getName() + "], value=" + methodElement2 + ". The feature value is removed. ");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    methodElement.eSetDeliver(bl);
                }
            }
            finally {
                methodElement.eSetDeliver(bl);
            }
        }
    }

    private boolean canReset(MethodElement methodElement) {
        boolean bl = false;
        if (methodElement == null || methodElement instanceof DiagramElement) {
            bl = true;
        }
        return bl;
    }

    private boolean canReset(EStructuralFeature eStructuralFeature) {
        return false;
    }

    private boolean canIgnore(EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature == UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable()) {
            return true;
        }
        return eStructuralFeature == UmaPackage.eINSTANCE.getArtifact_ContainerArtifact();
    }

    private boolean isReplaced(MethodElement methodElement) {
        return this.replacedElementMap.containsKey(methodElement.getGuid());
    }

    private void setReplaced(MethodElement methodElement) {
        String string = methodElement.getGuid();
        if (!this.replacedElementMap.containsKey(string)) {
            this.replacedElementMap.put(string, methodElement);
            this.setModified((EObject)methodElement);
        }
    }

    private MethodElement getReplaced(String string) {
        return (MethodElement)this.replacedElementMap.get(string);
    }

    private void copyNewElementResources(MethodElement methodElement) {
        this.scanResources(methodElement, true);
    }

    private void logNewElement(MethodElement methodElement) {
        if (!this.newElements.contains(methodElement) && this.diffMgr.getExistingElement(methodElement.getGuid()) == null) {
            this.newElements.add(methodElement);
            this.copyNewElementResources(methodElement);
            this.setModified((EObject)methodElement);
        }
    }

    private void logResetElement(MethodElement methodElement) {
        if (!this.newElements.contains(methodElement)) {
            this.newElements.add(methodElement);
            this.setModified((EObject)methodElement);
        }
    }

    private void logNewResource(Resource resource) {
        if (resource != null) {
            resource.setModified(true);
            String string = resource.getURI().toFileString();
            if (!this.newResources.contains(string)) {
                this.newResources.add(string);
            }
        }
    }

    private void logRemovedElements(List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (MethodElement methodElement : list) {
            if (methodElement.eContainer() != null || this.deletedElements.contains(methodElement)) continue;
            this.deletedElements.add(methodElement);
        }
    }

    private void setModified(EObject eObject) {
        Resource resource;
        if (eObject != null && (resource = eObject.eResource()) != null) {
            if (!resource.isModified()) {
                resource.setModified(true);
            }
            if (this.debug && resource.isModified()) {
                System.out.println("Modified: " + resource.getURI().toFileString());
            }
        }
    }

    private List getModifiedResources(MethodLibrary methodLibrary) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Resource resource2 = methodLibrary.eResource();
        if (resource2 != null) {
            ResourceSet resourceSet = resource2.getResourceSet();
            for (Resource resource2 : resourceSet.getResources()) {
                String string;
                if (resource2 == null || !resource2.isModified() || this.newResources.contains(string = resource2.getURI().toFileString())) continue;
                if (this.debug) {
                    System.out.println("Resource modified: " + string);
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private void deleteResoruces() {
        if (this.deletedElements.size() == 0) {
            return;
        }
        IFileManager iFileManager = Services.getFileManager();
        for (MethodElement methodElement : this.deletedElements) {
            Resource resource;
            ContentDescription contentDescription = null;
            if (methodElement instanceof DescribableElement) {
                contentDescription = ((DescribableElement)methodElement).getPresentation();
            } else if (methodElement instanceof ContentDescription) {
                contentDescription = methodElement;
            }
            if (contentDescription == null || (resource = contentDescription.eResource()) == null) continue;
            String string = resource.getURI().toFileString();
            if (this.debug) {
                System.out.println("deleting resource: " + string);
            }
            if (iFileManager.delete(string) || !this.debug) continue;
            System.out.println("unable to delete file: " + string);
        }
    }

    public static void handleNameReplace(Map map) {
        MethodElement methodElement;
        Object[] objectArray;
        for (Map.Entry entry : map.entrySet()) {
            objectArray = (Object[])entry.getValue();
            methodElement = (MethodElement)objectArray[0];
            String string = objectArray.length == 4 ? methodElement.getGuid() : (String)objectArray[1];
            LibraryImportManager.rename(methodElement, string);
            if (objectArray.length != 4) continue;
            methodElement = (MethodElement)objectArray[2];
            string = (String)objectArray[3];
            LibraryImportManager.rename(methodElement, string);
            methodElement = (MethodElement)objectArray[0];
            string = (String)objectArray[1];
            LibraryImportManager.rename(methodElement, string);
        }
        for (Map.Entry entry : map.entrySet()) {
            objectArray = (Object[])entry.getValue();
            methodElement = (MethodElement)objectArray[0];
            methodElement.eResource().setModified(true);
        }
    }

    private static void rename(MethodElement methodElement, String string) {
        if (string.equals(methodElement.getName())) {
            return;
        }
        if (methodElement instanceof ContentDescription || methodElement.eResource() == null) {
            methodElement.setName(string);
            if (methodElement instanceof ProcessComponent) {
                Process process = ((ProcessComponent)methodElement).getProcess();
                process.setName(string);
            }
        } else {
            LibraryView.runRename((NamedElement)methodElement, (String)string);
        }
    }

    private void registerSetElement(MethodElement methodElement, EStructuralFeature eStructuralFeature, Object object) {
        String string = ((MethodElement)object).getGuid();
        String string2 = methodElement.getGuid();
        Object[] objectArray = new Object[]{eStructuralFeature, object, methodElement};
        if (this.setElementMap == null) {
            this.setElementMap = new HashMap();
        }
        this.setElementMap.put(String.valueOf(methodElement.getName()) + string + string2, objectArray);
    }

    private void handleSetElements() {
        if (this.setElementMap == null) {
            return;
        }
        for (Map.Entry entry : this.setElementMap.entrySet()) {
            Object[] objectArray = (Object[])entry.getValue();
            EStructuralFeature eStructuralFeature = (EStructuralFeature)objectArray[0];
            MethodElement methodElement = (MethodElement)objectArray[1];
            MethodElement methodElement2 = (MethodElement)objectArray[2];
            String string = methodElement.getGuid();
            MethodElement methodElement3 = (MethodElement)this.replacedElementMap.get(string);
            if (methodElement3 == null || methodElement3 == methodElement) continue;
            methodElement2.eSet(eStructuralFeature, (Object)methodElement3);
        }
    }

    public static void ensureUniqueName(EObject eObject, MethodElement methodElement, Map map) {
        Object[] objectArray;
        Object object;
        if (eObject == null) {
            return;
        }
        Class<?> clazz = methodElement.getClass();
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        int n = 0;
        while (n < eObject.eContents().size()) {
            object = eObject.eContents().get(n);
            if (object.getClass() == clazz && object != methodElement) {
                objectArray = (Object[])object;
                hashMap.put(objectArray.getName(), objectArray);
            }
            ++n;
        }
        String string = methodElement.getName();
        object = string;
        while (hashMap.containsKey(object)) {
            object = String.valueOf(object) + "_renamed";
        }
        if (object != string) {
            methodElement.setName((String)object);
            objectArray = new Object[]{methodElement, string, hashMap.get(string), object};
            map.put(methodElement.getGuid(), objectArray);
        }
    }

    public static void ensureUniqueNameForExistingElement(MethodElement methodElement, String string, String string2, Map map) {
        EObject eObject = methodElement.eContainer();
        if (eObject != null) {
            methodElement.setName(string2);
            LibraryImportManager.ensureUniqueName(eObject, methodElement, map);
            if (!methodElement.getName().equals(string2)) {
                return;
            }
            methodElement.setName(string);
        }
        Object[] objectArray = new Object[]{methodElement, string2};
        map.put(methodElement.getGuid(), objectArray);
    }

    private void checkModifiedFiles() {
        final List list = this.getModifiedResources(this.baseLibrary);
        list.addAll(this.resScanner.getFilesTobeReplaced());
        list.addAll(this.diagramHandler.getModifiedFiles());
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                LibraryImportManager.this.fileCheckedOutStatus = FileModifyChecker.checkModify(list);
            }
        });
    }

    public class ElementListDiff {
        List newItems = new ArrayList();
        List deletedItems = new ArrayList();
        Map oldNewMap = new LinkedHashMap();

        public ElementListDiff(List list, List list2) {
            Map map = this.getGuidMap(list2);
            this.newItems.addAll(list2);
            for (MethodElement methodElement : list) {
                String string = methodElement.getGuid();
                Object v = map.get(string);
                if (v != null) {
                    this.oldNewMap.put(methodElement, v);
                    this.newItems.remove(v);
                    continue;
                }
                this.deletedItems.add(methodElement);
            }
        }

        private Map getGuidMap(List list) {
            HashMap<String, MethodElement> hashMap = new HashMap<String, MethodElement>();
            for (MethodElement methodElement : list) {
                hashMap.put(methodElement.getGuid(), methodElement);
            }
            return hashMap;
        }
    }
}

