/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigSpecs;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.wizards.ImportConfigurationWizard;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectConfigSpecsToImportPage
extends BaseWizardPage
implements ISelectionChangedListener,
ICheckStateListener {
    public static final String PAGE_NAME = SelectConfigSpecsToImportPage.class.getName();
    private static final String libraryConfigSpecExists = ImportResources.SelectConfigSpecsToImportPage_libraryConfigSpecExists;
    private static final String libraryConfigSpecNotExists = ImportResources.SelectConfigSpecsToImportPage_libraryConfigSpecNotExists;
    private static final String configSpecNoSelection = ImportResources.SelectConfigSpecsToImportPage_configSpecNoSelection;
    private static final String configSpecDataLabel = ImportResources.SelectConfigSpecsToImportPage_configSpecDataLabel;
    private CheckboxTableViewer ctrl_chkboxTableViewer;
    private Text ctrl_briefDescImport;
    private Label importConfigSpecLabel;
    private Text ctrl_briefDescLibrary;
    private Label libraryConfigSpecLabel;
    private Composite container;
    private ConfigurationImportData data;

    public SelectConfigSpecsToImportPage(ConfigurationImportData configurationImportData) {
        super(PAGE_NAME);
        this.setTitle(ImportResources.selectConfigSpecsWizardPage_title);
        this.setDescription(ImportResources.selectConfigSpecsWizardPage_text);
        this.setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportLibraryConfiguration.gif"));
        this.data = configurationImportData;
    }

    public void createControl(Composite composite) {
        this.container = new Composite(composite, 0);
        this.container.setLayout((Layout)new GridLayout(2, true));
        Composite composite2 = new Composite(this.container, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        SelectConfigSpecsToImportPage.createLabel((Composite)composite2, (String)ImportResources.SelectConfigSpecsToImportPage_label_configs, (int)2);
        this.ctrl_chkboxTableViewer = SelectConfigSpecsToImportPage.createCheckboxTableViewer((Composite)composite2, (int)1);
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object object) {
                return LibraryUIImages.IMG_METHOD_CONFIGURATON;
            }

            public String getText(Object object) {
                return super.getText(object);
            }
        };
        this.ctrl_chkboxTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_chkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite composite3 = new Composite(this.container, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(768));
        this.createImportConfigSpecInfo(composite3);
        Composite composite4 = new Composite(this.container, 0);
        composite4.setLayout((Layout)new GridLayout());
        composite4.setLayoutData((Object)new GridData(768));
        this.createLibraryConfigSpecInfo(composite4);
        this.addListeners();
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private void createImportConfigSpecInfo(Composite composite) {
        this.importConfigSpecLabel = SelectConfigSpecsToImportPage.createLabel((Composite)composite, (String)configSpecNoSelection, (int)1);
        SelectConfigSpecsToImportPage.createLine((Composite)composite, (int)1);
        SelectConfigSpecsToImportPage.createLabel((Composite)composite, (String)ImportResources.SelectConfigSpecsToImportPage_label_desc, (int)1);
        this.ctrl_briefDescImport = SelectConfigSpecsToImportPage.createMultiLineText((Composite)composite, (String)"", (int)275, (int)100, (int)1);
    }

    private void createLibraryConfigSpecInfo(Composite composite) {
        this.libraryConfigSpecLabel = SelectConfigSpecsToImportPage.createLabel((Composite)composite, (String)configSpecNoSelection, (int)1);
        SelectConfigSpecsToImportPage.createLine((Composite)composite, (int)1);
        SelectConfigSpecsToImportPage.createLabel((Composite)composite, (String)ImportResources.SelectConfigSpecsToImportPage_label_desc, (int)1);
        this.ctrl_briefDescLibrary = SelectConfigSpecsToImportPage.createMultiLineText((Composite)composite, (String)"", (int)275, (int)100, (int)1);
    }

    private void addListeners() {
        this.ctrl_chkboxTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.ctrl_chkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
        if (!structuredSelection.isEmpty()) {
            Object[] objectArray = structuredSelection.toArray();
            this.setDisplayAttributes((ConfigSpecs.Entry)objectArray[0]);
        } else {
            this.clearDisplayAttributes();
        }
    }

    private void setDisplayAttributes(ConfigSpecs.Entry entry) {
        this.ctrl_briefDescImport.setText(entry.configSpec.brief_desc == null ? "" : entry.configSpec.brief_desc);
        this.importConfigSpecLabel.setText(configSpecDataLabel);
        if (entry.existingConfig != null) {
            this.ctrl_briefDescLibrary.setText(entry.existingConfig.getBriefDescription());
            this.libraryConfigSpecLabel.setText(libraryConfigSpecExists);
        } else {
            this.libraryConfigSpecLabel.setText(libraryConfigSpecNotExists);
            this.ctrl_briefDescLibrary.setText("");
        }
    }

    private void clearDisplayAttributes() {
        this.ctrl_briefDescImport.setText("");
        this.ctrl_briefDescLibrary.setText("");
        this.libraryConfigSpecLabel.setText(configSpecNoSelection);
        this.importConfigSpecLabel.setText(configSpecNoSelection);
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        if (this.ctrl_chkboxTableViewer.getCheckedElements().length > 0) {
            for (ConfigSpecs.Entry entry : this.data.specs.configs) {
                entry.selected = this.ctrl_chkboxTableViewer.getChecked((Object)entry);
            }
            ((ImportConfigurationWizard)this.getWizard()).okToComplete = true;
        } else {
            ((ImportConfigurationWizard)this.getWizard()).okToComplete = false;
        }
        return false;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void onEnterPage(Object object) {
        this.ctrl_chkboxTableViewer.setInput((Object)this.data.specs.configs);
        if (this.data.specs.configs.size() > 0) {
            StructuredSelection structuredSelection = new StructuredSelection(this.data.specs.configs.get(0));
            this.ctrl_chkboxTableViewer.setSelection((ISelection)structuredSelection);
        }
    }
}

