/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.export.wizards.DestinationCommonPage;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.services.ConfigurationImportService;
import org.eclipse.epf.importing.wizards.ImportConfigurationWizard;
import org.eclipse.epf.importing.wizards.ImportUIPreferences;
import org.eclipse.epf.importing.wizards.PluginModifyInfo;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class SelectImportConfigurationSource
extends DestinationCommonPage {
    public static final String PAGE_NAME = SelectImportConfigurationSource.class.getName();
    private static final Status okStatus = new Status(0, ImportResources.SelectImportConfigurationSource_not_used, 0, "", null);
    private ConfigurationImportData data;
    private ConfigurationImportService service;
    private Status status = okStatus;

    public SelectImportConfigurationSource(ConfigurationImportData configurationImportData, ConfigurationImportService configurationImportService) {
        super(PAGE_NAME, configurationImportData.llData);
        this.setTitle(ImportResources.selectConfigDirWizardPage_title);
        this.setDescription(ImportResources.selectConfigDirWizardPage_text);
        this.setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportLibraryConfiguration.gif"));
        this.service = configurationImportService;
        this.data = configurationImportData;
    }

    protected void initControls() {
        String[] stringArray = ImportUIPreferences.getImportConfigDirs();
        if (stringArray != null && stringArray.length > 0) {
            this.exportPathCombo.setItems(stringArray);
            this.exportPathCombo.setText(stringArray[0]);
        }
        super.initControls();
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        boolean bl = false;
        this.status = okStatus;
        if (this.exportPathCombo.getText().length() > 0) {
            this.saveToDataModel();
            File file = new File(this.exportPathCombo.getText());
            if (!file.exists()) {
                this.status = new Status(4, ImportResources.SelectImportConfigurationSource_not_used, 0, ImportResources.SelectImportConfigurationSource_no_path, null);
            } else {
                bl = true;
            }
        }
        this.applyToStatusLine();
        return bl;
    }

    public IWizardPage getNextPage() {
        this.saveToDataModel();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                iProgressMonitor.beginTask(ImportResources.SelectImportConfigurationSource_MSG1, -1);
                SelectImportConfigurationSource.this.service.analyze(iProgressMonitor);
                iProgressMonitor.done();
            }
        };
        try {
            this.getWizard().getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = this.data.getErrorInfo().getError();
        if (string != null && string.length() > 0) {
            this.status = new Status(4, ImportResources.SelectImportConfigurationSource_not_used, 0, string, null);
            this.applyToStatusLine();
            return this;
        }
        BaseWizardPage baseWizardPage = null;
        if (this.data.specs != null) {
            baseWizardPage = ((ImportConfigurationWizard)this.getWizard()).specsPage;
        } else {
            PluginModifyInfo pluginModifyInfo = this.checkModify();
            if (pluginModifyInfo.readonlyPlugins.size() > 0) {
                string = pluginModifyInfo.getReadonlyMessage().toString();
                ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.ImportConfigurationWizard_error, string);
                this.status = new Status(4, ImportResources.SelectImportConfigurationSource_not_used, 0, ImportResources.SelectImportConfigurationSource_error_not_updatable, null);
                this.applyToStatusLine();
                return this;
            }
            if (pluginModifyInfo.lockedPlugins.size() > 0) {
                String string2 = ImportResources.importConfigWizard_title;
                String string3 = String.valueOf(pluginModifyInfo.getLockedMessage().toString()) + ImportResources.ImportPluginWizard_confirm_continue;
                boolean bl = ImportPlugin.getDefault().getMsgDialog().displayConfirmation(string2, string3);
                if (!bl) {
                    this.status = new Status(4, ImportResources.SelectImportConfigurationSource_not_used, 0, ImportResources.SelectImportConfigurationSource_error_not_updatable, null);
                    this.applyToStatusLine();
                    return this;
                }
            }
            baseWizardPage = ((ImportConfigurationWizard)this.getWizard()).configPage;
        }
        baseWizardPage.onEnterPage(null);
        return baseWizardPage;
    }

    public PluginModifyInfo checkModify() {
        return SelectImportConfigurationSource.checkModify(LibraryUtil.getMethodPluginGuids((MethodLibrary)this.service.getImportingLibrary()), this.getShell(), true);
    }

    public static PluginModifyInfo checkModify(List list, Shell shell, boolean bl) {
        PluginModifyInfo pluginModifyInfo = new PluginModifyInfo();
        List list2 = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
        for (MethodPlugin methodPlugin : list2) {
            IStatus iStatus;
            if (!list.contains(methodPlugin.getGuid())) continue;
            if (!methodPlugin.getUserChangeable().booleanValue()) {
                pluginModifyInfo.lockedPlugins.add(methodPlugin);
                continue;
            }
            if (!bl || (iStatus = TngUtil.checkEdit((EObject)methodPlugin, (Object)shell)).isOK()) continue;
            pluginModifyInfo.readonlyPlugins.add(methodPlugin);
        }
        return pluginModifyInfo;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void applyToStatusLine() {
        if (this.status != okStatus) {
            this.setErrorMessage(this.status.getMessage());
        } else {
            this.setErrorMessage(null);
        }
    }
}

