/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.importing.services.PluginImportingService;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SelectPluginsToImport
extends BaseWizardPage
implements ISelectionChangedListener,
ICheckStateListener,
Listener {
    public static final String PAGE_NAME = SelectPluginsToImport.class.getName();
    private static final String libraryPluginExists = ImportResources.SelectPluginsToImport_libraryPluginExists;
    private static final String libraryPluginNotExists = ImportResources.SelectPluginsToImport_libraryPluginNotExists;
    private static final String pluginNoSelection = ImportResources.SelectPluginsToImport_pluginNoSelection;
    private static final String pluginDataLabel = ImportResources.SelectPluginsToImport_pluginDataLabel;
    private CheckboxTableViewer ctrl_chkboxTableViewer;
    private Text ctrl_authorImport;
    private Text ctrl_versionImport;
    private Text ctrl_briefDescImport;
    private Label importPluginLabel;
    private Text ctrl_authorLibrary;
    private Text ctrl_versionLibrary;
    private Text ctrl_briefDescLibrary;
    private Label libraryPluginLabel;
    private Composite container;
    private int checkedCount = 0;
    private List checkedPluginList = new ArrayList();
    private PluginImportData data;
    private PluginImportingService service;

    public SelectPluginsToImport(PluginImportData pluginImportData, PluginImportingService pluginImportingService) {
        super(PAGE_NAME);
        this.setTitle(ImportResources.selectPluginsWizardPage_title);
        this.setDescription(ImportResources.selectPluginsWizardPage_text);
        this.setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportMethodPlugins.gif"));
        this.service = pluginImportingService;
        this.data = pluginImportData;
    }

    public void createControl(Composite composite) {
        this.container = new Composite(composite, 0);
        this.container.setLayout((Layout)new GridLayout(2, true));
        Composite composite2 = new Composite(this.container, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        SelectPluginsToImport.createLabel((Composite)composite2, (String)ImportResources.SelectPluginsToImport_label_plugins, (int)2);
        this.ctrl_chkboxTableViewer = SelectPluginsToImport.createCheckboxTableViewer((Composite)composite2, (int)2);
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object object) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object object) {
                if (object instanceof MethodPlugin) {
                    return ((MethodPlugin)object).getName();
                }
                return object.toString();
            }
        };
        this.ctrl_chkboxTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_chkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite composite3 = new Composite(this.container, 0);
        composite3.setLayout((Layout)new GridLayout());
        this.createImportPluginInfo(composite3);
        Composite composite4 = new Composite(this.container, 0);
        composite4.setLayout((Layout)new GridLayout());
        this.createLibraryPluginInfo(composite4);
        this.addListeners();
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private void createImportPluginInfo(Composite composite) {
        this.importPluginLabel = SelectPluginsToImport.createLabel((Composite)composite, (String)pluginNoSelection, (int)1);
        SelectPluginsToImport.createLine((Composite)composite, (int)1);
        SelectPluginsToImport.createLabel((Composite)composite, (String)ImportResources.SelectPluginsToImport_label_author, (int)1);
        this.ctrl_authorImport = SelectPluginsToImport.createMultiLineText((Composite)composite, (String)"", (int)275, (int)40, (int)1);
        SelectPluginsToImport.createLabel((Composite)composite, (String)ImportResources.SelectPluginsToImport_label_version, (int)1);
        this.ctrl_versionImport = SelectPluginsToImport.createText((Composite)composite, (String)"", (int)275, (int)1);
        SelectPluginsToImport.createLabel((Composite)composite, (String)ImportResources.SelectPluginsToImport_label_desc, (int)1);
        this.ctrl_briefDescImport = SelectPluginsToImport.createMultiLineText((Composite)composite, (String)"", (int)275, (int)100, (int)1);
    }

    private void createLibraryPluginInfo(Composite composite) {
        this.libraryPluginLabel = SelectPluginsToImport.createLabel((Composite)composite, (String)pluginNoSelection, (int)1);
        SelectPluginsToImport.createLine((Composite)composite, (int)1);
        SelectPluginsToImport.createLabel((Composite)composite, (String)ImportResources.SelectPluginsToImport_label_author, (int)1);
        this.ctrl_authorLibrary = SelectPluginsToImport.createMultiLineText((Composite)composite, (String)"", (int)275, (int)40, (int)1);
        SelectPluginsToImport.createLabel((Composite)composite, (String)ImportResources.SelectPluginsToImport_label_version, (int)1);
        this.ctrl_versionLibrary = SelectPluginsToImport.createText((Composite)composite, (String)"", (int)275, (int)1);
        SelectPluginsToImport.createLabel((Composite)composite, (String)ImportResources.SelectPluginsToImport_label_desc, (int)1);
        this.ctrl_briefDescLibrary = SelectPluginsToImport.createMultiLineText((Composite)composite, (String)"", (int)275, (int)100, (int)1);
    }

    private void addListeners() {
        this.ctrl_chkboxTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.ctrl_chkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        String string;
        Object object = checkStateChangedEvent.getElement();
        if (object instanceof PluginImportData.PluginInfo) {
            ((PluginImportData.PluginInfo)object).selected = checkStateChangedEvent.getChecked();
        }
        if ((string = this.service.validateSelection()) != null && string.length() > 0) {
            super.setErrorMessage(string);
        } else {
            super.setErrorMessage(null);
        }
        if (checkStateChangedEvent.getChecked()) {
            ++this.checkedCount;
            this.checkedPluginList.add(object);
        } else {
            --this.checkedCount;
            this.checkedPluginList.remove(object);
        }
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
        if (!structuredSelection.isEmpty()) {
            Object[] objectArray = structuredSelection.toArray();
            this.setDisplayAttributes((PluginImportData.PluginInfo)objectArray[0]);
        } else {
            this.clearDisplayAttributes();
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    private void setDisplayAttributes(PluginImportData.PluginInfo pluginInfo) {
        this.ctrl_authorImport.setText(pluginInfo.authors == null ? "" : pluginInfo.authors);
        this.ctrl_versionImport.setText(pluginInfo.version == null ? "" : pluginInfo.version);
        this.ctrl_briefDescImport.setText(pluginInfo.brief_desc == null ? "" : pluginInfo.brief_desc);
        this.importPluginLabel.setText(pluginDataLabel);
        if (pluginInfo.existingPlugin != null) {
            this.libraryPluginLabel.setText(libraryPluginExists);
            this.ctrl_authorLibrary.setText(pluginInfo.existingPlugin.getAuthors());
            this.ctrl_versionLibrary.setText(pluginInfo.existingPlugin.getVersion());
            this.ctrl_briefDescLibrary.setText(pluginInfo.existingPlugin.getBriefDescription());
        } else {
            this.libraryPluginLabel.setText(libraryPluginNotExists);
            this.ctrl_authorLibrary.setText("");
            this.ctrl_versionLibrary.setText("");
            this.ctrl_briefDescLibrary.setText("");
        }
    }

    private void clearDisplayAttributes() {
        this.importPluginLabel.setText(pluginNoSelection);
        this.ctrl_authorImport.setText("");
        this.ctrl_versionImport.setText("");
        this.ctrl_briefDescImport.setText("");
        this.libraryPluginLabel.setText(pluginNoSelection);
        this.ctrl_authorLibrary.setText("");
        this.ctrl_versionLibrary.setText("");
        this.ctrl_briefDescLibrary.setText("");
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return this.checkedCount > 0;
    }

    public void onEnterPage(Object object) {
        List list = this.data.getPlugins();
        if (list != null) {
            this.ctrl_chkboxTableViewer.setInput((Object)list.toArray());
            if (!list.isEmpty()) {
                StructuredSelection structuredSelection = new StructuredSelection(list.get(0));
                this.ctrl_chkboxTableViewer.setSelection((ISelection)structuredSelection);
            }
        }
    }
}

