/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.epf.authoring.gef.figures.FreeTextFigure;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

public class FreeTextCellEditorLocator
implements CellEditorLocator {
    IFigure figure;

    public FreeTextCellEditorLocator(IFigure iFigure) {
        this.setFigure(iFigure);
    }

    public void relocate(CellEditor cellEditor) {
        FreeTextFigure freeTextFigure = (FreeTextFigure)this.figure;
        Text text = (Text)cellEditor.getControl();
        String string = (String)cellEditor.getValue();
        GC gC = new GC((Drawable)text);
        Point point = gC.textExtent(string);
        gC.dispose();
        if (point.x != 0) {
            point = text.computeSize(point.x, -1);
        }
        text.setSize(point.x, point.y);
        Rectangle rectangle = new Rectangle(text.getClientArea().x, text.getClientArea().y, text.getClientArea().width, text.getClientArea().height);
        Rectangle rectangle2 = freeTextFigure.getClientArea();
        freeTextFigure.translateToAbsolute((Translatable)rectangle2);
        int n = (rectangle2.width - rectangle.width) / 2;
        int n2 = freeTextFigure.getTextFlowPage().getLocation().y;
        text.setLocation(rectangle2.x + n, n2);
    }

    public void setFigure(IFigure iFigure) {
        this.figure = iFigure;
    }

    public IFigure getFigure() {
        return this.figure;
    }
}

