/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.epf.authoring.gef.edit.BaseEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class LabelDirectEditManager
extends DirectEditManager {
    Font scaledFont;

    public LabelDirectEditManager(GraphicalEditPart graphicalEditPart, Class clazz, CellEditorLocator cellEditorLocator) {
        super(graphicalEditPart, clazz, cellEditorLocator);
    }

    protected void bringDown() {
        Font font = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (font != null) {
            font.dispose();
        }
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        this.getCellEditor().setValue((Object)this.getInitialText());
        IFigure iFigure = this.getEditPart().getFigure();
        this.scaledFont = iFigure.getFont();
        FontData fontData = this.scaledFont.getFontData()[0];
        Dimension dimension = new Dimension(0, fontData.getHeight());
        this.getDirectEditFigure().translateToAbsolute((Translatable)dimension);
        fontData.setHeight(dimension.height);
        this.scaledFont = new Font(null, fontData);
        text.setFont(this.scaledFont);
        text.selectAll();
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        return new TextCellEditor(composite, 66);
    }

    protected String getInitialText() {
        return ((BaseEditPart)this.getEditPart()).getDirectEditText();
    }

    protected IFigure getDirectEditFigure() {
        return ((BaseEditPart)this.getEditPart()).getDirectEditFigure();
    }
}

