/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.figures;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.StringTokenizer;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;

public class WrappableLabel
extends Figure
implements PositionConstants {
    private static String ELLIPSIS = "...";
    private Image icon;
    private String text = "";
    private String subStringText;
    private Dimension textSize;
    private Dimension subStringTextSize;
    private Dimension iconSize = new Dimension(0, 0);
    private Point iconLocation;
    private Point textLocation;
    private int textAlignment = 2;
    private int iconAlignment = 2;
    private int labelAlignment = 2;
    private int textPlacement = 4;
    private int iconTextGap = 3;
    private static final int FLAG_SELECTED = MAX_FLAG << 1;
    private static final int FLAG_HASFOCUS = MAX_FLAG << 2;
    private static final int FLAG_WRAP = MAX_FLAG << 5;
    private static final int FLAG_WRAP_ALIGN = MAX_FLAG << 6;
    private Dimension textDimension = new Dimension(-1, -1);
    private Dimension prefSizeDimension = new Dimension(-1, -1);
    private int wrapWidth;

    public WrappableLabel() {
    }

    public WrappableLabel(String string) {
        this.setText(string);
    }

    public WrappableLabel(Image image) {
        this.setIcon(image);
    }

    public WrappableLabel(String string, Image image) {
        this.setText(string);
        this.setIcon(image);
    }

    private void alignOnHeight(Point point, Dimension dimension, int n) {
        Insets insets = this.getInsets();
        switch (n) {
            case 8: {
                point.y = insets.top;
                break;
            }
            case 32: {
                point.y = this.bounds.height - dimension.height - insets.bottom;
                break;
            }
            default: {
                point.y = (this.bounds.height - dimension.height) / 2;
            }
        }
    }

    private void alignOnWidth(Point point, Dimension dimension, int n) {
        Insets insets = this.getInsets();
        switch (n) {
            case 1: {
                point.x = insets.left;
                break;
            }
            case 4: {
                point.x = this.bounds.width - dimension.width - insets.right;
                break;
            }
            default: {
                point.x = (this.bounds.width - dimension.width) / 2;
            }
        }
    }

    private void calculateAlignment() {
        switch (this.textPlacement) {
            case 8: 
            case 16: {
                this.alignOnHeight(this.textLocation, this.getTextSize(), this.textAlignment);
                this.alignOnHeight(this.iconLocation, this.iconSize, this.iconAlignment);
                break;
            }
            case 1: 
            case 4: {
                this.alignOnWidth(this.textLocation, this.getSubStringTextSize(), this.textAlignment);
                this.alignOnWidth(this.iconLocation, this.iconSize, this.iconAlignment);
            }
        }
    }

    protected Dimension calculateLabelSize(Dimension dimension) {
        int n = this.iconTextGap;
        if (this.getIcon() == null || this.getText().equals("")) {
            n = 0;
        }
        Dimension dimension2 = new Dimension(0, 0);
        if (this.textPlacement == 8 || this.textPlacement == 16) {
            dimension2.width = this.iconSize.width + n + dimension.width;
            dimension2.height = Math.max(this.iconSize.height, dimension.height);
        } else {
            dimension2.width = Math.max(this.iconSize.width, dimension.width);
            dimension2.height = this.iconSize.height + n + dimension.height;
        }
        return dimension2;
    }

    private void calculateLocations() {
        this.textLocation = new Point();
        this.iconLocation = new Point();
        this.calculatePlacement();
        this.calculateAlignment();
        Dimension dimension = this.getSize().getDifference(this.getPreferredSize());
        dimension.width += this.getTextSize().width - this.getSubStringTextSize().width;
        switch (this.labelAlignment) {
            case 2: {
                dimension.scale(0.5);
                break;
            }
            case 1: {
                dimension.scale(0.0);
                break;
            }
            case 4: {
                dimension.scale(1.0);
                break;
            }
            case 8: {
                dimension.height = 0;
                dimension.scale(0.5);
                break;
            }
            case 32: {
                dimension.height *= 2;
                dimension.scale(0.5);
                break;
            }
            default: {
                dimension.scale(0.5);
            }
        }
        switch (this.textPlacement) {
            case 8: 
            case 16: {
                dimension.height = 0;
                break;
            }
            case 1: 
            case 4: {
                dimension.width = 0;
            }
        }
        this.textLocation.translate(dimension);
        this.iconLocation.translate(dimension);
    }

    private void calculatePlacement() {
        int n = this.iconTextGap;
        if (this.icon == null || this.text.equals("")) {
            n = 0;
        }
        Insets insets = this.getInsets();
        switch (this.textPlacement) {
            case 16: {
                this.iconLocation.x = insets.left;
                this.textLocation.x = this.iconSize.width + n + insets.left;
                break;
            }
            case 8: {
                this.textLocation.x = insets.left;
                this.iconLocation.x = this.getSubStringTextSize().width + n + insets.left;
                break;
            }
            case 1: {
                this.textLocation.y = insets.top;
                this.iconLocation.y = this.getTextSize().height + n + insets.top;
                break;
            }
            case 4: {
                this.textLocation.y = this.iconSize.height + n + insets.top;
                this.iconLocation.y = insets.top;
            }
        }
    }

    protected Dimension calculateSubStringTextSize() {
        return FigureUtilities.getTextExtents((String)this.getSubStringText(), (Font)this.getFont());
    }

    protected Dimension calculateTextSize() {
        return FigureUtilities.getTextExtents((String)this.getWrappedText(this.getSize().width, this.getSize().height), (Font)this.getFont());
    }

    private void clearLocations() {
        this.textLocation = null;
        this.iconLocation = null;
    }

    public Image getIcon() {
        return this.icon;
    }

    public int getIconAlignment() {
        return this.iconAlignment;
    }

    public Rectangle getIconBounds() {
        Rectangle rectangle = this.getBounds();
        return new Rectangle(rectangle.getLocation().translate(this.getIconLocation()), this.iconSize);
    }

    protected Point getIconLocation() {
        if (this.iconLocation == null) {
            this.calculateLocations();
        }
        return this.iconLocation;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public Dimension getMinimumSize(int n, int n2) {
        if (this.minSize != null) {
            return this.minSize;
        }
        this.minSize = new Dimension();
        if (this.getLayoutManager() != null) {
            this.minSize.setSize(this.getLayoutManager().getMinimumSize((IFigure)this, n, n2));
        }
        Dimension dimension = this.calculateLabelSize(FigureUtilities.getTextExtents((String)ELLIPSIS, (Font)this.getFont()).intersect(FigureUtilities.getTextExtents((String)this.getText(), (Font)this.getFont())));
        Insets insets = this.getInsets();
        dimension.expand(insets.getWidth(), insets.getHeight());
        this.minSize.union(dimension);
        return this.minSize;
    }

    public Dimension getPreferredSize(int n, int n2) {
        Insets insets;
        if (this.prefSize == null || n != this.prefSizeDimension.width || n2 != this.prefSizeDimension.height) {
            this.prefSize = this.calculateLabelSize(this.getTextSize(n, n2));
            insets = this.getInsets();
            this.prefSize.expand(insets.getWidth(), insets.getHeight());
            if (this.getLayoutManager() != null) {
                this.prefSize.union(this.getLayoutManager().getPreferredSize((IFigure)this, n, n2));
            }
        }
        if (n >= 0 && n < this.prefSize.width) {
            insets = this.getMinimumSize(n, n2);
            Dimension dimension = this.prefSize.getCopy();
            dimension.width = Math.min(dimension.width, n);
            this.prefSizeDimension.width = dimension.width = Math.max(insets.width, dimension.width);
            this.prefSizeDimension.height = dimension.width;
            return dimension;
        }
        return this.prefSize;
    }

    public String getSubStringText() {
        if (this.subStringText != null) {
            return this.subStringText;
        }
        this.subStringText = this.text;
        Dimension dimension = this.getPreferredSize(this.getSize().width, this.getSize().height).getDifference(this.getSize());
        Dimension dimension2 = this.getTextSize().getExpanded(-dimension.width, -dimension.height);
        Font font = this.getFont();
        int n = FigureUtilities.getFontMetrics((Font)font).getHeight();
        int n2 = (int)((double)dimension2.height / (double)n);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(this.getText());
        int n3 = 0;
        int n4 = 0;
        while (stringBuffer2.length() > 0 && n4++ < n2) {
            n3 = this.getLineWrapPosition(stringBuffer2.toString(), font, dimension2.width);
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            if (n3 == 0 || stringBuffer2.length() > n3 && n4 == n2) {
                int n5 = FigureUtilities.getTextExtents((String)WrappableLabel.ELLIPSIS, (Font)font).width;
                n3 = WrappableLabel.getLargestSubstringConfinedTo(stringBuffer2.toString(), font, Math.max(dimension2.width - n5, 0));
                stringBuffer.append(stringBuffer2.substring(0, n3));
                stringBuffer.append(ELLIPSIS);
            } else {
                stringBuffer.append(stringBuffer2.substring(0, n3));
            }
            stringBuffer2.delete(0, n3);
        }
        this.subStringText = stringBuffer.toString();
        return this.subStringText;
    }

    protected Dimension getSubStringTextSize() {
        if (this.subStringTextSize == null) {
            this.subStringTextSize = this.calculateSubStringTextSize();
        }
        return this.subStringTextSize;
    }

    public String getText() {
        return this.text;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public Rectangle getTextBounds() {
        Rectangle rectangle = this.getBounds();
        return new Rectangle(rectangle.getLocation().translate(this.getTextLocation()), this.textSize);
    }

    protected Point getTextLocation() {
        if (this.textLocation != null) {
            return this.textLocation;
        }
        this.calculateLocations();
        return this.textLocation;
    }

    public int getTextPlacement() {
        return this.textPlacement;
    }

    protected Dimension getTextSize() {
        if (this.textSize == null) {
            this.textSize = this.calculateTextSize();
        }
        return this.textSize;
    }

    protected Dimension getTextSize(int n, int n2) {
        if (this.textSize == null) {
            this.textSize = this.calculateTextSize(n, n2);
            this.textDimension.width = n;
            this.textDimension.height = n2;
        }
        return this.textSize;
    }

    public void invalidate() {
        this.prefSize = null;
        this.minSize = null;
        this.clearLocations();
        this.textSize = null;
        this.subStringTextSize = null;
        this.subStringText = null;
        super.invalidate();
    }

    public boolean isTextTruncated() {
        return !this.getSubStringTextSize().equals((Object)this.getTextSize());
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isSelected()) {
            graphics.pushState();
            graphics.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            graphics.fillRectangle(this.getSelectionRectangle());
            graphics.popState();
            graphics.setForegroundColor(ColorConstants.white);
        }
        if (this.hasFocus()) {
            graphics.pushState();
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.menuBackgroundSelected);
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.drawFocus(this.getSelectionRectangle().resize(-1, -1));
            graphics.popState();
        }
        if (this.isOpaque()) {
            super.paintFigure(graphics);
        }
        Rectangle rectangle = this.getBounds();
        graphics.translate(rectangle.x, rectangle.y);
        if (this.icon != null) {
            graphics.drawImage(this.icon, this.getIconLocation());
        }
        if (!this.isEnabled()) {
            graphics.translate(1, 1);
            graphics.setForegroundColor(ColorConstants.buttonLightest);
            this.graphicsdrawText(graphics);
            graphics.drawText(this.getSubStringText(), this.getTextLocation());
            graphics.translate(-1, -1);
            graphics.setForegroundColor(ColorConstants.buttonDarker);
        }
        this.graphicsdrawText(graphics);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    public void setIcon(Image image) {
        if (this.icon == image) {
            return;
        }
        this.icon = image;
        this.repaint();
        if (this.icon == null) {
            this.setIconDimension(new Dimension());
        } else {
            this.setIconDimension(new Dimension(image));
        }
    }

    public void setIconAlignment(int n) {
        if (this.iconAlignment == n) {
            return;
        }
        this.iconAlignment = n;
        this.clearLocations();
        this.repaint();
    }

    public void setIconDimension(Dimension dimension) {
        if (dimension.equals((Object)this.iconSize)) {
            return;
        }
        this.iconSize = dimension;
        this.revalidate();
    }

    public void setIconTextGap(int n) {
        if (this.iconTextGap == n) {
            return;
        }
        this.iconTextGap = n;
        this.repaint();
        this.revalidate();
    }

    public void setLabelAlignment(int n) {
        if (this.labelAlignment == n) {
            return;
        }
        this.labelAlignment = n;
        this.clearLocations();
        this.repaint();
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (this.text.equals(string)) {
            return;
        }
        this.text = string;
        this.revalidate();
        this.repaint();
    }

    public void setTextAlignment(int n) {
        if (this.textAlignment == n) {
            return;
        }
        this.textAlignment = n;
        this.clearLocations();
        this.repaint();
    }

    public void setTextPlacement(int n) {
        if (this.textPlacement == n) {
            return;
        }
        this.textPlacement = n;
        this.revalidate();
        this.repaint();
    }

    private Rectangle getSelectionRectangle() {
        Rectangle rectangle = this.getTextBounds();
        rectangle.expand(new Insets(2, 2, 0, 0));
        this.translateToParent((Translatable)rectangle);
        rectangle.intersect(this.getBounds());
        return rectangle;
    }

    protected Dimension calculateTextSize(int n, int n2) {
        return FigureUtilities.getTextExtents((String)this.getWrappedText(n, n2), (Font)this.getFont());
    }

    private String getWrappedText(int n, int n2) {
        if (!this.isTextWrapped() || n == -1) {
            return this.getText();
        }
        if (this.isIconExist()) {
            switch (this.textPlacement) {
                case 8: 
                case 16: {
                    n -= this.iconSize.width + this.getIconTextGap();
                    break;
                }
                case 1: 
                case 4: {
                    if (n2 == -1) break;
                    n2 -= this.iconSize.height + this.getIconTextGap();
                }
            }
        }
        Font font = this.getFont();
        int n3 = Integer.MAX_VALUE;
        if (n2 != -1) {
            int n4 = FigureUtilities.getFontMetrics((Font)font).getHeight();
            n3 = (int)((double)n2 / (double)n4);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(this.getText());
        int n5 = 0;
        int n6 = 0;
        while (stringBuffer2.length() > 0 && n6++ < n3) {
            n5 = this.getLineWrapPosition(stringBuffer2.toString(), font, n2);
            if (n5 == 0) break;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(stringBuffer2.substring(0, n5));
            stringBuffer2.delete(0, n5);
        }
        return stringBuffer.toString();
    }

    private boolean isIconExist() {
        return true;
    }

    private int getLineWrapPosition(String string, Font font, int n) {
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.first();
        int n3 = breakIterator.next();
        if (FigureUtilities.getTextExtents((String)string.substring((int)n2, (int)n3), (Font)font).width > n) {
            breakIterator = BreakIterator.getCharacterInstance();
            breakIterator.setText(string);
            n2 = breakIterator.first();
        }
        while ((n3 = breakIterator.next()) != -1 && FigureUtilities.getTextExtents((String)string.substring((int)n2, (int)n3), (Font)font).width <= n) {
        }
        return n3 == -1 ? breakIterator.last() : breakIterator.previous();
    }

    static int getLargestSubstringConfinedTo(String string, Font font, int n) {
        FontMetrics fontMetrics = FigureUtilities.getFontMetrics((Font)font);
        float f = fontMetrics.getAverageCharWidth();
        int n2 = 0;
        int n3 = string.length() + 1;
        int n4 = 0;
        int n5 = 0;
        while (n3 - n2 > 1) {
            if ((n4 += (int)((float)(n - n5) / f)) >= n3) {
                n4 = n3 - 1;
            }
            if (n4 <= n2) {
                n4 = n2 + 1;
            }
            if ((n5 = FigureUtilities.getTextExtents((String)string.substring((int)0, (int)n4), (Font)font).width) < n) {
                n2 = n4;
                continue;
            }
            n3 = n4;
        }
        return n2;
    }

    public void setTextWrap(boolean bl) {
        if (this.isTextWrapped() == bl) {
            return;
        }
        this.setFlag(FLAG_WRAP, bl);
        this.revalidate();
        this.repaint();
    }

    public boolean isTextWrapped() {
        return true;
    }

    public void setTextWrapWidth(int n) {
        if (this.wrapWidth == n) {
            return;
        }
        this.wrapWidth = n;
        this.revalidate();
        this.repaint();
    }

    public void setTextWrapAlignment(int n) {
        if (this.getTextWrapAlignment() == n) {
            return;
        }
        this.setAlignmentFlags(n, FLAG_WRAP_ALIGN);
        this.repaint();
    }

    private void setAlignmentFlags(int n, int n2) {
        this.flags &= ~(7 * n2);
        switch (n) {
            case 2: {
                this.flags |= 1 * n2;
                break;
            }
            case 8: {
                this.flags |= 2 * n2;
                break;
            }
            case 1: {
                this.flags |= 3 * n2;
                break;
            }
            case 4: {
                this.flags |= 4 * n2;
                break;
            }
            case 32: {
                this.flags |= 5 * n2;
            }
        }
    }

    private int getAlignment(int n) {
        int n2 = this.flags & 7 * n;
        if (n2 == 1 * n) {
            return 2;
        }
        if (n2 == 2 * n) {
            return 8;
        }
        if (n2 == 3 * n) {
            return 1;
        }
        if (n2 == 4 * n) {
            return 4;
        }
        if (n2 == 5 * n) {
            return 32;
        }
        return 2;
    }

    public int getTextWrapAlignment() {
        return this.getAlignment(FLAG_WRAP_ALIGN);
    }

    public boolean hasFocus() {
        return (this.flags & FLAG_HASFOCUS) != 0;
    }

    public boolean isSelected() {
        return (this.flags & FLAG_SELECTED) != 0;
    }

    private void graphicsdrawText(Graphics graphics) {
        String string = this.getSubStringText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Font font = this.getFont();
        int n = FigureUtilities.getFontMetrics((Font)font).getHeight();
        int n2 = FigureUtilities.getTextExtents((String)string, (Font)font).width;
        int n3 = this.getTextLocation().y;
        if (FigureUtilities.getFontMetrics((Font)font).getLeading() == 0) {
            int n4 = 2;
            n3 += n4;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            System.out.println("Text added to draw" + string2);
            int n5 = FigureUtilities.getTextExtents((String)string2, (Font)font).width;
            int n6 = this.getTextLocation().x;
            switch (this.getTextWrapAlignment()) {
                case 2: {
                    n6 += (n2 - n5) / 2;
                    break;
                }
                case 4: {
                    n6 += n2 - n5;
                }
            }
            graphics.drawText(string2, n6, n3);
            n3 += n;
        }
    }

    public void setFocus(boolean bl) {
        if (this.hasFocus() == bl) {
            return;
        }
        this.setFlag(FLAG_HASFOCUS, bl);
        this.repaint();
    }

    public void setSelected(boolean bl) {
        if (this.isSelected() == bl) {
            return;
        }
        this.setFlag(FLAG_SELECTED, bl);
        this.repaint();
    }
}

