/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.actions.IModifyingAction;
import org.eclipse.epf.authoring.ui.actions.IWorkbenchPartAction;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.SynchronizeCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.actions.ProcessDeleteAction;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class ProcessAutoSynchronizeAction
extends CommandActionHandler
implements IWorkbenchPartAction,
IModifyingAction {
    protected IWorkbenchPart activeWorkbenchPart;
    protected boolean canRun;

    public ProcessAutoSynchronizeAction() {
        super(null, LibraryEditResources.AutoSynchronizeCommand_label);
    }

    public ProcessAutoSynchronizeAction(String string) {
        super(null, string);
    }

    public void setActiveWorkbenchPart(IWorkbenchPart iWorkbenchPart) {
        this.activeWorkbenchPart = iWorkbenchPart;
        if (iWorkbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)iWorkbenchPart).getEditingDomain();
        }
    }

    public Command createCommand(Collection collection) {
        return new SynchronizeCommand(this.getText(), collection){

            protected Command delete(List list) {
                try {
                    return ProcessDeleteAction.delete((Collection)list);
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.aborted = true;
                    return null;
                }
            }
        };
    }

    protected Process getProcess() {
        MethodElement methodElement;
        IEditorInput iEditorInput;
        if (this.activeWorkbenchPart instanceof IEditorPart && (iEditorInput = ((IEditorPart)this.activeWorkbenchPart).getEditorInput()) instanceof MethodElementEditorInput && (methodElement = ((MethodElementEditorInput)iEditorInput).getMethodElement()) instanceof ProcessComponent) {
            return ((ProcessComponent)methodElement).getProcess();
        }
        return null;
    }

    public boolean updateSelection(IStructuredSelection iStructuredSelection) {
        ArrayList arrayList = new ArrayList();
        for (Object object : iStructuredSelection) {
            if (object instanceof BreakdownElementWrapperItemProvider && !((BreakdownElementWrapperItemProvider)object).isReadOnly()) {
                object = TngUtil.unwrap(object);
            }
            boolean bl = false;
            if (object instanceof BreakdownElement) {
                if (object instanceof Descriptor) {
                    Descriptor descriptor = (Descriptor)object;
                    bl = ProcessUtil.getAssociatedElement((Descriptor)descriptor) != null && descriptor.getSuppressed() == false;
                } else if (((BreakdownElement)object).getSuperActivities() == null) {
                    if (object instanceof Process && ((Process)object).eContainer() instanceof ProcessComponent) {
                        bl = true;
                    }
                } else {
                    boolean bl2 = bl = object instanceof Activity || object instanceof TeamProfile;
                }
            }
            if (!bl) continue;
            arrayList.add(object);
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        return super.updateSelection((IStructuredSelection)new StructuredSelection(arrayList));
    }

    public void run() {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                ProcessAutoSynchronizeAction.this.canRun = ((SynchronizeCommand)ProcessAutoSynchronizeAction.this.command).initilize();
            }
        };
        UserInteractionHelper.runWithProgress((IRunnableWithProgress)iRunnableWithProgress, (String)LibraryEditResources.ProcessAutoSynchronizeAction_prepare);
        if (this.canRun) {
            super.run();
        } else {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(this.getText(), LibraryEditResources.ProcessAutoSynchronizeAction_noDescriptorToSynch);
        }
    }
}

