/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.io.File;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.richtext.dialogs.AddImageDialog;
import org.eclipse.epf.richtext.dialogs.BaseDialog;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MethodAddImageDialog
extends AddImageDialog {
    private static final int MAX_HEIGHT = 600;
    private static final int MAX_WIDTH = 600;
    private static final int DEFAULT_HEIGHT = 200;
    private static final int DEFAULT_WIDTH = 200;
    private MethodElement methodElement;
    private File fileToCopy;
    private String elementLoc;
    private int height = 200;
    private int width = 200;
    private String altTag = "";
    private Text heightText;
    private Text widthText;
    private Text altTagText;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            if (((BaseDialog)MethodAddImageDialog.this).okButton != null) {
                try {
                    if (modifyEvent.widget == MethodAddImageDialog.this.urlText) {
                        File file = new File(MethodAddImageDialog.this.urlText.getText().trim());
                        if (file.isAbsolute()) {
                            MethodAddImageDialog.this.fileToCopy = file;
                        } else {
                            MethodAddImageDialog.this.fileToCopy = new File(MethodAddImageDialog.this.elementLoc, MethodAddImageDialog.this.urlText.getText().trim());
                        }
                        if (MethodAddImageDialog.this.fileToCopy.isFile() && MethodAddImageDialog.this.fileToCopy.canRead()) {
                            MethodAddImageDialog.this.setImageInfo(MethodAddImageDialog.this.fileToCopy.getAbsolutePath());
                        }
                    }
                    MethodAddImageDialog.this.height = Integer.parseInt(MethodAddImageDialog.this.heightText.getText().trim());
                    MethodAddImageDialog.this.width = Integer.parseInt(MethodAddImageDialog.this.widthText.getText().trim());
                    ((BaseDialog)MethodAddImageDialog.this).okButton.setEnabled(MethodAddImageDialog.this.fileToCopy.isFile() && MethodAddImageDialog.this.fileToCopy.canRead() && MethodAddImageDialog.this.height > 0 && MethodAddImageDialog.this.width > 0);
                }
                catch (Exception exception) {
                    ((BaseDialog)MethodAddImageDialog.this).okButton.setEnabled(false);
                }
            }
        }
    };

    public MethodAddImageDialog(Shell shell, MethodElement methodElement) {
        super(shell);
        this.methodElement = methodElement;
        this.elementLoc = ResourceHelper.getFolderAbsolutePath((MethodElement)methodElement);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 4;
        ((GridData)this.urlText.getLayoutData()).horizontalSpan = 2;
        this.urlText.removeModifyListener(this.urlTextListener);
        this.urlText.addModifyListener(this.modifyListener);
        this.browseButton.removeSelectionListener((SelectionListener)this.browseSelectionAdapter);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                fileDialog.setFilterPath(ResourceHelper.getFolderAbsolutePath((MethodElement)MethodAddImageDialog.this.methodElement));
                String string = fileDialog.open();
                if (string != null && string.length() > 0) {
                    try {
                        File file = new File(fileDialog.getFilterPath(), fileDialog.getFileName());
                        MethodAddImageDialog.this.urlText.setText(file.getAbsolutePath());
                    }
                    catch (Exception exception) {
                        ((BaseDialog)MethodAddImageDialog.this).logger.logError((Throwable)exception);
                    }
                }
            }
        });
        Label label = new Label(composite2, 0);
        label.setText(AuthoringUIResources.heightLabel_text);
        this.heightText = new Text(composite2, 2048);
        this.heightText.setLayoutData((Object)new GridData());
        this.heightText.setText("200");
        this.heightText.addModifyListener(this.modifyListener);
        Label label2 = new Label(composite2, 64);
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 2;
        gridData.horizontalIndent = 10;
        label2.setLayoutData((Object)gridData);
        label2.setText(AuthoringUIResources.imageSizeLabel_text);
        gridData = new Label(composite2, 0);
        gridData.setText(AuthoringUIResources.widthLabel_text);
        this.widthText = new Text(composite2, 2048);
        this.widthText.setLayoutData((Object)new GridData());
        this.widthText.setText("200");
        this.widthText.addModifyListener(this.modifyListener);
        Label label3 = new Label(composite2, 0);
        label3.setText(AuthoringUIResources.altTagLabel_text);
        this.altTagText = new Text(composite2, 2048);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 3;
        this.altTagText.setLayoutData((Object)gridData2);
        this.altTagText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                MethodAddImageDialog.this.altTag = MethodAddImageDialog.this.altTagText.getText().trim();
            }
        });
        return composite2;
    }

    public File getFileToCopy() {
        return this.fileToCopy;
    }

    private void setImageInfo(String string) {
        File file = new File(string);
        if (file.exists()) {
            ImageData imageData = new ImageData(string);
            this.heightText.setText(String.valueOf(imageData.height));
            this.widthText.setText(String.valueOf(imageData.width));
        } else {
            this.heightText.setText(String.valueOf(200));
            this.widthText.setText(String.valueOf(200));
        }
    }

    public int getHeight() {
        return Math.min(600, Math.max(10, this.height));
    }

    public int getWidth() {
        return Math.min(600, Math.max(10, this.width));
    }

    public String getAltTag() {
        return this.altTag;
    }

    protected void okPressed() {
        super.okPressed();
    }
}

