/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.SectionsOrderDialog;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.forms.BaseFormPage;
import org.eclipse.epf.authoring.ui.providers.VariabilityElementLabelProvider;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.authoring.ui.util.EditorsContextHelper;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.AddToSectionListCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.MoveInSectionListCommand;
import org.eclipse.epf.library.edit.command.RemoveFromSectionList;
import org.eclipse.epf.library.edit.util.SectionList;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ChecklistItemsPage
extends BaseFormPage {
    private static final String FORM_PAGE_ID = "checklistCheckItemsPage";
    private Text ctrl_name;
    private Button ctrl_add;
    private Button ctrl_delete;
    private Button ctrl_up;
    private Button ctrl_down;
    private Button ctrl_order;
    private Table ctrl_checkItems;
    private TableViewer checkItemsTableViewer;
    private SectionList allcheckItems;
    private IMethodRichText activeControl;
    private boolean descExpandFlag = false;
    private IMethodRichTextEditor ctrl_expanded;
    private ImageHyperlink expandLink;
    private Label expandLabel;
    protected org.eclipse.ui.forms.widgets.Section formSection;
    private org.eclipse.ui.forms.widgets.Section generalSection;
    protected Composite sectionComposite;
    private Composite generalComposite;
    private Composite expandedComposite;
    private IMethodRichText ctrl_maindesc;
    private IStructuredContentProvider checkItemsViewerContentProvider;
    private ILabelProvider checkItemsViewerLabelProvider;
    private Checklist checklist;
    private Section currentItem;
    private ILibraryChangeListener libListener = null;
    private MethodElementEditor.ModifyListener contentModifyListener;
    private IActionManager actionMgr;

    public ChecklistItemsPage(FormEditor formEditor) {
        super(formEditor, FORM_PAGE_ID, AuthoringUIText.CHECK_ITEMS_TEXT);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        super.init(iEditorSite, iEditorInput);
        MethodElementEditorInput methodElementEditorInput = (MethodElementEditorInput)iEditorInput;
        this.checklist = (Checklist)methodElementEditorInput.getMethodElement();
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        super.createFormContent(iManagedForm);
        String string = LibraryUIText.getUIText((MethodElement)this.methodElement);
        this.form.setText(String.valueOf(LibraryUIText.TEXT_GUIDANCE) + " (" + string + "): " + this.methodElement.getName());
        this.formSection = this.toolkit.createSection(this.form.getBody(), 4096);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.formSection.setLayoutData((Object)tableWrapData);
        this.formSection.setLayout((Layout)new TableWrapLayout());
        this.sectionComposite = this.toolkit.createComposite((Composite)this.formSection, 0);
        this.sectionComposite.setLayoutData((Object)new TableWrapData(256));
        this.sectionComposite.setLayout((Layout)new TableWrapLayout());
        this.formSection.setClient((Control)this.sectionComposite);
        this.generalSection = this.toolkit.createSection(this.sectionComposite, 450);
        this.generalSection.setLayoutData((Object)new TableWrapData(256));
        this.generalSection.setText(AuthoringUIText.CHECK_ITEMS_SECTION_NAME);
        this.generalSection.setDescription(AuthoringUIText.CHECK_ITEMS_SECTION_DESC);
        this.generalSection.setLayout((Layout)new GridLayout());
        this.generalComposite = this.toolkit.createComposite((Composite)this.generalSection);
        this.generalComposite.setLayoutData((Object)new GridData(768));
        this.generalComposite.setLayout((Layout)new GridLayout(4, false));
        this.generalSection.setClient((Control)this.generalComposite);
        EditorsContextHelper.setHelp((Control)this.generalComposite.getParent(), this.checklist);
        tableWrapData = this.toolkit.createComposite(this.generalComposite);
        GridData gridData = new GridData(1808);
        gridData.verticalSpan = 1;
        gridData.horizontalSpan = 3;
        tableWrapData.setLayoutData((Object)gridData);
        tableWrapData.setLayout((Layout)new GridLayout());
        gridData = this.toolkit.createLabel((Composite)tableWrapData, AuthoringUIText.CHECK_ITEMS_TEXT);
        GridData gridData2 = new GridData(1);
        gridData2.horizontalSpan = 3;
        gridData.setLayoutData((Object)gridData2);
        this.ctrl_checkItems = this.toolkit.createTable((Composite)tableWrapData, 2);
        gridData2 = new GridData(1808);
        gridData2.horizontalSpan = 3;
        gridData2.heightHint = 150;
        this.ctrl_checkItems.setLayoutData((Object)gridData2);
        this.initProviders();
        this.checkItemsTableViewer = new TableViewer(this.ctrl_checkItems);
        this.checkItemsTableViewer.setContentProvider((IContentProvider)this.checkItemsViewerContentProvider);
        this.checkItemsTableViewer.setLabelProvider((IBaseLabelProvider)this.checkItemsViewerLabelProvider);
        gridData2 = this.toolkit.createComposite(this.generalComposite);
        gridData2.setLayoutData((Object)new GridData(68));
        gridData2.setLayout((Layout)new GridLayout());
        this.ctrl_add = this.toolkit.createButton((Composite)gridData2, AuthoringUIText.ADD_BUTTON_TEXT, 0);
        this.ctrl_add.setLayoutData((Object)new GridData(768));
        this.ctrl_delete = this.toolkit.createButton((Composite)gridData2, AuthoringUIText.DELETE_BUTTON_TEXT, 0);
        this.ctrl_delete.setLayoutData((Object)new GridData(768));
        this.ctrl_delete.setEnabled(false);
        this.ctrl_up = this.toolkit.createButton((Composite)gridData2, AuthoringUIText.UP_BUTTON_TEXT, 0);
        this.ctrl_up.setLayoutData((Object)new GridData(768));
        this.ctrl_up.setEnabled(false);
        this.ctrl_down = this.toolkit.createButton((Composite)gridData2, AuthoringUIText.DOWN_BUTTON_TEXT, 0);
        this.ctrl_down.setLayoutData((Object)new GridData(768));
        this.ctrl_down.setEnabled(false);
        this.ctrl_order = this.toolkit.createButton((Composite)gridData2, AuthoringUIText.ORDER_BUTTON_TEXT, 0);
        this.ctrl_order.setLayoutData((Object)new GridData(768));
        Label label = this.toolkit.createLabel(this.generalComposite, AuthoringUIText.NAME_TEXT);
        GridData gridData3 = new GridData(1);
        gridData3.horizontalSpan = 4;
        label.setLayoutData((Object)gridData3);
        this.ctrl_name = this.toolkit.createText(this.generalComposite, "", 4);
        gridData3 = new GridData(768);
        gridData3.horizontalSpan = 4;
        this.ctrl_name.setLayoutData((Object)gridData3);
        ChecklistItemsPage.createBlankLabel(this.toolkit, this.generalComposite, 4);
        this.ctrl_maindesc = this.createRichTextEditWithLink(this.toolkit, this.generalComposite, AuthoringUIText.DESCRIPTION_TEXT, 250, 300, 4);
        this.createRichTextEditorSection();
        this.toolkit.paintBordersFor((Composite)tableWrapData);
        this.toolkit.paintBordersFor((Composite)gridData2);
        this.toolkit.paintBordersFor(this.generalComposite);
        this.toolkit.paintBordersFor(this.expandedComposite);
        this.actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        this.addListeners();
        this.loadData();
        this.enableControls();
    }

    public void addListeners() {
        final MethodElementEditor methodElementEditor = (MethodElementEditor)this.getEditor();
        this.contentModifyListener = methodElementEditor.createModifyListener((EObject)this.currentItem);
        this.ctrl_name.addModifyListener((ModifyListener)this.contentModifyListener);
        this.contentModifyListener.setDisable(true);
        this.form.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                ChecklistItemsPage.this.loadData();
                if (TngUtil.isLocked((EObject)ChecklistItemsPage.this.contentElement)) {
                    ChecklistItemsPage.this.enableControls(false);
                } else {
                    ChecklistItemsPage.this.ctrl_add.setEnabled(true);
                    ChecklistItemsPage.this.checkSelection();
                }
            }
        });
        this.form.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                ChecklistItemsPage.this.deactivate();
            }
        });
        this.form.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent controlEvent) {
                if (ChecklistItemsPage.this.ctrl_expanded != null) {
                    ((GridData)((ChecklistItemsPage)ChecklistItemsPage.this).ctrl_expanded.getLayoutData()).heightHint = ChecklistItemsPage.this.getRichTextEditorHeight();
                    ((GridData)((ChecklistItemsPage)ChecklistItemsPage.this).ctrl_expanded.getLayoutData()).widthHint = ChecklistItemsPage.this.getRichTextEditorWidth();
                }
                ChecklistItemsPage.this.formSection.layout(true, true);
            }

            public void controlMoved(ControlEvent controlEvent) {
            }
        });
        this.ctrl_name.addModifyListener((ModifyListener)this.contentModifyListener);
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (ChecklistItemsPage.this.currentItem != null) {
                    String string = ChecklistItemsPage.this.currentItem.getName();
                    String string2 = ChecklistItemsPage.this.ctrl_name.getText();
                    if (ChecklistItemsPage.this.ctrl_name.getText() == null || ChecklistItemsPage.this.ctrl_name.getText().length() == 0) {
                        String string3 = AuthoringUIResources.bind((String)AuthoringUIResources.renameDialog_title, (Object)LibraryUIText.TEXT_CHECK_ITEM);
                        String string4 = AuthoringUIResources.bind((String)AuthoringUIResources.emptyElementNameError_msg, (Object)StrUtil.toLower((String)LibraryUIText.TEXT_CHECK_ITEM));
                        if (string != null && string.length() > 0) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string3, string4);
                        } else {
                            ChecklistItemsPage.this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"), string4);
                        }
                    } else if (!string.equals(string2)) {
                        methodElementEditor.getActionManager().doAction(1, (EObject)ChecklistItemsPage.this.currentItem, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)string2, -1);
                    }
                }
            }
        });
        this.ctrl_maindesc.addModifyListener(this.contentModifyListener);
        this.ctrl_maindesc.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                ChecklistItemsPage.this.saveMainDescription();
            }
        });
        this.checkItemsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ChecklistItemsPage.this.checkSelection();
            }
        });
        this.ctrl_add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Section section = UmaFactory.eINSTANCE.createSection();
                String string = MessageFormat.format(AuthoringUIText.NEW_ELEMENT_TEXT, LibraryUIText.TEXT_CHECK_ITEM);
                section.setName(string);
                AddToSectionListCommand addToSectionListCommand = new AddToSectionListCommand((ContentElement)ChecklistItemsPage.this.checklist, section, ChecklistItemsPage.this.allcheckItems);
                ChecklistItemsPage.this.getActionManager().execute((IResourceAwareCommand)addToSectionListCommand);
                ChecklistItemsPage.this.checkItemsTableViewer.refresh();
                ChecklistItemsPage.this.checkItemsTableViewer.setSelection((ISelection)new StructuredSelection((Object)section));
                ChecklistItemsPage.this.ctrl_name.setFocus();
                ChecklistItemsPage.this.ctrl_name.setSelection(0, string.length());
                ChecklistItemsPage.this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage("");
            }
        });
        this.ctrl_delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChecklistItemsPage.this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage("");
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ChecklistItemsPage.this.checkItemsTableViewer.getSelection();
                for (Object e : iStructuredSelection.toList()) {
                    if (!(e instanceof Section)) continue;
                    RemoveFromSectionList removeFromSectionList = new RemoveFromSectionList((ContentElement)ChecklistItemsPage.this.checklist, (Section)e, ChecklistItemsPage.this.allcheckItems);
                    ChecklistItemsPage.this.getActionManager().execute((IResourceAwareCommand)removeFromSectionList);
                }
                ChecklistItemsPage.this.checkItemsTableViewer.refresh();
                ChecklistItemsPage.this.editItem(null);
            }
        });
        this.ctrl_up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ChecklistItemsPage.this.checkItemsTableViewer.getSelection();
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(iStructuredSelection.toList());
                MoveInSectionListCommand moveInSectionListCommand = new MoveInSectionListCommand((ContentElement)ChecklistItemsPage.this.checklist, arrayList, ChecklistItemsPage.this.allcheckItems, 1);
                ChecklistItemsPage.this.getActionManager().execute((IResourceAwareCommand)moveInSectionListCommand);
                ChecklistItemsPage.this.checkItemsTableViewer.refresh();
                if (ChecklistItemsPage.this.checkItemsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)ChecklistItemsPage.this.checklist)) {
                    ChecklistItemsPage.this.ctrl_up.setEnabled(true);
                } else {
                    ChecklistItemsPage.this.ctrl_up.setEnabled(false);
                }
                if (ChecklistItemsPage.this.checkItemsTableViewer.getTable().getSelectionIndex() < ChecklistItemsPage.this.checkItemsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)ChecklistItemsPage.this.checklist)) {
                    ChecklistItemsPage.this.ctrl_down.setEnabled(true);
                } else {
                    ChecklistItemsPage.this.ctrl_down.setEnabled(false);
                }
            }
        });
        this.ctrl_down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ChecklistItemsPage.this.checkItemsTableViewer.getSelection();
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(iStructuredSelection.toList());
                MoveInSectionListCommand moveInSectionListCommand = new MoveInSectionListCommand((ContentElement)ChecklistItemsPage.this.checklist, arrayList, ChecklistItemsPage.this.allcheckItems, 0);
                ChecklistItemsPage.this.getActionManager().execute((IResourceAwareCommand)moveInSectionListCommand);
                ChecklistItemsPage.this.checkItemsTableViewer.refresh();
                if (ChecklistItemsPage.this.checkItemsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)ChecklistItemsPage.this.checklist)) {
                    ChecklistItemsPage.this.ctrl_up.setEnabled(true);
                } else {
                    ChecklistItemsPage.this.ctrl_up.setEnabled(false);
                }
                if (ChecklistItemsPage.this.checkItemsTableViewer.getTable().getSelectionIndex() < ChecklistItemsPage.this.checkItemsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)ChecklistItemsPage.this.checklist)) {
                    ChecklistItemsPage.this.ctrl_down.setEnabled(true);
                } else {
                    ChecklistItemsPage.this.ctrl_down.setEnabled(false);
                }
            }
        });
        this.ctrl_order.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SectionsOrderDialog sectionsOrderDialog = new SectionsOrderDialog(Display.getCurrent().getActiveShell(), (ContentElement)ChecklistItemsPage.this.checklist, ChecklistItemsPage.this.getActionManager(), AuthoringUIResources.ChecklistOrder_title, AuthoringUIResources.ChecklistOrder_description, AuthoringUIResources.ChecklistOrder_checklistitems_text);
                sectionsOrderDialog.open();
            }
        });
    }

    protected void enableControls(boolean bl) {
        this.ctrl_name.setEditable(bl);
        this.ctrl_maindesc.setEditable(bl);
        this.ctrl_add.setEnabled(bl);
        this.ctrl_delete.setEnabled(bl);
        this.ctrl_up.setEnabled(bl);
        this.ctrl_down.setEnabled(bl);
        this.ctrl_order.setEnabled(true);
        if (this.ctrl_expanded != null) {
            this.ctrl_expanded.setEditable(bl);
        }
    }

    protected void deactivate() {
        if (this.allcheckItems != null) {
            this.allcheckItems.apply();
        }
    }

    private void loadData() {
        this.allcheckItems = null;
        this.checkItemsTableViewer.setInput((Object)this.checklist);
        this.checkItemsTableViewer.refresh();
        this.editItem(this.currentItem);
    }

    private void editItem(Section section) {
        this.contentModifyListener.setDisable(true);
        if (this.ctrl_maindesc.getModified()) {
            this.saveMainDescription();
        }
        this.currentItem = section;
        String string = "";
        String string2 = "";
        if (this.currentItem != null) {
            string = this.currentItem.getName();
            string2 = this.currentItem.getSectionDescription();
            this.ctrl_name.setFocus();
            this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage("");
        }
        this.ctrl_name.setText(string == null ? "" : string);
        this.ctrl_maindesc.setText(string2 == null ? "" : string2);
        this.ctrl_maindesc.setModalObject((EObject)this.currentItem);
        this.ctrl_maindesc.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getSection_SectionDescription());
        if (section == null) {
            this.ctrl_maindesc.getFindReplaceAction().dispose();
        }
        this.contentModifyListener.setElement((EObject)this.currentItem);
        this.contentModifyListener.setDisable(this.currentItem == null);
        this.enableControls();
    }

    private void enableControls() {
        if (this.checklist.getPresentation().getSections().contains(this.currentItem)) {
            if (!TngUtil.isLocked((EObject)this.contentElement)) {
                this.ctrl_name.setEditable(true);
                this.ctrl_maindesc.setEditable(true);
            }
        } else {
            this.ctrl_name.setEditable(false);
            this.ctrl_maindesc.setEditable(false);
        }
    }

    public void dispose() {
        if (this.libListener != null) {
            ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
            if (iLibraryManager != null) {
                iLibraryManager.removeListener(this.libListener);
            }
            this.libListener = null;
        }
    }

    private void createRichTextEditorSection() {
        this.expandedComposite = this.toolkit.createComposite((Composite)this.formSection, 0);
        this.expandedComposite.setLayoutData((Object)new TableWrapData(256));
        this.expandedComposite.setLayout((Layout)new GridLayout(2, false));
        this.expandedComposite.setVisible(false);
        this.expandLink = this.toolkit.createImageHyperlink(this.expandedComposite, 0);
        this.expandLink.setImage(AuthoringUIImages.IMG_EXPANDED);
        this.expandLink.setToolTipText(AuthoringUIResources.closeRTE);
        this.expandLink.setUnderlined(false);
        this.expandLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                ChecklistItemsPage.this.toggle(hyperlinkEvent);
            }
        });
        this.expandLabel = ChecklistItemsPage.createDecoratedLabel(this.toolkit, this.expandedComposite, "");
    }

    protected void toggle(HyperlinkEvent hyperlinkEvent) {
        if (this.currentItem == null) {
            return;
        }
        if (this.ctrl_expanded == null) {
            this.ctrl_expanded = this.createRichTextEditor(this.toolkit, this.expandedComposite, 578, 1808, this.getRichTextEditorHeight(), this.getRichTextEditorWidth(), 2, this.expandLabel);
            this.ctrl_expanded.addModifyListener(this.contentModifyListener);
        }
        if (this.descExpandFlag) {
            this.sectionComposite.setVisible(true);
            this.expandedComposite.setVisible(false);
            this.formSection.setClient((Control)this.sectionComposite);
            IMethodRichText iMethodRichText = this.getActiveRichTextControl();
            iMethodRichText.setText(this.ctrl_expanded.getText());
            Iterator iterator = iMethodRichText.getListeners();
            while (iterator.hasNext()) {
                RichTextListener richTextListener = (RichTextListener)iterator.next();
                this.ctrl_expanded.removeListener(richTextListener.getEventType(), richTextListener.getListener());
            }
            if (this.ctrl_expanded.getModified()) {
                ((MethodElementEditor)this.getEditor()).saveModifiedRichText(this.ctrl_expanded);
            }
            iMethodRichText.setFocus();
        } else {
            this.sectionComposite.setVisible(false);
            this.expandedComposite.setVisible(true);
            this.formSection.setClient((Control)this.expandedComposite);
            this.expandLabel.setText(String.valueOf(this.currentItem.getName()) + " - " + (String)((ImageHyperlink)hyperlinkEvent.getSource()).getData("Title"));
            IMethodRichText iMethodRichText = (IMethodRichText)hyperlinkEvent.getHref();
            this.ctrl_expanded.setInitialText(iMethodRichText.getText());
            this.ctrl_expanded.setModalObject(iMethodRichText.getModalObject());
            this.ctrl_expanded.setModalObjectFeature(iMethodRichText.getModalObjectFeature());
            this.ctrl_expanded.setFindReplaceAction(iMethodRichText.getFindReplaceAction());
            Iterator iterator = iMethodRichText.getListeners();
            while (iterator.hasNext()) {
                RichTextListener richTextListener = (RichTextListener)iterator.next();
                this.ctrl_expanded.addListener(richTextListener.getEventType(), richTextListener.getListener());
            }
            boolean bl = !TngUtil.isLocked((EObject)this.contentElement);
            this.ctrl_expanded.setEditable(bl);
            if (bl) {
                this.ctrl_expanded.setFocus();
            }
            this.setActiveRichTextControl(iMethodRichText);
        }
        this.form.getBody().layout(true, true);
        this.descExpandFlag = !this.descExpandFlag;
    }

    private void setActiveRichTextControl(IMethodRichText iMethodRichText) {
        this.activeControl = iMethodRichText;
    }

    private IMethodRichText getActiveRichTextControl() {
        return this.activeControl;
    }

    private void initProviders() {
        this.checkItemsViewerContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (object != ChecklistItemsPage.this.checklist) {
                    return super.getElements(object);
                }
                if (ChecklistItemsPage.this.allcheckItems == null) {
                    ChecklistItemsPage.this.allcheckItems = new SectionList((ContentElement)ChecklistItemsPage.this.checklist, 1);
                }
                return ChecklistItemsPage.this.allcheckItems.toArray();
            }
        };
        this.checkItemsViewerLabelProvider = new VariabilityElementLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public boolean isExternal(Object object) {
                return !ChecklistItemsPage.this.checklist.getPresentation().getSections().contains(object);
            }
        };
    }

    private void saveMainDescription() {
        if (this.currentItem != null) {
            IMethodRichText iMethodRichText;
            IMethodRichText iMethodRichText2 = iMethodRichText = this.descExpandFlag ? this.ctrl_expanded : this.ctrl_maindesc;
            if (!iMethodRichText.getModified()) {
                return;
            }
            String string = this.currentItem.getSectionDescription();
            if (((MethodElementEditor)this.getEditor()).mustRestoreValue(iMethodRichText, string)) {
                return;
            }
            String string2 = iMethodRichText.getText();
            if (!string2.equals(string)) {
                this.actionMgr.doAction(1, (EObject)this.currentItem, (EStructuralFeature)UmaPackage.eINSTANCE.getSection_SectionDescription(), (Object)string2, -1);
            }
        }
    }

    protected IActionManager getActionManager() {
        FormEditor formEditor = this.getEditor();
        if (formEditor instanceof MethodElementEditor) {
            return ((MethodElementEditor)formEditor).getActionManager();
        }
        return null;
    }

    private void checkSelection() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.checkItemsTableViewer.getSelection();
        if (iStructuredSelection.size() > 0 && !TngUtil.isLocked((EObject)this.checklist)) {
            this.ctrl_delete.setEnabled(true);
            if (this.checkItemsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)this.checklist) && iStructuredSelection.size() == 1) {
                this.ctrl_up.setEnabled(true);
            } else {
                this.ctrl_up.setEnabled(false);
            }
            if (this.checkItemsTableViewer.getTable().getSelectionIndex() < this.checkItemsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)this.checklist) && iStructuredSelection.size() == 1) {
                this.ctrl_down.setEnabled(true);
            } else {
                this.ctrl_down.setEnabled(false);
            }
        }
        if (iStructuredSelection.size() == 1) {
            this.editItem((Section)iStructuredSelection.getFirstElement());
        }
    }
}

