/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.WorkProductFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class WorkProductDeliverablePartsPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "workProductDeliverablePartsPage";
    private WorkProduct workProduct;
    private IActionManager actionMgr;

    public WorkProductDeliverablePartsPage(FormEditor formEditor) {
        super(formEditor, FORM_PAGE_ID, AuthoringUIText.DELIVERABLE_PARTS_PAGE_TITLE);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        super.init(iEditorSite, iEditorInput);
        this.workProduct = (WorkProduct)this.contentElement;
        this.actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        this.setUseCategory2(false);
        this.setUseCategory3(false);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                Deliverable deliverable = (Deliverable)WorkProductDeliverablePartsPage.this.workProduct;
                return deliverable.getDeliveredWorkProducts().toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (WorkProduct workProduct : arrayList) {
                this.actionMgr.doAction(3, (EObject)this.workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts(), (Object)workProduct, -1);
            }
        }
    }

    protected void removeItemsFromModel1(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (WorkProduct workProduct : arrayList) {
                this.actionMgr.doAction(4, (EObject)this.workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts(), (Object)workProduct, -1);
            }
        }
    }

    protected Object getContentElement() {
        return this.workProduct;
    }

    protected String getTabString() {
        return FilterConstants.WORKPRODUCTS;
    }

    protected IFilter getFilter() {
        this.filter = new WorkProductFilter(){
            List badlist = new ArrayList();

            protected boolean childAccept(Object object) {
                if (object instanceof WorkProduct) {
                    if (object instanceof Deliverable && WorkProductDeliverablePartsPage.this.workProduct instanceof Deliverable) {
                        if (!UIHelper.checkCircularDeliverables((Deliverable)object, (Deliverable)WorkProductDeliverablePartsPage.this.workProduct)) {
                            this.badlist.add(object);
                            return false;
                        }
                        if (!WorkProductDeliverablePartsPage.this.checkVariability((Deliverable)object, this.badlist)) {
                            this.badlist.add(object);
                            return false;
                        }
                        ArrayList arrayList = new ArrayList();
                        for (Object e : this.badlist) {
                            UIHelper.deliverablePartsChain((Deliverable)e, arrayList);
                        }
                        if (arrayList.contains(object)) {
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        return this.filter;
    }

    public boolean checkVariability(Deliverable deliverable, List list) {
        VariabilityElement variabilityElement;
        Object object;
        Object object2;
        if (this.workProduct.getVariabilityBasedOnElement() != null && !UIHelper.checkCircularDeliverables(deliverable, (Deliverable)(object2 = this.workProduct.getVariabilityBasedOnElement()))) {
            return false;
        }
        object2 = TngUtil.getGeneralizers((VariabilityElement)this.workProduct);
        while (object2.hasNext()) {
            object = (VariabilityElement)object2.next();
            if (object == null) continue;
            list.add(object);
            if (object.equals(deliverable)) {
                return false;
            }
            if (UIHelper.checkCircularDeliverables(deliverable, (Deliverable)object)) continue;
            return false;
        }
        if (deliverable.getVariabilityBasedOnElement() != null && !UIHelper.checkCircularDeliverables((Deliverable)(object = deliverable.getVariabilityBasedOnElement()), (Deliverable)this.workProduct)) {
            return false;
        }
        object = TngUtil.getGeneralizers((VariabilityElement)deliverable);
        while (object.hasNext()) {
            variabilityElement = (VariabilityElement)object.next();
            if (variabilityElement == null) continue;
            if (variabilityElement.equals(deliverable)) {
                return false;
            }
            if (UIHelper.checkCircularDeliverables((Deliverable)variabilityElement, (Deliverable)this.workProduct)) continue;
            return false;
        }
        variabilityElement = new ArrayList();
        this.deliverablePartsVariability((Deliverable)this.workProduct, (List)variabilityElement);
        if (variabilityElement.contains(deliverable)) {
            return false;
        }
        this.deliverablePartsVariability(deliverable, (List)variabilityElement);
        return !variabilityElement.contains(this.workProduct);
    }

    private void deliverablePartsVariability(Deliverable deliverable, List list) {
        List list2 = deliverable.getDeliveredWorkProducts();
        if (list2 != null && list2.size() > 0) {
            for (Object object : list2) {
                if (!(object instanceof Deliverable)) continue;
                if (((Deliverable)object).getVariabilityBasedOnElement() != null) {
                    list.add(((Deliverable)object).getVariabilityBasedOnElement());
                } else {
                    Iterator iterator = TngUtil.getGeneralizers((VariabilityElement)deliverable);
                    while (iterator.hasNext()) {
                        VariabilityElement variabilityElement = (VariabilityElement)iterator.next();
                        UIHelper.deliverablePartsChain((Deliverable)variabilityElement, list);
                    }
                }
                this.deliverablePartsVariability((Deliverable)object, list);
            }
        }
        if (deliverable instanceof Deliverable) {
            Iterator iterator = TngUtil.getGeneralizers((VariabilityElement)deliverable);
            while (iterator.hasNext()) {
                Object object;
                object = (VariabilityElement)iterator.next();
                UIHelper.deliverablePartsChain((Deliverable)object, list);
            }
        }
    }

    protected String getMultipleSelectDescription(int n) {
        return super.getMultipleSelectDescription(n, AuthoringUIResources.workProductDeliverablePartsPage_multipleSelectDescription);
    }

    protected String getSectionDescription() {
        return AuthoringUIResources.workProductDeliverablePartsPage_sectionDescription;
    }

    protected String getSectionName() {
        return AuthoringUIResources.workProductDeliverablePartsPage_sectionName;
    }

    protected String getSelectedLabel() {
        return AuthoringUIResources.workProductDeliverablePartsPage_selectedLabel;
    }
}

