/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.filters.WorkProductFilter;
import org.eclipse.epf.authoring.ui.forms.DescriptionFormPage;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.VariabilityBaseElementFilter;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.ArtifactDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.DeliverableDescription;
import org.eclipse.epf.uma.Outcome;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescription;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class WorkProductDescriptionPage
extends DescriptionFormPage {
    private static final String FORM_PAGE_ID = "workProductDescriptionPage";
    private IMethodRichText ctrl_impact;
    private IMethodRichText ctrl_reason;
    private IMethodRichText ctrl_brief_outline;
    private IMethodRichText ctrl_representation_options;
    private IMethodRichText ctrl_external_desc;
    private IMethodRichText ctrl_packaging_guidance;
    private IMethodRichText ctrl_representation;
    private IMethodRichText ctrl_notation;
    private WorkProduct workProduct;

    public WorkProductDescriptionPage(FormEditor formEditor) {
        super(formEditor, FORM_PAGE_ID, AuthoringUIText.DESCRIPTION_PAGE_TITLE);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        super.init(iEditorSite, iEditorInput);
        this.workProduct = (WorkProduct)this.contentElement;
        this.purposeOn = true;
        this.externalIdOn = true;
        if (!(this.contentElement instanceof Outcome)) {
            this.notationSectionOn = true;
        }
        this.tailoringSectionOn = true;
        this.iconSectionOn = true;
    }

    protected void createNotationSectionContent() {
        super.createNotationSectionContent();
        if (this.workProduct instanceof Artifact) {
            this.ctrl_brief_outline = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.BRIEF_OUTLINE_TEXT, 40, 400, 4);
            this.ctrl_representation = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.REPRESENTATION_TEXT, 40, 400, 4);
            this.ctrl_notation = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.NOTATION_TEXT, 40, 400, 4);
        } else if (this.workProduct instanceof Deliverable) {
            this.ctrl_external_desc = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.EXTERNAL_DESCRIPTION_TEXT, 40, 400, 4);
            this.ctrl_packaging_guidance = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.PACKAGING_GUIDANCE_TEXT, 40, 400, 4);
        }
    }

    protected void createTailoringSectionContent() {
        super.createTailoringSectionContent();
        this.ctrl_impact = this.createRichTextEditWithLinkForSection(this.toolkit, this.tailoringComposite, AuthoringUIText.IMPACT_OF_NOT_HAVING_TEXT, 40, 400, 5);
        this.ctrl_reason = this.createRichTextEditWithLinkForSection(this.toolkit, this.tailoringComposite, AuthoringUIText.REASON_FOR_NOT_NEEDING_TEXT, 40, 400, 5);
        if (this.workProduct instanceof Artifact) {
            this.ctrl_representation_options = this.createRichTextEditWithLinkForSection(this.toolkit, this.tailoringComposite, AuthoringUIText.REPRESENTATION_OPTIONS_TEXT, 40, 400, 4);
        }
    }

    protected void addListeners() {
        final IActionManager iActionManager = ((MethodElementEditor)this.getEditor()).getActionManager();
        super.addListeners();
        this.ctrl_purpose.setModalObject((EObject)this.contentElement.getPresentation());
        this.ctrl_purpose.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_Purpose());
        this.ctrl_purpose.addModifyListener(this.contentModifyListener);
        this.ctrl_purpose.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                boolean bl;
                IMethodRichText iMethodRichText;
                IMethodRichText iMethodRichText2 = iMethodRichText = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_purpose;
                if (!iMethodRichText.getModified()) {
                    return;
                }
                String string = ((WorkProductDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getPurpose();
                if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(iMethodRichText, string)) {
                    return;
                }
                String string2 = iMethodRichText.getText();
                if (!string2.equals(string) && (bl = iActionManager.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_Purpose(), (Object)string2, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                    WorkProductDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_external_id.addModifyListener(this.contentModifyListener);
        this.ctrl_external_id.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_ExternalId());
            }

            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                String string = ((WorkProductDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getExternalId();
                if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(WorkProductDescriptionPage.this.ctrl_external_id, string)) {
                    return;
                }
                String string2 = WorkProductDescriptionPage.this.ctrl_external_id.getText();
                if (!string2.equals(string) && (bl = iActionManager.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_ExternalId(), (Object)string2, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                    WorkProductDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_impact.setModalObject((EObject)this.contentElement.getPresentation());
        this.ctrl_impact.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_ImpactOfNotHaving());
        this.ctrl_impact.addModifyListener(this.contentModifyListener);
        this.ctrl_impact.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                boolean bl;
                IMethodRichText iMethodRichText;
                IMethodRichText iMethodRichText2 = iMethodRichText = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_impact;
                if (!iMethodRichText.getModified()) {
                    return;
                }
                String string = ((WorkProductDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getImpactOfNotHaving();
                if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(iMethodRichText, string)) {
                    return;
                }
                String string2 = iMethodRichText.getText();
                if (!string2.equals(string) && (bl = iActionManager.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_ImpactOfNotHaving(), (Object)string2, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                    WorkProductDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_reason.setModalObject((EObject)this.contentElement.getPresentation());
        this.ctrl_reason.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_ReasonsForNotNeeding());
        this.ctrl_reason.addModifyListener(this.contentModifyListener);
        this.ctrl_reason.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                boolean bl;
                IMethodRichText iMethodRichText;
                IMethodRichText iMethodRichText2 = iMethodRichText = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_reason;
                if (!iMethodRichText.getModified()) {
                    return;
                }
                String string = ((WorkProductDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getReasonsForNotNeeding();
                if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(iMethodRichText, string)) {
                    return;
                }
                String string2 = iMethodRichText.getText();
                if (!string2.equals(string) && (bl = iActionManager.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_ReasonsForNotNeeding(), (Object)string2, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                    WorkProductDescriptionPage.this.updateChangeDate();
                }
            }
        });
        if (this.workProduct instanceof Artifact) {
            this.ctrl_brief_outline.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_brief_outline.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_BriefOutline());
            this.ctrl_brief_outline.addModifyListener(this.contentModifyListener);
            this.ctrl_brief_outline.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    boolean bl;
                    String string;
                    IMethodRichText iMethodRichText;
                    IMethodRichText iMethodRichText2 = iMethodRichText = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_brief_outline;
                    if (!iMethodRichText.getModified()) {
                        return;
                    }
                    String string2 = ((ArtifactDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getBriefOutline();
                    if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(iMethodRichText, string2)) {
                        return;
                    }
                    String string3 = string = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded.getText() : WorkProductDescriptionPage.this.ctrl_brief_outline.getText();
                    if (!string.equals(string2) && (bl = iActionManager.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_BriefOutline(), (Object)string, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                        WorkProductDescriptionPage.this.updateChangeDate();
                    }
                }
            });
            this.ctrl_representation_options.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_representation_options.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_RepresentationOptions());
            this.ctrl_representation_options.addModifyListener(this.contentModifyListener);
            this.ctrl_representation_options.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    boolean bl;
                    IMethodRichText iMethodRichText;
                    IMethodRichText iMethodRichText2 = iMethodRichText = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_representation_options;
                    if (!iMethodRichText.getModified()) {
                        return;
                    }
                    String string = ((ArtifactDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getRepresentationOptions();
                    if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(iMethodRichText, string)) {
                        return;
                    }
                    String string2 = iMethodRichText.getText();
                    if (!string2.equals(string) && (bl = iActionManager.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_RepresentationOptions(), (Object)string2, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                        WorkProductDescriptionPage.this.updateChangeDate();
                    }
                }
            });
            this.ctrl_representation.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_representation.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_Representation());
            this.ctrl_representation.addModifyListener(this.contentModifyListener);
            this.ctrl_representation.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    boolean bl;
                    String string;
                    IMethodRichText iMethodRichText;
                    IMethodRichText iMethodRichText2 = iMethodRichText = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_representation;
                    if (!iMethodRichText.getModified()) {
                        return;
                    }
                    String string2 = ((ArtifactDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getRepresentation();
                    if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(iMethodRichText, string2)) {
                        return;
                    }
                    String string3 = string = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded.getText() : WorkProductDescriptionPage.this.ctrl_representation.getText();
                    if (!string.equals(string2) && (bl = iActionManager.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_Representation(), (Object)string, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                        WorkProductDescriptionPage.this.updateChangeDate();
                    }
                }
            });
            this.ctrl_notation.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_notation.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_Notation());
            this.ctrl_notation.addModifyListener(this.contentModifyListener);
            this.ctrl_notation.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    boolean bl;
                    String string;
                    IMethodRichText iMethodRichText;
                    IMethodRichText iMethodRichText2 = iMethodRichText = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_notation;
                    if (!iMethodRichText.getModified()) {
                        return;
                    }
                    String string2 = ((ArtifactDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getNotation();
                    if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(iMethodRichText, string2)) {
                        return;
                    }
                    String string3 = string = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded.getText() : WorkProductDescriptionPage.this.ctrl_notation.getText();
                    if (!string.equals(string2) && (bl = iActionManager.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_Notation(), (Object)string, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                        WorkProductDescriptionPage.this.updateChangeDate();
                    }
                }
            });
        }
        if (this.workProduct instanceof Deliverable) {
            this.ctrl_external_desc.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_external_desc.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getDeliverableDescription_ExternalDescription());
            this.ctrl_external_desc.addModifyListener(this.contentModifyListener);
            this.ctrl_external_desc.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    boolean bl;
                    IMethodRichText iMethodRichText;
                    IMethodRichText iMethodRichText2 = iMethodRichText = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_external_desc;
                    if (!iMethodRichText.getModified()) {
                        return;
                    }
                    String string = ((DeliverableDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getExternalDescription();
                    if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(iMethodRichText, string)) {
                        return;
                    }
                    String string2 = iMethodRichText.getText();
                    if (!string2.equals(string) && (bl = iActionManager.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getDeliverableDescription_ExternalDescription(), (Object)string2, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                        WorkProductDescriptionPage.this.updateChangeDate();
                    }
                }
            });
            this.ctrl_packaging_guidance.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_packaging_guidance.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getDeliverableDescription_PackagingGuidance());
            this.ctrl_packaging_guidance.addModifyListener(this.contentModifyListener);
            this.ctrl_packaging_guidance.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    boolean bl;
                    IMethodRichText iMethodRichText;
                    IMethodRichText iMethodRichText2 = iMethodRichText = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_packaging_guidance;
                    if (!iMethodRichText.getModified()) {
                        return;
                    }
                    String string = ((DeliverableDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getPackagingGuidance();
                    if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(iMethodRichText, string)) {
                        return;
                    }
                    String string2 = iMethodRichText.getText();
                    if (!string2.equals(string) && (bl = iActionManager.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getDeliverableDescription_PackagingGuidance(), (Object)string2, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                        WorkProductDescriptionPage.this.updateChangeDate();
                    }
                }
            });
        }
    }

    protected void refresh(boolean bl) {
        super.refresh(bl);
        this.ctrl_impact.setEditable(bl);
        this.ctrl_reason.setEditable(bl);
        if (this.workProduct instanceof Artifact) {
            this.ctrl_brief_outline.setEditable(bl);
            this.ctrl_representation_options.setEditable(bl);
            this.ctrl_representation.setEditable(bl);
            this.ctrl_notation.setEditable(bl);
        }
        if (this.workProduct instanceof Deliverable) {
            this.ctrl_external_desc.setEditable(bl);
            this.ctrl_packaging_guidance.setEditable(bl);
        }
    }

    protected void loadData() {
        super.loadData();
        WorkProductDescription workProductDescription = (WorkProductDescription)this.workProduct.getPresentation();
        String string = workProductDescription.getPurpose();
        String string2 = workProductDescription.getImpactOfNotHaving();
        String string3 = workProductDescription.getReasonsForNotNeeding();
        this.ctrl_purpose.setText(string == null ? "" : string);
        this.ctrl_impact.setText(string2 == null ? "" : string2);
        this.ctrl_reason.setText(string3 == null ? "" : string3);
        if (this.externalIdOn) {
            String string4 = workProductDescription.getExternalId();
            this.ctrl_external_id.setText(string4 == null ? "" : string4);
        }
        if (this.workProduct instanceof Artifact) {
            this.ctrl_brief_outline.setText(((ArtifactDescription)workProductDescription).getBriefOutline() == null ? "" : ((ArtifactDescription)workProductDescription).getBriefOutline());
            this.ctrl_representation_options.setText(((ArtifactDescription)workProductDescription).getRepresentationOptions() == null ? "" : ((ArtifactDescription)workProductDescription).getRepresentationOptions());
            this.ctrl_representation.setText(((ArtifactDescription)workProductDescription).getRepresentation() == null ? "" : ((ArtifactDescription)workProductDescription).getRepresentation());
            this.ctrl_notation.setText(((ArtifactDescription)workProductDescription).getNotation() == null ? "" : ((ArtifactDescription)workProductDescription).getNotation());
        } else if (this.workProduct instanceof Deliverable) {
            this.ctrl_external_desc.setText(((DeliverableDescription)workProductDescription).getExternalDescription() == null ? "" : ((DeliverableDescription)workProductDescription).getExternalDescription());
            this.ctrl_packaging_guidance.setText(((DeliverableDescription)workProductDescription).getPackagingGuidance() == null ? "" : ((DeliverableDescription)workProductDescription).getPackagingGuidance());
        }
    }

    protected Object getContentElement() {
        return this.workProduct;
    }

    protected String getTabString() {
        return FilterConstants.WORKPRODUCTS;
    }

    protected IFilter getFilter() {
        this.filter = new WorkProductFilter(){
            List badlist = new ArrayList();

            protected boolean childAccept(Object object) {
                if (super.childAccept(object) && object instanceof ContentElement && object instanceof WorkProduct && ((ContentElement)this.getHelper().getContentElement()).getType().equals(((ContentElement)object).getType())) {
                    if (object instanceof Deliverable && WorkProductDescriptionPage.this.workProduct instanceof Deliverable) {
                        VariabilityElement variabilityElement;
                        if (!UIHelper.checkCircularDeliverables((Deliverable)object, (Deliverable)WorkProductDescriptionPage.this.workProduct)) {
                            this.badlist.add(object);
                            return false;
                        }
                        if (((Deliverable)object).getVariabilityBasedOnElement() != null && !UIHelper.checkCircularDeliverables((Deliverable)((Deliverable)object).getVariabilityBasedOnElement(), (Deliverable)WorkProductDescriptionPage.this.workProduct)) {
                            this.badlist.add(object);
                            return false;
                        }
                        Iterator iterator = TngUtil.getGeneralizers((VariabilityElement)((Deliverable)object));
                        while (iterator.hasNext()) {
                            variabilityElement = (VariabilityElement)iterator.next();
                            if (variabilityElement == null) continue;
                            if (variabilityElement.equals(object)) {
                                return false;
                            }
                            if (UIHelper.checkCircularDeliverables((Deliverable)variabilityElement, (Deliverable)WorkProductDescriptionPage.this.workProduct)) continue;
                            this.badlist.add(object);
                            return false;
                        }
                        variabilityElement = new ArrayList();
                        for (Object e : this.badlist) {
                            UIHelper.deliverablePartsChain((Deliverable)e, (List)variabilityElement);
                        }
                        if (variabilityElement.contains(object)) {
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        ((ContentFilter)this.filter).setAdditionalFilters(new IFilter[]{new VariabilityBaseElementFilter((VariabilityElement)this.workProduct)});
        return this.filter;
    }

    public void loadSectionDescription() {
        if (this.contentElement instanceof Artifact) {
            this.generalSectionDescription = AuthoringUIResources.artifact_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.artifact_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.artifact_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.artifact_versionInfoSection_desc;
            this.notationSectionDescription = AuthoringUIResources.artifact_notationSection_desc;
            this.tailoringSectionDescription = AuthoringUIResources.artifact_tailoringSection_desc;
            this.iconSectionDescription = AuthoringUIResources.artifact_iconSection_desc;
        }
        if (this.contentElement instanceof Outcome) {
            this.generalSectionDescription = AuthoringUIResources.outcome_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.outcome_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.outcome_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.outcome_versionInfoSection_desc;
            this.notationSectionDescription = AuthoringUIResources.outcome_notationSection_desc;
            this.tailoringSectionDescription = AuthoringUIResources.outcome_tailoringSection_desc;
            this.iconSectionDescription = AuthoringUIResources.outcome_iconSection_desc;
        }
        if (this.contentElement instanceof Deliverable) {
            this.generalSectionDescription = AuthoringUIResources.deliverable_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.deliverable_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.deliverable_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.deliverable_versionInfoSection_desc;
            this.notationSectionDescription = AuthoringUIResources.deliverable_notationSection_desc;
            this.tailoringSectionDescription = AuthoringUIResources.deliverable_tailoringSection_desc;
            this.iconSectionDescription = AuthoringUIResources.deliverable_iconSection_desc;
        }
    }
}

