/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.internal;

import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class MethodElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int ERROR = 64;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public MethodElementImageDescriptor(ImageDescriptor imageDescriptor, int n, Point point) {
        this.fBaseImage = imageDescriptor;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = n;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = point;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setAdornments(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fFlags = n;
    }

    public int getAdronments() {
        return this.fFlags;
    }

    public void setImageSize(Point point) {
        Assert.isNotNull((Object)point);
        Assert.isTrue((point.x >= 0 && point.y >= 0 ? 1 : 0) != 0);
        this.fSize = point;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (object == null || !MethodElementImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        MethodElementImageDescriptor methodElementImageDescriptor = (MethodElementImageDescriptor)((Object)object);
        return this.fBaseImage.equals(methodElementImageDescriptor.fBaseImage) && this.fFlags == methodElementImageDescriptor.fFlags && this.fSize.equals((Object)methodElementImageDescriptor.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int n, int n2) {
        ImageData imageData = this.getImageData(this.fBaseImage);
        this.drawImage(imageData, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private ImageData getImageData(ImageDescriptor imageDescriptor) {
        ImageData imageData = imageDescriptor.getImageData();
        if (imageData == null) {
            imageData = DEFAULT_IMAGE_DATA;
            AuthoringUIPlugin.getDefault().getLogger().logError("Image data not available: " + imageDescriptor.toString());
        }
        return imageData;
    }

    private void drawTopRight() {
    }

    private void drawBottomRight() {
    }

    private void drawBottomLeft() {
        Point point = this.getSize();
        int n = 0;
        if ((this.fFlags & 0x40) != 0) {
            ImageData imageData = this.getImageData(AuthoringUIImages.IMG_DESC_OVR_ERROR);
            this.drawImage(imageData, n, point.y - imageData.height);
            n += imageData.width;
        }
    }
}

