/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.preferences;

import java.io.File;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.jface.preference.IPreferenceStore;

public class LibraryLocationData {
    private String parentFolder;
    private String libName;
    private String libBriefDescription;
    private boolean isSingleLibFile;
    private boolean defLibDirChecked;
    protected static final String libraryFile = "library.xmi";
    private boolean isOkPressed;

    public boolean isOkPressed() {
        return this.isOkPressed;
    }

    public void setOkPressed(boolean bl) {
        this.isOkPressed = bl;
    }

    public boolean isSingleLibFile() {
        return this.isSingleLibFile;
    }

    public void setSingleLibFile(boolean bl) {
        this.isSingleLibFile = bl;
    }

    public String getLibName() {
        return this.libName;
    }

    public String getLibraryFile() {
        return String.valueOf(this.getParentFolder()) + File.separator + libraryFile;
    }

    public void setLibName(String string) {
        this.libName = string;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String string) {
        this.parentFolder = string;
    }

    public String getLibBriefDescription() {
        return this.libBriefDescription;
    }

    public void setLibBriefDescription(String string) {
        this.libBriefDescription = string;
    }

    public boolean isDefLibDirChecked() {
        return this.defLibDirChecked;
    }

    public void setDefLibDirChecked(boolean bl) {
        this.defLibDirChecked = bl;
    }

    public void loadFromPreferenceStore() {
        IPreferenceStore iPreferenceStore = LibraryPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("org.eclipse.epf.library.pref.last_library__parent_directory");
        this.setParentFolder(string);
        boolean bl = iPreferenceStore.getBoolean("org.eclipse.epf.library.pref.last_default_directory_checked");
        if (string == null || string.trim().length() == 0) {
            this.setDefLibDirChecked(true);
        } else {
            this.setDefLibDirChecked(bl);
        }
    }

    public void saveToPreferenceStore() {
        IPreferenceStore iPreferenceStore = LibraryPlugin.getDefault().getPreferenceStore();
        File file = new File(this.getParentFolder());
        LibraryUIPreferences.setSavedLibraryPath((String)file.getAbsolutePath());
        iPreferenceStore.setValue("org.eclipse.epf.library.pref.last_library__parent_directory", file.getParent());
        iPreferenceStore.setValue("org.eclipse.epf.library.pref.last_default_directory_checked", this.isDefLibDirChecked());
        LibraryPlugin.getDefault().savePluginPreferences();
    }
}

