/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.ProcessTaskFilter;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.properties.WorkBreakdownElementGeneralSection;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.process.command.LinkMethodElementCommand;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TaskDescriptorGeneralSection
extends WorkBreakdownElementGeneralSection {
    protected TaskDescriptor element;
    private Button synchronizedButton;
    private Text ctrl_method_element;
    private Button linkButton;
    private Button clearButton;

    protected void init() {
        super.init();
        this.element = (TaskDescriptor)this.getElement();
    }

    protected void createGeneralSection(Composite composite) {
        super.createGeneralSection(composite);
        this.checkBoxComposite = FormUI.createComposite(this.toolkit, this.generalComposite, 768, this.numOfColumns, true);
        this.synchronizedButton = FormUI.createCheckButton(this.toolkit, this.checkBoxComposite, 1);
        this.synchronizedButton.setText(PropertiesResources.BreakdownElement_Option_Synchronized);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.Process_Type_Task);
        this.ctrl_method_element = FormUI.createText(this.toolkit, this.generalComposite, -1, 1);
        this.ctrl_method_element.setText(this.getMethodElementName(this.element));
        this.ctrl_method_element.setEnabled(false);
        Composite composite2 = FormUI.createComposite(this.toolkit, this.generalComposite, 0, 2, true);
        this.linkButton = FormUI.createButton(this.toolkit, composite2, 8, 1);
        this.linkButton.setText(PropertiesResources.Process_Button_LinkMethodElement);
        this.clearButton = FormUI.createButton(this.toolkit, composite2, 8, 1);
        this.clearButton.setText(PropertiesResources.Process_Button_ClearMethodElement);
    }

    private void setMethodElement(List list) {
        if (list != null && list.size() >= 1 && list.get(0) instanceof Task) {
            Task task = (Task)list.get(0);
            boolean bl = true;
            if (bl) {
                LinkMethodElementCommand linkMethodElementCommand = new LinkMethodElementCommand((Descriptor)this.element, (Object)task, 24);
                this.actionMgr.execute((IResourceAwareCommand)linkMethodElementCommand);
                this.getEditor().setSelection(this.getSelection());
            } else {
                MessageFormat messageFormat = new MessageFormat(PropertiesResources.Process_InvalidLinkMethodElement);
                Object[] objectArray = new Object[]{task.getName()};
                AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(PropertiesResources.Process_LinkMethodElementTitle, messageFormat.format(objectArray));
            }
        }
    }

    private String getMethodElementName(TaskDescriptor taskDescriptor) {
        String string = PropertiesResources.Process_None;
        if (taskDescriptor.getTask() != null) {
            string = taskDescriptor.getTask().getName();
        }
        return string;
    }

    protected void addListeners() {
        super.addListeners();
        this.synchronizedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskDescriptorGeneralSection.this.actionMgr.doAction(1, (EObject)TaskDescriptorGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getDescriptor_IsSynchronizedWithSource(), (Object)TaskDescriptorGeneralSection.this.synchronizedButton.getSelection(), -1);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.linkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessTaskFilter processTaskFilter = new ProcessTaskFilter(TaskDescriptorGeneralSection.this.getConfiguration(), null, FilterConstants.TASKS);
                ArrayList<Task> arrayList = new ArrayList<Task>();
                if (TaskDescriptorGeneralSection.this.element.getTask() != null) {
                    arrayList.add(TaskDescriptorGeneralSection.this.element.getTask());
                }
                ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)processTaskFilter, TaskDescriptorGeneralSection.this.element, FilterConstants.TASKS, arrayList);
                itemsFilterDialog.setBlockOnOpen(true);
                itemsFilterDialog.setViewerSelectionSingle(true);
                itemsFilterDialog.setTitle(FilterConstants.TASKS);
                itemsFilterDialog.open();
                TaskDescriptorGeneralSection.this.setMethodElement(itemsFilterDialog.getSelectedItems());
                TaskDescriptorGeneralSection.this.ctrl_method_element.setText(TaskDescriptorGeneralSection.this.getMethodElementName(TaskDescriptorGeneralSection.this.element));
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskDescriptorGeneralSection.this.actionMgr.doAction(1, (EObject)TaskDescriptorGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_Task(), null, -1);
                TaskDescriptorGeneralSection.this.ctrl_method_element.setText(TaskDescriptorGeneralSection.this.getMethodElementName(TaskDescriptorGeneralSection.this.element));
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    protected void updateControls() {
        super.updateControls();
        this.synchronizedButton.setEnabled(this.editable);
        this.linkButton.setEnabled(this.editable);
        this.clearButton.setEnabled(this.editable);
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof TaskDescriptor) {
                super.refresh();
                this.element = (TaskDescriptor)this.getElement();
                this.synchronizedButton.setSelection(this.element.getIsSynchronizedWithSource().booleanValue());
                this.ctrl_method_element.setText(this.getMethodElementName(this.element));
            }
        }
        catch (Exception exception) {
            this.logger.logError("Error refreshing TaskDescriptor general section: " + this.element, (Throwable)exception);
        }
    }

    public String getNamePrefix() {
        return String.valueOf(LibraryUIText.TEXT_TASK_DESCRIPTOR) + ": ";
    }
}

