/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.configuration.closure.IConfigurationError;
import org.eclipse.epf.library.edit.navigator.ConfigurationsItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public class ConfigurationMarkerHelper {
    public static final ConfigurationMarkerHelper INSTANCE = new ConfigurationMarkerHelper();
    public static final String ATTR_ERROR_ID = "errorID";
    public static final String ATTR_CONFIG_GUID = "configGuid";
    public static final String ATTR_ERROR_ELEMENT_GUID = "elementGuid";
    public static final String ATTR_CAUSE_ELEMENT_GUID = "causeGuid";
    public static final String MARKER_ID = "org.eclipse.epf.authoring.ui.configuration";
    private static ContainerMap containersOfMarkedObjects = new ContainerMap();

    private ConfigurationMarkerHelper() {
    }

    protected String getMarkerID() {
        return MARKER_ID;
    }

    protected IFile getFile(URI uRI) {
        if (uRI.isFile()) {
            return (IFile)FileManager.getResourceForLocation((String)uRI.toFileString());
        }
        String string = uRI.scheme();
        if ("platform".equals(string) && uRI.segmentCount() > 1 && "resource".equals(uRI.segment(0))) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            int n2 = uRI.segmentCount();
            while (n < n2) {
                stringBuffer.append('/');
                stringBuffer.append(URI.decode((String)uRI.segment(n)));
                ++n;
            }
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(stringBuffer.toString()));
        }
        return null;
    }

    public static boolean isInvalid(Object object) {
        if (object instanceof ConfigurationsItemProvider) {
            Collection collection = ((ConfigurationsItemProvider)object).getChildren(object);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object2 = TngUtil.unwrap(iterator.next());
                if (containersOfMarkedObjects.containsKey(object2)) {
                    return true;
                }
                if (!(object2 instanceof MethodConfiguration) || !INSTANCE.hasMarkers((MethodConfiguration)object2)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof MethodConfiguration && INSTANCE.hasMarkers((MethodConfiguration)object)) {
            return true;
        }
        return containersOfMarkedObjects.containsKey(object);
    }

    public void deleteMarker(MethodConfiguration methodConfiguration, IConfigurationError iConfigurationError) {
        try {
            IMarker iMarker = this.getMarker(methodConfiguration, iConfigurationError);
            if (iMarker != null) {
                iMarker.delete();
                ConfigurationMarkerHelper.containersOfMarkedObjects.unmarkContainers((MethodElement)methodConfiguration);
            }
        }
        catch (CoreException coreException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)coreException);
        }
    }

    public IMarker createMarker(MethodConfiguration methodConfiguration, IConfigurationError iConfigurationError) {
        IMarker iMarker = this.getMarker(methodConfiguration, iConfigurationError);
        if (iMarker != null) {
            this.adjustMarker(iMarker, methodConfiguration, iConfigurationError);
            return iMarker;
        }
        try {
            IResource iResource = this.getIResource(methodConfiguration);
            if (iResource != null && iResource.exists()) {
                IMarker iMarker2 = iResource.createMarker(this.getMarkerID());
                iMarker2.setAttribute("org.eclipse.ui.editorID", (Object)"org.eclipse.epf.authoring.ui.editors.ConfigurationEditor");
                this.adjustMarker(iMarker2, methodConfiguration, iConfigurationError);
                ConfigurationMarkerHelper.containersOfMarkedObjects.markContainers((MethodElement)methodConfiguration);
                return iMarker2;
            }
        }
        catch (CoreException coreException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)coreException);
        }
        return null;
    }

    public void adjustMarker(IMarker iMarker, MethodConfiguration methodConfiguration, IConfigurationError iConfigurationError) {
        if (methodConfiguration == null || iConfigurationError == null) {
            return;
        }
        try {
            if (iMarker == null) {
                iMarker = this.getMarker(methodConfiguration, iConfigurationError);
            }
            if (iMarker == null) {
                return;
            }
            iMarker.setAttribute("severity", iConfigurationError.getSeverity());
            String string = this.getMessage(iConfigurationError);
            iMarker.setAttribute("message", (Object)string);
            iMarker.setAttribute("lineNumber", 0);
            iMarker.setAttribute(ATTR_CONFIG_GUID, (Object)methodConfiguration.getGuid());
            iMarker.setAttribute(ATTR_ERROR_ID, (Object)iConfigurationError.getId());
            if (iConfigurationError.getErrorMethodElement() != null) {
                iMarker.setAttribute("location", (Object)TngUtil.getLabelWithPath((Object)iConfigurationError.getErrorMethodElement()));
                iMarker.setAttribute(ATTR_ERROR_ELEMENT_GUID, (Object)iConfigurationError.getErrorMethodElement().getGuid());
            }
            if (iConfigurationError.getCauseMethodElement() != null) {
                iMarker.setAttribute(ATTR_CAUSE_ELEMENT_GUID, (Object)iConfigurationError.getCauseMethodElement().getGuid());
            }
        }
        catch (CoreException coreException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)coreException);
        }
    }

    public boolean hasMarker(MethodConfiguration methodConfiguration, IConfigurationError iConfigurationError) {
        return this.getMarker(methodConfiguration, iConfigurationError) != null;
    }

    public boolean hasMarkers(MethodConfiguration methodConfiguration) {
        IResource iResource = this.getIResource(methodConfiguration);
        if (iResource != null && iResource.exists()) {
            try {
                IMarker[] iMarkerArray = iResource.findMarkers(this.getMarkerID(), true, 0);
                return iMarkerArray.length > 0;
            }
            catch (CoreException coreException) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)coreException);
            }
        }
        return false;
    }

    public IMarker getMarker(MethodConfiguration methodConfiguration, IConfigurationError iConfigurationError) {
        if (methodConfiguration == null || iConfigurationError == null) {
            return null;
        }
        try {
            IResource iResource = this.getIResource(methodConfiguration);
            if (iResource != null) {
                IMarker[] iMarkerArray = iResource.findMarkers(this.getMarkerID(), false, 0);
                int n = 0;
                while (n < iMarkerArray.length) {
                    IMarker iMarker = iMarkerArray[n];
                    String string = (String)iMarker.getAttribute(ATTR_ERROR_ID);
                    if (iConfigurationError.getId().equals(string)) {
                        return iMarker;
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)coreException);
        }
        return null;
    }

    private String getMessage(IConfigurationError iConfigurationError) {
        return iConfigurationError.getErrorMessage();
    }

    private IResource getIResource(MethodConfiguration methodConfiguration) {
        Resource resource = methodConfiguration.eResource();
        URI uRI = resource.getURI();
        uRI = resource.getResourceSet().getURIConverter().normalize(uRI);
        return this.getFile(uRI);
    }

    public MethodConfiguration getConfig(IMarker iMarker) {
        if (iMarker == null) {
            return null;
        }
        try {
            String string = (String)iMarker.getAttribute(ATTR_CONFIG_GUID);
            MethodElement methodElement = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(string);
            if (methodElement instanceof MethodConfiguration) {
                return (MethodConfiguration)methodElement;
            }
        }
        catch (CoreException coreException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)coreException);
        }
        return null;
    }

    public MethodElement getErrorMethodElement(IMarker iMarker) {
        if (iMarker == null) {
            return null;
        }
        try {
            MethodElement methodElement;
            String string = (String)iMarker.getAttribute(ATTR_ERROR_ELEMENT_GUID);
            if (string != null && (methodElement = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(string)) instanceof MethodElement) {
                return methodElement;
            }
        }
        catch (CoreException coreException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)coreException);
        }
        return null;
    }

    public MethodElement getCauseMethodElement(IMarker iMarker) {
        if (iMarker == null) {
            return null;
        }
        try {
            MethodElement methodElement;
            String string = (String)iMarker.getAttribute(ATTR_CAUSE_ELEMENT_GUID);
            if (string != null && (methodElement = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(string)) instanceof MethodElement) {
                return methodElement;
            }
        }
        catch (CoreException coreException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)coreException);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContainerMap
    extends HashMap<Object, Integer> {
        private static final long serialVersionUID = 1L;

        public ContainerMap() {
            this.initMap();
            LibraryService.getInstance().addListener((ILibraryServiceListener)new LibraryServiceListener(){

                public void libraryOpened(MethodLibrary methodLibrary) {
                    ContainerMap.this.initMap();
                }

                public void libraryClosed(MethodLibrary methodLibrary) {
                    ContainerMap.this.clear();
                }

                public void libraryReopened(MethodLibrary methodLibrary) {
                    ContainerMap.this.initMap();
                }
            });
        }

        private void initMap() {
            IProject iProject;
            this.clear();
            MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
            if (methodLibrary != null && (iProject = MethodLibraryProject.findProject((MethodLibrary)methodLibrary)) != null) {
                try {
                    IMarker[] iMarkerArray = iProject.findMarkers(INSTANCE.getMarkerID(), false, 2);
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        IMarker iMarker = iMarkerArray[n];
                        String string = (String)iMarker.getAttribute(ConfigurationMarkerHelper.ATTR_CONFIG_GUID);
                        MethodElement methodElement = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(string);
                        if (methodElement != null) {
                            this.markContainers(methodElement);
                        }
                        ++n;
                    }
                }
                catch (CoreException coreException) {}
            }
        }

        private void increment(Object object) {
            Integer n = this.containsKey(object) ? (Integer)this.get(object) : new Integer(0);
            n = n + 1;
            this.put(object, n);
        }

        private void decrement(Object object) {
            if (this.containsKey(object)) {
                Integer n = (Integer)this.get(object);
                if (n == 1) {
                    this.remove(object);
                } else {
                    n = n - 1;
                    this.put(object, n);
                }
            }
        }

        private void markContainers(MethodElement methodElement) {
            EObject eObject = methodElement.eContainer();
            while (eObject != null) {
                this.increment(eObject);
                eObject = eObject.eContainer();
            }
        }

        private void unmarkContainers(MethodElement methodElement) {
            EObject eObject = methodElement.eContainer();
            while (eObject != null) {
                this.decrement(eObject);
                eObject = eObject.eContainer();
            }
        }
    }
}

