/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.element.TransientContentPackageItemProvider;
import org.eclipse.epf.library.edit.navigator.ContentItemProvider;
import org.eclipse.epf.library.edit.navigator.MethodPackagesItemProvider;
import org.eclipse.epf.library.edit.navigator.ProcessesItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.ProcessPackage;

public class LibraryValidationMarkerHelper
extends ValidateAction.EclipseResourcesUtil {
    public static final LibraryValidationMarkerHelper INSTANCE = new LibraryValidationMarkerHelper();
    public static final String GUID = "guid";
    private static ContainerSet containersOfMarkedObjects = new ContainerSet();

    protected IFile getFile(URI uRI) {
        if (uRI.isFile()) {
            return (IFile)FileManager.getResourceForLocation((String)uRI.toFileString());
        }
        return super.getFile(uRI);
    }

    protected boolean adjustMarker(IMarker iMarker, Diagnostic diagnostic) throws CoreException {
        Object e;
        boolean bl = super.adjustMarker(iMarker, diagnostic);
        if (!diagnostic.getData().isEmpty() && (e = diagnostic.getData().get(0)) instanceof MethodElement) {
            iMarker.setAttribute(GUID, (Object)((MethodElement)e).getGuid());
            iMarker.setAttribute("location", (Object)TngUtil.getLabelWithPath(e));
            iMarker.setAttribute("org.eclipse.ui.editorID", (Object)"org.eclipse.epf.authoring.ui.editors.MethodElementEditor");
        }
        return bl;
    }

    public static boolean isInvalid(Object object) {
        if (object instanceof ProcessesItemProvider) {
            ProcessesItemProvider processesItemProvider = (ProcessesItemProvider)object;
            ProcessPackage processPackage = processesItemProvider.getCapabilityPatternPackage();
            return processPackage != null && containersOfMarkedObjects.contains(processPackage) || (processPackage = processesItemProvider.getDeliveryProcessPackage()) != null && containersOfMarkedObjects.contains(processPackage);
        }
        if (object instanceof MethodPackagesItemProvider || object instanceof ContentItemProvider) {
            object = ((ItemProviderAdapter)object).getTarget();
        } else if (object instanceof TransientContentPackageItemProvider) {
            Collection collection = ((TransientContentPackageItemProvider)object).getChildren(object);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!INSTANCE.hasMarkers(iterator.next())) continue;
                return true;
            }
            return false;
        }
        return containersOfMarkedObjects.contains(object) || INSTANCE.hasMarkers(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasMarkers(Object object) {
        if (!(object instanceof MethodElement)) return super.hasMarkers(object);
        IFile iFile = this.getFile(object);
        if (iFile == null) return false;
        if (!iFile.exists()) return false;
        try {
            String string = ((MethodElement)object).getGuid();
            IMarker[] iMarkerArray = iFile.findMarkers(this.getMarkerID(), false, 0);
            int n = 0;
            while (true) {
                if (n >= iMarkerArray.length) {
                    return false;
                }
                IMarker iMarker = iMarkerArray[n];
                if (string.equals(iMarker.getAttribute(GUID))) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected IFile getFile(Object object) {
        try {
            return super.getFile(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void deleteMarkers(Object object) {
        if (object instanceof MethodElement) {
            IFile iFile = this.getFile(object);
            if (iFile != null && iFile.exists()) {
                try {
                    String string = ((MethodElement)object).getGuid();
                    IMarker[] iMarkerArray = iFile.findMarkers(this.getMarkerID(), false, 0);
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        IMarker iMarker = iMarkerArray[n];
                        if (string.equals(iMarker.getAttribute(GUID))) {
                            iMarker.delete();
                        }
                        ++n;
                    }
                }
                catch (CoreException coreException) {}
            }
            return;
        }
        super.deleteMarkers(object);
    }

    protected void deleteMarkers(IResource iResource, boolean bl, int n) {
        if (iResource != null && iResource.exists()) {
            try {
                IMarker[] iMarkerArray = iResource.findMarkers(this.getMarkerID(), false, 0);
                int n2 = 0;
                while (n2 < iMarkerArray.length) {
                    IMarker iMarker = iMarkerArray[n2];
                    String string = (String)iMarker.getAttribute(GUID);
                    MethodElement methodElement = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(string);
                    if (methodElement != null) {
                        LibraryValidationMarkerHelper.containersOfMarkedObjects.unmarkContainers(methodElement);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
        super.deleteMarkers(iResource, bl, n);
    }

    protected void createMarkers(IResource iResource, Diagnostic diagnostic, Diagnostic diagnostic2) throws CoreException {
        super.createMarkers(iResource, diagnostic, diagnostic2);
        if (iResource != null && iResource.exists()) {
            try {
                IMarker[] iMarkerArray = iResource.findMarkers(this.getMarkerID(), false, 0);
                int n = 0;
                while (n < iMarkerArray.length) {
                    IMarker iMarker = iMarkerArray[n];
                    String string = (String)iMarker.getAttribute(GUID);
                    MethodElement methodElement = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(string);
                    if (methodElement != null) {
                        LibraryValidationMarkerHelper.containersOfMarkedObjects.markContainers(methodElement);
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    protected String composeMessage(Diagnostic diagnostic, Diagnostic diagnostic2) {
        int n = diagnostic.getMessage().indexOf(LibraryEditResources.duplicateElementNameError_msg2);
        if (n > 0) {
            return diagnostic.getMessage().substring(0, n);
        }
        return super.composeMessage(diagnostic, diagnostic2);
    }

    private static class ContainerSet
    extends HashSet {
        private static final long serialVersionUID = 1L;

        public ContainerSet() {
            this.init();
            LibraryService.getInstance().addListener((ILibraryServiceListener)new LibraryServiceListener(){

                public void libraryOpened(MethodLibrary methodLibrary) {
                    ContainerSet.this.init();
                }

                public void libraryClosed(MethodLibrary methodLibrary) {
                    ContainerSet.this.clear();
                }

                public void libraryReopened(MethodLibrary methodLibrary) {
                    ContainerSet.this.init();
                }
            });
        }

        private void init() {
            IProject iProject;
            this.clear();
            MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
            if (methodLibrary != null && (iProject = MethodLibraryProject.findProject((MethodLibrary)methodLibrary)) != null) {
                try {
                    IMarker[] iMarkerArray = iProject.findMarkers(INSTANCE.getMarkerID(), false, 2);
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        IMarker iMarker = iMarkerArray[n];
                        String string = (String)iMarker.getAttribute(LibraryValidationMarkerHelper.GUID);
                        MethodElement methodElement = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(string);
                        if (methodElement != null) {
                            this.markContainers(methodElement);
                        }
                        ++n;
                    }
                }
                catch (CoreException coreException) {}
            }
        }

        private void markContainers(MethodElement methodElement) {
            EObject eObject = methodElement.eContainer();
            while (eObject != null) {
                this.add(eObject);
                eObject = eObject.eContainer();
            }
        }

        private void unmarkContainers(MethodElement methodElement) {
            EObject eObject = methodElement.eContainer();
            while (eObject != null) {
                this.remove(eObject);
                eObject = eObject.eContainer();
            }
        }
    }
}

