/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class MarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private static final IMarkerResolution[] EMPTY_RESOLUTIONS = new IMarkerResolution[0];

    public IMarkerResolution[] getResolutions(IMarker iMarker) {
        block8: {
            try {
                EObject eObject;
                Resource resource;
                String string = (String)iMarker.getAttribute("proxyURI");
                String string2 = (String)iMarker.getAttribute("ownerGUID");
                if (string == null || string2 == null || (resource = RefreshJob.getInstance().getResource(iMarker.getResource())) == null || (eObject = resource.getEObject(string2)) == null) break block8;
                URI uRI = URI.createURI((String)string);
                int n = -1;
                EReference eReference = null;
                block2: for (EReference eReference2 : eObject.eClass().getEAllReferences()) {
                    InternalEList internalEList;
                    if (!eReference2.isChangeable() || eReference2.isDerived()) continue;
                    if (eReference2.isMany()) {
                        internalEList = (InternalEList)eObject.eGet((EStructuralFeature)eReference2);
                        int n2 = 0;
                        Iterator iterator = internalEList.basicIterator();
                        while (iterator.hasNext()) {
                            InternalEObject internalEObject = (InternalEObject)iterator.next();
                            if (internalEObject.eIsProxy() && uRI.equals((Object)internalEObject.eProxyURI())) {
                                n = n2;
                                eReference = eReference2;
                                break block2;
                            }
                            ++n2;
                        }
                        continue;
                    }
                    internalEList = (InternalEObject)eObject.eGet((EStructuralFeature)eReference2, false);
                    if (internalEList == null || !internalEList.eIsProxy() || !uRI.equals((Object)internalEList.eProxyURI())) continue;
                    eReference = eReference2;
                    break;
                }
                if (eReference != null) {
                    Object object = MarkerResolutionGenerator.getSelectableObject(eObject);
                    if (object != null) {
                        return new IMarkerResolution[]{new MarkerResolution(eObject, eReference, n), new ShowOwnerInLibraryView(object)};
                    }
                    return new IMarkerResolution[]{new MarkerResolution(eObject, eReference, n)};
                }
            }
            catch (Exception exception) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
        return EMPTY_RESOLUTIONS;
    }

    private static Object getSelectableObject(EObject eObject) {
        ProcessComponent processComponent;
        if (eObject instanceof MethodPlugin || eObject instanceof ContentElement || eObject instanceof ContentPackage || eObject instanceof ProcessComponent) {
            return eObject;
        }
        if (eObject instanceof MethodElement && (processComponent = UmaUtil.getProcessComponent((MethodElement)((MethodElement)eObject))) != null) {
            return processComponent;
        }
        if (eObject instanceof ProcessPackage) {
            return eObject;
        }
        if (eObject instanceof ContentDescription && eObject.eContainer() instanceof ContentElement) {
            return eObject.eContainer();
        }
        processComponent = eObject.eResource();
        MethodElement methodElement = PersistenceUtil.getMethodElement((Resource)processComponent);
        if (methodElement != eObject) {
            return MarkerResolutionGenerator.getSelectableObject((EObject)methodElement);
        }
        return null;
    }

    private static class MarkerResolution
    implements IMarkerResolution {
        private EObject owner;
        private EReference reference;
        private int index;

        private MarkerResolution(EObject eObject, EReference eReference, int n) {
            this.owner = eObject;
            this.reference = eReference;
            this.index = n;
        }

        public String getLabel() {
            return AuthoringUIResources.MarkerResolutionGenerator_removeUnresolvedReference;
        }

        public void run(IMarker iMarker) {
            ResourceSet resourceSet;
            if (this.reference.isMany()) {
                ((List)this.owner.eGet((EStructuralFeature)this.reference)).remove(this.index);
            } else {
                this.owner.eSet((EStructuralFeature)this.reference, null);
            }
            boolean bl = false;
            Resource resource = this.owner.eResource();
            ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
            try {
                failSafeMethodLibraryPersister.save(resource);
                failSafeMethodLibraryPersister.commit();
                bl = true;
            }
            catch (Exception exception) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                failSafeMethodLibraryPersister.rollback();
            }
            if (bl && (resourceSet = resource.getResourceSet()) instanceof MultiFileResourceSetImpl) {
                ((MultiFileResourceSetImpl)resourceSet).getMarkerMananger().doValidateMarkers(resource);
            }
        }
    }

    private static class ShowOwnerInLibraryView
    implements IMarkerResolution {
        private Object owner;

        private ShowOwnerInLibraryView(Object object) {
            this.owner = object;
        }

        public String getLabel() {
            return AuthoringUIResources.MarkerResolutionGenerator_showOwnerInLibraryView;
        }

        public void run(IMarker iMarker) {
            LibraryView.getView().setSelectionToViewer(this.owner);
        }
    }
}

