/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.views.ConfigurationView;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.persistence.refresh.IRefreshHandler;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class RefreshHandler
implements IRefreshHandler {
    private LibraryView libView;

    public void refresh(final IProgressMonitor iProgressMonitor) {
        this.libView = LibraryView.getView();
        Viewer viewer = this.libView != null ? this.libView.getViewer() : null;
        Control control = viewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        if (control.getDisplay().getThread() == Thread.currentThread()) {
            this.doRefresh(iProgressMonitor);
        } else {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    RefreshHandler.this.doRefresh(iProgressMonitor);
                }
            });
        }
    }

    private void doRefresh(IProgressMonitor iProgressMonitor) {
        ArrayList arrayList;
        if (!RefreshJob.getInstance().getRemovedResources().isEmpty()) {
            arrayList = new ArrayList(RefreshJob.getInstance().getRemovedResources());
            this.handleRemovedResources(arrayList);
            RefreshJob.getInstance().getRemovedResources().removeAll(arrayList);
        }
        if (!RefreshJob.getInstance().getChangedResources().isEmpty()) {
            arrayList = new ArrayList(RefreshJob.getInstance().getChangedResources());
            this.handleChangedResources(arrayList);
            RefreshJob.getInstance().getChangedResources().removeAll(arrayList);
        }
    }

    private Collection handleRemovedResources(Collection collection) {
        return collection;
    }

    private Collection handleChangedResources(Collection collection) {
        Resource resource;
        ListSelectionDialog listSelectionDialog;
        Object object;
        Object object2;
        Object object3;
        Control control = this.libView.getViewer().getControl();
        if (control == null || control.isDisposed()) {
            return Collections.EMPTY_LIST;
        }
        IWorkbenchPage iWorkbenchPage = this.libView.getSite().getPage();
        Shell shell = AuthoringUIPlugin.getDefault().getWorkbench().getDisplay().getActiveShell();
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList(collection);
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            object3 = iEditorReferenceArray[n];
            object2 = object3.getEditor(true);
            if (object2 instanceof MethodElementEditor && object2.isDirty()) {
                object = ((MethodElementEditor)((Object)object2)).getUsedResources();
                int n2 = 0;
                while (n2 < arrayList2.size()) {
                    listSelectionDialog = (Resource)arrayList2.get(n2);
                    if (object.contains(listSelectionDialog)) {
                        arrayList.add(object2);
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        final ArrayList<Object> arrayList3 = new ArrayList<Object>();
        if (!arrayList.isEmpty()) {
            Object object4;
            object3 = new IStructuredContentProvider(){
                List fContents;

                public Object[] getElements(Object object) {
                    if (this.fContents != null && this.fContents == object) {
                        return this.fContents.toArray();
                    }
                    return new Object[0];
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object object, Object object2) {
                    this.fContents = object2 instanceof List ? (List)object2 : null;
                }
            };
            object2 = new LabelProvider(){

                public String getText(Object object) {
                    if (object instanceof IEditorPart) {
                        return ((IEditorPart)object).getTitle();
                    }
                    return super.getText(object);
                }

                public Image getImage(Object object) {
                    if (object instanceof IEditorPart) {
                        return ((IEditorPart)object).getTitleImage();
                    }
                    return super.getImage(object);
                }
            };
            object = AuthoringUIResources._UI_FileConflict_label;
            String string = AuthoringUIResources._WARN_FileConflict;
            listSelectionDialog = new ListSelectionDialog(shell, arrayList, (IStructuredContentProvider)object3, (ILabelProvider)object2, string);
            listSelectionDialog.setTitle((String)object);
            listSelectionDialog.setBlockOnOpen(true);
            listSelectionDialog.open();
            resource = listSelectionDialog.getResult();
            int n3 = 0;
            while (n3 < ((Resource)resource).length) {
                object4 = resource[n3];
                arrayList3.add(object4);
                arrayList.remove(object4);
                ++n3;
            }
            n3 = 0;
            while (n3 < arrayList.size()) {
                object4 = (MethodElementEditor)((Object)arrayList.get(n3));
                Collection<Resource> collection2 = ((MethodElementEditor)((Object)object4)).getUsedResources();
                arrayList2.removeAll(collection2);
                ++n3;
            }
        }
        if (!arrayList2.isEmpty()) {
            int n4 = 0;
            while (n4 < iEditorReferenceArray.length) {
                object2 = iEditorReferenceArray[n4];
                object = object2.getEditor(true);
                if (object instanceof MethodElementEditor && !object.isDirty()) {
                    Collection<Resource> collection3 = ((MethodElementEditor)((Object)object)).getUsedResources();
                    int n5 = 0;
                    while (n5 < arrayList2.size()) {
                        resource = (Resource)arrayList2.get(n5);
                        if (collection3.contains(resource)) {
                            arrayList3.add(object);
                            break;
                        }
                        ++n5;
                    }
                }
                ++n4;
            }
            ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
            if (iLibraryManager != null) {
                iLibraryManager.reloadResources(arrayList2);
            }
            this.libView.getViewer().refresh();
            object2 = ConfigurationView.getView();
            if (object2 != null && (control = ((ConfigurationView)((Object)object2)).getViewer().getControl()) != null && !control.isDisposed()) {
                ((ConfigurationView)((Object)object2)).getViewer().refresh();
            }
        }
        if (!arrayList3.isEmpty()) {
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    int n = 0;
                    while (n < arrayList3.size()) {
                        MethodElementEditor methodElementEditor = (MethodElementEditor)((Object)arrayList3.get(n));
                        methodElementEditor.refresh();
                        ++n;
                    }
                }
            });
        }
        return arrayList2;
    }
}

