/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.io.File;
import java.util.HashMap;
import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.wizards.NewLibraryMainPage;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.common.utils.PerspectiveUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewLibraryWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = NewLibraryWizard.class.getName();
    private NewLibraryMainPage mainPage;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setWindowTitle(AuthoringUIResources.newLibraryWizard_title);
    }

    public void addPages() {
        SaveAllEditorsPage.addPageIfNeeded(this, true, null, null, null);
        this.mainPage = new NewLibraryMainPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        composite.getShell().setImage(AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/MethodLibrary.gif"));
    }

    public boolean performFinish() {
        try {
            String string = this.mainPage.getLibraryName();
            String string2 = this.mainPage.getLibraryDescription();
            String string3 = this.mainPage.getLibraryType();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            File file = new File(this.mainPage.getLibraryPath());
            hashMap.put("library.path", file.getAbsolutePath());
            if (XMILibraryUtil.containsPluginOrConfigSpecExportFile((String)file.getAbsolutePath())) {
                throw new Exception(LibraryUIResources.openLibraryError_reason4);
            }
            MethodLibrary methodLibrary = LibraryService.getInstance().createMethodLibrary(string, string3, hashMap);
            if (methodLibrary != null) {
                if (string2.length() > 0) {
                    methodLibrary.setBriefDescription(string2);
                }
                LibraryUIPreferences.addNewLibraryPath((String)file.getAbsolutePath());
                PerspectiveUtil.openPerspective((String)AuthoringPerspective.PERSPECTIVE_ID);
                return true;
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = AuthoringUIResources.newLibraryInternlError_reason;
            }
            string = String.valueOf(string) + "\n\n" + AuthoringUIResources.newLibraryError_advice;
            if (exception.getMessage() != null) {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newLibraryWizard_title, AuthoringUIResources.newLibraryError_msg, string);
            }
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newLibraryWizard_title, AuthoringUIResources.newLibraryError_msg, string, (Throwable)exception);
        }
        return false;
    }
}

