/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.ITopic;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.BreadcrumbsFilter;
import org.eclipse.help.internal.webapp.servlet.FramesetFilter;
import org.eclipse.help.internal.webapp.servlet.IFilter;
import org.eclipse.help.internal.webapp.servlet.InjectionFilter;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;

public class NavServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String XHTML_1 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"../content/PLUGINS_ROOT/PRODUCT_PLUGIN/book.css\"/>\n<title>";
    private static final String XHTML_2 = "</title>\n</head>\n<body>\n";
    private static final String XHTML_3 = "</body>\n</html>";
    private static final IFilter[] filters = new IFilter[]{new FramesetFilter(), new InjectionFilter(), new BreadcrumbsFilter()};

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Locale locale = this.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("text/html; charset=UTF-8");
        String path = req.getPathInfo().substring(1);
        ITopic topic = this.getTopic(path, locale);
        Object out = resp.getOutputStream();
        int i = 0;
        while (i < filters.length) {
            out = filters[i].filter(req, (OutputStream)out);
            ++i;
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        this.writeContent(topic, path, locale, writer);
        writer.close();
    }

    private Locale getLocale(HttpServletRequest req, HttpServletResponse resp) {
        String nl = UrlUtil.getLocale(req, resp);
        StringTokenizer locales = new StringTokenizer(nl, "_");
        Locale locale = locales.countTokens() == 1 ? new Locale(locales.nextToken(), "") : (locales.countTokens() == 2 ? new Locale(locales.nextToken(), locales.nextToken()) : (locales.countTokens() == 3 ? new Locale(locales.nextToken(), locales.nextToken(), locales.nextToken()) : Locale.getDefault()));
        return locale;
    }

    private ITopic getTopic(String topicPath, Locale locale) {
        StringTokenizer tok = new StringTokenizer(topicPath, "_");
        int index = Integer.parseInt(tok.nextToken());
        ITopic topic = HelpPlugin.getTocManager().getTocs(locale.toString())[index].getTopic(null);
        while (tok.hasMoreTokens()) {
            index = Integer.parseInt(tok.nextToken());
            topic = topic.getSubtopics()[index];
        }
        return topic;
    }

    private void writeContent(ITopic topic, String path, Locale locale, PrintWriter writer) {
        writer.write(XHTML_1);
        writer.write(topic.getLabel());
        writer.write(XHTML_2);
        writer.write("<h1 class=\"NavTitle\">" + topic.getLabel() + "</h1>\n");
        writer.write("<h3 class=\"NavListTitle\">" + WebappResources.getString("TocHeading", locale) + "</h3>\n");
        writer.write("<ul class=\"NavList\">\n");
        ITopic[] subtopics = topic.getSubtopics();
        int i = 0;
        while (i < subtopics.length) {
            if (!UAContentFilter.isFiltered((Object)subtopics[i], (IEvaluationContext)HelpEvaluationContext.getContext())) {
                writer.write("<li><a href=\"");
                String href = subtopics[i].getHref();
                href = href == null ? String.valueOf(path) + '_' + i : XMLGenerator.xmlEscape(UrlUtil.getHelpURL(href));
                writer.write(href);
                writer.write("\">" + subtopics[i].getLabel() + "</a></li>\n");
            }
            ++i;
        }
        writer.write("</ul>\n");
        writer.write(XHTML_3);
    }
}

