/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.EnabledTopicUtils;
import org.eclipse.help.internal.webapp.data.TocData;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;

public class TocFragmentServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Map locale2Response = new WeakHashMap();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String locale = UrlUtil.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("application/xml; charset=UTF-8");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
        TocData data = new TocData(this.getServletContext(), req, resp);
        Serializer serializer = new Serializer(data, req.getLocale());
        String response = serializer.generateTreeXml();
        locale2Response.put(locale, response);
        resp.getWriter().write(response);
    }

    private class Serializer {
        private TocData tocData;
        private StringBuffer buf;
        private int requestKind;
        private Locale locale;
        private static final int REQUEST_SHOW_IN_TOC = 1;
        private static final int REQUEST_SHOW_TOCS = 2;
        private static final int REQUEST_SHOW_CHILDREN = 3;

        public Serializer(TocData data, Locale locale) {
            this.tocData = data;
            this.buf = new StringBuffer();
            this.locale = locale;
            this.requestKind = this.tocData.getTopicHref() != null ? 1 : (this.tocData.getSelectedToc() == -1 ? 2 : 3);
        }

        public String generateTreeXml() {
            this.buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.buf.append("<tree_data>\n");
            if (this.tocData.isRemoteHelpError()) {
                this.addError(WebappResources.getString("remoteHelpErrorMessage", this.locale));
            }
            if (this.requestKind == 1 && this.tocData.getTopicPath() == null) {
                this.addError(WebappResources.getString("CannotSync", this.locale));
            } else {
                this.serializeTocs();
            }
            this.buf.append("</tree_data>\n");
            return this.buf.toString();
        }

        private void addError(String message) {
            this.buf.append("<error>");
            this.buf.append(XMLGenerator.xmlEscape(message));
            this.buf.append("</error>");
        }

        private void serializeTocs() {
            ITopic[] topicPath = this.tocData.getTopicPath();
            int selectedToc = this.tocData.getSelectedToc();
            int toc = 0;
            while (toc < this.tocData.getTocCount()) {
                boolean shouldLoad;
                boolean bl = shouldLoad = this.requestKind == 2 || toc == selectedToc;
                if (!this.tocData.isEnabled(toc)) {
                    shouldLoad = false;
                }
                if (shouldLoad) {
                    boolean isSelected = false;
                    if (this.requestKind == 2) {
                        isSelected = toc == 0;
                    } else if (this.requestKind == 3) {
                        isSelected = this.tocData.getRootPath() == null;
                    }
                    this.serializeToc(this.tocData.getTocs()[toc], toc, topicPath, isSelected);
                }
                ++toc;
            }
        }

        private void serializeToc(IToc toc, int tocIndex, ITopic[] topicPath, boolean isSelected) {
            ITopic[] topics = this.tocData.getEnabledSubtopics(toc);
            if (topics.length <= 0) {
                return;
            }
            if (this.requestKind == 3) {
                topicPath = this.getTopicPathFromRootPath(toc);
            }
            this.buf.append("<node");
            if (toc.getLabel() != null) {
                this.buf.append("\n      title=\"" + XMLGenerator.xmlEscape(toc.getLabel()) + '\"');
            }
            this.buf.append("\n      id=\"" + XMLGenerator.xmlEscape(toc.getHref()) + "\"");
            String href = toc.getTopic(null).getHref();
            if (href == null) {
                href = "/../nav/" + tocIndex;
            }
            this.buf.append("\n      href=\"" + XMLGenerator.xmlEscape(UrlUtil.getHelpURL(href)) + "\"");
            this.buf.append("\n      image=\"toc_closed\"");
            boolean serializeChildren = true;
            if (this.requestKind == 2) {
                serializeChildren = false;
            }
            if (this.requestKind == 1 && topicPath.length == 0) {
                serializeChildren = false;
                this.buf.append("\n      is_selected=\"true\"");
                this.buf.append("\n      is_highlighted=\"true\"");
            }
            this.buf.append(">\n");
            if (serializeChildren) {
                this.serializeChildTopics(topics, topicPath, "", isSelected);
            }
            this.buf.append("</node>\n");
        }

        private ITopic[] getTopicPathFromRootPath(IToc toc) {
            int[] rootPath = this.tocData.getRootPath();
            if (rootPath == null) {
                return null;
            }
            int pathLength = rootPath.length;
            ITopic[] topicPath = new ITopic[pathLength];
            ITopic[] children = EnabledTopicUtils.getEnabled(toc.getTopics());
            int i = 0;
            while (i < pathLength) {
                int index = rootPath[i];
                if (index >= children.length) {
                    return null;
                }
                topicPath[i] = children[index];
                children = EnabledTopicUtils.getEnabled(topicPath[i].getSubtopics());
                ++i;
            }
            return topicPath;
        }

        private void serializeTopic(ITopic topic, ITopic[] topicPath, boolean isSelected, String parentPath) {
            ITopic[] subtopics = EnabledTopicUtils.getEnabled(topic.getSubtopics());
            this.buf.append("<node");
            if (topic.getLabel() != null) {
                this.buf.append("\n      title=\"" + XMLGenerator.xmlEscape(topic.getLabel()) + '\"');
            }
            this.buf.append("\n      id=\"" + parentPath + "\"");
            String href = topic.getHref();
            if (href == null) {
                href = "/../nav/" + this.tocData.getSelectedToc() + '_' + parentPath;
            }
            this.buf.append("\n      href=\"" + XMLGenerator.xmlEscape(UrlUtil.getHelpURL(href)) + '\"');
            if (subtopics.length == 0) {
                this.buf.append("\n      is_leaf=\"true\"");
            }
            if (isSelected && this.requestKind == 1) {
                this.buf.append("\n      is_selected=\"true\"");
                this.buf.append("\n      is_highlighted=\"true\"");
            }
            String icon = subtopics.length == 0 ? "topic" : (topic.getHref() == null ? "container_obj" : "container_topic");
            this.buf.append("\n      image=\"" + icon + "\"");
            this.buf.append(">\n");
            this.serializeChildTopics(subtopics, topicPath, parentPath, isSelected);
            this.buf.append("</node>\n");
        }

        private void serializeChildTopics(ITopic[] childTopics, ITopic[] topicPath, String parentPath, boolean parentIsSelected) {
            block6: {
                block5: {
                    if (!parentIsSelected || this.requestKind != 3) break block5;
                    int subtopic = 0;
                    while (subtopic < childTopics.length) {
                        this.serializeTopic(childTopics[subtopic], null, false, this.addSuffix(parentPath, subtopic));
                        ++subtopic;
                    }
                    break block6;
                }
                if (topicPath == null) break block6;
                int subtopic = 0;
                while (subtopic < childTopics.length) {
                    if (topicPath[0].getLabel().equals(childTopics[subtopic].getLabel())) {
                        ITopic[] newPath = null;
                        if (topicPath.length > 1) {
                            newPath = new ITopic[topicPath.length - 1];
                            System.arraycopy(topicPath, 1, newPath, 0, topicPath.length - 1);
                        }
                        this.serializeTopic(childTopics[subtopic], newPath, topicPath.length == 1, this.addSuffix(parentPath, subtopic));
                    } else {
                        this.serializeTopic(childTopics[subtopic], null, false, this.addSuffix(parentPath, subtopic));
                    }
                    ++subtopic;
                }
            }
        }

        private String addSuffix(String parentPath, int subtopic) {
            if (parentPath.length() == 0) {
                return String.valueOf(parentPath) + subtopic;
            }
            return String.valueOf(parentPath) + '_' + subtopic;
        }
    }
}

