/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.xml.wizards;

import java.io.File;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.xml.ImportXMLPlugin;
import org.eclipse.epf.importing.xml.ImportXMLResources;
import org.eclipse.epf.importing.xml.preferences.ImportXMLPreferences;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectXMLFilePage
extends BaseWizardPage {
    public static final String PAGE_NAME = SelectXMLFilePage.class.getName();
    private Text pathText;
    private String path;
    private boolean mergeOption = true;
    private boolean checkBasePlugins = true;

    public SelectXMLFilePage() {
        super(PAGE_NAME);
        this.setTitle(ImportXMLResources.selectXMLFilePage_title);
        this.setDescription(ImportXMLResources.selectXMLFilePage_desc);
        this.setImageDescriptor(ImportXMLPlugin.getDefault().getImageDescriptor("full/wizban/ImportXML.gif"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(ImportXMLResources.fileLabel_text);
        this.pathText = new Text(composite2, 2048);
        this.pathText.setLayoutData((Object)new GridData(768));
        this.pathText.setText(ImportXMLPreferences.getXMLFile());
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (SelectXMLFilePage.this.isValidPath(SelectXMLFilePage.this.pathText.getText().trim())) {
                    SelectXMLFilePage.this.setPageComplete(true);
                    SelectXMLFilePage.this.setErrorMessage(null);
                } else {
                    SelectXMLFilePage.this.setPageComplete(false);
                    SelectXMLFilePage.this.setErrorMessage(ImportXMLResources.invalidXMLFile_error);
                }
            }
        });
        Button button = new Button(composite2, 8);
        button.setLayoutData((Object)new GridData(3));
        button.setText(ImportXMLResources.browseButton_text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
                String string = fileDialog.open();
                boolean bl = false;
                if (string != null) {
                    SelectXMLFilePage.this.pathText.setText(string);
                    bl = SelectXMLFilePage.this.isValidPath(string);
                }
                SelectXMLFilePage.this.setPageComplete(bl);
            }
        });
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        group.setLayoutData((Object)gridData);
        group.setText(ImportXMLResources.optionGroup_text);
        this.mergeOption = ImportXMLPreferences.getMergeOption();
        Button button2 = SelectXMLFilePage.createRadioButton((Composite)group, (String)ImportXMLResources.overwriteRadioButton_text, (int)1, (!this.mergeOption ? 1 : 0) != 0);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectXMLFilePage.this.mergeOption = false;
            }
        });
        Button button3 = SelectXMLFilePage.createRadioButton((Composite)group, (String)ImportXMLResources.mergeRadioButton_text, (int)1, (boolean)this.mergeOption);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectXMLFilePage.this.mergeOption = true;
            }
        });
        Group group2 = new Group(composite2, 0);
        group2.setLayout((Layout)new GridLayout(1, false));
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 3;
        group2.setLayoutData((Object)gridData2);
        group2.setText(ImportXMLResources.optionGroup1_text);
        this.checkBasePlugins = ImportXMLPreferences.getCheckBasePluginsOption();
        Button button4 = SelectXMLFilePage.createRadioButton((Composite)group2, (String)ImportResources.checkBaseRadioButton_text, (int)1, (boolean)this.checkBasePlugins);
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectXMLFilePage.this.checkBasePlugins = true;
            }
        });
        Button button5 = SelectXMLFilePage.createRadioButton((Composite)group2, (String)ImportResources.ignoreRemoveRadioButton_text, (int)1, (!this.checkBasePlugins ? 1 : 0) != 0);
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectXMLFilePage.this.checkBasePlugins = false;
            }
        });
        this.setControl((Control)composite2);
        this.setPageComplete(this.isValidPath(this.pathText.getText().trim()));
    }

    private boolean isValidPath(String string) {
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            this.path = string;
            return true;
        }
        return false;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getMergeOption() {
        return this.mergeOption;
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        return super.isPageComplete();
    }

    public boolean getCheckBasePlugins() {
        return this.checkBasePlugins;
    }
}

