/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.util.List;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.PreferenceUtil;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportUIPreferences {
    private static final String EXPORT_PLUGIN_DIRS = "exportPluginDirs";
    private static final String EXPORT_CONFIG_DIRS = "exportConfigDirs";
    private static final String DEFAULT_EXPORT_PLUGIN_DIR_NAME = "Export" + FileUtil.FILE_SEP + "Plugins";
    private static final String DEFAULT_EXPORT_CONFIG_DIR_NAME = "Export" + FileUtil.FILE_SEP + "Configurations";
    private static String defaultExportPluginDir = null;
    private static String defaultExportConfigDir = null;
    private static IPreferenceStore prefStore = ExportPlugin.getDefault().getPreferenceStore();

    static {
        prefStore.setDefault(EXPORT_PLUGIN_DIRS, ExportUIPreferences.getDefaultExportPluginDir());
        prefStore.setDefault(EXPORT_CONFIG_DIRS, ExportUIPreferences.getDefaultExportConfigDir());
    }

    public static String getDefaultExportPluginDir() {
        if (defaultExportPluginDir == null) {
            defaultExportPluginDir = System.getProperty("user.home");
            String string = LibraryUIPreferences.getApplicationShortName();
            defaultExportPluginDir = string != null && string.length() > 0 ? String.valueOf(defaultExportPluginDir) + FileUtil.FILE_SEP + string + FileUtil.FILE_SEP + DEFAULT_EXPORT_PLUGIN_DIR_NAME : String.valueOf(defaultExportPluginDir) + FileUtil.FILE_SEP + DEFAULT_EXPORT_PLUGIN_DIR_NAME;
        }
        return defaultExportPluginDir;
    }

    public static String[] getExportPluginDirs() {
        return PreferenceUtil.getStringValues((IPreferenceStore)prefStore, (String)EXPORT_PLUGIN_DIRS);
    }

    public static List<String> getExportPluginDirsList() {
        return PreferenceUtil.getList((IPreferenceStore)prefStore, (String)EXPORT_PLUGIN_DIRS);
    }

    public static void addExportPluginDir(String string) {
        PreferenceUtil.addToList((IPreferenceStore)prefStore, (String)EXPORT_PLUGIN_DIRS, (String)string);
    }

    public static String getDefaultExportConfigDir() {
        if (defaultExportConfigDir == null) {
            defaultExportConfigDir = System.getProperty("user.home");
            String string = LibraryUIPreferences.getApplicationShortName();
            defaultExportConfigDir = string != null && string.length() > 0 ? String.valueOf(defaultExportConfigDir) + FileUtil.FILE_SEP + string + FileUtil.FILE_SEP + DEFAULT_EXPORT_CONFIG_DIR_NAME : String.valueOf(defaultExportConfigDir) + FileUtil.FILE_SEP + DEFAULT_EXPORT_CONFIG_DIR_NAME;
        }
        return defaultExportConfigDir;
    }

    public static String[] getExportConfigDirs() {
        return PreferenceUtil.getStringValues((IPreferenceStore)prefStore, (String)EXPORT_CONFIG_DIRS);
    }

    public static List<String> getExportConfigDirsList() {
        return PreferenceUtil.getList((IPreferenceStore)prefStore, (String)EXPORT_CONFIG_DIRS);
    }

    public static void addExportConfigDir(String string) {
        PreferenceUtil.addToList((IPreferenceStore)prefStore, (String)EXPORT_CONFIG_DIRS, (String)string);
    }
}

