/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.DiagramResources;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.RoleTaskComposite;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.diagram.model.WorkProductComposite;
import org.eclipse.epf.diagram.model.impl.NamedNodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.diagram.model.util.INodeChangeListener;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.process.WorkProductDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.DiagramElement;
import org.eclipse.epf.uma.Dimension;
import org.eclipse.epf.uma.GraphConnector;
import org.eclipse.epf.uma.GraphEdge;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Property;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.SimpleSemanticModelElement;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.util.UmaUtil;

public class GraphicalDataHelper {
    public static final int ACTIVITY_DIAGRAM = 0;
    public static final int WORK_PRODUCT_DEPENDENCY_DIAGRAM = 1;
    public static final int ACTIVITY_DETAIL_DIAGRAM = 2;
    static final int[] DIAGRAM_TYPES;
    static final String[] DIAGRAM_TYPE_TEXTS;
    public static final String PROP_TYPE = "type";
    public static final String PROP_WORK_PRODUCT_COMPOSITE_TYPE = "wpCompositeType";
    public static final String PROP_AUTO_LAYOUT = "autolayout";
    public static final String PROP_INDEX = "index";
    public static final String PROP_AUTO_LAYOUT_VALUE_TRUE = "true";
    public static final String PROP_AUTO_LAYOUT_VALUE_FALSE = "false";
    public static final String GRAPH_NODE_SYNCH_BAR = "synchnonization bar";
    public static final String GRAPH_NODE_START = "start node";
    public static final String GRAPH_NODE_END = "end node";
    public static final String GRAPH_NODE_DECISION = "decision node";
    public static final String GRAPH_NODE_FREE_TEXT = "free text";
    public static final String DIAGRAM_WORKFLOW = "Workflow";
    public static final String DIAGRAM_WORK_PRODUCT_DEPENDENCY = "Work Product Dependency";
    public static final String DIAGRAM_ACTIVITY_DETAIL = "Activity Detail";
    public static final String ADD_DIAGRAM_TASKS_PER_ROW = "ACTIVITY_DETAIL_DIAGRAM_TASKS_PER_ROW";

    static {
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 1;
        DIAGRAM_TYPES = nArray;
        DIAGRAM_TYPE_TEXTS = new String[]{DiagramResources.type_activity, DiagramResources.type_WPD, DiagramResources.type_activityDetail};
    }

    public static Point toPoint(org.eclipse.epf.uma.Point point) {
        return new Point(point.getX().doubleValue(), point.getY().doubleValue());
    }

    public static org.eclipse.epf.uma.Point newModelPoint(int n, int n2) {
        org.eclipse.epf.uma.Point point = UmaFactory.eINSTANCE.createPoint();
        point.setX(new Double(n));
        point.setY(new Double(n2));
        return point;
    }

    public static Property findProperty(GraphNode graphNode, String string) {
        int n = graphNode.getProperty().size() - 1;
        while (n > -1) {
            Property property = (Property)graphNode.getProperty().get(n);
            if (string.equals(property.getKey())) {
                return property;
            }
            --n;
        }
        return null;
    }

    public static Dimension newModelDimension(int n, int n2) {
        Dimension dimension = UmaFactory.eINSTANCE.createDimension();
        dimension.setWidth(new Double(n));
        dimension.setHeight(new Double(n2));
        return dimension;
    }

    public static void fillConnections(Node node, GraphNode graphNode) {
        boolean bl = node.eDeliver();
        try {
            node.eSetDeliver(false);
            Diagram diagram = (Diagram)node.eContainer();
            for (GraphConnector graphConnector : graphNode.getAnchorage()) {
                for (GraphEdge graphEdge : graphConnector.getGraphEdge()) {
                    if (graphEdge.getAnchor().size() <= 1) continue;
                    Link link = null;
                    if (graphEdge.eContainer() != graphNode) continue;
                    GraphConnector graphConnector2 = (GraphConnector)graphEdge.getAnchor().get(1);
                    GraphNode graphNode2 = (GraphNode)graphConnector2.eContainer();
                    if (graphNode.eContainer() != graphNode2.eContainer()) continue;
                    GraphNode graphNode3 = graphNode2;
                    if (graphNode2.getSemanticModel() instanceof UMASemanticModelBridge) {
                        graphNode3 = ((UMASemanticModelBridge)graphNode2.getSemanticModel()).getElement();
                    }
                    if (graphNode3 != null) {
                        Node node2 = GraphicalDataHelper.findNode(diagram, (Object)graphNode3);
                        link = ModelFactory.eINSTANCE.createLink();
                        link.setSource(node);
                        link.setTarget(node2);
                        link.setObject(graphEdge);
                        continue;
                    }
                    if (!LibraryEditPlugin.getDefault().isDebugging()) continue;
                    System.out.println("Linked object is null: for: " + node.getGraphNode() + ": for graphConnector: " + graphConnector2);
                }
            }
        }
        finally {
            node.eSetDeliver(bl);
        }
    }

    public static Node findNode(Diagram diagram, GraphNode graphNode, Class clazz) {
        SemanticModelBridge semanticModelBridge = graphNode.getSemanticModel();
        if (semanticModelBridge instanceof UMASemanticModelBridge) {
            INodeChangeListener iNodeChangeListener = (INodeChangeListener)UmaUtil.getAdapter((EObject)((UMASemanticModelBridge)semanticModelBridge).getElement(), (Class)clazz);
            return iNodeChangeListener.getNode();
        }
        for (Node node : diagram.getNodes()) {
            if (graphNode != node.getObject()) continue;
            return node;
        }
        return null;
    }

    public static Node findNode(NodeContainer nodeContainer, Object object) {
        for (Node node : nodeContainer.getNodes()) {
            if (object != node.getObject() && object != node.getLinkedElement()) continue;
            return node;
        }
        return null;
    }

    public static Node findNode(NodeContainer nodeContainer, Object object, boolean bl) {
        for (Node node : nodeContainer.getNodes()) {
            if (object == node.getObject()) {
                return node;
            }
            if (!bl || !(node.getObject() instanceof VariabilityElement)) continue;
            VariabilityElement variabilityElement = ((VariabilityElement)node.getObject()).getVariabilityBasedOnElement();
            while (variabilityElement != null) {
                if (variabilityElement == object) {
                    return node;
                }
                variabilityElement = variabilityElement.getVariabilityBasedOnElement();
            }
        }
        return null;
    }

    public static Node findNode(ActivityDetailDiagram activityDetailDiagram, Object object) {
        Node node = null;
        for (Node node2 : activityDetailDiagram.getNodes()) {
            if ((node2 instanceof RoleTaskComposite || node2 instanceof WorkProductComposite) && (node = GraphicalDataHelper.findNode((NodeContainer)node2, object)) != null) {
                return node;
            }
            if (object != node2.getObject()) continue;
            return node2;
        }
        return null;
    }

    public static Node findNode(ActivityDetailDiagram activityDetailDiagram, Object object, Class clazz) {
        Node node = null;
        for (Node node2 : activityDetailDiagram.getNodes()) {
            if ((node2 instanceof RoleTaskComposite || node2 instanceof WorkProductComposite) && (node = GraphicalDataHelper.findNode((NodeContainer)node2, object)) != null) {
                return node;
            }
            if (object != node2.getObject() || !clazz.isInstance(node2)) continue;
            return node2;
        }
        return null;
    }

    public static Link findLink(Node node, Object object) {
        for (Link link : node.getOutgoingConnections()) {
            Node node2 = link.getTarget();
            if (node2.getLinkedElement() != object) continue;
            return link;
        }
        return null;
    }

    private static String getTypeString(int n) {
        switch (n) {
            case 2: {
                return GRAPH_NODE_DECISION;
            }
            case 4: {
                return GRAPH_NODE_END;
            }
            case 3: {
                return GRAPH_NODE_START;
            }
            case 1: {
                return GRAPH_NODE_SYNCH_BAR;
            }
            case 6: {
                return GRAPH_NODE_FREE_TEXT;
            }
        }
        return null;
    }

    public static GraphNode newTypedGraphNode(int n) {
        GraphNode graphNode = UmaFactory.eINSTANCE.createGraphNode();
        SimpleSemanticModelElement simpleSemanticModelElement = UmaFactory.eINSTANCE.createSimpleSemanticModelElement();
        simpleSemanticModelElement.setTypeInfo(GraphicalDataHelper.getTypeString(n));
        graphNode.setSemanticModel((SemanticModelBridge)simpleSemanticModelElement);
        org.eclipse.epf.uma.Point point = UmaFactory.eINSTANCE.createPoint();
        point.setX(new Double(-1.0));
        point.setY(new Double(-1.0));
        graphNode.setPosition(point);
        Dimension dimension = UmaFactory.eINSTANCE.createDimension();
        dimension.setWidth(new Double(-1.0));
        dimension.setHeight(new Double(-1.0));
        graphNode.setSize(dimension);
        if (n == 6) {
            graphNode.setName(DiagramResources.addFreeTxt);
        }
        if (n == 6) {
            Property property = UmaFactory.eINSTANCE.createProperty();
            property.setKey(GRAPH_NODE_FREE_TEXT);
            property.setValue(DiagramResources.addFreeTxt);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(property);
            graphNode.set(10, arrayList);
        }
        return graphNode;
    }

    public static void removeGraphicalData(Link link) {
        GraphEdge graphEdge = (GraphEdge)link.getObject();
        if (graphEdge != null) {
            GraphicalDataManager.getInstance().removeGraphEdge(graphEdge);
        }
    }

    public static void addGraphicalData(Link link) {
        GraphEdge graphEdge = (GraphEdge)link.getObject();
        if (graphEdge == null) {
            graphEdge = GraphicalDataManager.getInstance().addGraphConnectorPair(link.getSource().getGraphNode(), link.getTarget().getGraphNode());
            link.setObject(graphEdge);
            link.setSourceEndPoint(link.getSourceEndPoint());
            link.setTargetEndPoint(link.getTargetEndPoint());
        } else {
            GraphNode graphNode = link.getSource().getGraphNode();
            GraphNode graphNode2 = link.getTarget().getGraphNode();
            Object e = graphEdge.getAnchor().get(0);
            graphNode.getAnchorage().add(e);
            graphNode.getContained().add(graphEdge);
            Object e2 = graphEdge.getAnchor().get(1);
            graphNode2.getAnchorage().add(e2);
        }
    }

    public static void setSemanticModel(Link link, WorkOrder workOrder) {
        GraphEdge graphEdge = (GraphEdge)link.getObject();
        UMASemanticModelBridge uMASemanticModelBridge = UmaFactory.eINSTANCE.createUMASemanticModelBridge();
        uMASemanticModelBridge.setElement((MethodElement)workOrder);
        graphEdge.setSemanticModel((SemanticModelBridge)uMASemanticModelBridge);
    }

    public static Collection getSourceNodes(TypedNode typedNode, Class clazz) {
        ArrayList arrayList = new ArrayList();
        GraphicalDataHelper.getSourceNodes(arrayList, typedNode, clazz);
        return arrayList;
    }

    public static Collection getTargetNodes(TypedNode typedNode, Class clazz) {
        ArrayList arrayList = new ArrayList();
        GraphicalDataHelper.getTargetNodes(arrayList, typedNode, clazz);
        return arrayList;
    }

    public static void getTargetNodes(Collection collection, TypedNode typedNode, Class clazz) {
        for (Link link : typedNode.getOutgoingConnections()) {
            Node node = link.getTarget();
            if (clazz.isInstance(node)) {
                collection.add(node);
                continue;
            }
            if (!(node instanceof TypedNode)) continue;
            GraphicalDataHelper.getTargetNodes(collection, (TypedNode)node, clazz);
        }
    }

    public static void getSourceNodes(Collection collection, TypedNode typedNode, Class clazz) {
        for (Link link : typedNode.getIncomingConnections()) {
            Node node = link.getSource();
            if (clazz.isInstance(node)) {
                collection.add(node);
                continue;
            }
            if (!(node instanceof TypedNode)) continue;
            GraphicalDataHelper.getSourceNodes(collection, (TypedNode)node, clazz);
        }
    }

    public static Node getFirstSourceNode(TypedNode typedNode, Class clazz) {
        for (Link link : typedNode.getIncomingConnections()) {
            Node node = link.getSource();
            if (clazz.isInstance(node)) {
                return node;
            }
            if (!(node instanceof TypedNode) || (node = GraphicalDataHelper.getFirstSourceNode((TypedNode)node, clazz)) == null) continue;
            return node;
        }
        return null;
    }

    public static WorkOrder removeWorkOrder(NamedNodeImpl namedNodeImpl, Object object) {
        boolean bl = namedNodeImpl.isNotificationEnabled();
        try {
            namedNodeImpl.setNotificationEnabled(false);
            WorkOrder workOrder = UmaUtil.removeWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)namedNodeImpl.getObject()), (Object)object);
            return workOrder;
        }
        finally {
            namedNodeImpl.setNotificationEnabled(bl);
        }
    }

    public static WorkOrder addDefaultWorkOrder(NamedNodeImpl namedNodeImpl, WorkBreakdownElement workBreakdownElement) {
        boolean bl = namedNodeImpl.isNotificationEnabled();
        try {
            namedNodeImpl.setNotificationEnabled(false);
            WorkOrder workOrder = UmaUtil.createDefaultWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)namedNodeImpl.getObject()), (WorkBreakdownElement)workBreakdownElement);
            return workOrder;
        }
        finally {
            namedNodeImpl.setNotificationEnabled(bl);
        }
    }

    public static boolean hasNoRoleDescriptorAssociated(TaskDescriptor taskDescriptor) {
        return taskDescriptor.getPerformedPrimarilyBy() == null;
    }

    public static boolean contains(NodeContainer nodeContainer, Node node) {
        for (Object e : nodeContainer.getNodes()) {
            if (e == node) {
                return true;
            }
            if (!(e instanceof NodeContainer) || !GraphicalDataHelper.contains((NodeContainer)e, node)) continue;
            return true;
        }
        return false;
    }

    public static boolean refreshFromBase(org.eclipse.epf.uma.Diagram diagram) {
        SemanticModelBridge semanticModelBridge = diagram.getSemanticModel();
        if (semanticModelBridge instanceof UMASemanticModelBridge) {
            UMASemanticModelBridge uMASemanticModelBridge = (UMASemanticModelBridge)semanticModelBridge;
            Activity activity = (Activity)uMASemanticModelBridge.getElement();
            Activity activity2 = (Activity)activity.getVariabilityBasedOnElement();
            if (activity2 == null || activity.getVariabilityType() == VariabilityType.LOCAL_REPLACEMENT_LITERAL) {
                return false;
            }
            int n = GraphicalDataManager.getInstance().getDiagramType(diagram);
            switch (n) {
                case 0: {
                    GraphNode graphNode;
                    MethodElement methodElement;
                    org.eclipse.epf.uma.Diagram diagram2 = GraphicalDataManager.getInstance().getUMADiagram(activity2, n, false);
                    if (diagram2 == null) {
                        return false;
                    }
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    org.eclipse.epf.uma.Diagram diagram3 = GraphicalDataHelper.copyDiagram(diagram2);
                    for (Object object : diagram2.getContained()) {
                        semanticModelBridge = object.getSemanticModel();
                        if (semanticModelBridge instanceof UMASemanticModelBridge) {
                            methodElement = ((UMASemanticModelBridge)semanticModelBridge).getElement();
                            graphNode = GraphicalDataManager.findGraphNode(diagram, methodElement);
                            if (graphNode == null) continue;
                            arrayList.add(graphNode);
                            continue;
                        }
                        if (!GraphicalDataHelper.isUIGraphNode(object) || (methodElement = GraphicalDataHelper.findUIGraphNode(diagram, object.getGuid())) == null) continue;
                        arrayList.add(methodElement);
                    }
                    diagram.getContained().removeAll(arrayList);
                    Iterator iterator = diagram.getContained().iterator();
                    while (iterator.hasNext()) {
                        Object object;
                        object = (GraphNode)iterator.next();
                        if (GraphicalDataHelper.isUIGraphNode(object) && object.getBriefDescription() != null && object.getBriefDescription().length() > 0) {
                            iterator.remove();
                            continue;
                        }
                        methodElement = object.getSemanticModel();
                        if (!(methodElement instanceof UMASemanticModelBridge) || !((graphNode = ((UMASemanticModelBridge)methodElement).getElement()) instanceof Activity) || ((Activity)graphNode).getVariabilityBasedOnElement() == null) continue;
                        iterator.remove();
                    }
                    for (Object object : activity.getBreakdownElements()) {
                        if (!(object instanceof Activity) || (graphNode = GraphicalDataManager.findGraphNode(diagram3, methodElement = ((Activity)object).getVariabilityBasedOnElement())) == null) continue;
                        UMASemanticModelBridge uMASemanticModelBridge2 = (UMASemanticModelBridge)graphNode.getSemanticModel();
                        uMASemanticModelBridge2.setElement((MethodElement)object);
                    }
                    diagram.getContained().addAll(diagram3.getContained());
                    break;
                }
                default: {
                    org.eclipse.epf.uma.Diagram diagram4 = GraphicalDataManager.getInstance().getUMADiagram(activity2, n, false);
                    if (diagram4 == null) {
                        return false;
                    }
                    ArrayList<GraphNode> arrayList = new ArrayList<GraphNode>();
                    org.eclipse.epf.uma.Diagram diagram5 = GraphicalDataHelper.copyDiagram(diagram4);
                    for (GraphNode graphNode : diagram4.getContained()) {
                        MethodElement methodElement;
                        GraphNode graphNode2;
                        semanticModelBridge = graphNode.getSemanticModel();
                        if (!(semanticModelBridge instanceof UMASemanticModelBridge) || (graphNode2 = GraphicalDataManager.findGraphNode(diagram, methodElement = ((UMASemanticModelBridge)semanticModelBridge).getElement())) == null) continue;
                        arrayList.add(graphNode2);
                    }
                    diagram.getContained().removeAll(arrayList);
                    diagram.getContained().addAll(diagram5.getContained());
                }
            }
        }
        return false;
    }

    private static GraphNode findUIGraphNode(org.eclipse.epf.uma.Diagram diagram, String string) {
        for (GraphNode graphNode : diagram.getContained()) {
            if (!GraphicalDataHelper.isUIGraphNode(graphNode) || !string.equals(graphNode.getBriefDescription())) continue;
            return graphNode;
        }
        return null;
    }

    public static boolean isUIGraphNode(GraphNode graphNode) {
        String string;
        SemanticModelBridge semanticModelBridge = graphNode.getSemanticModel();
        return semanticModelBridge instanceof SimpleSemanticModelElement && ((string = ((SimpleSemanticModelElement)semanticModelBridge).getTypeInfo()).equals(GRAPH_NODE_DECISION) || string.equals(GRAPH_NODE_END) || string.equals(GRAPH_NODE_START) || string.equals(GRAPH_NODE_SYNCH_BAR) || string.equals(GRAPH_NODE_FREE_TEXT));
    }

    public static org.eclipse.epf.uma.Diagram copyDiagram(org.eclipse.epf.uma.Diagram diagram) {
        org.eclipse.epf.uma.Diagram diagram2 = (org.eclipse.epf.uma.Diagram)TngUtil.copy((MethodElement)diagram);
        int n = diagram2.getContained().size();
        int n2 = 0;
        while (n2 < n) {
            GraphNode graphNode = (GraphNode)diagram2.getContained().get(n2);
            if (GraphicalDataHelper.isUIGraphNode(graphNode)) {
                graphNode.setBriefDescription(((DiagramElement)diagram.getContained().get(n2)).getGuid());
            }
            ++n2;
        }
        return diagram2;
    }

    public static Collection getDiagrams(Activity activity) {
        return GraphicalDataHelper.getDiagrams(activity, false);
    }

    public static Collection getDiagrams(Activity activity, boolean bl) {
        ArrayList<org.eclipse.epf.uma.Diagram> arrayList = new ArrayList<org.eclipse.epf.uma.Diagram>();
        int n = 0;
        while (n < DIAGRAM_TYPES.length) {
            org.eclipse.epf.uma.Diagram diagram = GraphicalDataManager.getInstance().getUMADiagram(activity, DIAGRAM_TYPES[n], bl);
            if (diagram != null) {
                arrayList.add(diagram);
            }
            ++n;
        }
        return arrayList;
    }

    public static String getDiagramTypeText(org.eclipse.epf.uma.Diagram diagram) {
        int n = GraphicalDataManager.getInstance().getDiagramType(diagram);
        if (n != -1) {
            return DIAGRAM_TYPE_TEXTS[n];
        }
        return DiagramResources.type_unknown;
    }

    public static void setAllDiagramSuppressed(Process process, boolean bl) {
        AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(process){
            private static final long serialVersionUID = -618949014476371114L;

            protected Iterator getChildren(Object object) {
                Activity activity = (Activity)object;
                ArrayList arrayList = new ArrayList();
                for (Object e : activity.getBreakdownElements()) {
                    if (!(e instanceof Activity)) continue;
                    arrayList.add(e);
                }
                return arrayList.iterator();
            }
        };
        while (abstractTreeIterator.hasNext()) {
            Collection collection = GraphicalDataHelper.getDiagrams((Activity)abstractTreeIterator.next(), bl);
            for (org.eclipse.epf.uma.Diagram diagram : collection) {
                diagram.setSuppressed(Boolean.valueOf(bl));
            }
        }
    }

    public static void removeLink(Link link) {
        Node node = link.getSource();
        Node node2 = link.getTarget();
        boolean bl = node != null ? node.eDeliver() : false;
        boolean bl2 = node2 != null ? node2.eDeliver() : false;
        try {
            if (node != null) {
                node.eSetDeliver(false);
            }
            if (node2 != null) {
                node2.eSetDeliver(false);
            }
            link.setSource(null);
            link.setTarget(null);
        }
        finally {
            if (node != null) {
                node.eSetDeliver(bl);
            }
            if (node2 != null) {
                node2.eSetDeliver(bl2);
            }
        }
    }

    public static Object findElement(Collection collection, Object object) {
        for (Object e : collection) {
            Object object2;
            if (object == TngUtil.unwrap(e)) {
                return e;
            }
            if (!(e instanceof WorkProductDescriptorWrapperItemProvider) || (object2 = GraphicalDataHelper.findElement(((WorkProductDescriptorWrapperItemProvider)e).getChildren(e), object)) == null) continue;
            return object2;
        }
        return null;
    }

    public static boolean anyDuplicatePredecessors(WorkBreakdownElement workBreakdownElement) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        GraphicalDataHelper.getPreds(workBreakdownElement, arrayList2);
        for (Object e : arrayList2) {
            if (!arrayList.contains(e)) {
                arrayList.add(e);
                continue;
            }
            return true;
        }
        return false;
    }

    public static void getPreds(WorkBreakdownElement workBreakdownElement, List list) {
        List list2 = workBreakdownElement.getLinkToPredecessor();
        for (WorkOrder workOrder : list2) {
            list.add(workOrder.getPred());
        }
    }

    public static boolean canRemoveAllPreds(Link link, Node node, Node node2) {
        if (node2 instanceof WorkBreakdownElementNode) {
            EList<Link> eList = node2.getIncomingConnections();
            for (Link link2 : eList) {
                Collection collection;
                if (!(link2.getSource() instanceof TypedNode && ((TypedNode)link2.getSource()).getType() == 1 ? (collection = GraphicalDataHelper.getSourceNodes((TypedNode)link2.getSource(), WorkBreakdownElementNode.class)).contains(node) : link2.getSource() instanceof WorkBreakdownElementNode && link2.getSource().equals(node))) continue;
                return false;
            }
        }
        return true;
    }

    public static void getSyncBarSourceNodes(TypedNode typedNode, Collection collection) {
        for (Link link : typedNode.getIncomingConnections()) {
            Node node = link.getSource();
            if (node instanceof WorkBreakdownElementNode) {
                collection.add(node);
                continue;
            }
            if (!(node instanceof TypedNode) || ((TypedNode)node).getType() != 1) continue;
            GraphicalDataHelper.getSyncBarSourceNodes((TypedNode)node, collection);
        }
    }

    public static void getSyncBarTargetNodes(TypedNode typedNode, Collection collection) {
        for (Link link : typedNode.getOutgoingConnections()) {
            Node node = link.getTarget();
            if (node instanceof WorkBreakdownElementNode) {
                collection.add(node);
                continue;
            }
            if (!(node instanceof TypedNode) || ((TypedNode)node).getType() != 1) continue;
            GraphicalDataHelper.getSyncBarTargetNodes((TypedNode)node, collection);
        }
    }

    public static Node findNode(NodeContainer nodeContainer, Object object, Class clazz) {
        for (Node node : nodeContainer.getNodes()) {
            if (object != node.getObject() || !clazz.isInstance(node)) continue;
            return node;
        }
        return null;
    }

    public static Property createProperty(GraphNode graphNode, String string, String string2) {
        Property property = null;
        if (graphNode != null) {
            property = GraphicalDataHelper.findProperty(graphNode, string);
        }
        if (property == null) {
            property = UmaFactory.eINSTANCE.createProperty();
            property.setKey(string);
            property.setValue(string2);
            ArrayList<Property> arrayList = graphNode.getList(10);
            if (arrayList == null) {
                arrayList = new ArrayList<Property>();
                graphNode.set(10, arrayList);
            }
            arrayList.add(property);
        } else {
            property.setValue(string2);
        }
        return property;
    }

    public static String getAutoLayoutFlag(ActivityDetailDiagram activityDetailDiagram) {
        Property property;
        List list;
        String string = null;
        GraphNode graphNode = activityDetailDiagram.getGraphNode();
        if (graphNode != null && (list = graphNode.getList(10)) != null && list.size() > 0 && (property = GraphicalDataHelper.findProperty(graphNode, PROP_AUTO_LAYOUT)) != null) {
            string = property.getValue();
        }
        return string;
    }

    public static boolean isAutoLayout(ActivityDetailDiagram activityDetailDiagram) {
        String string;
        Property property;
        List list;
        GraphNode graphNode = activityDetailDiagram.getGraphNode();
        if (graphNode != null && (list = graphNode.getList(10)) != null && list.size() > 0 && (property = GraphicalDataHelper.findProperty(graphNode, PROP_AUTO_LAYOUT)) != null && (string = property.getValue()) != null && string != "" && (PROP_AUTO_LAYOUT_VALUE_TRUE.equals(string) || PROP_AUTO_LAYOUT_VALUE_FALSE.equals(string))) {
            return new Boolean(string);
        }
        return false;
    }

    public static int getTasksPerRow() {
        String string = LibraryEditPlugin.getDefault().getPreferenceStore().getString(ADD_DIAGRAM_TASKS_PER_ROW);
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return 10;
            }
        }
        return 10;
    }

    public static Property getPropertyByKey(List list, String string) {
        if (!list.isEmpty()) {
            for (Property property : list) {
                if (property == null || !property.getKey().equals(string)) continue;
                return property;
            }
        }
        return null;
    }

    public static Property getProperty(Node node, String string) {
        List list;
        GraphNode graphNode = node.getGraphNode();
        if (graphNode != null && (list = graphNode.getProperty()) != null && !list.isEmpty()) {
            int n = list.size() - 1;
            while (n > -1) {
                Property property = (Property)list.get(n);
                if (string.equals(property.getKey())) {
                    return property;
                }
                --n;
            }
        }
        return null;
    }
}

