/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.custom.commands;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;

public class ActivityPartitionDestroyCommand
extends DestroyElementCommand {
    private EditPart host;

    public ActivityPartitionDestroyCommand(DestroyElementRequest destroyElementRequest, EditPart editPart) {
        super(destroyElementRequest);
        this.host = editPart;
    }

    protected EObject getElementToDestroy() {
        View view = (View)this.host.getModel();
        EAnnotation eAnnotation = view.getEAnnotation("Shortcut");
        if (eAnnotation != null) {
            return view;
        }
        return super.getElementToDestroy();
    }

    protected void tearDownIncomingReferences(EObject eObject) {
        int n;
        Collection collection;
        CrossReferenceAdapter crossReferenceAdapter = CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)eObject);
        if (crossReferenceAdapter != null && (collection = crossReferenceAdapter.getInverseReferences(eObject)) != null && (n = collection.size()) > 0) {
            EStructuralFeature.Setting[] settingArray = collection.toArray(new EStructuralFeature.Setting[n]);
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature.Setting setting = settingArray[n2];
                EReference eReference = (EReference)setting.getEStructuralFeature();
                if (eReference.isChangeable() && !eReference.isDerived() && !eReference.isContainment() && !eReference.isContainer()) {
                    EcoreUtil.remove((EObject)setting.getEObject(), (EStructuralFeature)eReference, (Object)eObject);
                }
                ++n2;
            }
        }
    }

    private void moveChildrensToParent(EObject eObject) {
        if (eObject instanceof ActivityPartition) {
            ActivityPartition activityPartition = (ActivityPartition)eObject;
            Activity activity = activityPartition.getInActivity();
            EList eList = activityPartition.getNodes();
            for (ActivityNode activityNode : eList) {
                activity.getNodes().add((Object)activityNode);
                activityNode.getInPartitions().remove((Object)activityPartition);
            }
            for (ActivityNode activityNode : activityPartition.getEdges()) {
                activity.getEdges().add((Object)activityNode);
                activityNode.getInPartitions().remove((Object)activityPartition);
            }
        }
    }
}

