/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.custom.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.epf.diagram.ad.edit.parts.ActivityPartitionEditPart;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.AddCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.UMLPackage;

public class ActivityXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected Command createAddCommand(EditPart editPart, Object object) {
        EditPart editPart2 = editPart.getParent();
        if (editPart2 instanceof ActivityPartitionEditPart && editPart instanceof ShapeEditPart && object instanceof Rectangle) {
            boolean bl;
            Rectangle rectangle = (Rectangle)object;
            IFigure iFigure = ((ActivityPartitionEditPart)editPart2).getFigure();
            View view = (View)editPart.getModel();
            boolean bl2 = bl = ViewUtil.resolveSemanticElement((View)view) != null || iFigure.getBounds().contains(rectangle.getLocation());
            if (bl) {
                int n = rectangle.x - ((ActivityPartitionEditPart)editPart2).getLocation().x;
                int n2 = rectangle.y - ((ActivityPartitionEditPart)editPart2).getLocation().y;
                SetBoundsCommand setBoundsCommand = new SetBoundsCommand(((ShapeEditPart)editPart).getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)view), new Point(n, n2));
                return new ICommandProxy((ICommand)setBoundsCommand);
            }
        }
        return super.createAddCommand(editPart, object);
    }

    protected Command getMoveChildrenCommand(Request request) {
        return super.getMoveChildrenCommand(request);
    }

    protected Command createChangeConstraintCommand(EditPart editPart, Object object) {
        return super.createChangeConstraintCommand(editPart, object);
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest changeBoundsRequest, EditPart editPart, Object object) {
        Command command;
        block5: {
            block4: {
                command = super.createChangeConstraintCommand(changeBoundsRequest, editPart, object);
                if (!(editPart instanceof ActivityPartitionEditPart)) break block4;
                List list = ActivityXYLayoutEditPolicy.getNodesInPartition((ActivityPartitionEditPart)editPart);
                if (list == null || list.isEmpty()) break block5;
                for (EditPart editPart2 : list) {
                    if (!(editPart2 instanceof ShapeNodeEditPart)) continue;
                    ChangeBoundsRequest changeBoundsRequest2 = new ChangeBoundsRequest((Object)"resize children");
                    changeBoundsRequest2.setEditParts(editPart2);
                    changeBoundsRequest2.setMoveDelta(changeBoundsRequest.getMoveDelta());
                    changeBoundsRequest2.setSizeDelta(changeBoundsRequest.getSizeDelta());
                    changeBoundsRequest2.setLocation(changeBoundsRequest.getLocation());
                    changeBoundsRequest2.setExtendedData(changeBoundsRequest.getExtendedData());
                    changeBoundsRequest2.setResizeDirection(changeBoundsRequest.getResizeDirection());
                    command = command.chain(editPart2.getParent().getCommand((Request)changeBoundsRequest2));
                }
                break block5;
            }
            EditPart editPart3 = editPart.getParent();
            if (editPart3 instanceof DiagramEditPart) {
                List list = ((DiagramEditPart)editPart3).getChildren();
                for (EditPart editPart4 : list) {
                    if (!(editPart4 instanceof ActivityPartitionEditPart)) continue;
                    Node node = (Node)editPart4.getModel();
                    LayoutConstraint layoutConstraint = node.getLayoutConstraint();
                    if (layoutConstraint instanceof Bounds) {
                        Rectangle rectangle = ((ActivityPartitionEditPart)editPart4).getFigure().getBounds();
                        if (!(object instanceof Rectangle) || !rectangle.contains((Rectangle)object)) continue;
                        changeBoundsRequest.setType((Object)"create child");
                        command = command.chain(editPart4.getCommand((Request)changeBoundsRequest));
                        continue;
                    }
                    if (!ActivityDiagramEditorPlugin.getInstance().isDebugging()) continue;
                    System.out.println("LayoutConstraint: " + layoutConstraint);
                }
            }
        }
        return command;
    }

    private static List getNodesInPartition(ActivityPartitionEditPart activityPartitionEditPart) {
        ArrayList<EditPart> arrayList = new ArrayList<EditPart>();
        ActivityPartition activityPartition = (ActivityPartition)((Node)activityPartitionEditPart.getModel()).getElement();
        EList eList = activityPartition.getNodes();
        for (Object e : eList) {
            arrayList.add(ActivityXYLayoutEditPolicy.findEditPartyByElement(activityPartitionEditPart.getParent(), e));
        }
        return arrayList;
    }

    private static EditPart findEditPartyByElement(EditPart editPart, Object object) {
        List list = editPart.getChildren();
        for (EditPart editPart2 : list) {
            if (((Node)editPart2.getModel()).getElement() != object) continue;
            return editPart2;
        }
        return null;
    }

    protected Command getAddCommand(Request request) {
        CompoundCommand compoundCommand = new CompoundCommand();
        compoundCommand.setDebugLabel("Add in ConstrainedLayoutEditPolicy with Reparent if necessary");
        compoundCommand.add(super.getAddCommand(request));
        if (request instanceof ChangeBoundsRequest && request.getType() == "add children") {
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            List list = changeBoundsRequest.getEditParts();
            int n = 0;
            while (n < list.size()) {
                IGraphicalEditPart iGraphicalEditPart = (IGraphicalEditPart)list.get(n);
                IGraphicalEditPart iGraphicalEditPart2 = (IGraphicalEditPart)iGraphicalEditPart.getParent();
                if (iGraphicalEditPart2 instanceof ActivityPartitionEditPart) {
                    Point point = iGraphicalEditPart.getFigure().getBounds().getLocation().getCopy();
                    point.translate(changeBoundsRequest.getMoveDelta());
                    if (!iGraphicalEditPart2.getFigure().getBounds().contains(point)) {
                        compoundCommand.add(this.getReparentCommand(iGraphicalEditPart, iGraphicalEditPart2, changeBoundsRequest));
                    }
                }
                ++n;
            }
        }
        return compoundCommand.unwrap();
    }

    protected Command getReparentCommand(IGraphicalEditPart iGraphicalEditPart, IGraphicalEditPart iGraphicalEditPart2, ChangeBoundsRequest changeBoundsRequest) {
        CompositeCommand compositeCommand = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        View view = (View)this.getHost().getModel();
        EObject eObject = ViewUtil.resolveSemanticElement((View)view);
        View view2 = (View)iGraphicalEditPart.getModel();
        EObject eObject2 = ViewUtil.resolveSemanticElement((View)view2);
        TransactionalEditingDomain transactionalEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (eObject2 != null) {
            compositeCommand.compose((IUndoableOperation)new ReparentingElementsCommand(new MoveRequest(transactionalEditingDomain, eObject, UMLPackage.eINSTANCE.getActivity_Node(), eObject2), eObject2, view2, iGraphicalEditPart2));
            compositeCommand.compose((IUndoableOperation)new AddCommand(iGraphicalEditPart.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)view), (IAdaptable)new EObjectAdapter((EObject)view2)));
            compositeCommand.compose((IUndoableOperation)this.adjustLocationCommand(iGraphicalEditPart, changeBoundsRequest));
        }
        return compositeCommand.isEmpty() ? null : new ICommandProxy(compositeCommand.reduce());
    }

    private ICommand adjustLocationCommand(IGraphicalEditPart iGraphicalEditPart, ChangeBoundsRequest changeBoundsRequest) {
        if (iGraphicalEditPart instanceof ShapeEditPart) {
            Point point = changeBoundsRequest.getMoveDelta().getCopy();
            Point point2 = iGraphicalEditPart.getFigure().getBounds().getLocation();
            point.x += point2.x;
            point.y += point2.y;
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(((ShapeEditPart)iGraphicalEditPart).getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)((View)iGraphicalEditPart.getModel())), point);
            return setBoundsCommand;
        }
        return null;
    }

    public class ReparentingElementsCommand
    extends EditElementCommand {
        private final EObject moveElement;
        private IGraphicalEditPart oldParent;
        private View view;

        public ReparentingElementsCommand(MoveRequest moveRequest, EObject eObject, View view, IGraphicalEditPart iGraphicalEditPart) {
            this("reparent on move", eObject, (IEditCommandRequest)moveRequest);
            this.oldParent = iGraphicalEditPart;
            this.view = view;
        }

        protected ReparentingElementsCommand(String string, EObject eObject, IEditCommandRequest iEditCommandRequest) {
            super(string, eObject, iEditCommandRequest);
            this.moveElement = eObject;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
            View view = (View)ActivityXYLayoutEditPolicy.this.getHost().getModel();
            if (view.getElement() instanceof Activity && this.moveElement instanceof ActivityNode) {
                View view2 = (View)this.oldParent.getModel();
                ((ActivityNode)this.moveElement).getInPartitions().remove((Object)view2.getElement());
            }
            return null;
        }

        public boolean canExecute() {
            return this.moveElement != null;
        }
    }
}

