/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.internal.tools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.gef.ui.internal.l10n.Cursors;
import org.eclipse.swt.graphics.Cursor;

public class SelectConnectionEditPartTracker
extends SelectEditPartTracker {
    private Request sourceRequest;
    private int index = -1;
    private String type;
    private boolean bSourceFeedback = false;

    public SelectConnectionEditPartTracker(ConnectionEditPart owner) {
        super((EditPart)owner);
    }

    protected boolean handleButtonDown(int button) {
        if (!super.handleButtonDown(button)) {
            return false;
        }
        Point p = this.getLocation();
        this.getConnection().translateToRelative((Translatable)p);
        PointList points = this.getConnection().getPoints();
        Dimension size = new Dimension(7, 7);
        int i = 1;
        while (i < points.size() - 1) {
            Point ptCenter = points.getPoint(i);
            Rectangle rect = new Rectangle(ptCenter.x - size.width / 2, ptCenter.y - size.height / 2, size.width, size.height);
            if (rect.contains(p)) {
                this.setType("move bendpoint");
                this.setIndex(i);
            }
            ++i;
        }
        if (this.getIndex() == -1) {
            this.setIndex(PointListUtilities.findNearestLineSegIndexOfPoint((PointList)this.getConnection().getPoints(), (Point)new Point(p.x, p.y)));
            this.setIndex(this.getIndex() - 1);
            this.setType("create bendpoint");
        }
        return true;
    }

    protected boolean shouldAllowDrag() {
        return this.getIndex() != -1;
    }

    protected boolean handleButtonUp(int button) {
        boolean bExecuteDrag = this.isInState(4) && this.shouldAllowDrag();
        boolean bRet = super.handleButtonUp(button);
        if (bExecuteDrag) {
            this.eraseSourceFeedback();
            this.setCurrentCommand(this.getCommand());
            this.executeCurrentCommand();
        }
        return bRet;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(4) && this.shouldAllowDrag()) {
            this.updateSourceRequest();
            this.showSourceFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected boolean handleDragStarted() {
        return this.stateTransition(2, 4);
    }

    protected Cursor calculateCursor() {
        if (this.getType() == "move bendpoint") {
            return Cursors.CURSOR_SEG_MOVE;
        }
        return this.getConnection().getCursor();
    }

    public void deactivate() {
        if (!this.isInState(0x40000000)) {
            this.eraseSourceFeedback();
        }
        this.sourceRequest = null;
        super.deactivate();
    }

    private boolean isShowingFeedback() {
        return this.bSourceFeedback;
    }

    private void setShowingFeedback(boolean bSet) {
        this.bSourceFeedback = bSet;
    }

    protected List createOperationSet() {
        ArrayList<ConnectionEditPart> list = new ArrayList<ConnectionEditPart>();
        list.add(this.getConnectionEditPart());
        return list;
    }

    private void showSourceFeedback() {
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            editPart.showSourceFeedback(this.getSourceRequest());
            ++i;
        }
        this.setShowingFeedback(true);
    }

    private void eraseSourceFeedback() {
        if (!this.isShowingFeedback()) {
            return;
        }
        this.setShowingFeedback(false);
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            editPart.eraseSourceFeedback(this.getSourceRequest());
            ++i;
        }
    }

    private Request getSourceRequest() {
        if (this.sourceRequest == null) {
            this.sourceRequest = this.createSourceRequest();
        }
        return this.sourceRequest;
    }

    protected Object getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected Request createSourceRequest() {
        BendpointRequest request = new BendpointRequest();
        request.setType(this.getType());
        request.setIndex(this.getIndex());
        request.setSource((ConnectionEditPart)this.getSourceEditPart());
        return request;
    }

    protected Command getCommand() {
        return this.getSourceEditPart().getCommand(this.getSourceRequest());
    }

    protected String getCommandName() {
        return this.getType().toString();
    }

    private Connection getConnection() {
        return (Connection)this.getConnectionEditPart().getFigure();
    }

    private ConnectionEditPart getConnectionEditPart() {
        return (ConnectionEditPart)this.getSourceEditPart();
    }

    protected String getDebugName() {
        return "Bendpoint Handle Tracker " + this.getCommandName();
    }

    protected int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    protected void updateSourceRequest() {
        BendpointRequest request = (BendpointRequest)this.getSourceRequest();
        request.setLocation(this.getLocation());
    }
}

