/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.serviceability;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.common.serviceability.EPFVersion;
import org.eclipse.epf.common.serviceability.EPFVersions;
import org.eclipse.epf.common.serviceability.ILibraryExtensionVersionCheck;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionUtil {
    public static final String EXTENSION_POINT_NAMESPACE;
    public static final String EXTENSION_POINT_NAME = "version";
    public static final String EXTENSION_VERSIONS_INFO = "versions";
    public static final String EXTENSION_LIB_EXTENSION_CHECK = "libraryExtensionVersionCheck";
    private static final String DISABLE_VERSION_CHECKING_PREF = "disable_version_checking";
    public static Map<String, EPFVersions> versions;
    public static Map<String, ILibraryExtensionVersionCheck> libExtCheckers;
    protected static boolean versionCheckingDisabled;
    private static List<String> toolIDsCheckList;
    public static final Pattern p_XMIVersionPattern;
    public static final Pattern p_XMLVersionAttributePattern;
    public static final Pattern p_XMI_ELEMENT_START_TAG;
    public static final String XML_ELEMENT_END_TAG = ">";
    public static final String XMI_ATTRIBUTE_TAG = "xmi";
    public static final String XML_ELEMENT_START_TAG = "<uma:MethodLibrary";
    public static final String XML_VERSIONS_SEPARATOR = ";";
    public static final String XML_TOOL_VERSION_SEPARATOR = "=";

    static {
        String string;
        EXTENSION_POINT_NAMESPACE = CommonPlugin.class.getPackage().getName();
        versions = new LinkedHashMap<String, EPFVersions>();
        libExtCheckers = new LinkedHashMap<String, ILibraryExtensionVersionCheck>();
        versionCheckingDisabled = false;
        toolIDsCheckList = new ArrayList<String>();
        toolIDsCheckList.add("epf");
        try {
            string = CommonPlugin.getDefault().getPreferenceStore().getString(DISABLE_VERSION_CHECKING_PREF);
            versionCheckingDisabled = Boolean.valueOf(string);
        }
        catch (MissingResourceException missingResourceException) {
            versionCheckingDisabled = false;
        }
        string = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = string.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IExtension iExtension = iExtensionArray[n];
                VersionUtil.initExtension(iExtension);
                ++n;
            }
        }
        p_XMIVersionPattern = Pattern.compile("(\\w+?):version=\"(.+?)\"", 32);
        p_XMLVersionAttributePattern = Pattern.compile("tool=\"(.*?)\"", 32);
        p_XMI_ELEMENT_START_TAG = Pattern.compile("<?xml version=\".+?\" encoding=\".+?\"?>");
    }

    protected static void initExtension(IExtension iExtension) {
        String string = iExtension.getSimpleIdentifier();
        String string2 = iExtension.getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)string2);
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            try {
                String string3;
                if (EXTENSION_VERSIONS_INFO.equals(iConfigurationElement.getName()) && (string3 = iConfigurationElement.getAttribute("class")) != null) {
                    versions.put(string, (EPFVersions)bundle.loadClass(string3).newInstance());
                    break;
                }
                if (EXTENSION_LIB_EXTENSION_CHECK.equals(iConfigurationElement.getName()) && (string3 = iConfigurationElement.getAttribute("class")) != null) {
                    libExtCheckers.put(string, (ILibraryExtensionVersionCheck)bundle.loadClass(string3).newInstance());
                    break;
                }
            }
            catch (Exception exception) {
                CommonPlugin.getDefault().getLogger().logError(exception);
            }
            ++n;
        }
    }

    public static Map getVersionsMap() {
        return Collections.unmodifiableMap(versions);
    }

    public static Set<String> getAllToolIDs() {
        return Collections.unmodifiableSet(versions.keySet());
    }

    public static EPFVersions getVersions(String string) {
        return versions.get(string);
    }

    public static boolean isVersionCheckingDisabled() {
        return versionCheckingDisabled;
    }

    protected static Map readVersionsFromXMLFile(File file) {
        String string;
        String string2;
        Matcher matcher;
        int n;
        int n2;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        StringBuffer stringBuffer = null;
        try {
            stringBuffer = FileUtil.readFile(file, "UTF-8");
        }
        catch (Exception exception) {
            CommonPlugin.getDefault().getLogger().logError(exception);
        }
        if (stringBuffer != null && (n2 = stringBuffer.indexOf(XML_ELEMENT_START_TAG)) != -1 && (n = stringBuffer.indexOf(XML_ELEMENT_END_TAG, n2 + XML_ELEMENT_START_TAG.length())) != -1 && (matcher = p_XMLVersionAttributePattern.matcher(string2 = stringBuffer.substring(n2, n))).find() && (string = matcher.group(1)) != null && string.length() > 0) {
            String[] stringArray = StrUtil.split(string, XML_VERSIONS_SEPARATOR);
            int n3 = 0;
            while (n3 < stringArray.length) {
                String[] stringArray2;
                if (stringArray[n3] != null && stringArray[n3].length() > 0 && (stringArray2 = StrUtil.split(stringArray[n3], XML_TOOL_VERSION_SEPARATOR)).length == 2) {
                    String string3 = stringArray2[0];
                    String string4 = stringArray2[1];
                    if (string3 != null && string3.trim().length() > 0 && string4 != null && string4.trim().length() > 0) {
                        linkedHashMap.put(string3, string4);
                    }
                }
                ++n3;
            }
        }
        if (linkedHashMap.size() == 0) {
            return null;
        }
        return linkedHashMap;
    }

    protected static Map readVersionsFromXMIFile(File file) {
        int n;
        int n2;
        Matcher matcher;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        StringBuffer stringBuffer = null;
        try {
            stringBuffer = FileUtil.readFile(file, "UTF-8");
        }
        catch (Exception exception) {
            CommonPlugin.getDefault().getLogger().logError(exception);
        }
        if (stringBuffer != null && (matcher = p_XMI_ELEMENT_START_TAG.matcher(stringBuffer)).find() && (n2 = stringBuffer.indexOf(XML_ELEMENT_END_TAG, n = matcher.end())) != -1) {
            String string = stringBuffer.substring(n, n2 + 1);
            Matcher matcher2 = p_XMIVersionPattern.matcher(string);
            while (matcher2.find()) {
                String string2 = matcher2.group(1);
                if (string2.equals(XMI_ATTRIBUTE_TAG)) continue;
                String string3 = matcher2.group(2);
                if (string2 == null || string2.trim().length() <= 0 || string3 == null || string3.trim().length() <= 0) continue;
                linkedHashMap.put(string2, string3);
            }
        }
        if (linkedHashMap.size() == 0) {
            return null;
        }
        return linkedHashMap;
    }

    public static Map readVersionsFromFile(File file) {
        if (file.getName().toUpperCase().endsWith("XMI")) {
            return VersionUtil.readVersionsFromXMIFile(file);
        }
        if (file.getName().toUpperCase().endsWith("XML")) {
            return VersionUtil.readVersionsFromXMLFile(file);
        }
        Map map = VersionUtil.readVersionsFromXMIFile(file);
        if (map != null) {
            return map;
        }
        map = VersionUtil.readVersionsFromXMLFile(file);
        if (map != null) {
            return map;
        }
        return null;
    }

    public static VersionCheckInfo checkXMLVersion(File file) {
        Map map = VersionUtil.readVersionsFromFile(file);
        if (map == null) {
            return null;
        }
        VersionCheckInfo versionCheckInfo = null;
        for (String string : toolIDsCheckList) {
            String string2;
            if (map.get(string) == null || (versionCheckInfo = VersionUtil._checkXMLVersion(string, string2 = (String)map.get(string))) == null) continue;
            return versionCheckInfo;
        }
        return null;
    }

    private static VersionCheckInfo _checkXMLVersion(String string, String string2) {
        EPFVersions ePFVersions = VersionUtil.getVersions(string);
        if (ePFVersions != null) {
            EPFVersion ePFVersion = ePFVersions.getMinToolVersionForCurrentXMLSchemaVersion();
            int n = ePFVersion.compareToolVersionTo(new Version(string2));
            String string3 = ePFVersion.getToolVersion().toString();
            return new VersionCheckInfo(string, string2, string3, -n);
        }
        return null;
    }

    public static VersionCheckInfo checkLibraryVersion(File file) {
        Object object;
        Object object2;
        if (file.getName().equals("library.xmi")) {
            object2 = toolIDsCheckList.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (libExtCheckers.get(object) == null) continue;
                Object object3 = null;
                ILibraryExtensionVersionCheck object4 = libExtCheckers.get(object);
                object3 = object4.checkLibraryVersion(file.getParentFile());
                if (object3 == null) continue;
                return object3;
            }
        }
        if ((object2 = VersionUtil.readVersionsFromFile(file)) == null) {
            return null;
        }
        object = null;
        for (String string : toolIDsCheckList) {
            String string2;
            if (object2.get(string) == null || (object = VersionUtil._checkLibVersion(string, string2 = (String)object2.get(string))) == null) continue;
            return object;
        }
        return null;
    }

    private static VersionCheckInfo _checkLibVersion(String string, String string2) {
        EPFVersions ePFVersions = VersionUtil.getVersions(string);
        if (ePFVersions != null) {
            EPFVersion ePFVersion = ePFVersions.getMinToolVersionForCurrentLibraryVersion();
            int n = ePFVersion.compareToolVersionTo(new Version(string2));
            String string3 = ePFVersion.getToolVersion().toString();
            return new VersionCheckInfo(string, string2, string3, -n);
        }
        return null;
    }

    public static String getPrimaryToolID() {
        return toolIDsCheckList.get(0);
    }

    public static boolean addToolID(String string, String string2) {
        if (string2 != null) {
            int n = toolIDsCheckList.indexOf(string2);
            if (n != -1) {
                toolIDsCheckList.add(n, string);
                return true;
            }
            return false;
        }
        toolIDsCheckList.add(0, string);
        return true;
    }

    public static class VersionCheckInfo {
        public String toolID;
        public String toolVersion;
        public String currentMinToolVersion;
        public int result;

        public VersionCheckInfo(String string, String string2, String string3, int n) {
            this.toolID = string;
            this.toolVersion = string2;
            this.currentMinToolVersion = string3;
            this.result = n;
        }
    }
}

