/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class PerspectiveUtil {
    private PerspectiveUtil() {
    }

    public static String getActivePerspectiveId() {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null) {
            IPerspectiveDescriptor iPerspectiveDescriptor = iWorkbenchPage.getPerspective();
            return iPerspectiveDescriptor.getId();
        }
        return null;
    }

    public static IPerspectiveDescriptor openPerspective(String string) {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null) {
            IPerspectiveRegistry iPerspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
            IPerspectiveDescriptor iPerspectiveDescriptor = iWorkbenchPage.getPerspective();
            if (!iPerspectiveDescriptor.getId().equals(string)) {
                IPerspectiveDescriptor iPerspectiveDescriptor2 = iPerspectiveRegistry.findPerspectiveWithId(string);
                iWorkbenchPage.setPerspective(iPerspectiveDescriptor2);
            }
            return iPerspectiveDescriptor;
        }
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            PlatformUI.getWorkbench().showPerspective(string, iWorkbenchWindow);
        }
        catch (WorkbenchException workbenchException) {}
        return null;
    }

    public static boolean isActivePerspective(String string) {
        String string2 = PerspectiveUtil.getActivePerspectiveId();
        if (string == null || string2 == null) {
            return false;
        }
        return string2.equalsIgnoreCase(string);
    }

    public static IViewPart getView(String string) {
        try {
            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (iWorkbenchPage != null) {
                IViewPart iViewPart = iWorkbenchPage.findView(string);
                if (iViewPart == null) {
                    iViewPart = iWorkbenchPage.showView(string);
                }
                return iViewPart;
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

