/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UmaUtil {
    public static void replace(MethodElement methodElement, MethodElement methodElement2) {
        EList eList = methodElement.eClass().getEAllStructuralFeatures();
        if (eList != null) {
            int n = eList.size();
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)eList.get(n2);
                if (eStructuralFeature != UmaPackage.eINSTANCE.getMethodElement_Guid()) {
                    Object object = methodElement2.eGet(eStructuralFeature);
                    methodElement.eSet(eStructuralFeature, object);
                }
                ++n2;
            }
        }
    }

    public static boolean hasDirectResource(EObject eObject) {
        Resource resource = eObject.eResource();
        return resource != null && resource.getContents().contains((Object)eObject);
    }

    public static Collection<Resource> getResources(EObject eObject) {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        UmaUtil.getResources(eObject, hashSet);
        return hashSet;
    }

    public static void getResources(EObject eObject, Collection<Resource> collection) {
        if (UmaUtil.hasDirectResource(eObject)) {
            collection.add(eObject.eResource());
        } else {
            Iterator iterator = eObject.eContents().iterator();
            while (iterator.hasNext()) {
                UmaUtil.getResources((EObject)iterator.next(), collection);
            }
        }
    }

    public static Object getAdapter(EObject eObject, Class clazz) {
        for (Adapter adapter : eObject.eAdapters()) {
            if (!clazz.isInstance(adapter)) continue;
            return adapter;
        }
        return null;
    }

    public static void removeAllAdapters(EObject eObject) {
        TreeIterator treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject2 = (EObject)treeIterator.next();
            eObject2.eAdapters().clear();
        }
    }

    public static MethodPackage findMethodPackage(List list, String string) {
        int n = list.size() - 1;
        while (n > -1) {
            MethodPackage methodPackage;
            Object e = list.get(n);
            if (e instanceof MethodPackage && string.equals((methodPackage = (MethodPackage)e).getName())) {
                return methodPackage;
            }
            --n;
        }
        return null;
    }

    public static MethodPackage findMethodPackage(MethodPlugin methodPlugin, String[] stringArray) {
        MethodPackage methodPackage = null;
        List list = methodPlugin.getMethodPackages();
        int n = 0;
        while (n < stringArray.length) {
            methodPackage = UmaUtil.findMethodPackage(list, stringArray[n]);
            if (methodPackage == null) {
                return null;
            }
            list = methodPackage.getChildPackages();
            ++n;
        }
        return methodPackage;
    }

    public static Activity getParentActivity(BreakdownElement breakdownElement) {
        return breakdownElement.getSuperActivities();
    }

    public static Activity getOwningActivity(WorkOrder workOrder) {
        ProcessPackage processPackage = (ProcessPackage)workOrder.eContainer();
        for (Object e : processPackage.getProcessElements()) {
            if (!(e instanceof Activity)) continue;
            return (Activity)e;
        }
        return null;
    }

    public static ContentPackage findContentPackage(List list, String string) {
        int n = list.size() - 1;
        while (n > -1) {
            ContentPackage contentPackage;
            Object e = list.get(n);
            if (e instanceof ContentPackage && string.equals((contentPackage = (ContentPackage)e).getName())) {
                return contentPackage;
            }
            --n;
        }
        return null;
    }

    public static ContentPackage findContentPackage(MethodPlugin methodPlugin, String[] stringArray) {
        ContentPackage contentPackage = null;
        List list = methodPlugin.getMethodPackages();
        int n = 0;
        while (n < stringArray.length) {
            contentPackage = UmaUtil.findContentPackage(list, stringArray[n]);
            if (contentPackage == null) {
                return null;
            }
            list = contentPackage.getChildPackages();
            ++n;
        }
        return contentPackage;
    }

    public static MethodPlugin getMethodPlugin(EObject eObject) {
        EObject eObject2 = eObject;
        while (eObject2 != null) {
            if (eObject2 instanceof MethodPlugin) {
                return (MethodPlugin)eObject2;
            }
            eObject2 = eObject2.eContainer();
        }
        return null;
    }

    public static MethodLibrary getMethodLibrary(EObject eObject) {
        EObject eObject2 = eObject;
        while (eObject2 != null) {
            if (eObject2 instanceof MethodLibrary) {
                return (MethodLibrary)eObject2;
            }
            eObject2 = eObject2.eContainer();
        }
        return null;
    }

    public static EObject getTopContainer(EObject eObject) {
        EObject eObject2 = null;
        EObject eObject3 = eObject.eContainer();
        while (eObject3 != null) {
            eObject2 = eObject3;
            eObject3 = eObject3.eContainer();
        }
        return eObject2;
    }

    public static ContentPackage getContentPackage(EObject eObject) {
        EObject eObject2 = eObject;
        while (eObject2 != null) {
            if (eObject2 instanceof ContentPackage) {
                return (ContentPackage)eObject2;
            }
            eObject2 = eObject2.eContainer();
        }
        return null;
    }

    public static ProcessPackage getProcessPackage(EObject eObject) {
        EObject eObject2 = eObject;
        while (eObject2 != null) {
            if (eObject2 instanceof ProcessPackage) {
                return (ProcessPackage)eObject2;
            }
            eObject2 = eObject2.eContainer();
        }
        return null;
    }

    public static Diagram getDiagram(EObject eObject) {
        EObject eObject2 = eObject;
        while (eObject2 != null) {
            if (eObject2 instanceof Diagram) {
                return (Diagram)eObject2;
            }
            eObject2 = eObject2.eContainer();
        }
        return null;
    }

    public static boolean isContainedByContentPackage(EObject eObject, ContentPackage contentPackage) {
        return UmaUtil.isContainedBy(eObject, contentPackage);
    }

    public static boolean isContainedBy(EObject eObject, Object object) {
        if (eObject == null) {
            return false;
        }
        EObject eObject2 = eObject.eContainer();
        while (eObject2 != null) {
            if (eObject2 == object) {
                return true;
            }
            eObject2 = eObject2.eContainer();
        }
        return false;
    }

    public static String generateGUID() {
        return EcoreUtil.generateUUID();
    }

    public static String createContentDescriptionName(MethodElement methodElement) {
        return String.valueOf(methodElement.getName()) + ',' + methodElement.getGuid();
    }

    public static void getAllSupers(List list, VariabilityElement variabilityElement, VariabilityType variabilityType) {
        VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
        if (variabilityElement2 != null && variabilityElement.getVariabilityType() == variabilityType && !list.contains(variabilityElement2)) {
            list.add(variabilityElement2);
            UmaUtil.getAllSupers(list, variabilityElement2, variabilityType);
        }
    }

    public static void getAllSupersBoth(List list, VariabilityElement variabilityElement, VariabilityType variabilityType, VariabilityType variabilityType2) {
        VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
        if (!(variabilityElement2 == null || variabilityElement.getVariabilityType() != variabilityType && variabilityElement.getVariabilityType() != variabilityType2 || list.contains(variabilityElement2))) {
            list.add(variabilityElement2);
            UmaUtil.getAllSupersBoth(list, variabilityElement2, variabilityType, variabilityType2);
        }
    }

    public static Class getClassOfContentElement(ContentElement contentElement) {
        if (contentElement instanceof Role) {
            return Role.class;
        }
        if (contentElement instanceof Task) {
            return Task.class;
        }
        if (contentElement instanceof WorkProduct) {
            return WorkProduct.class;
        }
        if (contentElement instanceof Guidance) {
            return Guidance.class;
        }
        if (contentElement instanceof Domain) {
            return Domain.class;
        }
        if (contentElement instanceof Discipline) {
            return Discipline.class;
        }
        if (contentElement instanceof DisciplineGrouping) {
            return DisciplineGrouping.class;
        }
        if (contentElement instanceof RoleSet) {
            return RoleSet.class;
        }
        if (contentElement instanceof RoleSetGrouping) {
            return RoleSetGrouping.class;
        }
        if (contentElement instanceof WorkProductType) {
            return WorkProductType.class;
        }
        return Object.class;
    }

    public static WorkOrder createDefaultWorkOrder(WorkBreakdownElement workBreakdownElement, WorkBreakdownElement workBreakdownElement2) {
        return UmaUtil.createDefaultWorkOrder(workBreakdownElement, workBreakdownElement2, true);
    }

    public static WorkOrder createDefaultWorkOrder(WorkBreakdownElement workBreakdownElement, WorkBreakdownElement workBreakdownElement2, boolean bl) {
        WorkOrder workOrder = UmaFactory.eINSTANCE.createWorkOrder();
        workOrder.setPred(workBreakdownElement2);
        if (bl) {
            workBreakdownElement.getLinkToPredecessor().add(workOrder);
        }
        return workOrder;
    }

    public static WorkOrder findWorkOrder(WorkBreakdownElement workBreakdownElement, Object object) {
        for (WorkOrder workOrder : workBreakdownElement.getLinkToPredecessor()) {
            if (workOrder.getPred() != object) continue;
            return workOrder;
        }
        return null;
    }

    public static WorkOrder removeWorkOrder(WorkBreakdownElement workBreakdownElement, Object object) {
        Iterator iterator = workBreakdownElement.getLinkToPredecessor().iterator();
        while (iterator.hasNext()) {
            WorkOrder workOrder = (WorkOrder)iterator.next();
            if (workOrder.getPred() != object) continue;
            iterator.remove();
            return workOrder;
        }
        return null;
    }

    public static ProcessComponent getProcessComponent(MethodElement methodElement) {
        MethodElement methodElement2 = methodElement;
        while (methodElement2 != null && !(methodElement2 instanceof ProcessComponent)) {
            methodElement2 = methodElement2.eContainer();
        }
        if (methodElement2 != null) {
            return (ProcessComponent)methodElement2;
        }
        return null;
    }

    public static MethodUnit getMethodUnit(MethodElement methodElement) {
        MethodElement methodElement2 = methodElement;
        while (methodElement2 != null && !(methodElement2 instanceof MethodUnit)) {
            methodElement2 = methodElement2.eContainer();
        }
        if (methodElement2 != null) {
            return (MethodUnit)methodElement2;
        }
        return null;
    }

    public static boolean hasReference(MethodPlugin methodPlugin, MethodPlugin methodPlugin2) {
        EObject eObject;
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)methodPlugin.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            eObject = (EObject)featureIterator.next();
            EStructuralFeature eStructuralFeature = featureIterator.feature();
            if (eStructuralFeature == UmaPackage.eINSTANCE.getMethodPlugin_Bases() || UmaUtil.getMethodPlugin(eObject) != methodPlugin2) continue;
            return true;
        }
        featureIterator = methodPlugin.eAllContents();
        while (featureIterator.hasNext()) {
            eObject = (EObject)featureIterator.next();
            if (eObject instanceof ProcessElement) continue;
            for (EObject eObject2 : eObject.eCrossReferences()) {
                if (UmaUtil.getMethodPlugin(eObject2) != methodPlugin2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean removeReferences(MethodPlugin methodPlugin, MethodPlugin methodPlugin2) {
        TreeIterator treeIterator = methodPlugin.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            if (eObject instanceof ProcessElement) continue;
            EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
            while (featureIterator.hasNext()) {
                EObject eObject2 = (EObject)featureIterator.next();
                if (UmaUtil.getMethodPlugin(eObject2) != methodPlugin2) continue;
                EStructuralFeature eStructuralFeature = featureIterator.feature();
                if (eStructuralFeature.isMany()) {
                    ((Collection)eObject.eGet(eStructuralFeature)).remove(eObject2);
                    continue;
                }
                eObject.eSet(eStructuralFeature, null);
            }
        }
        return false;
    }

    public static String getMessage(IStatus iStatus) {
        String string = iStatus.getMessage();
        if (iStatus.isMultiStatus()) {
            StringBuffer stringBuffer = new StringBuffer(string);
            IStatus[] iStatusArray = iStatus.getChildren();
            int n = 0;
            while (n < iStatusArray.length) {
                stringBuffer.append('\n').append(iStatusArray[n].getMessage());
                ++n;
            }
            string = stringBuffer.toString();
        }
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        return string;
    }

    public static final String generateGUID(String string) {
        return GUID.generate(string);
    }

    public static void main(String[] stringArray) {
        System.out.println(UmaUtil.generateGUID());
    }

    private static class GUID {
        private static MessageDigest md5 = null;
        private static final char[] BASE64_DIGITS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};

        private GUID() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static MessageDigest getMD5() {
            if (md5 != null) return md5;
            Class<GUID> clazz = GUID.class;
            synchronized (GUID.class) {
                if (md5 != null) return md5;
                try {
                    md5 = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    noSuchAlgorithmException.printStackTrace();
                }
                return md5;
            }
        }

        public static final String generate(String string) {
            MessageDigest messageDigest = GUID.getMD5();
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            char[] cArray = new char[23];
            cArray[0] = 45;
            int n = 0;
            while (n < 5) {
                cArray[4 * n + 1] = BASE64_DIGITS[byArray[n * 3] >> 2 & 0x3F];
                cArray[4 * n + 2] = BASE64_DIGITS[byArray[n * 3] << 4 & 0x30 | byArray[n * 3 + 1] >> 4 & 0xF];
                cArray[4 * n + 3] = BASE64_DIGITS[byArray[n * 3 + 1] << 2 & 0x3C | byArray[n * 3 + 2] >> 6 & 3];
                cArray[4 * n + 4] = BASE64_DIGITS[byArray[n * 3 + 2] & 0x3F];
                ++n;
            }
            cArray[21] = BASE64_DIGITS[byArray[15] >> 2 & 0x3F];
            cArray[22] = BASE64_DIGITS[byArray[15] << 4 & 0x30];
            return new String(cArray);
        }
    }
}

