/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ui.viewer;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.ad.edit.parts.ActivityEditPart;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.model.LinkedObject;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.ui.DiagramUIPlugin;
import org.eclipse.epf.diagram.ui.service.DiagramImageService;
import org.eclipse.epf.diagram.ui.viewer.AbstractDiagramGraphicalViewer;
import org.eclipse.epf.library.configuration.ProcessConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.diagram.DiagramInfo;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DiagramElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractDiagramGraphicalViewerEx
extends AbstractDiagramGraphicalViewer {
    protected GraphicalEditPart part = null;
    protected Diagram diagram;
    protected DiagramManager dmgr;
    protected boolean debug = DiagramUIPlugin.getDefault().isDebugging();
    protected MethodConfiguration config = null;

    public AbstractDiagramGraphicalViewerEx(Composite composite, Object object) {
        super(composite, object);
    }

    public EditPart loadDiagram(Object object, boolean bl, IFilter iFilter, Suppression suppression) {
        Rectangle rectangle;
        IFigure iFigure;
        Iterator iterator;
        EditPart editPart = this.createEditPart(object, iFilter, suppression);
        if (editPart == null && this.debug) {
            System.out.println("Editpart is null: " + object);
        }
        this.graphicalViewer.setContents(editPart);
        this.refresh((DiagramEditPart)editPart);
        this.parent.pack(true);
        if (editPart != null && this.debug) {
            iterator = editPart.getChildren().iterator();
            while (iterator.hasNext()) {
                iFigure = (EditPart)iterator.next();
                rectangle = (View)iFigure.getModel();
                System.out.println(String.valueOf(rectangle.getType()) + ":" + ViewUtil.getStructuralFeatureValue((View)rectangle, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X()) + "," + ViewUtil.getStructuralFeatureValue((View)rectangle, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y()));
            }
        }
        if ((iterator = TngUtil.unwrap((Object)object)) instanceof VariabilityElement && this.getDiagramType() != null && this.getDiagramType().equalsIgnoreCase("ActivityDetail") && TngUtil.hasContributor((VariabilityElement)((VariabilityElement)iterator))) {
            bl = true;
        }
        if (bl) {
            this.cleanUpDiagram();
            this.parent.pack(true);
        }
        if ((iFigure = this.getFigure()) != null) {
            rectangle = iFigure.getBounds();
            if (rectangle.x < 0 || rectangle.y < 0) {
                if (editPart instanceof ActivityEditPart) {
                    ((ActivityEditPart)editPart).moveFigure(-rectangle.x, -rectangle.y);
                }
                this.parent.pack(true);
                rectangle = iFigure.getBounds();
            }
        }
        return editPart;
    }

    public DiagramInfo getDiagramInfo() {
        DiagramInfo diagramInfo = null;
        Object object = this.part.getModel();
        if (object instanceof LinkedObject) {
            object = ((LinkedObject)object).getObject();
        }
        if (object instanceof View) {
            if ((object = ((View)object).getElement()) != null && object instanceof EModelElement) {
                object = BridgeHelper.getMethodElement((EModelElement)((EModelElement)object));
            }
            if (object instanceof Node) {
                object = ((Node)object).getLinkedElement();
            }
        }
        if (object instanceof MethodElement) {
            diagramInfo = new DiagramInfo(this.getDiagramType(), (MethodElement)object);
            this.loadDiagramInfo(this.part, diagramInfo);
        }
        return diagramInfo;
    }

    public void createDiagramImage(ImageFileFormat imageFileFormat) {
    }

    protected EditPartFactory createEditPartFactory() {
        return EditPartService.getInstance();
    }

    protected void configureGraphicalViewer() {
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.listBackground);
        DiagramGraphicalViewer diagramGraphicalViewer = (DiagramGraphicalViewer)this.getGraphicalViewer();
        DiagramRootEditPart diagramRootEditPart = (DiagramRootEditPart)EditPartService.getInstance().createRootEditPart(this.getDiagram());
        LayeredPane cfr_ignored_0 = (LayeredPane)diagramRootEditPart.getLayer((Object)"Printable Layers");
        FreeformLayer freeformLayer = new FreeformLayer();
        freeformLayer.setLayoutManager((LayoutManager)new DelegatingLayout());
        LayeredPane layeredPane = (LayeredPane)diagramRootEditPart.getLayer((Object)"Scalable Layers");
        FreeformLayer freeformLayer2 = new FreeformLayer();
        freeformLayer2.setEnabled(false);
        layeredPane.addLayerAfter((Layer)freeformLayer2, (Object)"Scaled Feedback Layer", (Object)"Decoration Unprintable Layer");
        diagramGraphicalViewer.setRootEditPart((RootEditPart)diagramRootEditPart);
        diagramGraphicalViewer.setEditPartFactory(this.createEditPartFactory());
    }

    protected Diagram getDiagram() {
        if (this.diagram == null) {
            Object object;
            block12: {
                try {
                    if (this.diagram == null && (object = TngUtil.unwrap((Object)this.wrapper)) instanceof Activity) {
                        Activity activity = (Activity)object;
                        this.dmgr = DiagramManager.getInstance((Process)TngUtil.getOwningProcess((BreakdownElement)activity), (Object)this);
                        List list = this.dmgr.getDiagrams(activity, DiagramImageService.getIntType(this.getDiagramType()));
                        if (!list.isEmpty()) {
                            this.diagram = (Diagram)list.get(0);
                        } else if (this.debug) {
                            System.out.println("Diagram is empty for " + activity);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!this.debug) break block12;
                    exception.printStackTrace();
                }
            }
            if (this.diagram == null) {
                if (this.debug) {
                    System.out.println("Creating diagram of  " + this.getDiagramType());
                }
                try {
                    this.diagram = this.dmgr.createDiagram((Activity)TngUtil.unwrap((Object)this.wrapper), DiagramImageService.getIntType(this.getDiagramType()), DiagramImageService.getPreferenceHint(this.getDiagramType()));
                }
                catch (Exception exception) {}
            }
            if (this.diagram != null && (object = this.diagram.getElement()) instanceof Node) {
                ((Node)object).addConsumer((Object)this);
            }
        }
        return this.diagram;
    }

    protected void createGraphicalViewer() {
        this.graphicalViewer = new DiagramGraphicalViewer();
        this.graphicalViewer.createControl(this.parent);
        this.configureGraphicalViewer();
    }

    protected void loadDiagramInfo(GraphicalEditPart graphicalEditPart, DiagramInfo diagramInfo) {
        List list = graphicalEditPart.getChildren();
        for (Object e : list) {
            if (!(e instanceof GraphicalEditPart)) continue;
            graphicalEditPart = (GraphicalEditPart)e;
            Object object = graphicalEditPart.getModel();
            Object object2 = object;
            if (object2 instanceof LinkedObject) {
                object2 = ((LinkedObject)object2).getObject();
            }
            if (object2 instanceof View) {
                if ((object2 = ((View)object2).getElement()) instanceof Node) {
                    if (object2 instanceof NodeContainer) {
                        this.loadDiagramInfo((GraphicalEditPart)e, diagramInfo);
                    }
                    object2 = ((Node)object2).getLinkedElement();
                }
                if (object2 != null && object2 instanceof EModelElement) {
                    object2 = BridgeHelper.getMethodElement((EModelElement)((EModelElement)object2));
                }
            }
            if (object2 instanceof DiagramElement || !(object2 instanceof MethodElement)) continue;
            boolean bl = object instanceof NamedNode ? ((NamedNode)object).isSuppressed() : ((MethodElement)object2).getSuppressed().booleanValue();
            IFigure iFigure = graphicalEditPart.getFigure();
            Rectangle rectangle = iFigure.getBounds();
            String string = null;
            if (iFigure instanceof WrapLabel) {
                string = ((WrapLabel)iFigure).getText();
            }
            diagramInfo.addArea((MethodElement)object2, rectangle.x, rectangle.y, rectangle.width, rectangle.height, string, bl);
        }
    }

    public void dispose() {
        EObject eObject;
        super.dispose();
        if (this.dmgr != null) {
            this.dmgr.removeConsumer((Object)this);
        }
        if (this.diagram != null && (eObject = this.diagram.getElement()) instanceof Node) {
            ((Node)eObject).removeConsumer((Object)this);
        }
    }

    protected void refresh(DiagramEditPart diagramEditPart) {
        block2: {
            try {
                DiagramEditorUtil.refresh((DiagramEditPart)diagramEditPart, (IProgressMonitor)new NullProgressMonitor(), (boolean)true);
                DiagramEditorUtil.refreshLabels((DiagramEditPart)diagramEditPart);
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                System.out.println("Error diagram refresh while publishing : " + exception);
            }
        }
    }

    public void updateDiagramElement(final Diagram diagram, final MethodElement methodElement, final Suppression suppression, final MethodConfiguration methodConfiguration, final IFilter iFilter, IProgressMonitor iProgressMonitor) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
        AbstractEMFOperation abstractEMFOperation = new AbstractEMFOperation(transactionalEditingDomain, ""){

            protected IStatus doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                org.eclipse.epf.diagram.model.Diagram diagram2 = (org.eclipse.epf.diagram.model.Diagram)diagram.getElement();
                diagram2.setSuppression(suppression);
                if (iFilter == null && methodConfiguration != null) {
                    ProcessConfigurator processConfigurator = new ProcessConfigurator(AbstractDiagramGraphicalViewerEx.this.config, null);
                    diagram2.setFilter((IFilter)processConfigurator);
                } else {
                    diagram2.setFilter(iFilter);
                }
                diagram2.setLinkedElement(methodElement);
                return Status.OK_STATUS;
            }
        };
        try {
            abstractEMFOperation.execute(iProgressMonitor, null);
        }
        catch (ExecutionException executionException) {
            CommonPlugin.getDefault().getLogger().logError((Throwable)executionException);
        }
    }

    public void setMethodConfiguration(MethodConfiguration methodConfiguration) {
        this.config = methodConfiguration;
    }

    public MethodConfiguration getMethodConfiguration() {
        return this.config;
    }
}

