/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.Services;

public class FileModifyChecker {
    public static IStatus checkModify(List list) {
        try {
            Object object;
            String[] stringArray = new String[list.size()];
            list.toArray(stringArray);
            IFileManager iFileManager = Services.getFileManager();
            IStatus iStatus = iFileManager.checkModify(stringArray, (Object)MsgBox.getDefaultShell());
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < stringArray.length) {
                object = new File(stringArray[n]);
                if (((File)object).exists() && !((File)object).canWrite()) {
                    arrayList.add(stringArray[n]);
                }
                ++n;
            }
            if (arrayList.size() > 0) {
                String string = ImportResources.FileModifyChecker_Checkout_failed_title;
                object = ImportResources.FileModifyChecker_Checkout_failed_msg;
                if (new MsgDialog((AbstractPlugin)ImportPlugin.getDefault()).displayPrompt(string, (String)object)) {
                    return FileModifyChecker.checkModify(arrayList);
                }
            }
            return iStatus;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new Status(4, ImportPlugin.getDefault().getId(), 0, throwable.getMessage() == null ? "" : throwable.getMessage(), null);
        }
    }

    public static IStatus syncExecCheckModify(final List list) {
        final IStatus[] iStatusArray = new IStatus[1];
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                iStatusArray[0] = FileModifyChecker.checkModify(list);
            }
        });
        return iStatusArray[0];
    }

    public static List getModifiedFiles(ResourceSet resourceSet) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Resource resource : resourceSet.getResources()) {
            if (resource == null || !resource.isModified()) continue;
            arrayList.add(resource.getURI().toFileString());
        }
        return arrayList;
    }
}

