/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.export.services.ConfigurationExportService;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigurationImportService;
import org.eclipse.epf.importing.services.DirCopy;
import org.eclipse.epf.importing.services.FileModifyChecker;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImportingService {
    private UpgradeCallerInfo upGradeInfo;
    private static boolean newMergeScheme = true;
    private static boolean localDebug = false;
    private PluginImportData data;
    LibraryDocument importingLibDoc;
    LibraryDocument targetLibDoc;
    IStatus fileCheckedOutStatus = null;
    private boolean checkBasePlugins = true;
    private File defaultConfigFolder;
    private Map<String, File> targetFileMap;

    public PluginImportingService(PluginImportData pluginImportData) {
        this.data = pluginImportData;
    }

    public void validate(IProgressMonitor iProgressMonitor) {
        try {
            Object object;
            if (iProgressMonitor != null) {
                iProgressMonitor.setTaskName(ImportResources.PluginImportingService_MSG0);
            }
            if (this.data == null) {
                return;
            }
            this.data.clear();
            File file = new File(String.valueOf(this.data.llData.getParentFolder()) + File.separator + "export.xmi");
            if (!file.exists()) {
                this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.PluginImportingService_MSG1, (Object)file.toString()));
                return;
            }
            boolean bl = true;
            if (bl) {
                this.upGradeInfo = new ConfigurationImportService.UpgradeInfo(UpgradeCallerInfo.upgradeImportPlugin, file);
                if (!ConfigurationImportService.handleToolVersion(file, this.upGradeInfo)) {
                    this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.importPluginsWizard_ERR_Import_plugin, (Object)file.toString()));
                    return;
                }
                if (this.upGradeInfo.getCopiedLibFile() != null) {
                    file = this.upGradeInfo.getCopiedLibFile();
                }
            } else {
                object = ConfigurationImportService.versionCheck(file.getAbsolutePath(), ImportResources.importPluginsWizard_title);
                if (object != null) {
                    this.data.getErrorInfo().addError((String)object);
                    return;
                }
            }
            this.importingLibDoc = new LibraryDocument(file);
            object = new File(LibraryService.getInstance().getCurrentMethodLibrary().eResource().getURI().toFileString());
            this.targetLibDoc = new LibraryDocument((File)object);
            this.scanLibraryFile(this.importingLibDoc);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void performImport(IProgressMonitor iProgressMonitor) throws Exception {
        boolean bl = RefreshJob.getInstance().isEnabled();
        try {
            if (bl) {
                RefreshJob.getInstance().setEnabled(false);
            }
            this.__doImport(iProgressMonitor);
        }
        finally {
            if (bl) {
                RefreshJob.getInstance().setEnabled(true);
            }
            if (this.upGradeInfo != null) {
                this.upGradeInfo.removeCopiedLibrary();
                this.upGradeInfo = null;
            }
            this.defaultConfigFolder = null;
            this.targetFileMap = null;
        }
    }

    private void __doImport(IProgressMonitor iProgressMonitor) {
        try {
            if (iProgressMonitor != null) {
                iProgressMonitor.setTaskName(ImportResources.PluginImportingService_MSG3);
            }
            List list = this.unlockPlugins();
            File file = this.targetLibDoc.getFile();
            this.defaultConfigFolder = null;
            this.targetFileMap = new HashMap<String, File>();
            if (newMergeScheme) {
                if (!this.merge(this.targetLibDoc)) {
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            String string = ImportResources.importPluginsWizard_title;
                            String string2 = ImportResources.importPluginsWizard_ERR_Import_plugin;
                            new MsgDialog((AbstractPlugin)ImportPlugin.getDefault()).displayError(string, string2);
                        }
                    });
                    return;
                }
                if (list.size() > 0) {
                    this.lockUnlockedPlugins(list);
                    LibraryService.getInstance().saveCurrentMethodLibrary();
                    LibraryService.getInstance().reopenCurrentMethodLibrary();
                }
                MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
                ResourceUtil.refreshResources((MethodLibrary)methodLibrary, (IProgressMonitor)iProgressMonitor);
                return;
            }
            if (this.importEntries(this.targetLibDoc)) {
                this.targetLibDoc.save();
                this.fixLibraryGuid(file.getParentFile(), this.importingLibDoc.getLibraryGuid(), this.targetLibDoc.getLibraryGuid());
                LibraryService.getInstance().reopenCurrentMethodLibrary();
                if (list.size() > 0) {
                    this.lockUnlockedPlugins(list);
                    LibraryService.getInstance().saveCurrentMethodLibrary();
                }
            }
            LibraryService.getInstance().reopenCurrentMethodLibrary();
            MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
            ResourceUtil.refreshResources((MethodLibrary)methodLibrary, (IProgressMonitor)iProgressMonitor);
        }
        catch (Exception exception) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }

    private List unlockPlugins() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PluginImportData.PluginInfo pluginInfo : this.data.getPlugins()) {
            if (pluginInfo.existingPlugin == null || !pluginInfo.selected || pluginInfo.existingPlugin.getUserChangeable().booleanValue()) continue;
            pluginInfo.existingPlugin.setUserChangeable(new Boolean(true));
            arrayList.add(pluginInfo.existingPlugin.getGuid());
        }
        return arrayList;
    }

    private void lockUnlockedPlugins(List list) {
        List list2 = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
        for (MethodPlugin methodPlugin : list2) {
            if (!list.contains(methodPlugin.getGuid())) continue;
            methodPlugin.setUserChangeable(new Boolean(false));
        }
    }

    private boolean importEntries(LibraryDocument libraryDocument) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (PluginImportData.PluginInfo pluginInfo : this.data.getPlugins()) {
            if (!pluginInfo.selected) continue;
            if (pluginInfo.existingPlugin == null) {
                arrayList2.add(pluginInfo.guid);
            }
            arrayList.add(pluginInfo.guid);
        }
        for (Object object : this.data.getConfigs()) {
            if (!((PluginImportData.ConfiguarationInfo)object).selected) continue;
            if (((PluginImportData.ConfiguarationInfo)object).existingConfig == null) {
                arrayList2.add(((PluginImportData.ConfiguarationInfo)object).guid);
            }
            arrayList.add(((PluginImportData.ConfiguarationInfo)object).guid);
        }
        if (!newMergeScheme) {
            this.importLibEntries(libraryDocument, arrayList2);
        } else {
            MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
            this.ensureUniqueNames(methodLibrary.getMethodPlugins());
            this.ensureUniqueNames(methodLibrary.getPredefinedConfigurations());
        }
        return this.copyFiles(libraryDocument, arrayList, arrayList2);
    }

    private void importLibEntries(LibraryDocument libraryDocument, List list) {
        String string;
        Element element;
        if (list == null || list.size() == 0) {
            return;
        }
        NodeList nodeList = this.importingLibDoc.getPlugins();
        int n = 0;
        while (n < nodeList.getLength()) {
            element = (Element)nodeList.item(n);
            string = LibraryDocument.getGuid((Element)element);
            if (list.contains(string)) {
                libraryDocument.addPlugin(element);
            }
            ++n;
        }
        nodeList = this.importingLibDoc.getConfigurations();
        n = 0;
        while (n < nodeList.getLength()) {
            element = (Element)nodeList.item(n);
            string = LibraryDocument.getGuid((Element)element);
            if (list.contains(string)) {
                libraryDocument.addConfiguration(element);
            }
            ++n;
        }
        nodeList = this.importingLibDoc.getResourceDescriptors();
        n = 0;
        while (n < nodeList.getLength()) {
            element = (Element)nodeList.item(n);
            string = element.getAttribute("id");
            if (list.contains(string)) {
                libraryDocument.addResource(element);
            }
            ++n;
        }
        nodeList = this.importingLibDoc.getResourceSubManagers();
        n = 0;
        while (n < nodeList.getLength()) {
            element = (Element)nodeList.item(n);
            string = LibraryDocument.getSubManagerBaseGuid((String)element.getAttribute("href"));
            if (list.contains(string)) {
                libraryDocument.addResource(element);
            }
            ++n;
        }
    }

    private boolean copyFiles(LibraryDocument libraryDocument, List list, List list2) {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        for (String string : list) {
            String string2 = this.importingLibDoc.getResourceUri(string);
            if (string2 == null || string2.length() == 0) continue;
            final File file = this.importingLibDoc.getFileFromUri(string2);
            if (!file.exists()) continue;
            final File file2 = this.getTargetFile(methodLibrary, string);
            if (file2 == null) {
                return false;
            }
            this.targetFileMap.put(string, file2);
            if (this.data.getPluginInfo(string) != null) {
                if (file2.exists()) {
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            DirCopy dirCopy = new DirCopy(file.getParentFile(), file2.getParentFile());
                            PluginImportingService.this.fileCheckedOutStatus = dirCopy.execute();
                        }
                    });
                } else {
                    PluginImportingService.copyDir(file.getParentFile(), file2.getParentFile());
                }
            } else if (this.data.getConfigInfo(string) != null && DirCopy.needCopy(file, file2)) {
                final ArrayList<String> arrayList = new ArrayList<String>();
                if (file2.exists()) {
                    arrayList.add(file2.getAbsolutePath());
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            PluginImportingService.this.fileCheckedOutStatus = FileModifyChecker.checkModify(arrayList);
                        }
                    });
                }
                if (this.fileCheckedOutStatus == null || this.fileCheckedOutStatus.isOK()) {
                    FileUtil.copyFile((File)file, (File)file2);
                }
            }
            if (this.fileCheckedOutStatus == null || this.fileCheckedOutStatus.isOK()) continue;
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    String string = ImportResources.importPluginsWizard_title;
                    String string2 = ImportResources.importPluginsWizard_ERR_Import_plugin;
                    new MsgDialog((AbstractPlugin)ImportPlugin.getDefault()).displayError(string, string2, PluginImportingService.this.fileCheckedOutStatus);
                }
            });
            return false;
        }
        return true;
    }

    public static void copyDir(File file, File file2) {
        Copy copy = new Copy();
        copy.setOverwrite(true);
        FileSet fileSet = new FileSet();
        fileSet.setExcludes(ConfigurationExportService.excludes);
        fileSet.setDir(file);
        copy.addFileset(fileSet);
        copy.setTodir(file2);
        copy.setProject(new Project());
        copy.execute();
    }

    public String validateSelection() {
        Object object2;
        if (!this.isCheckBasePlugins()) {
            return null;
        }
        this.data.getErrorInfo().clear();
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        List list = methodLibrary == null ? new ArrayList() : methodLibrary.getMethodPlugins();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object object2 : list) {
            hashMap.put(object2.getGuid(), object2);
        }
        HashSet hashSet = new HashSet();
        object2 = new HashSet();
        for (Object object3 : this.data.getPlugins()) {
            if (!((PluginImportData.PluginInfo)object3).selected) continue;
            object2.add(((PluginImportData.PluginInfo)object3).guid);
            for (Object object4 : ((PluginImportData.PluginInfo)object3).usedPlugins) {
                if (hashSet.contains(object4)) continue;
                hashSet.add(object4);
            }
        }
        if (object2.size() > 0) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object object4;
                Object object3;
                object3 = (String)iterator.next();
                String string = (String)this.data.basePluginUrlMap.get(object3);
                if (object2.contains(object3) || hashMap.containsKey(object3)) continue;
                if (string != null && string.length() > 0) {
                    object4 = NLS.bind((String)ImportResources.PluginImportingService_MSG5, (Object)string);
                } else {
                    Map map = this.importingLibDoc.getGuidToPlugNameMap();
                    String string2 = map == null ? null : (String)map.get(object3);
                    object4 = string2 == null || string2.length() == 0 ? ImportResources.PluginImportingService_MSG6 : NLS.bind((String)ImportResources.PluginImportingService_MSG5, (Object)(String.valueOf(string2) + ", " + (String)object3));
                }
                this.data.getErrorInfo().addError((String)object4);
                if (string == null || string.length() == 0) break;
            }
        }
        return this.data.getErrorInfo().getError();
    }

    private void scanLibraryFile(LibraryDocument libraryDocument) {
        this.visitLibTag(libraryDocument);
        this.visitResourceTag(libraryDocument);
        this.data.validatePlugins();
        for (PluginImportData.PluginInfo pluginInfo : this.data.getPlugins()) {
            if (pluginInfo.existingPlugin != null) continue;
            for (String string : pluginInfo.usedPlugins) {
                if (this.data.basePluginUrlMap.containsKey(string)) continue;
                this.data.basePluginUrlMap.put(string, "");
            }
        }
    }

    private void visitLibTag(LibraryDocument libraryDocument) {
        NodeList nodeList = libraryDocument.getPlugins();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            PluginImportData.PluginInfo pluginInfo = this.data.new PluginImportData.PluginInfo();
            pluginInfo.guid = LibraryDocument.getGuid((Element)element);
            this.data.getPlugins().add(pluginInfo);
            this.loadExistingPluginInfo(pluginInfo);
            ++n;
        }
        this.buildConfigInfoFromFiles();
    }

    private void visitResourceTag(LibraryDocument libraryDocument) {
        NodeList nodeList = libraryDocument.getResourceDescriptors();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            String string = element.getAttribute("id");
            String string2 = element.getAttribute("uri");
            File file = libraryDocument.getFileFromUri(string2);
            PluginImportData.PluginInfo pluginInfo = this.data.getPluginInfo(string);
            if (pluginInfo != null) {
                if (file.exists()) {
                    this.loadPluginInfo(file, pluginInfo);
                } else {
                    this.data.removePluginInfo(string);
                }
            } else {
                PluginImportData.ConfiguarationInfo configuarationInfo = this.data.getConfigInfo(string);
                if (configuarationInfo != null && file.exists()) {
                    this.loadConfigInfo(file, configuarationInfo);
                }
            }
            ++n;
        }
    }

    protected void loadConfigInfo(File file, PluginImportData.ConfiguarationInfo configuarationInfo) {
        try {
            Document document = XMLUtil.loadXml((File)file);
            Element element = document.getDocumentElement();
            Element element2 = null;
            if (element.getTagName().equals("org.eclipse.epf.uma:MethodConfiguration")) {
                element2 = element;
            } else {
                NodeList nodeList = element.getElementsByTagName("org.eclipse.epf.uma:MethodConfiguration");
                if (nodeList.getLength() > 0) {
                    element2 = (Element)nodeList.item(0);
                }
            }
            if (element2 != null) {
                configuarationInfo.name = element2.getAttribute("name");
            }
        }
        catch (Exception exception) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }

    protected void loadPluginInfo(File file, PluginImportData.PluginInfo pluginInfo) {
        try {
            NodeList nodeList;
            Document document = XMLUtil.loadXml((File)file);
            Element element = document.getDocumentElement();
            Element element2 = null;
            if (element.getTagName().equals("org.eclipse.epf.uma:MethodPlugin")) {
                element2 = element;
            } else {
                nodeList = element.getElementsByTagName("org.eclipse.epf.uma:MethodPlugin");
                if (nodeList.getLength() > 0) {
                    element2 = (Element)nodeList.item(0);
                }
            }
            if (element2 != null) {
                pluginInfo.name = element2.getAttribute("name");
                pluginInfo.version = LibraryDocument.getChildValue((Element)element2, (String)"version");
                pluginInfo.brief_desc = LibraryDocument.getChildValue((Element)element2, (String)"briefDescription");
                pluginInfo.authors = LibraryDocument.getChildValue((Element)element2, (String)"authors");
                pluginInfo.changeDate = LibraryDocument.getChildValue((Element)element2, (String)"changeDate");
                pluginInfo.url = file.toString();
                nodeList = element2.getElementsByTagName("bases");
                int n = 0;
                while (n < nodeList.getLength()) {
                    Element element3 = (Element)nodeList.item(n);
                    String string = element3.getAttribute("href");
                    int n2 = string.indexOf("#");
                    if (n2 > 0) {
                        string = string.substring(n2 + 1);
                    } else {
                        n2 = string.indexOf("uma://");
                        if (n2 >= 0) {
                            string = string.substring(n2 + 6);
                        }
                    }
                    pluginInfo.usedPlugins.add(string);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }

    private void loadExistingPluginInfo(PluginImportData.PluginInfo pluginInfo) {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        List list = methodLibrary == null ? new ArrayList() : methodLibrary.getMethodPlugins();
        for (MethodPlugin methodPlugin : list) {
            if (!methodPlugin.getGuid().equals(pluginInfo.guid)) continue;
            pluginInfo.existingPlugin = methodPlugin;
        }
    }

    private void loadExistingConfigInfo(PluginImportData.ConfiguarationInfo configuarationInfo) {
        MethodConfiguration[] methodConfigurationArray = LibraryServiceUtil.getMethodConfigurations((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
        if (methodConfigurationArray == null || methodConfigurationArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < methodConfigurationArray.length) {
            MethodConfiguration methodConfiguration = methodConfigurationArray[n];
            if (methodConfiguration.getGuid().equals(configuarationInfo.guid)) {
                configuarationInfo.existingConfig = methodConfiguration;
            }
            ++n;
        }
    }

    private void fixLibraryGuid(File file, String string, String string2) {
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                return string.equals("library.xmi") || string.equals("plugin.xmi") || string.equals("model.xmi");
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                this.fixLibraryGuid(fileArray[n], string, string2);
            } else {
                try {
                    String string3 = FileUtil.readFile((File)fileArray[n], (String)"UTF-8").toString();
                    if (string3.indexOf(string) >= 0) {
                        string3 = string3.replaceAll(string, string2);
                        FileUtil.writeUTF8File((String)fileArray[n].getAbsolutePath(), (String)string3);
                    }
                }
                catch (IOException iOException) {
                    ImportPlugin.getDefault().getLogger().logError((Throwable)iOException);
                }
            }
            ++n;
        }
    }

    private boolean merge(LibraryDocument libraryDocument) throws Exception {
        if (!this.importEntries(libraryDocument)) {
            return false;
        }
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        Resource resource = methodLibrary.eResource();
        ResourceManager resourceManager = MultiFileSaveUtil.getResourceManager((Resource)resource);
        ResourceSet resourceSet = resource.getResourceSet();
        this.mergePlugins(libraryDocument, methodLibrary, resourceManager, resourceSet);
        this.mergeConfigs(libraryDocument, methodLibrary, resourceManager, resourceSet);
        methodLibrary.eResource().setModified(true);
        this.save(methodLibrary, null);
        LibraryService.getInstance().reopenCurrentMethodLibrary();
        if (!this.isCheckBasePlugins()) {
            methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
            LibraryUtil.loadAll((MethodLibrary)methodLibrary);
            List<MethodPlugin> list = this.collectMissingBasePlugins(methodLibrary);
            List list2 = methodLibrary.getPredefinedConfigurations();
            this.checkModify(list2);
            if (!list.isEmpty() || !list2.isEmpty()) {
                methodLibrary.eResource().setModified(true);
                LinkedHashSet<Resource> linkedHashSet = new LinkedHashSet<Resource>();
                this.collectResourcestoSave(linkedHashSet, list);
                this.collectResourcestoSave(linkedHashSet, list2);
                this.save(methodLibrary, linkedHashSet);
                LibraryService.getInstance().reopenCurrentMethodLibrary();
            }
        }
        return true;
    }

    private void checkModify(List<MethodConfiguration> list) {
        if (list == null) {
            return;
        }
        final ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < list.size()) {
            MethodConfiguration methodConfiguration = list.get(n);
            Resource resource = methodConfiguration.eResource();
            if (resource != null) {
                String string = resource.getURI().toFileString();
                arrayList.add(string);
            }
            ++n;
        }
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                PluginImportingService.this.fileCheckedOutStatus = FileModifyChecker.checkModify(arrayList);
            }
        });
    }

    private List<MethodPlugin> collectMissingBasePlugins(MethodLibrary methodLibrary) {
        ArrayList<MethodPlugin> arrayList = new ArrayList<MethodPlugin>();
        Map map = MethodElementUtil.buildMap((Collection)methodLibrary.getMethodPlugins());
        block0: for (PluginImportData.PluginInfo pluginInfo : this.data.getPlugins()) {
            MethodPlugin methodPlugin;
            if (!pluginInfo.selected || (methodPlugin = (MethodPlugin)map.get(pluginInfo.guid)) == null) continue;
            List list = methodPlugin.getBases();
            int n = 0;
            while (n < list.size()) {
                MethodPlugin methodPlugin2 = (MethodPlugin)list.get(n);
                if (!map.containsKey(methodPlugin2.getGuid())) {
                    arrayList.add(methodPlugin);
                    continue block0;
                }
                ++n;
            }
        }
        return arrayList;
    }

    private void collectResourcestoSave(Set<Resource> set, List<? extends MethodElement> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            this.collectResourcestoSave(set, list.get(n));
            ++n;
        }
    }

    private void collectResourcestoSave(Set<Resource> set, MethodElement methodElement) {
        TreeIterator treeIterator;
        if (methodElement instanceof MethodPlugin) {
            treeIterator = methodElement.eAllContents();
            while (treeIterator.hasNext()) {
                Resource resource;
                EObject eObject = (EObject)treeIterator.next();
                if (eObject instanceof ContentDescription || (resource = eObject.eResource()) == null) continue;
                set.add(resource);
                resource.setModified(true);
            }
        }
        treeIterator = methodElement.eResource();
        set.add((Resource)treeIterator);
        treeIterator.setModified(true);
    }

    private void save(ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister, Set<Resource> set) throws Exception {
        if (set == null) {
            return;
        }
        for (MultiFileXMIResourceImpl multiFileXMIResourceImpl : set) {
            try {
                if (!multiFileXMIResourceImpl.isSynchronized()) {
                    multiFileXMIResourceImpl.load(multiFileXMIResourceImpl.getResourceSet().getLoadOptions());
                }
                failSafeMethodLibraryPersister.save((Resource)multiFileXMIResourceImpl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void save(MethodLibrary methodLibrary, Set<Resource> set) {
        block10: {
            MultiFileResourceSetImpl multiFileResourceSetImpl = (MultiFileResourceSetImpl)methodLibrary.eResource().getResourceSet();
            Map map = multiFileResourceSetImpl.getDefaultSaveOptions();
            Object v = map.get("DISCARD_UNRESOLVED_REFERENCES");
            ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
            Map map2 = failSafeMethodLibraryPersister.getSaveOptions();
            if (!this.isCheckBasePlugins() && set != null) {
                map2.put("DISCARD_UNRESOLVED_REFERENCES", Boolean.TRUE);
                map.put("DISCARD_UNRESOLVED_REFERENCES", Boolean.TRUE);
            }
            try {
                try {
                    this.save(failSafeMethodLibraryPersister, set);
                    failSafeMethodLibraryPersister.save(methodLibrary.eResource());
                    failSafeMethodLibraryPersister.commit();
                }
                catch (Exception exception) {
                    failSafeMethodLibraryPersister.rollback();
                    exception.printStackTrace();
                    if (this.isCheckBasePlugins() || set == null) break block10;
                    if (v == null) {
                        map.remove("DISCARD_UNRESOLVED_REFERENCES");
                        break block10;
                    }
                    map.put("DISCARD_UNRESOLVED_REFERENCES", v);
                }
            }
            finally {
                if (!this.isCheckBasePlugins() && set != null) {
                    if (v == null) {
                        map.remove("DISCARD_UNRESOLVED_REFERENCES");
                    } else {
                        map.put("DISCARD_UNRESOLVED_REFERENCES", v);
                    }
                }
            }
        }
    }

    private void mergePlugins(LibraryDocument libraryDocument, MethodLibrary methodLibrary, ResourceManager resourceManager, ResourceSet resourceSet) {
        ArrayList<String> arrayList = null;
        for (Object object : this.data.getPlugins()) {
            if (!((PluginImportData.PluginInfo)object).selected || ((PluginImportData.PluginInfo)object).existingPlugin == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(((PluginImportData.PluginInfo)object).guid);
        }
        Map map = this.importingLibDoc.buildPluginGuidToResMgrGuidMap(arrayList);
        for (PluginImportData.PluginInfo pluginInfo : this.data.getPlugins()) {
            if (pluginInfo.selected && pluginInfo.existingPlugin == null) {
                this.mergeElement(pluginInfo.guid, libraryDocument, methodLibrary, resourceManager, resourceSet, methodLibrary.getMethodPlugins());
                continue;
            }
            if (!pluginInfo.selected || map == null) continue;
            Resource resource = pluginInfo.existingPlugin.eResource();
            ResourceManager resourceManager2 = MultiFileSaveUtil.getResourceManager((Resource)resource);
            String string = resourceManager2.getGuid();
            String string2 = (String)map.get(pluginInfo.guid);
            if (string2 == null || string2.equals(string)) continue;
            resourceManager2.setGuid(string2);
        }
    }

    private void mergeConfigs(LibraryDocument libraryDocument, MethodLibrary methodLibrary, ResourceManager resourceManager, ResourceSet resourceSet) {
        for (PluginImportData.ConfiguarationInfo configuarationInfo : this.data.getConfigs()) {
            if (!configuarationInfo.selected || configuarationInfo.existingConfig != null) continue;
            this.mergeElement(configuarationInfo.guid, libraryDocument, methodLibrary, resourceManager, resourceSet, methodLibrary.getPredefinedConfigurations());
        }
    }

    private void mergeElement(String string, LibraryDocument libraryDocument, MethodLibrary methodLibrary, ResourceManager resourceManager, ResourceSet resourceSet, List list) {
        String string2 = this.importingLibDoc.getResourceUri(string);
        if (string2 == null || string2.length() == 0) {
            return;
        }
        File file = this.targetFileMap.get(string);
        String string3 = file.getAbsolutePath();
        URI uRI = URI.createFileURI((String)string3);
        Resource resource = resourceSet.getResource(uRI, true);
        MethodElement methodElement = PersistenceUtil.getMethodElement((Resource)resource);
        list.add(methodElement);
        MultiFileSaveUtil.registerWithResourceManager((ResourceManager)resourceManager, (Object)methodElement, (URI)uRI);
        ResourceManager resourceManager2 = MultiFileSaveUtil.getResourceManager((Resource)resource);
        if (resourceManager2 != null) {
            resourceManager.getSubManagers().add(resourceManager2);
        }
    }

    private void buildConfigInfoFromFiles() {
        File file = this.upGradeInfo == null ? null : this.upGradeInfo.getCopiedLibFile();
        File file2 = file == null ? new File(String.valueOf(this.data.llData.getParentFolder()) + File.separator + "export.xmi") : file;
        File file3 = new File(file2.getParent(), "configurations");
        LibraryDocument.ConfigDocVisitor configDocVisitor = new LibraryDocument.ConfigDocVisitor(){

            public void visit(File file, Element element) {
                PluginImportData.ConfiguarationInfo configuarationInfo = PluginImportingService.this.data.new PluginImportData.ConfiguarationInfo();
                configuarationInfo.guid = element.getAttribute("guid");
                configuarationInfo.name = element.getAttribute("name");
                String string = "configurations" + File.separator + file.getName();
                PluginImportingService.this.importingLibDoc.addToGuidToUriMap(configuarationInfo.guid, string);
                PluginImportingService.this.data.getConfigs().add(configuarationInfo);
                PluginImportingService.this.loadExistingConfigInfo(configuarationInfo);
                if (configuarationInfo.existingConfig != null) {
                    URI uRI = configuarationInfo.existingConfig.eResource().getURI();
                    string = "configurations" + File.separator + uRI.lastSegment();
                    string = PluginImportingService.this.targetLibDoc.decodeUri(string);
                    PluginImportingService.this.targetLibDoc.addToGuidToUriMap(configuarationInfo.guid, string);
                }
            }
        };
        LibraryDocument.visitConfigFiles((File)file3, (LibraryDocument.ConfigDocVisitor)configDocVisitor);
    }

    private void ensureUniqueNames(List list) {
        Object object;
        Object object2;
        Object object32;
        Object object4;
        if (list.isEmpty()) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = 0;
        while (n < list.size()) {
            object4 = (MethodElement)list.get(n);
            hashMap.put(object4.getName().toUpperCase(), object4);
            ++n;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        object4 = new ArrayList();
        if (list.get(0) instanceof MethodPlugin) {
            for (Object object32 : this.data.getPlugins()) {
                if (!((PluginImportData.PluginInfo)object32).selected || ((PluginImportData.PluginInfo)object32).existingPlugin != null && ((PluginImportData.PluginInfo)object32).existingPlugin.getName().equals(((PluginImportData.PluginInfo)object32).name)) continue;
                arrayList.add(((PluginImportData.PluginInfo)object32).name);
                if (((PluginImportData.PluginInfo)object32).existingPlugin == null) continue;
                object4.add(object32);
            }
        } else {
            for (Object object32 : this.data.getConfigs()) {
                if (!((PluginImportData.ConfiguarationInfo)object32).selected || ((PluginImportData.ConfiguarationInfo)object32).existingConfig != null && ((PluginImportData.ConfiguarationInfo)object32).existingConfig.getName().equals(((PluginImportData.ConfiguarationInfo)object32).name)) continue;
                arrayList.add(((PluginImportData.ConfiguarationInfo)object32).name);
                if (((PluginImportData.ConfiguarationInfo)object32).existingConfig == null) continue;
                object4.add(object32);
            }
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            object2 = object32 = (String)arrayList.get(n2);
            while (hashMap.containsKey(((String)object2).toUpperCase())) {
                object2 = String.valueOf(object2) + "_renamed";
            }
            if (object2 != object32) {
                object = (MethodElement)hashMap.get(((String)object32).toUpperCase());
                LibraryView.runRename((NamedElement)object, (String)object2);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < object4.size()) {
            object32 = object4.get(n2);
            object2 = object32 instanceof PluginImportData.PluginInfo ? ((PluginImportData.PluginInfo)object32).existingPlugin : ((PluginImportData.ConfiguarationInfo)object32).existingConfig;
            object = object32 instanceof PluginImportData.PluginInfo ? ((PluginImportData.PluginInfo)object32).name : ((PluginImportData.ConfiguarationInfo)object32).name;
            LibraryView.runRename((NamedElement)object2, (String)object);
            ++n2;
        }
    }

    private File getTargetFile(final MethodLibrary methodLibrary, String string) {
        Object object;
        File file = null;
        final File[] fileArray = new File[1];
        final IFileBasedLibraryPersister iFileBasedLibraryPersister = (IFileBasedLibraryPersister)LibraryServiceUtil.getCurrentPersister();
        PluginImportData.ConfiguarationInfo configuarationInfo = this.data.getConfigInfo(string);
        if (configuarationInfo != null) {
            object = this.getResourceFile((MethodElement)configuarationInfo.existingConfig);
            if (object != null) {
                return object;
            }
            if (this.defaultConfigFolder == null) {
                SafeUpdateController.syncExec((Runnable)new Runnable(){

                    public void run() {
                        fileArray[0] = iFileBasedLibraryPersister.getDefaultMethodConfigurationFolder(methodLibrary);
                    }
                });
                file = fileArray[0];
                if (file == null) {
                    return null;
                }
                this.defaultConfigFolder = file;
            } else {
                file = this.defaultConfigFolder;
            }
            if (localDebug) {
                System.out.println("LD> defaultConfigFolder: " + file);
            }
        } else {
            object = this.data.getPluginInfo(string);
            if (object != null) {
                File file2 = this.getResourceFile((MethodElement)((PluginImportData.PluginInfo)object).existingPlugin);
                if (file2 != null) {
                    return file2;
                }
                file = iFileBasedLibraryPersister.createMethodPluginFolder(((PluginImportData.PluginInfo)object).name, methodLibrary);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        object = configuarationInfo == null ? "plugin.xmi" : String.valueOf(configuarationInfo.name) + ".xmi";
        return new File(file, (String)object);
    }

    public boolean isCheckBasePlugins() {
        return this.checkBasePlugins;
    }

    public void setCheckBasePlugins(boolean bl) {
        this.checkBasePlugins = bl;
    }

    private File getResourceFile(MethodElement methodElement) {
        if (methodElement == null) {
            return null;
        }
        Resource resource = methodElement.eResource();
        URI uRI = resource.getURI();
        return new File(uRI.toFileString());
    }
}

