/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.io.File;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.export.wizards.DestinationCommonPage;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.importing.services.PluginImportingService;
import org.eclipse.epf.importing.wizards.ImportPluginWizard;
import org.eclipse.epf.importing.wizards.ImportUIPreferences;
import org.eclipse.epf.importing.wizards.SelectPluginsToImport;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class SelectImportPluginSource
extends DestinationCommonPage {
    public static final String PAGE_NAME = SelectImportPluginSource.class.getName();
    private static final Status OK_STATUS = new Status(0, ImportResources.SelectImportPluginSource_not_used, 0, "", null);
    private PluginImportData data;
    private PluginImportingService service;
    private Status status = OK_STATUS;

    public SelectImportPluginSource(PluginImportData pluginImportData, PluginImportingService pluginImportingService) {
        super(PAGE_NAME, pluginImportData.llData);
        this.setTitle(ImportResources.selectPluginsDirWizardPage_title);
        this.setDescription(ImportResources.selectPluginsDirWizardPage_text);
        this.setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportMethodPlugins.gif"));
        this.service = pluginImportingService;
        this.data = pluginImportData;
    }

    protected void initControls() {
        String[] stringArray = ImportUIPreferences.getImportPluginDirs();
        if (stringArray != null && stringArray.length > 0) {
            this.exportPathCombo.setItems(stringArray);
            this.exportPathCombo.setText(stringArray[0]);
        }
        super.initControls();
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        boolean bl = false;
        this.status = OK_STATUS;
        if (this.exportPathCombo.getText().length() > 0) {
            this.saveToDataModel();
            File file = new File(this.exportPathCombo.getText());
            if (!file.exists()) {
                this.status = new Status(4, ImportResources.SelectImportPluginSource_not_used, 0, ImportResources.SelectImportPluginSource_no_path, null);
            } else {
                bl = true;
            }
        }
        this.applyToStatusLine();
        return bl;
    }

    public IWizardPage getNextPage() {
        this.saveToDataModel();
        this.service.validate(null);
        String string = this.data.getErrorInfo().getError();
        if (string != null && string.length() > 0) {
            super.setErrorMessage(string);
            return this;
        }
        SelectPluginsToImport selectPluginsToImport = ((ImportPluginWizard)this.getWizard()).page2;
        selectPluginsToImport.onEnterPage(null);
        return selectPluginsToImport;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void applyToStatusLine() {
        if (this.status != OK_STATUS) {
            this.setErrorMessage(this.status.getMessage());
        } else {
            this.setErrorMessage(null);
        }
    }

    protected void createAdditionalControls(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        group.setLayoutData((Object)gridData);
        group.setText(ImportResources.optionGroup_text);
        boolean bl = ImportUIPreferences.getCheckBasePlugins();
        this.setCheckBasePlugins(bl);
        Button button = SelectImportPluginSource.createRadioButton((Composite)group, (String)ImportResources.checkBaseRadioButton_text, (int)1, (boolean)bl);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectImportPluginSource.this.setCheckBasePlugins(true);
            }
        });
        Button button2 = SelectImportPluginSource.createRadioButton((Composite)group, (String)ImportResources.ignoreRemoveRadioButton_text, (int)1, (!bl ? 1 : 0) != 0);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectImportPluginSource.this.setCheckBasePlugins(false);
            }
        });
    }

    private void setCheckBasePlugins(boolean bl) {
        this.service.setCheckBasePlugins(bl);
    }
}

