/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegatingEList<E>
extends AbstractList<E>
implements EList<E>,
Cloneable,
Serializable {
    public DelegatingEList() {
    }

    public DelegatingEList(Collection<? extends E> collection) {
        this.addAll(collection);
    }

    protected boolean useEquals() {
        return true;
    }

    protected boolean equalObjects(Object firstObject, Object secondObject) {
        return this.useEquals() && firstObject != null ? firstObject.equals(secondObject) : firstObject == secondObject;
    }

    protected boolean canContainNull() {
        return true;
    }

    protected boolean isUnique() {
        return false;
    }

    protected E validate(int index, E object) {
        if (!this.canContainNull() && object == null) {
            throw new IllegalArgumentException("The 'no null' constraint is violated");
        }
        return object;
    }

    protected E resolve(int index, E object) {
        return object;
    }

    protected void didSet(int index, E newObject, E oldObject) {
    }

    protected void didAdd(int index, E newObject) {
    }

    protected void didRemove(int index, E oldObject) {
    }

    protected void didClear(int size, Object[] oldObjects) {
        if (oldObjects != null) {
            int i = 0;
            while (i < size) {
                Object object = oldObjects[i];
                this.didRemove(i, object);
                ++i;
            }
        }
    }

    protected void didMove(int index, E movedObject, int oldIndex) {
    }

    protected void didChange() {
    }

    protected abstract List<E> delegateList();

    @Override
    public int size() {
        return this.delegateSize();
    }

    protected int delegateSize() {
        return this.delegateList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegateIsEmpty();
    }

    protected boolean delegateIsEmpty() {
        return this.delegateList().isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.delegateContains(object);
    }

    protected boolean delegateContains(Object object) {
        return this.delegateList().contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.delegateContainsAll(collection);
    }

    protected boolean delegateContainsAll(Collection<?> collection) {
        return this.delegateList().containsAll(collection);
    }

    @Override
    public int indexOf(Object object) {
        return this.delegateIndexOf(object);
    }

    protected int delegateIndexOf(Object object) {
        return this.delegateList().indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.delegateLastIndexOf(object);
    }

    protected int delegateLastIndexOf(Object object) {
        return this.delegateList().lastIndexOf(object);
    }

    @Override
    public Object[] toArray() {
        return this.delegateToArray();
    }

    protected Object[] delegateToArray() {
        return this.delegateList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.delegateToArray(array);
    }

    protected <T> T[] delegateToArray(T[] array) {
        return this.delegateList().toArray(array);
    }

    @Override
    public E get(int index) {
        return this.resolve(index, this.delegateGet(index));
    }

    protected E delegateGet(int index) {
        return this.delegateList().get(index);
    }

    protected E basicGet(int index) {
        return this.delegateGet(index);
    }

    @Override
    public E set(int index, E object) {
        int currentIndex;
        if (this.isUnique() && (currentIndex = this.indexOf(object)) >= 0 && currentIndex != index) {
            throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
        }
        return this.setUnique(index, object);
    }

    public E setUnique(int index, E object) {
        E oldObject = this.delegateSet(index, this.validate(index, object));
        this.didSet(index, object, oldObject);
        this.didChange();
        return oldObject;
    }

    protected E delegateSet(int index, E object) {
        return this.delegateList().set(index, object);
    }

    @Override
    public boolean add(E object) {
        if (this.isUnique() && this.contains(object)) {
            return false;
        }
        this.addUnique(object);
        return true;
    }

    public void addUnique(E object) {
        ++this.modCount;
        int size = this.size();
        this.delegateAdd(this.validate(size, object));
        this.didAdd(size, object);
        this.didChange();
    }

    protected void delegateAdd(E object) {
        this.delegateList().add(object);
    }

    @Override
    public void add(int index, E object) {
        if (this.isUnique() && this.contains(object)) {
            throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
        }
        this.addUnique(index, object);
    }

    public void addUnique(int index, E object) {
        ++this.modCount;
        this.delegateAdd(index, this.validate(index, object));
        this.didAdd(index, object);
        this.didChange();
    }

    protected void delegateAdd(int index, E object) {
        this.delegateList().add(index, object);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (this.isUnique()) {
            collection = this.getNonDuplicates(collection);
        }
        return this.addAllUnique(collection);
    }

    public boolean addAllUnique(Collection<? extends E> collection) {
        ++this.modCount;
        if (collection.isEmpty()) {
            return false;
        }
        int i = this.size();
        for (E object : collection) {
            this.delegateAdd(this.validate(i, object));
            this.didAdd(i, object);
            this.didChange();
            ++i;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        if (this.isUnique()) {
            collection = this.getNonDuplicates(collection);
        }
        return this.addAllUnique(index, collection);
    }

    public boolean addAllUnique(int index, Collection<? extends E> collection) {
        ++this.modCount;
        if (collection.isEmpty()) {
            return false;
        }
        for (E object : collection) {
            this.delegateAdd(index, this.validate(index, object));
            this.didAdd(index, object);
            this.didChange();
            ++index;
        }
        return true;
    }

    public boolean addAllUnique(Object[] objects, int start, int end) {
        int growth = end - start;
        ++this.modCount;
        if (growth == 0) {
            return false;
        }
        int index = this.size();
        int i = start;
        while (i < end) {
            Object object = objects[i];
            this.delegateAdd(this.validate(index, object));
            this.didAdd(index, object);
            this.didChange();
            ++i;
            ++index;
        }
        return true;
    }

    public boolean addAllUnique(int index, Object[] objects, int start, int end) {
        int growth = end - start;
        ++this.modCount;
        if (growth == 0) {
            return false;
        }
        int i = start;
        while (i < end) {
            Object object = objects[i];
            this.delegateAdd(this.validate(index, object));
            this.didAdd(index, object);
            this.didChange();
            ++i;
            ++index;
        }
        return true;
    }

    @Override
    public boolean remove(Object object) {
        int index = this.indexOf(object);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean modified = false;
        ListIterator<E> i = this.listIterator();
        while (i.hasNext()) {
            if (!collection.contains(i.next())) continue;
            i.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public E remove(int index) {
        ++this.modCount;
        E oldObject = this.delegateRemove(index);
        this.didRemove(index, oldObject);
        this.didChange();
        return oldObject;
    }

    protected E delegateRemove(int index) {
        return this.delegateList().remove(index);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        ListIterator<E> i = this.listIterator();
        while (i.hasNext()) {
            if (collection.contains(i.next())) continue;
            i.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.doClear(this.size(), this.delegateToArray());
    }

    protected void doClear(int oldSize, Object[] oldData) {
        ++this.modCount;
        this.delegateClear();
        this.didClear(oldSize, oldData);
        this.didChange();
    }

    protected void delegateClear() {
        this.delegateList().clear();
    }

    @Override
    public void move(int index, E object) {
        this.move(index, this.indexOf(object));
    }

    @Override
    public E move(int targetIndex, int sourceIndex) {
        E object;
        ++this.modCount;
        int size = this.size();
        if (targetIndex >= size || targetIndex < 0) {
            throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=" + size);
        }
        if (sourceIndex >= size || sourceIndex < 0) {
            throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=" + size);
        }
        if (targetIndex != sourceIndex) {
            object = this.delegateMove(targetIndex, sourceIndex);
            this.didMove(targetIndex, object, sourceIndex);
            this.didChange();
        } else {
            object = this.delegateGet(sourceIndex);
        }
        return object;
    }

    protected E delegateMove(int targetIndex, int sourceIndex) {
        E result = this.delegateRemove(sourceIndex);
        this.delegateAdd(targetIndex, result);
        return result;
    }

    @Override
    public boolean equals(Object object) {
        return this.delegateEquals(object);
    }

    protected boolean delegateEquals(Object object) {
        return this.delegateList().equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegateHashCode();
    }

    protected int delegateHashCode() {
        return this.delegateList().hashCode();
    }

    @Override
    public String toString() {
        return this.delegateToString();
    }

    protected String delegateToString() {
        return this.delegateList().toString();
    }

    @Override
    public Iterator<E> iterator() {
        return new EIterator();
    }

    protected Iterator<E> delegateIterator() {
        return this.delegateList().iterator();
    }

    protected Iterator<E> basicIterator() {
        return new NonResolvingEIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new EListIterator();
    }

    protected ListIterator<E> delegateListIterator() {
        return this.delegateList().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        int size = this.size();
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + size);
        }
        return new EListIterator(index);
    }

    protected ListIterator<E> basicListIterator() {
        return new NonResolvingEListIterator();
    }

    protected ListIterator<E> basicListIterator(int index) {
        int size = this.size();
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + size);
        }
        return new NonResolvingEListIterator(index);
    }

    protected List<E> basicList() {
        return this.delegateBasicList();
    }

    protected List<E> delegateBasicList() {
        return this.delegateList();
    }

    protected Collection<E> getDuplicates(Collection<?> collection) {
        if (collection.isEmpty()) {
            return ECollections.emptyEList();
        }
        BasicEList<E> filteredResult = this.useEquals() ? new BasicEList<E>(collection.size()) : new BasicEList.FastCompare(collection.size());
        for (E object : this) {
            if (!collection.contains(object)) continue;
            filteredResult.add(object);
        }
        return filteredResult;
    }

    protected Collection<E> getNonDuplicates(Collection<? extends E> collection) {
        UniqueEList<E> result = this.useEquals() ? new UniqueEList<E>(collection.size()) : new UniqueEList.FastCompare(collection.size());
        for (E object : collection) {
            if (this.contains(object)) continue;
            result.add(object);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EIterator<E1>
    implements Iterator<E1> {
        protected int cursor = 0;
        protected int lastCursor = -1;
        protected int expectedModCount;

        protected EIterator() {
            this.expectedModCount = DelegatingEList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != DelegatingEList.this.size();
        }

        @Override
        public E1 next() {
            return (E1)this.doNext();
        }

        protected E doNext() {
            try {
                Object next = DelegatingEList.this.get(this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                DelegatingEList.this.remove(this.lastCursor);
                this.expectedModCount = DelegatingEList.this.modCount;
                if (this.lastCursor < this.cursor) {
                    --this.cursor;
                }
                this.lastCursor = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        protected void checkModCount() {
            if (DelegatingEList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EListIterator<E1>
    extends EIterator<E1>
    implements ListIterator<E1> {
        public EListIterator() {
        }

        public EListIterator(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E1 previous() {
            return (E1)this.doPrevious();
        }

        protected E doPrevious() {
            try {
                Object previous = DelegatingEList.this.get(--this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor;
                return previous;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E1 object) {
            this.doSet(object);
        }

        protected void doSet(E object) {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                DelegatingEList.this.set(this.lastCursor, object);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E1 object) {
            this.doAdd(object);
        }

        protected void doAdd(E object) {
            this.checkModCount();
            try {
                DelegatingEList.this.add(this.cursor++, object);
                this.expectedModCount = DelegatingEList.this.modCount;
                this.lastCursor = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NonResolvingEIterator<E1>
    extends EIterator<E1> {
        protected NonResolvingEIterator() {
        }

        @Override
        public E doNext() {
            try {
                Object next = DelegatingEList.this.delegateGet(this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NonResolvingEListIterator<E1>
    extends EListIterator<E1> {
        public NonResolvingEListIterator() {
        }

        public NonResolvingEListIterator(int index) {
            super(index);
        }

        @Override
        protected E doNext() {
            try {
                Object next = DelegatingEList.this.delegateGet(this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        @Override
        protected E doPrevious() {
            try {
                Object previous = DelegatingEList.this.delegateGet(--this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor;
                return previous;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E1 object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E1 object) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnmodifiableEList<E>
    extends DelegatingEList<E> {
        private static final long serialVersionUID = 1L;
        protected List<E> underlyingList;

        public UnmodifiableEList(List<E> underlyingList) {
            this.underlyingList = underlyingList;
        }

        @Override
        protected List<E> delegateList() {
            return this.underlyingList;
        }

        @Override
        public E set(int index, E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void move(int index, E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E move(int targetIndex, int sourceIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            return this.basicIterator();
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.basicListIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return this.basicListIterator(index);
        }
    }
}

