/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextComboAction;
import org.eclipse.epf.richtext.html.FontStyle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontStyleAction
extends RichTextComboAction {
    public FontStyleAction(final IRichText iRichText) {
        super(iRichText);
        this.setToolTipText(RichTextResources.fontStyleAction_toolTipText);
        this.input = new ArrayList();
        this.input.add(FontStyle.NORMAL.getName());
        this.input.add(FontStyle.SECTION_HEADING.getName());
        this.input.add(FontStyle.SUBSECTION_HEADING.getName());
        this.input.add(FontStyle.SUB_SUBSECTION_HEADING.getName());
        this.input.add(FontStyle.QUOTE.getName());
        this.input.add(FontStyle.CODE_SAMPLE.getName());
        iRichText.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                String string = iRichText.getSelected().getBlockStyle();
                String string2 = FontStyle.getFontStyleName(string);
                int n = ((List)FontStyleAction.this.input).indexOf(string2);
                FontStyleAction.this.setNotifyListeners(false);
                FontStyleAction.this.getCCombo().select(n);
                FontStyleAction.this.setNotifyListeners(true);
            }
        });
    }

    @Override
    public void execute(IRichText iRichText) {
        if (iRichText != null) {
            String string = this.getCComboSelection();
            String string2 = FontStyle.getFontStyleValue(string);
            iRichText.executeCommand("setFontStyle", string2);
        }
    }

    @Override
    public Collection<String> getInput() {
        return this.input;
    }
}

