/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.io.UnsupportedEncodingException;
import org.eclipse.epf.common.html.HTMLFormatter;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;

public class TidyAction
extends RichTextAction {
    boolean forceOutput = false;
    boolean makeBare = false;
    boolean word2000 = false;
    protected HTMLFormatter htmlFormatter;

    public TidyAction(IRichText iRichText, boolean bl, boolean bl2, boolean bl3) {
        super(iRichText, 1);
        this.forceOutput = bl;
        this.makeBare = bl2;
        this.word2000 = bl3;
        this.setImageDescriptor(RichTextImages.IMG_DESC_TIDY);
        this.setToolTipText(RichTextResources.pastePlainTextAction_toolTipText);
        this.htmlFormatter = new HTMLFormatter();
    }

    public void execute(IRichText iRichText) {
        String string = iRichText instanceof RichTextEditor ? ((RichTextEditor)iRichText).getText() : iRichText.getText();
        try {
            string = this.htmlFormatter.formatHTML(string, false, this.forceOutput, this.makeBare, this.word2000);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            RichTextPlugin.getDefault().getLogger().logError((Throwable)unsupportedEncodingException);
        }
        if (iRichText instanceof RichTextEditor) {
            ((RichTextEditor)iRichText).setText(string);
        } else {
            iRichText.setText(string);
        }
        iRichText.checkModify();
    }

    public boolean disableInSourceMode() {
        return false;
    }
}

