/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishManager;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.epf.publishing.ui.wizards.PublishProgressMonitorDialog;
import org.eclipse.epf.publishing.ui.wizards.PublishingOperation;
import org.eclipse.epf.publishing.ui.wizards.SelectConfigPage;
import org.eclipse.epf.publishing.ui.wizards.SelectContentPage;
import org.eclipse.epf.publishing.ui.wizards.SelectDestinationPage;
import org.eclipse.epf.publishing.ui.wizards.SelectPublishingOptionsPage;
import org.eclipse.epf.ui.wizards.BaseWizard;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class PublishConfigWizard
extends BaseWizard
implements INewWizard {
    public static final String WIZARD_ID = PublishConfigWizard.class.getName();
    public static final String WIZARD_EXTENSION_POINT_ID = "org.eclipse.epf.publishing.ui.publishConfigWizard";
    protected SelectConfigPage selectConfigPage;
    protected SelectContentPage selectContentPage;
    protected SelectPublishingOptionsPage selectPublishingOptionsPage;
    protected SelectDestinationPage selectDestinationPage;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        this.setWindowTitle(PublishingUIResources.publishConfigWizard_title);
    }

    public String getWizardExtenderExtensionPointId() {
        return WIZARD_EXTENSION_POINT_ID;
    }

    public void addPages() {
        if (this.wizardExtender == null) {
            this.selectConfigPage = new SelectConfigPage();
            this.selectContentPage = new SelectContentPage();
            this.selectPublishingOptionsPage = new SelectPublishingOptionsPage();
            this.selectDestinationPage = new SelectDestinationPage();
            super.addPage((IWizardPage)this.selectConfigPage);
            super.addPage((IWizardPage)this.selectContentPage);
            super.addPage((IWizardPage)this.selectPublishingOptionsPage);
            super.addPage((IWizardPage)this.selectDestinationPage);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            IWizardPage iWizardPage = this.wizardExtender.getReplaceWizardPage(SelectConfigPage.PAGE_NAME);
            if (iWizardPage != null) {
                arrayList.add(iWizardPage);
            } else {
                this.selectConfigPage = new SelectConfigPage();
                arrayList.add((Object)this.selectConfigPage);
            }
            iWizardPage = this.wizardExtender.getReplaceWizardPage(SelectContentPage.PAGE_NAME);
            if (iWizardPage != null) {
                arrayList.add(iWizardPage);
            } else {
                this.selectContentPage = new SelectContentPage();
                arrayList.add((Object)this.selectContentPage);
            }
            iWizardPage = this.wizardExtender.getReplaceWizardPage(SelectPublishingOptionsPage.PAGE_NAME);
            if (iWizardPage != null) {
                arrayList.add(iWizardPage);
            } else {
                this.selectPublishingOptionsPage = new SelectPublishingOptionsPage();
                arrayList.add((Object)this.selectPublishingOptionsPage);
            }
            iWizardPage = this.wizardExtender.getReplaceWizardPage(SelectDestinationPage.PAGE_NAME);
            if (iWizardPage != null) {
                arrayList.add(iWizardPage);
            } else {
                this.selectDestinationPage = new SelectDestinationPage();
                arrayList.add((Object)this.selectDestinationPage);
            }
            super.getNewWizardPages(arrayList);
            for (IWizardPage iWizardPage2 : arrayList) {
                super.addPage(iWizardPage2);
            }
            this.wizardExtender.initWizardPages(arrayList);
        }
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        composite.getShell().setImage(AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/MethodConfiguration.gif"));
    }

    public boolean performFinish() {
        if (this.wizardExtender != null) {
            return this.wizardExtender.doFinish();
        }
        PublishManager publishManager = new PublishManager();
        boolean bl = this.publishConfig(this.selectConfigPage.getConfigName(), this.getPublishingOptions(), publishManager);
        if (publishManager != null) {
            publishManager.dispose();
        }
        return bl;
    }

    public boolean publishConfig(String string, PublishOptions publishOptions, PublishManager publishManager) {
        try {
            if (this.checkAndCreateDir(publishOptions)) {
                MethodConfiguration methodConfiguration = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)string);
                publishManager.init(publishOptions.getPublishDir(), methodConfiguration, publishOptions);
                PublishingOperation publishingOperation = new PublishingOperation((AbstractPublishManager)publishManager);
                PublishProgressMonitorDialog publishProgressMonitorDialog = new PublishProgressMonitorDialog(Display.getCurrent().getActiveShell(), publishManager.getViewBuilder());
                UserInteractionHelper.runWithProgress((IRunnableWithProgress)publishingOperation, (IRunnableContext)publishProgressMonitorDialog, (boolean)true, (String)PublishingUIResources.publishConfigWizard_title);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigWizard_title, PublishingUIResources.publishConfigError_msg, PublishingUIResources.publishConfigError_reason, (Throwable)exception);
        }
        finally {
            if (this.selectPublishingOptionsPage != null) {
                this.selectPublishingOptionsPage.savePreferences();
            }
            if (this.selectDestinationPage != null) {
                this.selectDestinationPage.savePreferences();
            }
            MethodConfiguration methodConfiguration = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)string);
            String string2 = methodConfiguration.getGuid();
            PublishingUIPreferences.setConfigPrefInitialized(string2, true);
            PublishingUIPreferences.saveAllPreferences();
        }
        return true;
    }

    public PublishOptions getPublishingOptions() {
        PublishOptions publishOptions = this.selectPublishingOptionsPage != null ? this.selectPublishingOptionsPage.getPublishingOptions() : new PublishOptions();
        if (this.selectContentPage != null) {
            boolean bl = this.selectContentPage.getPublishConfigSelection();
            publishOptions.setPublishConfiguration(bl);
            publishOptions.setPublishProcess(!bl);
            if (!bl) {
                publishOptions.setProcesses(this.selectContentPage.getSelectedProcesses());
            }
        }
        if (this.selectDestinationPage != null) {
            publishOptions.setPublishDir(this.selectDestinationPage.getPublishDirectory());
            if (!this.selectDestinationPage.getStaticWebSiteSelection() && publishOptions instanceof PublishHTMLOptions) {
                PublishHTMLOptions publishHTMLOptions = (PublishHTMLOptions)publishOptions;
                publishHTMLOptions.setPublishDynamicWebApp(true);
                publishHTMLOptions.setDynamicWebAppName(this.selectDestinationPage.getWebAppName());
                publishHTMLOptions.setIncludeServletSearch(this.selectDestinationPage.getIncludeSearchSelection());
            }
        }
        return publishOptions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkAndCreateDir(PublishOptions publishOptions) {
        Object object;
        String string = publishOptions.getPublishDir();
        String string2 = PublishingUIPreferences.getDefaultPublishPath();
        boolean bl = false;
        IPath iPath = Path.fromOSString((String)string);
        if (!iPath.isAbsolute()) {
            object = String.valueOf(string2) + System.getProperty("file.separator") + string;
            bl = PublishingUIPlugin.getDefault().getMsgDialog().displayPrompt(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.bind((String)PublishingUIResources.confirmPathDialog_text, (Object)object));
            if (!bl) return false;
            publishOptions.setPublishDir(string);
        }
        if (((File)(object = new File(string))).exists()) {
            File[] fileArray = ((File)object).listFiles();
            if (fileArray == null || fileArray.length <= 0) return true;
            bl = PublishingUIPlugin.getDefault().getMsgDialog().displayConfirmation(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.bind((String)PublishingUIResources.overwriteDialog_text, (Object)string));
            if (!bl) return bl;
            try {
                bl = FileUtil.deleteAllFiles((String)((File)object).getAbsolutePath());
                if (bl) return bl;
                PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.cannotPublishError_msg, PublishingUIResources.bind((String)PublishingUIResources.deleteFilesError_reason, (Object)string));
                return false;
            }
            catch (Exception exception) {
                PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.cannotPublishError_msg, PublishingUIResources.bind((String)PublishingUIResources.deleteFilesError_reason, (Object)string), (Throwable)exception);
                return false;
            }
        }
        try {
            bl = ((File)object).mkdirs();
        }
        catch (Exception exception) {
            PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.cannotPublishError_msg, PublishingUIResources.bind((String)PublishingUIResources.createDirError_reason, (Object)((File)object).getAbsolutePath()), (Throwable)exception);
            return false;
        }
        if (bl) return bl;
        PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.cannotPublishError_msg, PublishingUIResources.bind((String)PublishingUIResources.createDirError_reason, (Object)((File)object).getAbsolutePath()));
        return false;
    }
}

