/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.xml.services;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.common.serviceability.VersionUtil;
import org.eclipse.epf.dataexchange.util.ContentProcessor;
import org.eclipse.epf.dataexchange.util.ILogger;
import org.eclipse.epf.dataexchange.util.IResourceHandler;
import org.eclipse.epf.export.services.DiagramHandler;
import org.eclipse.epf.export.xml.ExportXMLResources;
import org.eclipse.epf.export.xml.services.FeatureManager;
import org.eclipse.epf.export.xml.services.XMLLibrary;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigurationImportService;
import org.eclipse.epf.importing.services.FileModifyChecker;
import org.eclipse.epf.importing.services.LibraryImportManager;
import org.eclipse.epf.importing.wizards.PluginModifyInfo;
import org.eclipse.epf.importing.wizards.SelectImportConfigurationSource;
import org.eclipse.epf.importing.xml.ImportXMLPlugin;
import org.eclipse.epf.importing.xml.ImportXMLResources;
import org.eclipse.epf.importing.xml.services.ImportResourceHandler;
import org.eclipse.epf.importing.xml.services.ImportXMLogger;
import org.eclipse.epf.importing.xml.services.UmaLibrary;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.migration.IMigrator;
import org.eclipse.epf.persistence.migration.MappingUtil;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.xml.uma.Activity;
import org.eclipse.epf.xml.uma.CapabilityPattern;
import org.eclipse.epf.xml.uma.ContentCategory;
import org.eclipse.epf.xml.uma.ContentCategoryPackage;
import org.eclipse.epf.xml.uma.ContentPackage;
import org.eclipse.epf.xml.uma.DeliveryProcess;
import org.eclipse.epf.xml.uma.Discipline;
import org.eclipse.epf.xml.uma.Domain;
import org.eclipse.epf.xml.uma.Guidance;
import org.eclipse.epf.xml.uma.MethodElement;
import org.eclipse.epf.xml.uma.MethodElementProperty;
import org.eclipse.epf.xml.uma.MethodLibrary;
import org.eclipse.epf.xml.uma.MethodPackage;
import org.eclipse.epf.xml.uma.MethodPlugin;
import org.eclipse.epf.xml.uma.Process;
import org.eclipse.epf.xml.uma.ProcessComponent;
import org.eclipse.epf.xml.uma.ProcessPackage;
import org.eclipse.epf.xml.uma.UmaPackage;
import org.eclipse.epf.xml.uma.WorkOrder;
import org.eclipse.epf.xml.uma.WorkOrderType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ImportXMLService {
    private boolean error = false;
    private Map renameElementMap = new HashMap();
    private boolean overwrite = false;
    private IStatus fileCheckedOutStatus = null;
    private String xmlPath;
    private XMLLibrary xmlLib;
    private UmaLibrary umaLib;
    private ImportXMLogger logger = new ImportXMLogger();
    private List discardedElements = new ArrayList();
    private DiagramHandler diagramHandler;
    private Map<String, org.eclipse.epf.xml.uma.TaskDescriptor> tdMap;
    Map workOrderMap = new HashMap();
    private IMigrator migrator;
    private boolean checkBasePlugins = true;
    private List processedElements = new ArrayList();

    public boolean loadXml(final String string) {
        String string2 = this.versionCheck(string, ImportXMLResources.importXMLWizard_title);
        if (string2 != null) {
            return false;
        }
        this.xmlPath = string;
        this.logger.logMessage("Loading xml library ...");
        boolean bl = false;
        try {
            this.xmlLib = new XMLLibrary(null, (ILogger)this.logger, string);
            this.xmlLib.load();
            bl = this.checkOldPlugins();
        }
        catch (Exception exception) {
            this.logger.logError(NLS.bind((String)ExportXMLResources.xmlLibrary_error_load_xml, (Object)string), exception);
            final String string3 = exception.toString();
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    ImportXMLPlugin.getDefault().getMsgDialog().displayError(NLS.bind((String)ExportXMLResources.xmlLibrary_error_load_xml, (Object)string), string3);
                }
            });
        }
        return bl;
    }

    private boolean checkOldPlugins() {
        Object object;
        EList eList = ((MethodLibrary)this.xmlLib.getRoot()).getMethodPlugin();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < eList.size()) {
            object = (MethodElement)eList.get(n);
            arrayList.add(object.getId());
            ++n;
        }
        final PluginModifyInfo pluginModifyInfo = SelectImportConfigurationSource.checkModify(arrayList, (Shell)MsgBox.getDefaultShell(), (boolean)false);
        if (pluginModifyInfo.lockedPlugins.size() > 0) {
            object = new boolean[1];
            SafeUpdateController.syncExec((Runnable)new Runnable((boolean[])object){
                private final /* synthetic */ boolean[] val$ret;
                {
                    this.val$ret = blArray;
                }

                public void run() {
                    String string = ImportXMLResources.importXMLWizard_title;
                    String string2 = String.valueOf(pluginModifyInfo.getLockedMessage().toString()) + ImportResources.ImportPluginWizard_confirm_continue;
                    this.val$ret[0] = ImportXMLPlugin.getDefault().getMsgDialog().displayConfirmation(string, string2);
                }
            });
            return (boolean)object[0];
        }
        return true;
    }

    public File getLogPath() {
        return this.logger.getLogPath();
    }

    public void dispose() {
        this.discardedElements.clear();
        this.workOrderMap.clear();
        this.logger.dispose();
    }

    public void doImport(IProgressMonitor iProgressMonitor) throws Exception {
        boolean bl = RefreshJob.getInstance().isEnabled();
        try {
            try {
                String string;
                Object object;
                Object object2;
                Object object3;
                if (bl) {
                    RefreshJob.getInstance().setEnabled(false);
                }
                this.handleTypeChanges();
                ImportResourceHandler importResourceHandler = new ImportResourceHandler(new File(this.xmlPath).getParentFile(), new File(LibraryService.getInstance().getCurrentMethodLibraryLocation()));
                ContentProcessor contentProcessor = new ContentProcessor((IResourceHandler)importResourceHandler, (ILogger)this.logger);
                this.diagramHandler = new DiagramHandler(new File(this.xmlPath).getParentFile(), new File(LibraryService.getInstance().getCurrentMethodLibraryLocation())){

                    protected File[] getFiles(org.eclipse.epf.uma.MethodElement methodElement) {
                        File file;
                        Process process;
                        String string;
                        File[] fileArray = super.getFiles(methodElement, false);
                        EDataObject eDataObject = ImportXMLService.this.xmlLib.getElement(methodElement.getGuid());
                        if (eDataObject instanceof Process && (string = (process = (Process)eDataObject).getDiagramURI()) != null && string.length() > 0 && (file = new File(this.getSourceLibRoot(), string)).exists()) {
                            fileArray[0] = file;
                        }
                        return fileArray;
                    }
                };
                this.xmlLib.fixLibraryForImport();
                List list = this.xmlLib.getReferencedPlugins();
                if (list.size() > 0 && (object3 = LibraryService.getInstance().getCurrentMethodLibrary()) != null) {
                    object2 = object3.getMethodPlugins();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        string = ((org.eclipse.epf.uma.MethodPlugin)object.next()).getGuid();
                        list.remove(string);
                    }
                }
                if (this.isCheckBasePlugins() && list.size() > 0) {
                    object3 = this.xmlLib.getGuidToPlugNameMap();
                    object2 = list.iterator();
                    while (object2.hasNext()) {
                        String string2;
                        object = "";
                        string = (String)object2.next();
                        if (object3 != null && (string2 = (String)object3.get(string)) != null) {
                            object = String.valueOf(object) + string2 + ", ";
                        }
                        object = String.valueOf(object) + string;
                        this.logger.logError(NLS.bind((String)ImportXMLResources.importXMLService_missing_plugin, (Object)object), null);
                    }
                    throw new Exception(ImportXMLResources.importXMLService_error_missing_plugins);
                }
                this.umaLib = new UmaLibrary(contentProcessor, (ILogger)this.logger, this.overwrite);
                object3 = this.xmlLib.getRoot();
                object2 = this.umaLib.getRoot();
                this.logger.logMessage("create target library elements ...");
                this.creatEDataObjectTree((EDataObject)object3, (EDataObject)object2);
                this.logger.logMessage("copying all feature values for target library elements ...");
                this.iteratEDataObject((MethodElement)object3);
                this.logger.logMessage("fix the target library ...");
                this.umaLib.fixLibrary();
                this.umaLib.fixTaskDescriptors(this.tdMap);
                LibraryImportManager.handleNameReplace((Map)this.renameElementMap);
                this.diagramHandler.postRegisterElements();
                this.logger.logMessage("delete unneeded elements ...");
                this.umaLib.deleteElements();
                object = FileModifyChecker.getModifiedFiles((ResourceSet)LibraryService.getInstance().getCurrentMethodLibrary().eResource().getResourceSet());
                object.addAll(this.diagramHandler.getModifiedFiles());
                string = FileModifyChecker.syncExecCheckModify((List)object);
                if (string.isOK()) {
                    org.eclipse.epf.uma.MethodLibrary methodLibrary;
                    MethodConfiguration methodConfiguration;
                    this.logger.logMessage("saving target library ...");
                    List list2 = LibraryService.getInstance().getCurrentMethodLibrary().getPredefinedConfigurations();
                    int n = list2 == null ? 0 : list2.size();
                    int n2 = 0;
                    while (n2 < n) {
                        methodConfiguration = (MethodConfiguration)list2.get(n2);
                        LibraryUtil.validateMethodConfiguration(null, (MethodConfiguration)methodConfiguration);
                        ++n2;
                    }
                    if (n != 0 && (methodConfiguration = ((MultiFileResourceSetImpl)(methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary()).eResource().getResourceSet()).getPersister()) instanceof IFileBasedLibraryPersister) {
                        IFileBasedLibraryPersister iFileBasedLibraryPersister = (IFileBasedLibraryPersister)methodConfiguration;
                        File file = iFileBasedLibraryPersister.getDefaultMethodConfigurationFolder(methodLibrary);
                        if (file != null) {
                            iFileBasedLibraryPersister.setDefaultMethodConfigurationFolder(methodLibrary, file);
                        } else {
                            throw new Exception(ImportXMLResources.importXMLService_import_failed);
                        }
                    }
                    LibraryUtil.saveLibrary((org.eclipse.epf.uma.MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (boolean)false, (boolean)false);
                    this.diagramHandler.execute();
                    this.logger.logMessage("re-open target library ...");
                    LibraryService.getInstance().reopenCurrentMethodLibrary();
                    if (this.migrator != null) {
                        org.eclipse.epf.uma.MethodLibrary methodLibrary2 = LibraryService.getInstance().getCurrentMethodLibrary();
                        this.migrator.migrateXmlImportedLib(methodLibrary2, iProgressMonitor);
                        LibraryService.getInstance().reopenCurrentMethodLibrary();
                    }
                    this.logger.logMessage("import completed successfully ...");
                } else {
                    SafeUpdateController.syncExec((Runnable)new Runnable((IStatus)string){
                        private final /* synthetic */ IStatus val$fileCheckedOutStatus;
                        {
                            this.val$fileCheckedOutStatus = iStatus;
                        }

                        public void run() {
                            String string = ImportXMLResources.importXMLWizard_title;
                            String string2 = ImportXMLResources.importXMLService_import_failed;
                            new MsgDialog((AbstractPlugin)ImportXMLPlugin.getDefault()).displayError(string, string2, this.val$fileCheckedOutStatus);
                        }
                    });
                }
            }
            catch (Exception exception) {
                this.logger.logError(NLS.bind((String)ImportXMLResources.importXMLService_import_failed, (Object)exception.getMessage()), exception);
                throw exception;
            }
        }
        finally {
            if (bl) {
                RefreshJob.getInstance().setEnabled(true);
            }
        }
    }

    private void creatEDataObjectTree(EDataObject eDataObject, EDataObject eDataObject2) {
        for (EDataObject eDataObject3 : eDataObject.eContents()) {
            this.createRmcObject(eDataObject3, eDataObject2);
        }
    }

    private void createRmcObject(EDataObject eDataObject, EDataObject eDataObject2) {
        if (eDataObject instanceof MethodElementProperty) {
            return;
        }
        EReference eReference = eDataObject.eContainmentFeature();
        this.createRmcObject(eDataObject, eDataObject2, eReference.getName());
    }

    private void createRmcObject(EDataObject eDataObject, EDataObject eDataObject2, String string) {
        try {
            if (eDataObject == null) {
                return;
            }
            EDataObject eDataObject3 = null;
            if (eDataObject instanceof MethodPlugin) {
                MethodPlugin methodPlugin = (MethodPlugin)eDataObject;
                eDataObject3 = this.umaLib.createMethodPlugin(methodPlugin.getId(), methodPlugin.getName());
            } else if (eDataObject instanceof ContentCategoryPackage) {
                this.setDiscarded(((ContentCategoryPackage)eDataObject).getId());
            } else if (eDataObject instanceof ContentCategory && !(eDataObject.eContainer() instanceof Domain) && !(eDataObject.eContainer() instanceof Discipline) || eDataObject.eContainer() instanceof ContentCategoryPackage) {
                String string2 = this.getPlugin((EObject)eDataObject).getId();
                eDataObject3 = this.umaLib.createContentCategory(string2, eDataObject.eClass().getName(), eDataObject.getType().getName(), this.xmlLib.getElementId(eDataObject));
            } else {
                Object object;
                Object object2;
                if (eDataObject instanceof MethodPackage && eDataObject.eContainer() instanceof MethodPlugin) {
                    if (eDataObject instanceof ContentPackage) {
                        eDataObject2 = this.umaLib.getContentRootPackage(eDataObject2);
                    } else if (eDataObject instanceof ProcessComponent) {
                        object2 = ((ProcessComponent)eDataObject).getProcess();
                        if (object2 instanceof CapabilityPattern) {
                            eDataObject2 = this.umaLib.getCapabilityPatternRootPackage(eDataObject2);
                        } else if (object2 instanceof DeliveryProcess) {
                            eDataObject2 = this.umaLib.getDeliveryProcessRootPackage(eDataObject2);
                        }
                    } else if (eDataObject instanceof ProcessPackage && (object2 = this.xmlLib.getAllProcesses((MethodPackage)eDataObject)) != null && object2.size() > 0) {
                        object = object2.get(0);
                        if (object instanceof CapabilityPattern) {
                            eDataObject2 = this.umaLib.getCapabilityPatternRootPackage(eDataObject2);
                        } else if (object instanceof DeliveryProcess) {
                            eDataObject2 = this.umaLib.getDeliveryProcessRootPackage(eDataObject2);
                        }
                    }
                }
                if (eDataObject2 instanceof TaskDescriptor && string.equals("step")) {
                    return;
                }
                eDataObject3 = this.umaLib.createElement(eDataObject2, string, eDataObject.eClass().getName(), eDataObject.getType().getName(), this.xmlLib.getElementId(eDataObject));
                if (eDataObject instanceof org.eclipse.epf.xml.uma.TaskDescriptor && (object2 = (org.eclipse.epf.xml.uma.TaskDescriptor)eDataObject).getTask() != null && (object = object2.getStep()) != null && !object.isEmpty()) {
                    if (this.tdMap == null) {
                        this.tdMap = new HashMap<String, org.eclipse.epf.xml.uma.TaskDescriptor>();
                    }
                    this.tdMap.put(object2.getId(), (org.eclipse.epf.xml.uma.TaskDescriptor)object2);
                }
                if (eDataObject instanceof WorkOrder) {
                    this.workOrderMap.put(eDataObject, eDataObject3);
                }
            }
            this.creatEDataObjectTree(eDataObject, eDataObject3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private MethodPlugin getPlugin(EObject eObject) {
        while (eObject != null && !(eObject instanceof MethodPlugin)) {
            eObject = eObject.eContainer();
        }
        return (MethodPlugin)eObject;
    }

    private EDataObject getRmcObject(MethodElement methodElement) {
        if (methodElement instanceof MethodLibrary) {
            return this.umaLib.getRoot();
        }
        String string = methodElement.getId();
        return this.umaLib.getElement(string);
    }

    private void iteratEDataObject(MethodElement methodElement) {
        this.iteratEDataObject_(methodElement);
        EDataObject eDataObject = this.getRmcObject(methodElement);
        if (eDataObject instanceof org.eclipse.epf.uma.MethodElement) {
            this.diagramHandler.registerElement((org.eclipse.epf.uma.MethodElement)eDataObject);
        }
    }

    private void iteratEDataObject_(MethodElement methodElement) {
        this.logger.logMessage(" === processing element " + methodElement.getType().getName() + ": " + methodElement.getName());
        if (this.isProcessed(methodElement.getId())) {
            return;
        }
        this.setProcessed(methodElement.getId());
        if (methodElement instanceof ContentCategoryPackage) {
            Iterator iterator = ((ContentCategoryPackage)methodElement).getContentCategory().iterator();
            while (iterator.hasNext()) {
                this.iteratEDataObject((MethodElement)iterator.next());
            }
            return;
        }
        EDataObject eDataObject = this.getRmcObject(methodElement);
        EClass eClass = methodElement.eClass();
        EList eList = eClass.getEAllStructuralFeatures();
        boolean bl = this.umaLib.isNewElement(methodElement.getId()) || methodElement instanceof MethodLibrary;
        boolean bl2 = !bl && methodElement instanceof MethodPlugin;
        for (EStructuralFeature eStructuralFeature : eList) {
            Object object;
            if (FeatureManager.INSTANCE.isUnneededXmlFeature(eStructuralFeature.getName()) || bl2 && UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable() == eStructuralFeature || (object = methodElement.eGet(eStructuralFeature)) == null) continue;
            try {
                Object object2;
                Object object32;
                boolean bl3 = eStructuralFeature.getName().equals("methodElementProperty");
                if (object instanceof List && !bl3) {
                    for (Object object32 : (List)object) {
                        String string;
                        if (object32 instanceof String) {
                            this.umaLib.setReferenceValue(eDataObject, eStructuralFeature.getName(), (String)object32);
                            continue;
                        }
                        if (object32 instanceof MethodElement) {
                            object2 = (MethodElement)object32;
                            string = object2.getId();
                            if (!this.isDiscarded(string) && object2.eContainer() != methodElement) {
                                this.umaLib.setReferenceValue(eDataObject, eStructuralFeature.getName(), string);
                            }
                            this.iteratEDataObject((MethodElement)object32);
                            continue;
                        }
                        if (object32 instanceof WorkOrder) {
                            object2 = (WorkOrder)object32;
                            string = this.workOrderMap.get(object2);
                            this.umaLib.setWorkOrder(string, object2.getValue());
                            continue;
                        }
                        this.logger.logMessage(NLS.bind((String)ImportXMLResources.importXMLService_element_not_handled, object32));
                    }
                    continue;
                }
                if (eStructuralFeature instanceof EReference && !bl3) {
                    Object object4 = object;
                    if (object4 instanceof WorkOrder) {
                        this.logger.logMessage("workorder value");
                        continue;
                    }
                    if (object4 instanceof String && !this.isDiscarded((String)object4)) {
                        this.umaLib.setReferenceValue(eDataObject, eStructuralFeature.getName(), (String)object4);
                        continue;
                    }
                    if (object4 instanceof MethodElement) {
                        object32 = ((MethodElement)object4).getId();
                        if (object32 == null) {
                            this.logger.logWarning(NLS.bind((String)ImportXMLResources.importXMLService_element_without_id, (Object)((MethodElement)object4).getName()));
                        }
                        if (!this.isDiscarded((String)object32)) {
                            this.umaLib.setReferenceValue(eDataObject, eStructuralFeature.getName(), (String)object32);
                        }
                        this.iteratEDataObject((MethodElement)object4);
                        continue;
                    }
                    this.logger.logWarning(NLS.bind((String)ImportXMLResources.importXMLService_element_not_handled, (Object)object4));
                    continue;
                }
                if (eDataObject instanceof ContentCategoryPackage) {
                    this.logger.logMessage("hrre");
                }
                if (object instanceof WorkOrderType) {
                    object = ((WorkOrderType)object).getName();
                }
                boolean bl4 = false;
                if (!bl && eStructuralFeature == UmaPackage.eINSTANCE.getNamedElement_Name()) {
                    object32 = (String)eDataObject.eGet((EStructuralFeature)org.eclipse.epf.uma.UmaPackage.eINSTANCE.getNamedElement_Name());
                    object2 = (String)methodElement.eGet(eStructuralFeature);
                    if (!((String)object2).equals(object32)) {
                        LibraryImportManager.ensureUniqueNameForExistingElement((org.eclipse.epf.uma.MethodElement)((org.eclipse.epf.uma.MethodElement)eDataObject), object32, (String)object2, (Map)this.renameElementMap);
                        bl4 = true;
                    }
                }
                if (!bl4) {
                    this.umaLib.setAtributeFeatureValue(eDataObject, eStructuralFeature.getName(), object);
                }
                if (!bl || eStructuralFeature != UmaPackage.eINSTANCE.getNamedElement_Name() || !((object2 = (object32 = (org.eclipse.epf.uma.MethodElement)eDataObject).eContainer()) instanceof org.eclipse.epf.uma.MethodElement) || this.umaLib.isNewElement(((org.eclipse.epf.uma.MethodElement)object2).getGuid())) continue;
                LibraryImportManager.ensureUniqueName((EObject)object2, object32, (Map)this.renameElementMap);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean isProcessed(String string) {
        return this.processedElements.contains(string);
    }

    private void setProcessed(String string) {
        if (!this.processedElements.contains(string)) {
            this.processedElements.add(string);
        }
    }

    private boolean isDiscarded(String string) {
        return this.discardedElements.contains(string);
    }

    private void setDiscarded(String string) {
        this.discardedElements.add(string);
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    private String versionCheck(final String string, final String string2) {
        final String[] stringArray = new String[]{null};
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                VersionUtil.VersionCheckInfo versionCheckInfo = VersionUtil.checkXMLVersion((File)new File(string));
                if (versionCheckInfo == null) {
                    stringArray[0] = NLS.bind((String)ImportXMLResources.versionMismatch_oldData_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                } else if (versionCheckInfo.result < 0) {
                    try {
                        ImportXMLService.this.migrator = MappingUtil.getMigratorByLibPath((String)string);
                    }
                    catch (Exception exception) {
                        stringArray[0] = exception.toString();
                    }
                    if (ImportXMLService.this.migrator == null && stringArray[0] == null) {
                        stringArray[0] = versionCheckInfo.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)ImportXMLResources.versionMismatch_oldData, (Object[])new Object[]{versionCheckInfo.toolVersion, Platform.getProduct().getName()}) : NLS.bind((String)ImportXMLResources.versionMismatch_oldData_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                    }
                } else if (versionCheckInfo.result > 0) {
                    stringArray[0] = versionCheckInfo.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)ImportXMLResources.versionMismatch_oldTool, (Object[])new Object[]{versionCheckInfo.toolVersion, Platform.getProduct().getName()}) : NLS.bind((String)ImportXMLResources.versionMismatch_oldTool_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                }
                if (stringArray[0] != null) {
                    ImportXMLPlugin.getDefault().getMsgDialog().displayError(string2, stringArray[0]);
                }
            }
        });
        return stringArray[0];
    }

    public void handleTypeChanges() {
        org.eclipse.epf.uma.MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        HashMap hashMap = new HashMap();
        ConfigurationImportService.collectPotentialTypeChanged((org.eclipse.epf.uma.MethodLibrary)methodLibrary, hashMap);
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        TreeIterator treeIterator = this.xmlLib.getRoot().eAllContents();
        while (treeIterator.hasNext()) {
            EClass eClass;
            Object e = treeIterator.next();
            if (!(e instanceof Guidance) && !(e instanceof Activity)) continue;
            MethodElement methodElement = (MethodElement)e;
            String string = methodElement.eClass().getName();
            Object object = hashMap2.get(string);
            if (object == null && (eClass = FeatureManager.INSTANCE.getRmcEClass(string)) != null) {
                object = UmaFactory.eINSTANCE.create(eClass);
                hashMap2.put(string, object);
            }
            if (object == null) continue;
            hashMap3.put(methodElement.getId(), object);
        }
        ConfigurationImportService.handleTypeChanges(hashMap, hashMap3);
    }

    private boolean isCheckBasePlugins() {
        return this.checkBasePlugins;
    }

    public void setCheckBasePlugins(boolean bl) {
        this.checkBasePlugins = bl;
    }
}

