/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.web.search;

import com.ibm.icu.text.DecimalFormat;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.eclipse.epf.web.search.analysis.ChineseAnalyzer;
import org.eclipse.epf.web.search.analysis.TextAnalyzer;

public class IndexSearch {
    private static Searcher searcher;

    public static Hits search(String indexLocation, String inputQuery, String searchField) {
        String queryString;
        Query q;
        Hits hits;
        block12: {
            hits = null;
            q = null;
            queryString = null;
            DecimalFormat scoreFormatter = new DecimalFormat("0.######");
            if (indexLocation == null || inputQuery == null || searchField == null || searchField.length() == 0 || inputQuery.length() == 0) {
                return null;
            }
            queryString = IndexSearch.detectHyphenated(inputQuery);
            if (queryString != null && queryString.length() != 0) break block12;
            return null;
        }
        try {
            if (searcher == null) {
                searcher = new IndexSearcher((Directory)new RAMDirectory(indexLocation));
            }
            if (searcher == null) {
                return hits;
            }
            Sort sort = null;
            try {
                q = QueryParser.parse((String)queryString, (String)searchField, (Analyzer)new TextAnalyzer());
                if (q != null) {
                    hits = searcher.search(q, sort);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if ((q = QueryParser.parse((String)queryString, (String)searchField, (Analyzer)new ChineseAnalyzer())) != null) {
                hits = searcher.search(q, sort);
            }
            return hits;
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        catch (Throwable p1) {
            p1.printStackTrace();
        }
        return hits;
    }

    public static String detectHyphenated(String queryString) {
        StringTokenizer spaceTokenizer = new StringTokenizer(queryString);
        StringBuffer wordBuffer = new StringBuffer();
        while (spaceTokenizer.hasMoreTokens()) {
            String word = spaceTokenizer.nextToken();
            if (word.indexOf(45) == -1 || word.startsWith("\"")) {
                return queryString;
            }
            wordBuffer.append("\"");
            wordBuffer.append(word);
            wordBuffer.append("\"");
            if (!spaceTokenizer.hasMoreTokens()) continue;
            wordBuffer.append(" ");
        }
        return wordBuffer.toString();
    }
}

